/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.osg.security;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.c;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.security.WanDetectedAttackMessageDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.a.b;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.x;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WanDetectedAttackMessageDetector
implements a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(WanDetectedAttackMessageDetector.class);
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a b;
    @Autowired
    private e c;
    private static final List<c> d = new ArrayList<c>(Arrays.asList(com.tplink.smb.omada.anomaly.api.b.c.db, com.tplink.smb.omada.anomaly.api.b.c.dc, com.tplink.smb.omada.anomaly.api.b.c.dd, com.tplink.smb.omada.anomaly.api.b.c.de, com.tplink.smb.omada.anomaly.api.b.c.df, com.tplink.smb.omada.anomaly.api.b.c.dg, com.tplink.smb.omada.anomaly.api.b.c.dh, com.tplink.smb.omada.anomaly.api.b.c.di, com.tplink.smb.omada.anomaly.api.b.c.dj, com.tplink.smb.omada.anomaly.api.b.c.dk, com.tplink.smb.omada.anomaly.api.b.c.dl, com.tplink.smb.omada.anomaly.api.b.c.dm, com.tplink.smb.omada.anomaly.api.b.c.dn, com.tplink.smb.omada.anomaly.api.b.c.do, com.tplink.smb.omada.anomaly.api.b.c.dp, com.tplink.smb.omada.anomaly.api.b.c.dq, com.tplink.smb.omada.anomaly.api.b.c.dr));
    private static final Set<String> e = new HashSet<String>(Arrays.asList(com.tplink.smb.omada.anomaly.api.b.c.dq.a(), com.tplink.smb.omada.anomaly.api.b.c.dr.a()));

    @Override
    public c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.cZ;
    }

    @Override
    public List<c> e() {
        return d;
    }

    @Override
    public List<b> a(DevicePreprocessDTO devicePreprocessDTO) {
        WanDetectedAttackMessageDTO wanDetectedAttackMessageDTO = (WanDetectedAttackMessageDTO)devicePreprocessDTO.getPreprocessData().get(this.a().a());
        if (Objects.isNull(wanDetectedAttackMessageDTO.getData())) {
            a.debug("skip abnormal {} anomaly detect for mac {} omadac {} site {}, for data is empty", new Object[]{this.a(), devicePreprocessDTO.getMac(), devicePreprocessDTO.getOmadacId(), devicePreprocessDTO.getSiteId()});
            return Collections.emptyList();
        }
        if (a.isDebugEnabled()) {
            a.debug("detect anomaly event {} for Osg {},preHandle data:{}", new Object[]{this.a(), devicePreprocessDTO.getMac(), x.a((Object)wanDetectedAttackMessageDTO)});
        }
        AnomalyEventSettingDTO anomalyEventSettingDTO = devicePreprocessDTO.getAnomalyEventSettings().get(this.a().a());
        b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.b.a()).a(devicePreprocessDTO.getMac()).c(devicePreprocessDTO.getOmadacId()).d(devicePreprocessDTO.getSiteId()).a((long)devicePreprocessDTO.getTime()).a(this.a()).a(this.a(anomalyEventSettingDTO)).b(true).a();
        HashSet<String> errCodes = new HashSet<String>();
        ArrayList attackSources = new ArrayList();
        HashMap<String, List<AttackInfo>> attackInfoMap = new HashMap<String, List<AttackInfo>>(2);
        wanDetectedAttackMessageDTO.getData().getAttacks().forEach(attack -> {
            String errorCode = attack.getErrCode();
            String ip = attack.getIp();
            String mac = attack.getMac();
            Integer count = attack.getCount();
            String bindMac = attack.getBindMac();
            errCodes.add(attack.getErrCode());
            boolean arpCause = e.contains(errorCode);
            if (arpCause) {
                List attackInfoList = attackInfoMap.computeIfAbsent(errorCode, s2 -> new ArrayList());
                attackInfoList.add(this.a(ip, count, mac, bindMac));
            }
            attackSources.add(new AttackSource(this.a(arpCause, ip, mac), count));
        });
        HashMap<String, Object> detailParams = new HashMap<String, Object>();
        detailParams.put("attackSource", attackSources);
        anomalyEvent.a(null, null, detailParams, Collections.singletonMap(devicePreprocessDTO.getMac(), this.c.a(devicePreprocessDTO.getOmadacId(), devicePreprocessDTO.getSiteId(), devicePreprocessDTO.getMac())), null, null);
        this.a(anomalyEvent, errCodes, devicePreprocessDTO, attackInfoMap);
        return Collections.singletonList(anomalyEvent);
    }

    private void a(b anomalyEvent, Set<String> errCodes, DevicePreprocessDTO devicePreprocessDTO, Map<String, List<AttackInfo>> attackInfoMap) {
        errCodes.forEach(errCode -> {
            c causeEnum = com.tplink.smb.omada.anomaly.api.b.c.a((String)errCode);
            if (Objects.nonNull(causeEnum)) {
                b cause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(devicePreprocessDTO.getMac()).c(devicePreprocessDTO.getOmadacId()).d(devicePreprocessDTO.getSiteId()).a((long)devicePreprocessDTO.getTime()).a(causeEnum).a(causeEnum.c()).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(causeEnum)).a();
                if (e.contains(errCode)) {
                    cause.c(CollectionUtils.toMap((Object[])new Object[]{"attackInfo", attackInfoMap.getOrDefault(errCode, new ArrayList())}));
                }
                anomalyEvent.d(cause);
            }
        });
    }

    private String a(boolean arpCause, String ip, String mac) {
        if (arpCause) {
            return com.tplink.smb.omada.anomaly.core.port.f.a.a(mac, "--");
        }
        return com.tplink.smb.omada.anomaly.core.port.f.a.a(ip, "--");
    }

    private AttackInfo a(String ip, Integer count, String mac, String bindMac) {
        AttackInfo attackInfo = new AttackInfo();
        attackInfo.setAttackMac(com.tplink.smb.omada.anomaly.core.port.f.a.a(mac, "--"));
        attackInfo.setAttackCount(count);
        attackInfo.setAttackPacket(this.a(ip, mac));
        attackInfo.setBindRule(this.a(ip, bindMac));
        return attackInfo;
    }

    private String a(String val1, String val2) {
        return com.tplink.smb.omada.anomaly.core.port.f.a.a(val1, "--") + ":" + com.tplink.smb.omada.anomaly.core.port.f.a.a(val2, "--");
    }

    @KeepClass
    private static class AttackInfo {
        private String attackMac;
        private Integer attackCount;
        private String attackPacket;
        private String bindRule;

        @Generated
        public String getAttackMac() {
            return this.attackMac;
        }

        @Generated
        public Integer getAttackCount() {
            return this.attackCount;
        }

        @Generated
        public String getAttackPacket() {
            return this.attackPacket;
        }

        @Generated
        public String getBindRule() {
            return this.bindRule;
        }

        @Generated
        public void setAttackMac(String attackMac) {
            this.attackMac = attackMac;
        }

        @Generated
        public void setAttackCount(Integer attackCount) {
            this.attackCount = attackCount;
        }

        @Generated
        public void setAttackPacket(String attackPacket) {
            this.attackPacket = attackPacket;
        }

        @Generated
        public void setBindRule(String bindRule) {
            this.bindRule = bindRule;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof AttackInfo)) {
                return false;
            }
            AttackInfo other = (AttackInfo)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$attackCount = this.getAttackCount();
            Integer other$attackCount = other.getAttackCount();
            if (this$attackCount == null ? other$attackCount != null : !((Object)this$attackCount).equals(other$attackCount)) {
                return false;
            }
            String this$attackMac = this.getAttackMac();
            String other$attackMac = other.getAttackMac();
            if (this$attackMac == null ? other$attackMac != null : !this$attackMac.equals(other$attackMac)) {
                return false;
            }
            String this$attackPacket = this.getAttackPacket();
            String other$attackPacket = other.getAttackPacket();
            if (this$attackPacket == null ? other$attackPacket != null : !this$attackPacket.equals(other$attackPacket)) {
                return false;
            }
            String this$bindRule = this.getBindRule();
            String other$bindRule = other.getBindRule();
            return !(this$bindRule == null ? other$bindRule != null : !this$bindRule.equals(other$bindRule));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AttackInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $attackCount = this.getAttackCount();
            result = result * 59 + ($attackCount == null ? 43 : ((Object)$attackCount).hashCode());
            String $attackMac = this.getAttackMac();
            result = result * 59 + ($attackMac == null ? 43 : $attackMac.hashCode());
            String $attackPacket = this.getAttackPacket();
            result = result * 59 + ($attackPacket == null ? 43 : $attackPacket.hashCode());
            String $bindRule = this.getBindRule();
            result = result * 59 + ($bindRule == null ? 43 : $bindRule.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WanDetectedAttackMessageDetector.AttackInfo(attackMac=" + this.getAttackMac() + ", attackCount=" + this.getAttackCount() + ", attackPacket=" + this.getAttackPacket() + ", bindRule=" + this.getBindRule() + ")";
        }

        @Generated
        public AttackInfo() {
        }

        @Generated
        public AttackInfo(String attackMac, Integer attackCount, String attackPacket, String bindRule) {
            this.attackMac = attackMac;
            this.attackCount = attackCount;
            this.attackPacket = attackPacket;
            this.bindRule = bindRule;
        }
    }

    @KeepClass
    private static class AttackSource {
        private String attackIp;
        private Integer attackCount;

        @Generated
        public String getAttackIp() {
            return this.attackIp;
        }

        @Generated
        public Integer getAttackCount() {
            return this.attackCount;
        }

        @Generated
        public void setAttackIp(String attackIp) {
            this.attackIp = attackIp;
        }

        @Generated
        public void setAttackCount(Integer attackCount) {
            this.attackCount = attackCount;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof AttackSource)) {
                return false;
            }
            AttackSource other = (AttackSource)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$attackCount = this.getAttackCount();
            Integer other$attackCount = other.getAttackCount();
            if (this$attackCount == null ? other$attackCount != null : !((Object)this$attackCount).equals(other$attackCount)) {
                return false;
            }
            String this$attackIp = this.getAttackIp();
            String other$attackIp = other.getAttackIp();
            return !(this$attackIp == null ? other$attackIp != null : !this$attackIp.equals(other$attackIp));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AttackSource;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $attackCount = this.getAttackCount();
            result = result * 59 + ($attackCount == null ? 43 : ((Object)$attackCount).hashCode());
            String $attackIp = this.getAttackIp();
            result = result * 59 + ($attackIp == null ? 43 : $attackIp.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WanDetectedAttackMessageDetector.AttackSource(attackIp=" + this.getAttackIp() + ", attackCount=" + this.getAttackCount() + ")";
        }

        @Generated
        public AttackSource(String attackIp, Integer attackCount) {
            this.attackIp = attackIp;
            this.attackCount = attackCount;
        }
    }
}

