/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.osg.networking;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.c;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.AbstractDeviceDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.hardware.OsgPortTrafficDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.networking.OsgConnectEventDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a.d;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.b;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.anomaly.core.port.cache.l;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.ClientObjectDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OsgDisconnectedFrequentlyDetector
implements a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(OsgDisconnectedFrequentlyDetector.class);
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a b;
    @Autowired
    private e c;
    @Autowired
    private l d;
    private static final List<c> e = new ArrayList<c>(Arrays.asList(com.tplink.smb.omada.anomaly.api.b.c.dZ, com.tplink.smb.omada.anomaly.api.b.c.ea, com.tplink.smb.omada.anomaly.api.b.c.ee));

    @Override
    public c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.cO;
    }

    @Override
    public f c() {
        return f.e;
    }

    @Override
    public List<c> d() {
        return e;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b detectTimeRange, String mac, List<DevicePreprocessDTO> devicePreDataList) {
        if (CollectionUtils.isEmpty(devicePreDataList)) {
            return Collections.emptyList();
        }
        if (a.isDebugEnabled()) {
            a.debug("frequently disconnected anomaly detect for mac {}  omadac {} site {}, data: {}", new Object[]{mac, detectTimeRange.a(), detectTimeRange.b(), x.a(devicePreDataList)});
        }
        AnomalyEventSettingDTO anomalyEventSetting = detectTimeRange.e().get(this.a().a());
        int disconnectFreThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSetting, "offlineCount", 4);
        TreeMap<Long, Integer> timeEvents = new TreeMap<Long, Integer>();
        OsgDisconnectedFrequentlyDetector.a(devicePreDataList, timeEvents);
        ArrayList<Long> upTimes = new ArrayList<Long>();
        ArrayList<Long> downTimes = new ArrayList<Long>();
        com.tplink.smb.omada.anomaly.core.domain.model.rule.c.a.a(timeEvents, detectTimeRange.d() - this.c().c(), upTimes, downTimes);
        if (downTimes.size() < disconnectFreThreshold) {
            return Collections.emptyList();
        }
        com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.b.a()).a(mac).c(detectTimeRange.a()).d(detectTimeRange.b()).a(detectTimeRange.d()).a(this.a()).a(this.a(anomalyEventSetting)).a();
        HashMap<String, Long> clientTraffic = new HashMap<String, Long>();
        HashMap<String, ClientObjectDTO> clients = new HashMap<String, ClientObjectDTO>();
        TreeMap<Long, Map<Integer, OsgPortTrafficDTO>> portTrafficMap = new TreeMap<Long, Map<Integer, OsgPortTrafficDTO>>();
        this.a(devicePreDataList, clientTraffic, clients, portTrafficMap);
        long startTime = detectTimeRange.d() - this.c().c();
        long endTime = detectTimeRange.d();
        int offlineCount = downTimes.size();
        anomalyEvent.a(CollectionUtils.toStringMap((String[])new String[]{"devMac", mac}), CollectionUtils.toStringMap((String[])new String[]{"devMac", mac, "offlineCount", String.valueOf(offlineCount)}), CollectionUtils.toMap((Object[])new Object[]{"startTime", startTime, "endTime", endTime, "upTimes", upTimes, "downTimes", downTimes}), Collections.singletonMap(mac, this.c.a(detectTimeRange.a(), detectTimeRange.b(), mac)), null, null);
        com.tplink.smb.omada.anomaly.core.domain.model.rule.a.d.a(anomalyEvent, clientTraffic, clients, portTrafficMap);
        com.tplink.smb.omada.anomaly.core.domain.model.a.b ipConflictCause = this.a(anomalyEvent);
        if (Objects.nonNull(ipConflictCause)) {
            anomalyEvent.d(ipConflictCause);
        }
        return Collections.singletonList(anomalyEvent);
    }

    @Override
    public void a(String omadacId, String siteId, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEventSet, Map<String, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b>> causeMap, com.tplink.smb.omada.anomaly.core.domain.model.b.a associateResult) {
        for (com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent : anomalyEventSet) {
            String deviceMac = anomalyEvent.g();
            Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> rebootCauses = causeMap.get(com.tplink.smb.omada.anomaly.core.domain.model.rule.b.a(deviceMac, com.tplink.smb.omada.anomaly.api.b.c.cK));
            if (!CollectionUtils.isEmpty(rebootCauses)) {
                c causeEnum = com.tplink.smb.omada.anomaly.api.b.c.ef;
                anomalyEvent.d(com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(anomalyEvent.g()).c(anomalyEvent.i()).d(anomalyEvent.j()).a(anomalyEvent.k()).a(causeEnum).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(causeEnum)).a());
            }
            if (CollectionUtils.isNotEmptyMap(anomalyEvent.u()) && anomalyEvent.u().containsKey(com.tplink.smb.omada.anomaly.api.b.c.cP.a())) continue;
            for (c causeEnum : this.d()) {
                com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(anomalyEvent.g()).c(anomalyEvent.i()).d(anomalyEvent.j()).a(anomalyEvent.k()).a(causeEnum).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(causeEnum)).a();
                anomalyEvent.d(cause);
            }
        }
    }

    private static void a(List<DevicePreprocessDTO> devicePreDataList, SortedMap<Long, Integer> timeEvents) {
        String preDataMapKey = com.tplink.smb.omada.anomaly.api.b.c.cO.a();
        for (DevicePreprocessDTO devicePreprocessDTO : devicePreDataList) {
            if (Objects.isNull(devicePreprocessDTO.getPreprocessData()) || Objects.isNull(devicePreprocessDTO.getPreprocessData().get(preDataMapKey))) continue;
            AbstractDeviceDTO abstractDeviceDTO = devicePreprocessDTO.getPreprocessData().get(preDataMapKey);
            OsgConnectEventDTO dto = (OsgConnectEventDTO)abstractDeviceDTO;
            if (Objects.nonNull(dto.getAdoptSuccessTime())) {
                timeEvents.put(dto.getAdoptSuccessTime(), 0);
            }
            if (Objects.nonNull(dto.getInformTime())) {
                timeEvents.put(dto.getInformTime(), 1);
            }
            if (!Objects.nonNull(dto.getDisconnectTime())) continue;
            timeEvents.put(dto.getDisconnectTime(), 2);
        }
    }

    private void a(List<DevicePreprocessDTO> devicePreDataList, Map<String, Long> clientTraffic, Map<String, ClientObjectDTO> clients, Map<Long, Map<Integer, OsgPortTrafficDTO>> portTrafficMap) {
        for (DevicePreprocessDTO devicePreprocessDTO : devicePreDataList) {
            if (CollectionUtils.isEmptyMap(devicePreprocessDTO.getPreprocessData()) || Objects.isNull(devicePreprocessDTO.getPreprocessData().get(this.a().a()))) continue;
            AbstractDeviceDTO abstractDeviceDTO = devicePreprocessDTO.getPreprocessData().get(this.a().a());
            OsgConnectEventDTO connectEventDTO = (OsgConnectEventDTO)abstractDeviceDTO;
            if (Objects.nonNull(connectEventDTO.getClientTraffic())) {
                connectEventDTO.getClientTraffic().forEach((clientMac, traffic) -> {
                    long oldTraffic = clientTraffic.getOrDefault(clientMac, 0L);
                    clientTraffic.put((String)clientMac, oldTraffic + traffic);
                });
            }
            if (Objects.nonNull(connectEventDTO.getClients())) {
                connectEventDTO.getClients().forEach(clients::put);
            }
            if (!CollectionUtils.isNotEmptyMap((Map)connectEventDTO.getPortTrafficMap())) continue;
            portTrafficMap.put(connectEventDTO.getInformTime(), connectEventDTO.getPortTrafficMap());
        }
    }

    private com.tplink.smb.omada.anomaly.core.domain.model.a.b a(com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent) {
        Map<String, Long> ipConflictMap = this.d.a(anomalyEvent.i(), anomalyEvent.j(), anomalyEvent.k());
        if (a.isDebugEnabled()) {
            a.debug("detected osg ip conflict: {}", (Object)x.a(ipConflictMap));
        }
        if (CollectionUtils.isEmptyMap(ipConflictMap)) {
            return null;
        }
        String latestConflictMac = null;
        long latestEventTime = 0L;
        for (Map.Entry<String, Long> entry : ipConflictMap.entrySet()) {
            if (latestEventTime >= entry.getValue()) continue;
            latestConflictMac = entry.getKey();
        }
        String omadacId = anomalyEvent.i();
        String siteId = anomalyEvent.j();
        String osgMac = anomalyEvent.g();
        com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(anomalyEvent.g()).c(anomalyEvent.i()).d(anomalyEvent.j()).a(latestEventTime).a(com.tplink.smb.omada.anomaly.api.b.c.cP).b(Collections.singletonMap("devMac", latestConflictMac)).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(com.tplink.smb.omada.anomaly.api.b.c.cP)).a();
        com.tplink.smb.omada.anomaly.core.domain.model.a.a anomalyAdvice = com.tplink.smb.omada.anomaly.core.domain.model.a.a.a().a(com.tplink.smb.omada.anomaly.api.b.a.a).a(CollectionUtils.toStringMap((String[])new String[]{"devMac", osgMac})).b(CollectionUtils.toMap((Object[])new Object[]{osgMac, this.c.a(omadacId, siteId, osgMac)})).a();
        cause.g(Collections.singletonMap(com.tplink.smb.omada.anomaly.api.b.b.bp.a(), anomalyAdvice));
        return cause;
    }

    @KeepClass
    public static class ClientTraffic {
        private String clientMac;
        private Long traffic;

        @Generated
        public String getClientMac() {
            return this.clientMac;
        }

        @Generated
        public Long getTraffic() {
            return this.traffic;
        }

        @Generated
        public void setClientMac(String clientMac) {
            this.clientMac = clientMac;
        }

        @Generated
        public void setTraffic(Long traffic) {
            this.traffic = traffic;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof ClientTraffic)) {
                return false;
            }
            ClientTraffic other = (ClientTraffic)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$traffic = this.getTraffic();
            Long other$traffic = other.getTraffic();
            if (this$traffic == null ? other$traffic != null : !((Object)this$traffic).equals(other$traffic)) {
                return false;
            }
            String this$clientMac = this.getClientMac();
            String other$clientMac = other.getClientMac();
            return !(this$clientMac == null ? other$clientMac != null : !this$clientMac.equals(other$clientMac));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClientTraffic;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $traffic = this.getTraffic();
            result = result * 59 + ($traffic == null ? 43 : ((Object)$traffic).hashCode());
            String $clientMac = this.getClientMac();
            result = result * 59 + ($clientMac == null ? 43 : $clientMac.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OsgDisconnectedFrequentlyDetector.ClientTraffic(clientMac=" + this.getClientMac() + ", traffic=" + this.getTraffic() + ")";
        }

        @Generated
        public ClientTraffic(String clientMac, Long traffic) {
            this.clientMac = clientMac;
            this.traffic = traffic;
        }
    }
}

