/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.osg.hardware;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.c;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.AbstractDeviceDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.hardware.OsgCpuUtilDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.hardware.OsgPortTrafficDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.a.b;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a.d;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.ClientObjectDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OsgHighCpuUtilDetector
implements a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(OsgHighCpuUtilDetector.class);
    private static final int b = OmadacType.s() ? 5 : 20;
    private static final int c = 60;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a d;
    @Autowired
    private e e;

    @Override
    public c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.cM;
    }

    @Override
    public f c() {
        return f.c;
    }

    @Override
    public List<b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b detectTimeRange, String mac, List<DevicePreprocessDTO> devicePreDataList) {
        if (CollectionUtils.isEmpty(devicePreDataList)) {
            return Collections.emptyList();
        }
        AnomalyEventSettingDTO anomalyEventSetting = detectTimeRange.e().get(this.a().a());
        int highCpuUtilThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSetting, "threshold", 90);
        int highCpuRatioThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSetting, "count", 80);
        int highCpuUtilCount = 0;
        int cpuUtilTotalCount = 0;
        ArrayList<OsgCpuUtilDTO> cpuUtilDTOList = new ArrayList<OsgCpuUtilDTO>();
        for (DevicePreprocessDTO devicePreprocessDTO : devicePreDataList) {
            AbstractDeviceDTO abstractDeviceDTO = devicePreprocessDTO.getPreprocessData().get(this.a().a());
            if (Objects.isNull(abstractDeviceDTO)) continue;
            OsgCpuUtilDTO osgCpuUtilDTO = (OsgCpuUtilDTO)abstractDeviceDTO;
            cpuUtilDTOList.add(osgCpuUtilDTO);
            if (!Objects.nonNull(osgCpuUtilDTO.getCpuUtil())) continue;
            ++cpuUtilTotalCount;
            highCpuUtilCount = osgCpuUtilDTO.getCpuUtil() >= highCpuUtilThreshold ? highCpuUtilCount + 1 : highCpuUtilCount;
        }
        if (cpuUtilTotalCount * 100 < b * 60) {
            a.debug("skip {} anomaly detect for mac {} omadac {} site {}, for data is not enough", new Object[]{this.a(), mac, detectTimeRange.a(), detectTimeRange.b()});
            return Collections.emptyList();
        }
        a.debug("high cpu util anomaly detect for mac {}  omadac {} site {}, pre data is: {}", new Object[]{mac, detectTimeRange.a(), detectTimeRange.b(), cpuUtilDTOList});
        if (highCpuUtilCount * 100 < cpuUtilTotalCount * highCpuRatioThreshold) {
            return Collections.emptyList();
        }
        TreeMap<Long, OsgCpuUtil> cpuUtilMap = new TreeMap<Long, OsgCpuUtil>();
        HashMap<String, Long> clientTraffic = new HashMap<String, Long>();
        HashMap<String, ClientObjectDTO> clients = new HashMap<String, ClientObjectDTO>();
        TreeMap<Long, Map<Integer, OsgPortTrafficDTO>> portTrafficMap = new TreeMap<Long, Map<Integer, OsgPortTrafficDTO>>();
        long detectTime = detectTimeRange.d();
        for (OsgCpuUtilDTO osgCpuUtilDTO : cpuUtilDTOList) {
            if (Objects.nonNull(osgCpuUtilDTO.getCpuUtil())) {
                cpuUtilMap.put(osgCpuUtilDTO.getTime(), new OsgCpuUtil(osgCpuUtilDTO.getTime(), osgCpuUtilDTO.getCpuUtil()));
            }
            this.a(osgCpuUtilDTO, clientTraffic, clients, portTrafficMap);
        }
        b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.d.a()).a(mac).c(detectTimeRange.a()).d(detectTimeRange.b()).a(detectTime).a(this.a()).a(this.a(anomalyEventSetting)).a();
        anomalyEvent.a(CollectionUtils.toStringMap((String[])new String[]{"devMac", mac}), CollectionUtils.toStringMap((String[])new String[]{"devMac", mac, "count", String.valueOf(highCpuRatioThreshold), "threshold", String.valueOf(highCpuUtilThreshold)}), Collections.singletonMap("cpuUtils", cpuUtilMap.values()), Collections.singletonMap(mac, this.e.a(detectTimeRange.a(), detectTimeRange.b(), mac)), null, null);
        this.a(anomalyEvent, clientTraffic, clients, portTrafficMap);
        return Collections.singletonList(anomalyEvent);
    }

    private void a(OsgCpuUtilDTO osgCpuUtilDTO, Map<String, Long> clientTraffic, Map<String, ClientObjectDTO> clients, Map<Long, Map<Integer, OsgPortTrafficDTO>> portTrafficMap) {
        if (CollectionUtils.isNotEmptyMap((Map)osgCpuUtilDTO.getClientTraffic())) {
            osgCpuUtilDTO.getClientTraffic().forEach((clientMac, traffic) -> clientTraffic.compute((String)clientMac, (k2, v2) -> {
                v2 = Objects.isNull(v2) ? traffic : Long.valueOf(v2 + traffic);
                return v2;
            }));
        }
        if (CollectionUtils.isNotEmptyMap((Map)osgCpuUtilDTO.getClients())) {
            osgCpuUtilDTO.getClients().forEach(clients::put);
        }
        if (CollectionUtils.isNotEmptyMap((Map)osgCpuUtilDTO.getPortTrafficMap())) {
            portTrafficMap.put(osgCpuUtilDTO.getTime(), osgCpuUtilDTO.getPortTrafficMap());
        }
    }

    private void a(b anomalyEvent, Map<String, Long> clientTrafficMap, Map<String, ClientObjectDTO> clients, Map<Long, Map<Integer, OsgPortTrafficDTO>> portTrafficMap) {
        com.tplink.smb.omada.anomaly.core.domain.model.rule.a.d.a(anomalyEvent, clientTrafficMap, clients, portTrafficMap);
        b loopCause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(anomalyEvent.g()).c(anomalyEvent.i()).d(anomalyEvent.j()).a(anomalyEvent.k()).a(com.tplink.smb.omada.anomaly.api.b.c.ee).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(com.tplink.smb.omada.anomaly.api.b.c.ee)).a();
        anomalyEvent.d(loopCause);
    }

    @KeepClass
    public static class OsgCpuUtil {
        private Long time;
        private Integer cpuUtil;

        OsgCpuUtil(long time) {
            this.time = time;
        }

        @Generated
        public Long getTime() {
            return this.time;
        }

        @Generated
        public Integer getCpuUtil() {
            return this.cpuUtil;
        }

        @Generated
        public void setTime(Long time) {
            this.time = time;
        }

        @Generated
        public void setCpuUtil(Integer cpuUtil) {
            this.cpuUtil = cpuUtil;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof OsgCpuUtil)) {
                return false;
            }
            OsgCpuUtil other = (OsgCpuUtil)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$time = this.getTime();
            Long other$time = other.getTime();
            if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
                return false;
            }
            Integer this$cpuUtil = this.getCpuUtil();
            Integer other$cpuUtil = other.getCpuUtil();
            return !(this$cpuUtil == null ? other$cpuUtil != null : !((Object)this$cpuUtil).equals(other$cpuUtil));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OsgCpuUtil;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
            Integer $cpuUtil = this.getCpuUtil();
            result = result * 59 + ($cpuUtil == null ? 43 : ((Object)$cpuUtil).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OsgHighCpuUtilDetector.OsgCpuUtil(time=" + this.getTime() + ", cpuUtil=" + this.getCpuUtil() + ")";
        }

        @Generated
        public OsgCpuUtil(Long time, Integer cpuUtil) {
            this.time = time;
            this.cpuUtil = cpuUtil;
        }
    }
}

