/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.eap.roam;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.AbstractDeviceDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.ApsDelayStatDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.client.ClientRoamDeviceDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.client.RoamTimeDTO;
import com.tplink.smb.omada.anomaly.api.dto.common.dto.ApDelayStatDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.b;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.client.api.internal.c;
import com.tplink.smb.omada.client.api.internal.dto.ClientRoamRecordQueryDTO;
import com.tplink.smb.omada.client.api.internal.dto.clientanomaly.ClientRoamRecordDTO;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.I;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.ClientObjectDTO;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.DeviceObjectDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoamingUnusualDetector
implements a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(RoamingUnusualDetector.class);
    private static final int b = 8;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a c;
    @Autowired
    private e d;
    @Autowired
    private c e;

    @Override
    public com.tplink.smb.omada.anomaly.api.b.c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.aI;
    }

    @Override
    public f c() {
        return f.e;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b detectTimeRange) {
        ClientRoamRecordQueryDTO queryDTO = new ClientRoamRecordQueryDTO(detectTimeRange.a(), detectTimeRange.b(), Long.valueOf(detectTimeRange.d()));
        Map clientRoamRecordMap = this.e.a(queryDTO);
        if (CollectionUtils.isEmptyMap((Map)clientRoamRecordMap)) {
            return Collections.emptyList();
        }
        if (a.isDebugEnabled()) {
            a.debug("roam anomaly detect for omadac {} site {}, roam record is: {}", new Object[]{detectTimeRange.a(), detectTimeRange.b(), x.a((Object)clientRoamRecordMap)});
        }
        AnomalyEventSettingDTO frequentRoamSetting = detectTimeRange.e().get(com.tplink.smb.omada.anomaly.api.b.c.aH.a());
        AnomalyEventSettingDTO roamSlowSetting = detectTimeRange.e().get(this.a().a());
        ArrayList<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEvents = new ArrayList<com.tplink.smb.omada.anomaly.core.domain.model.a.b>();
        for (Map.Entry entry : clientRoamRecordMap.entrySet()) {
            String clientMac = (String)entry.getKey();
            ClientRoamRecordDTO clientRoamRecordDTO = (ClientRoamRecordDTO)entry.getValue();
            this.b(clientMac, roamSlowSetting, detectTimeRange, clientRoamRecordDTO, anomalyEvents);
            this.a(clientMac, frequentRoamSetting, detectTimeRange, clientRoamRecordDTO, anomalyEvents);
        }
        return anomalyEvents;
    }

    @Override
    public void a(String omadacId, String siteId, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEventSet, Map<String, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b>> causeMap, com.tplink.smb.omada.anomaly.core.domain.model.b.a associateResult) {
        com.tplink.smb.omada.anomaly.api.b.c highSrvDelayEnum = com.tplink.smb.omada.anomaly.api.b.c.at;
        for (com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent : anomalyEventSet) {
            ClientRoamDeviceDTO clientRoamDeviceDTO = (ClientRoamDeviceDTO)anomalyEvent.B();
            if (!Objects.nonNull(clientRoamDeviceDTO)) continue;
            ArrayList<String> devMacs = new ArrayList<String>();
            ApsDelayStatDTO apsDelayStatDTO = new ApsDelayStatDTO();
            HashMap<String, DeviceObjectDTO> devices = new HashMap<String, DeviceObjectDTO>();
            ArrayList<ApsDelayStatDTO.ApsDelay> allDelays = new ArrayList<ApsDelayStatDTO.ApsDelay>();
            for (String deviceMac : clientRoamDeviceDTO.getDevMacs()) {
                Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> highDelayCauses = causeMap.get(com.tplink.smb.omada.anomaly.core.domain.model.rule.b.a(deviceMac, highSrvDelayEnum));
                if (CollectionUtils.isEmpty(highDelayCauses)) continue;
                com.tplink.smb.omada.anomaly.core.domain.model.a.b highDelayCause = highDelayCauses.iterator().next();
                devMacs.add(deviceMac);
                this.a(deviceMac, highDelayCause, allDelays);
                devices.put(deviceMac, this.d.a(omadacId, siteId, deviceMac));
            }
            apsDelayStatDTO.setDevMacs(devMacs);
            apsDelayStatDTO.setAllDelays(allDelays);
            if (!CollectionUtils.isNotEmpty((Collection)apsDelayStatDTO.getDevMacs())) continue;
            com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(anomalyEvent.g()).a(anomalyEvent.k()).a(com.tplink.smb.omada.anomaly.api.b.c.as).a(CollectionUtils.toStringMap((String[])new String[]{"devMac", (String)devMacs.get(0)})).d(devices).c(Collections.singletonMap("apDelays", apsDelayStatDTO)).a();
            anomalyEvent.d(cause);
        }
    }

    private void a(String clientMac, AnomalyEventSettingDTO frequentRoamSetting, com.tplink.smb.omada.anomaly.core.domain.model.b.b detectTimeRange, ClientRoamRecordDTO roamRecordDTO, List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEvents) {
        if (Boolean.FALSE.equals(frequentRoamSetting.getEnable())) {
            return;
        }
        int frequentRoamThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(frequentRoamSetting, "threshold", 10);
        String omadacId = detectTimeRange.a();
        String siteId = detectTimeRange.b();
        a.debug("roam frequently detect for omadac {} site {} client {}, roam record is: {}", new Object[]{omadacId, siteId, clientMac, roamRecordDTO});
        if (CollectionUtils.isNotEmpty((Collection)roamRecordDTO.getRoamItems()) && roamRecordDTO.getRoamItems().size() >= frequentRoamThreshold) {
            ArrayList<RoamTimeDTO> roamTimes = new ArrayList<RoamTimeDTO>();
            HashSet devMacs = new HashSet();
            roamRecordDTO.getRoamItems().forEach(roamItem -> {
                if (Objects.nonNull(roamItem.getRoamTime())) {
                    roamTimes.add(RoamTimeDTO.builder().time(roamItem.getRoamTime()).duration(roamItem.getDuration()).build());
                }
                devMacs.add(roamItem.getSourceAp());
                devMacs.add(roamItem.getTargetAp());
            });
            if (roamTimes.size() < frequentRoamThreshold) {
                return;
            }
            HashMap<String, Object> detail = new HashMap<String, Object>(2);
            roamTimes.sort(Comparator.comparing(RoamTimeDTO::getTime));
            detail.put("roams", roamTimes);
            ArrayList deviceMacList = new ArrayList();
            HashMap<String, DeviceObjectDTO> devices = new HashMap<String, DeviceObjectDTO>();
            devMacs.forEach(mac -> {
                deviceMacList.add(new DeviceMac((String)mac));
                devices.put((String)mac, this.d.a(omadacId, siteId, (String)mac));
            });
            detail.put("devMacs", deviceMacList);
            com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.c.a()).c(omadacId).d(siteId).a(clientMac).a(detectTimeRange.d()).a(com.tplink.smb.omada.anomaly.api.b.c.aH).a(this.a(frequentRoamSetting)).a(CollectionUtils.toStringMap((String[])new String[]{"clientMac", clientMac})).b(CollectionUtils.toStringMap((String[])new String[]{"count", String.valueOf(frequentRoamThreshold)})).c(detail).d(devices).e(Collections.singletonMap(clientMac, ClientObjectDTO.builder().name(roamRecordDTO.getClientName()).deviceType(roamRecordDTO.getDeviceType()).ip(roamRecordDTO.getIp()).build())).a();
            com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = this.a(anomalyEvent);
            anomalyEvent.d(cause);
            anomalyEvent.a(true);
            a.debug("omadac: {}, site: {}, roam frequent: {}", new Object[]{omadacId, siteId, anomalyEvent});
            anomalyEvents.add(anomalyEvent);
        }
    }

    private void b(String clientMac, AnomalyEventSettingDTO roamSlowSetting, com.tplink.smb.omada.anomaly.core.domain.model.b.b detectTimeRange, ClientRoamRecordDTO roamRecordDTO, List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEvents) {
        if (Boolean.FALSE.equals(roamSlowSetting.getEnable()) || roamRecordDTO.getRoamItems().size() < 8) {
            return;
        }
        long slowRoamingThreshold = (long)com.tplink.smb.omada.anomaly.core.port.f.a.a(roamSlowSetting, "duration", 3) * 1000L;
        int slowRoamingRatio = com.tplink.smb.omada.anomaly.core.port.f.a.a(roamSlowSetting, "threshold", 20);
        String omadacId = detectTimeRange.a();
        String siteId = detectTimeRange.b();
        a.debug("roam slowly detect for omadac {} site {} client {}, roam record is: {}", new Object[]{omadacId, siteId, clientMac, roamRecordDTO});
        int slowRoamCnt = 0;
        int ntpSyncCnt = 0;
        ArrayList<RoamTimeDTO> roamTimes = new ArrayList<RoamTimeDTO>();
        HashSet<String> devMacs = new HashSet<String>();
        for (ClientRoamRecordDTO.RoamItem roamItem : roamRecordDTO.getRoamItems()) {
            if (!Boolean.TRUE.equals(roamItem.getNtpSync())) continue;
            ++ntpSyncCnt;
            if (I.a((Long)roamItem.getDuration()) < slowRoamingThreshold) continue;
            ++slowRoamCnt;
            roamTimes.add(RoamTimeDTO.builder().time(roamItem.getRoamTime()).duration(roamItem.getDuration()).build());
            devMacs.add(roamItem.getSourceAp());
            devMacs.add(roamItem.getTargetAp());
        }
        a.debug("slowRoamCnt: {}, ntpSyncCnt: {}", (Object)slowRoamCnt, (Object)ntpSyncCnt);
        if (ntpSyncCnt != 0 && slowRoamCnt * 100 >= ntpSyncCnt * slowRoamingRatio) {
            com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.c.a()).c(omadacId).d(siteId).a(clientMac).a(detectTimeRange.d()).a(com.tplink.smb.omada.anomaly.api.b.c.aI).a(this.a(roamSlowSetting)).a(CollectionUtils.toStringMap((String[])new String[]{"clientMac", clientMac})).b(CollectionUtils.toStringMap((String[])new String[]{"duration", String.valueOf(slowRoamingThreshold / 1000L), "threshold", String.valueOf(slowRoamingRatio)})).c(Collections.singletonMap("roams", roamTimes)).e(Collections.singletonMap(clientMac, ClientObjectDTO.builder().name(roamRecordDTO.getClientName()).deviceType(roamRecordDTO.getDeviceType()).ip(roamRecordDTO.getIp()).build())).a((AbstractDeviceDTO)new ClientRoamDeviceDTO(new ArrayList(devMacs))).a();
            com.tplink.smb.omada.anomaly.core.domain.model.a.b interCause = this.a(anomalyEvent, devMacs);
            anomalyEvent.d(interCause);
            a.debug("omadac: {}, site: {}, roam slow: {}", new Object[]{omadacId, siteId, anomalyEvent});
            anomalyEvents.add(anomalyEvent);
        }
    }

    private com.tplink.smb.omada.anomaly.core.domain.model.a.b a(com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent) {
        return com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(anomalyEvent.g()).a(anomalyEvent.k()).a(com.tplink.smb.omada.anomaly.api.b.c.aG).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(com.tplink.smb.omada.anomaly.api.b.c.aG)).a();
    }

    private com.tplink.smb.omada.anomaly.core.domain.model.a.b a(com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent, Set<String> devMacs) {
        String omadacId = anomalyEvent.i();
        String siteId = anomalyEvent.j();
        HashMap<String, DeviceObjectDTO> devices = new HashMap<String, DeviceObjectDTO>();
        ArrayList deviceMacList = new ArrayList();
        if (CollectionUtils.isNotEmpty(devMacs)) {
            devMacs.forEach(mac -> {
                devices.put((String)mac, this.d.a(omadacId, siteId, (String)mac));
                deviceMacList.add(new DeviceMac((String)mac));
            });
        }
        return com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(anomalyEvent.g()).a(anomalyEvent.k()).a(com.tplink.smb.omada.anomaly.api.b.c.aa).d(devices).c(Collections.singletonMap("devMacs", deviceMacList)).a();
    }

    private void a(String deviceMac, com.tplink.smb.omada.anomaly.core.domain.model.a.b highDelayCause, List<ApsDelayStatDTO.ApsDelay> allDelays) {
        block4: {
            if (!CollectionUtils.isNotEmptyMap(highDelayCause.r()) || !highDelayCause.r().containsKey("delay")) break block4;
            List apDelayStatDTOS = (List)highDelayCause.r().get("delay");
            if (CollectionUtils.isEmpty(allDelays)) {
                for (ApDelayStatDTO apDelayStatDTO : apDelayStatDTOS) {
                    ArrayList<ApsDelayStatDTO.Delays> delays = new ArrayList<ApsDelayStatDTO.Delays>();
                    delays.add(new ApsDelayStatDTO.Delays(deviceMac, apDelayStatDTO.getDelay()));
                    allDelays.add(new ApsDelayStatDTO.ApsDelay(apDelayStatDTO.getTime(), delays));
                }
            } else {
                int index = 0;
                for (ApDelayStatDTO apDelayStatDTO : apDelayStatDTOS) {
                    ApsDelayStatDTO.ApsDelay apsDelay = allDelays.get(index);
                    apsDelay.getDelays().add(new ApsDelayStatDTO.Delays(deviceMac, apDelayStatDTO.getDelay()));
                }
            }
        }
    }

    @KeepClass
    public static class DeviceMac {
        private String devMac;

        @Generated
        public String getDevMac() {
            return this.devMac;
        }

        @Generated
        public void setDevMac(String devMac) {
            this.devMac = devMac;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof DeviceMac)) {
                return false;
            }
            DeviceMac other = (DeviceMac)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$devMac = this.getDevMac();
            String other$devMac = other.getDevMac();
            return !(this$devMac == null ? other$devMac != null : !this$devMac.equals(other$devMac));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DeviceMac;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $devMac = this.getDevMac();
            result = result * 59 + ($devMac == null ? 43 : $devMac.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RoamingUnusualDetector.DeviceMac(devMac=" + this.getDevMac() + ")";
        }

        @Generated
        public DeviceMac(String devMac) {
            this.devMac = devMac;
        }
    }
}

