/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.eap.roam;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.ApRoamSuccessRateDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.a.b;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.client.api.internal.c;
import com.tplink.smb.omada.client.api.internal.dto.ClientRoamRecordQueryDTO;
import com.tplink.smb.omada.client.api.internal.dto.clientanomaly.ClientRoamRecordDTO;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.ClientObjectDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoamSuccessRateDetector
implements a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(RoamSuccessRateDetector.class);
    private static final int b = 8;
    private static final int c = 20;
    private static final List<com.tplink.smb.omada.anomaly.api.b.c> d = new ArrayList<com.tplink.smb.omada.anomaly.api.b.c>(Arrays.asList(com.tplink.smb.omada.anomaly.api.b.c.ba, com.tplink.smb.omada.anomaly.api.b.c.Y));
    private static final List<com.tplink.smb.omada.anomaly.api.b.c> e = new ArrayList<com.tplink.smb.omada.anomaly.api.b.c>(Collections.singletonList(com.tplink.smb.omada.anomaly.api.b.c.Y));
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a f;
    @Autowired
    private e g;
    @Autowired
    private c h;

    @Override
    public com.tplink.smb.omada.anomaly.api.b.c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.aD;
    }

    @Override
    public f c() {
        return com.tplink.smb.omada.anomaly.api.b.f.e;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.api.b.c> d() {
        return d;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.api.b.c> f() {
        return e;
    }

    @Override
    public void a(String omadacId, String siteId, Set<b> anomalyEventSet, Map<String, Set<b>> causeMap, com.tplink.smb.omada.anomaly.core.domain.model.b.a associateResult) {
        this.b(omadacId, siteId, anomalyEventSet, causeMap, associateResult);
    }

    @Override
    public List<b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b detectTimeRange, String mac, List<DevicePreprocessDTO> devicePreDataList) {
        if (CollectionUtils.isEmpty(devicePreDataList)) {
            return Collections.emptyList();
        }
        AnomalyEventSettingDTO anomalyEventSetting = detectTimeRange.e().get(this.a().a());
        int successRateThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSetting, "threshold", 50);
        long suggestRoamCnt = 0L;
        HashMap<String, Integer> suggestRoamMap = new HashMap<String, Integer>();
        HashMap<String, ClientObjectDTO> clients = new HashMap<String, ClientObjectDTO>();
        suggestRoamCnt = this.a(suggestRoamCnt, devicePreDataList, suggestRoamMap, clients);
        if (suggestRoamMap.size() < 8 || suggestRoamCnt == 0L) {
            return Collections.emptyList();
        }
        ClientRoamRecordQueryDTO queryDTO = new ClientRoamRecordQueryDTO(detectTimeRange.a(), detectTimeRange.b(), Long.valueOf(detectTimeRange.d()));
        Map clientRoamRecordMap = this.h.a(queryDTO);
        long roamSuccessCnt = 0L;
        HashMap<String, Integer> successRoamMap = new HashMap<String, Integer>();
        for (Map.Entry entry : suggestRoamMap.entrySet()) {
            ClientRoamRecordDTO clientRoamRecordDTO = (ClientRoamRecordDTO)clientRoamRecordMap.get(entry.getKey());
            if (!Objects.nonNull(clientRoamRecordDTO)) continue;
            long l2 = clientRoamRecordDTO.getRoamItems().stream().filter(roamItem -> Objects.equals(mac, roamItem.getSourceAp())).count();
            successRoamMap.put((String)entry.getKey(), (int)l2);
            roamSuccessCnt += l2;
        }
        a.debug("detect anomaly event {} on AP {}, successCount is {}, suggestCount is {}", new Object[]{this.a(), mac, roamSuccessCnt, suggestRoamCnt});
        if (roamSuccessCnt * 100L > suggestRoamCnt * (long)successRateThreshold) {
            return Collections.emptyList();
        }
        ArrayList<RoamFailure> roamFailureList = new ArrayList<RoamFailure>();
        for (Map.Entry entry : suggestRoamMap.entrySet()) {
            int successCnt = successRoamMap.getOrDefault(entry.getKey(), 0);
            roamFailureList.add(new RoamFailure((String)entry.getKey(), (Integer)entry.getValue() - successCnt));
        }
        List<RoamFailure> result = roamFailureList.stream().filter(roamFailure -> roamFailure.getRoamFailCount() > 0).sorted(Comparator.comparing(RoamFailure::getRoamFailCount, Comparator.reverseOrder())).collect(Collectors.toList());
        if (result.size() > 20) {
            result = result.subList(0, 20);
        }
        HashMap<String, ClientObjectDTO> hashMap = new HashMap<String, ClientObjectDTO>();
        result.forEach(roamFailure -> topClients.put(roamFailure.getClientMac(), this.a(clients, roamFailure.getClientMac())));
        b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.f.a()).a(mac).c(detectTimeRange.a()).d(detectTimeRange.b()).a(detectTimeRange.d()).a(this.a()).a(this.a(anomalyEventSetting)).a();
        anomalyEvent.a(CollectionUtils.toStringMap((String[])new String[]{"devMac", mac}), CollectionUtils.toStringMap((String[])new String[]{"threshold", String.valueOf(successRateThreshold)}), Collections.singletonMap("roams", result), Collections.singletonMap(mac, this.g.a(detectTimeRange.a(), detectTimeRange.b(), mac)), hashMap, null);
        b apsDistanceFar = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(mac).c(detectTimeRange.a()).d(detectTimeRange.b()).a(detectTimeRange.d()).a(com.tplink.smb.omada.anomaly.api.b.c.aE).a(com.tplink.smb.omada.anomaly.api.b.c.aE.c()).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(com.tplink.smb.omada.anomaly.api.b.c.aE)).a();
        anomalyEvent.d(apsDistanceFar);
        return Collections.singletonList(anomalyEvent);
    }

    private long a(long suggestRoamCnt, List<DevicePreprocessDTO> devicePreDataList, Map<String, Integer> suggestRoamMap, Map<String, ClientObjectDTO> clients) {
        for (DevicePreprocessDTO devicePreprocessDTO : devicePreDataList) {
            if (Objects.isNull(devicePreprocessDTO.getPreprocessData()) || Objects.isNull(devicePreprocessDTO.getPreprocessData().get(this.a().a()))) continue;
            ApRoamSuccessRateDTO apRoamSuccessRateDTO = (ApRoamSuccessRateDTO)devicePreprocessDTO.getPreprocessData().get(this.a().a());
            this.a(apRoamSuccessRateDTO, clients);
            for (ApRoamSuccessRateDTO.RoamClientRecord roamClientRecord : apRoamSuccessRateDTO.getRoamClients()) {
                String clientMac = roamClientRecord.getMac();
                suggestRoamCnt += (long)roamClientRecord.getSuggestRoamCnt().intValue();
                if (suggestRoamMap.containsKey(clientMac)) {
                    suggestRoamMap.put(clientMac, suggestRoamMap.get(clientMac) + roamClientRecord.getSuggestRoamCnt());
                    continue;
                }
                suggestRoamMap.put(clientMac, roamClientRecord.getSuggestRoamCnt());
            }
        }
        return suggestRoamCnt;
    }

    private void a(ApRoamSuccessRateDTO apRoamSuccessRateDTO, Map<String, ClientObjectDTO> clients) {
        apRoamSuccessRateDTO.getClientObjectMap().forEach((clientMac, clientObjectDTO) -> {
            if (clients.containsKey(clientMac)) {
                ClientObjectDTO clientObject = (ClientObjectDTO)clients.get(clientMac);
                clientObject.setIp(clientObjectDTO.getIp());
                if (Objects.nonNull(clientObjectDTO.getName())) {
                    clientObject.setName(clientObjectDTO.getName());
                }
            } else {
                clients.put((String)clientMac, (ClientObjectDTO)clientObjectDTO);
            }
        });
    }

    private ClientObjectDTO a(Map<String, ClientObjectDTO> clientObjectMap, String clientMac) {
        ClientObjectDTO clientObjectDTO;
        if (clientObjectMap.containsKey(clientMac)) {
            clientObjectDTO = clientObjectMap.get(clientMac);
            if (Objects.isNull(clientObjectDTO.getName())) {
                clientObjectDTO.setName(clientMac);
            }
            if (Objects.isNull(clientObjectDTO.getDeviceType())) {
                clientObjectDTO.setDeviceType(com.tplink.smb.omada.anomaly.core.domain.model.d.a.a(clientObjectDTO.getName()));
            }
        } else {
            clientObjectDTO = ClientObjectDTO.builder().deviceType("unknown").ip(null).name(clientMac).build();
        }
        return clientObjectDTO;
    }

    @KeepClass
    private static class RoamFailure {
        private String clientMac;
        private Integer roamFailCount;

        @Generated
        public String getClientMac() {
            return this.clientMac;
        }

        @Generated
        public Integer getRoamFailCount() {
            return this.roamFailCount;
        }

        @Generated
        public void setClientMac(String clientMac) {
            this.clientMac = clientMac;
        }

        @Generated
        public void setRoamFailCount(Integer roamFailCount) {
            this.roamFailCount = roamFailCount;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof RoamFailure)) {
                return false;
            }
            RoamFailure other = (RoamFailure)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$roamFailCount = this.getRoamFailCount();
            Integer other$roamFailCount = other.getRoamFailCount();
            if (this$roamFailCount == null ? other$roamFailCount != null : !((Object)this$roamFailCount).equals(other$roamFailCount)) {
                return false;
            }
            String this$clientMac = this.getClientMac();
            String other$clientMac = other.getClientMac();
            return !(this$clientMac == null ? other$clientMac != null : !this$clientMac.equals(other$clientMac));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RoamFailure;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $roamFailCount = this.getRoamFailCount();
            result = result * 59 + ($roamFailCount == null ? 43 : ((Object)$roamFailCount).hashCode());
            String $clientMac = this.getClientMac();
            result = result * 59 + ($clientMac == null ? 43 : $clientMac.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RoamSuccessRateDetector.RoamFailure(clientMac=" + this.getClientMac() + ", roamFailCount=" + this.getRoamFailCount() + ")";
        }

        @Generated
        public RoamFailure(String clientMac, Integer roamFailCount) {
            this.clientMac = clientMac;
            this.roamFailCount = roamFailCount;
        }
    }
}

