/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.eap.networking;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.c;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.AbstractDeviceDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.BatchApMacsDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.a.h;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.b;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.DeviceObjectDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BatchApDisconnectDetector
implements a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(BatchApDisconnectDetector.class);
    private static final int b = 2;
    private static final int c = 60;
    private static final int d = 5;
    private static final int e = 5;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a f;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.e g;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.model.rule.a.a h;
    @Autowired
    private h i;
    private static final List<c> j = new LinkedList<c>(Arrays.asList(com.tplink.smb.omada.anomaly.api.b.c.s, com.tplink.smb.omada.anomaly.api.b.c.u, com.tplink.smb.omada.anomaly.api.b.c.v, com.tplink.smb.omada.anomaly.api.b.c.q, com.tplink.smb.omada.anomaly.api.b.c.c, com.tplink.smb.omada.anomaly.api.b.c.d, com.tplink.smb.omada.anomaly.api.b.c.o));
    private static final List<c> k = new ArrayList<c>();
    private static final List<c> l = new ArrayList<c>(Arrays.asList(com.tplink.smb.omada.anomaly.api.b.c.s, com.tplink.smb.omada.anomaly.api.b.c.u, com.tplink.smb.omada.anomaly.api.b.c.v, com.tplink.smb.omada.anomaly.api.b.c.q, com.tplink.smb.omada.anomaly.api.b.c.o, com.tplink.smb.omada.anomaly.api.b.c.c));

    @Override
    public c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.r;
    }

    @Override
    public f c() {
        return com.tplink.smb.omada.anomaly.api.b.f.e;
    }

    @Override
    public List<c> d() {
        return j;
    }

    @Override
    public List<c> e() {
        return k;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange, Map<String, List<DevicePreprocessDTO>> devicePreprocessDataMap) {
        long totalAp = 0L;
        long disconnectAp = 0L;
        long disconnectCount = 0L;
        HashMap<String, Long> disconnectAps = new HashMap<String, Long>();
        for (Map.Entry<String, List<DevicePreprocessDTO>> entry : devicePreprocessDataMap.entrySet()) {
            String mac = entry.getKey();
            List<DevicePreprocessDTO> devicePreDataList = entry.getValue();
            if (Objects.isNull(mac) || !this.a(devicePreDataList)) continue;
            TreeMap<Long, Integer> timeEvents = new TreeMap<Long, Integer>();
            com.tplink.smb.omada.anomaly.core.domain.model.rule.eap.networking.a.a(devicePreDataList, timeEvents);
            ArrayList<Long> upTimes = new ArrayList<Long>();
            ArrayList<Long> downTimes = new ArrayList<Long>();
            com.tplink.smb.omada.anomaly.core.domain.model.rule.c.a.a(timeEvents, anomalyDetectTimeRange.d() - this.c().c(), upTimes, downTimes);
            ++totalAp;
            if (downTimes.isEmpty()) continue;
            ++disconnectAp;
            disconnectCount += (long)downTimes.size();
            disconnectAps.put(mac, (Long)downTimes.get(downTimes.size() - 1));
        }
        a.debug("timing detect batch ap disconnected, total ap: {}, disconnectCount: {}, disconnectAPs: {}", new Object[]{totalAp, disconnectCount, disconnectAps});
        return this.a(totalAp, disconnectAp, disconnectCount, disconnectAps, anomalyDetectTimeRange);
    }

    private List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> a(long totalAp, long disconnectAp, long disconnectCount, Map<String, Long> disconnectAps, com.tplink.smb.omada.anomaly.core.domain.model.b.b detectTimeRange) {
        boolean reachDisconnectNum;
        if (totalAp <= 5L) {
            return Collections.emptyList();
        }
        AnomalyEventSettingDTO batchApDisconnectSetting = com.tplink.smb.omada.anomaly.core.port.f.a.a(detectTimeRange, this.a());
        int avgDisconnectCountThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(batchApDisconnectSetting, "avgDisconnectCount", 2);
        int batchDisconnectRadioThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(batchApDisconnectSetting, "disconnectApPercent", 60);
        int batchDisconnectNumThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(batchApDisconnectSetting, "disconnectCount", 5);
        boolean reachAvgDisconnectNum = disconnectCount >= totalAp * (long)avgDisconnectCountThreshold;
        boolean reachDisconnectRadio = disconnectAp * 100L >= totalAp * (long)batchDisconnectRadioThreshold;
        boolean bl = reachDisconnectNum = disconnectAp >= (long)batchDisconnectNumThreshold;
        if (reachAvgDisconnectNum || reachDisconnectRadio || reachDisconnectNum) {
            com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.f.a()).b(detectTimeRange.b()).c(detectTimeRange.a()).d(detectTimeRange.b()).a(detectTimeRange.d()).a(this.a()).a(this.a(batchApDisconnectSetting)).a();
            HashMap<String, String> satisfiedCondition = new HashMap<String, String>();
            this.a(satisfiedCondition, reachAvgDisconnectNum, "avgDisconnectCount", String.valueOf(avgDisconnectCountThreshold));
            this.a(satisfiedCondition, reachDisconnectRadio, "disconnectApPercent", String.valueOf(batchDisconnectRadioThreshold));
            this.a(satisfiedCondition, reachDisconnectNum, "disconnectCount", String.valueOf(batchDisconnectNumThreshold));
            HashMap<String, DeviceObjectDTO> deviceObjectMap = new HashMap<String, DeviceObjectDTO>();
            HashSet<String> apMacs = new HashSet<String>();
            ArrayList<DisconnectRecord> disconnectRecords = new ArrayList<DisconnectRecord>();
            for (Map.Entry<String, Long> entry : disconnectAps.entrySet()) {
                String mac = entry.getKey();
                Long time = entry.getValue();
                DeviceObjectDTO deviceObjectDTO = this.g.b(detectTimeRange.a(), detectTimeRange.b(), mac, DeviceTypeEnum.a);
                deviceObjectMap.put(mac, deviceObjectDTO);
                apMacs.add(mac);
                disconnectRecords.add(new DisconnectRecord(mac, time));
            }
            BatchApMacsDTO batchApMacsDTO = new BatchApMacsDTO(apMacs);
            anomalyEvent.a(null, satisfiedCondition, CollectionUtils.toMap((Object[])new Object[]{"disconnectRecords", disconnectRecords}), deviceObjectMap, null, null);
            anomalyEvent.a((AbstractDeviceDTO)batchApMacsDTO);
            this.a(anomalyEvent, detectTimeRange);
            a.debug("detect {} for APs {}", (Object)this.a(), disconnectAps);
            return Collections.singletonList(anomalyEvent);
        }
        return Collections.emptyList();
    }

    private boolean a(List<DevicePreprocessDTO> devicePreprocessDTOList) {
        if (CollectionUtils.isEmpty(devicePreprocessDTOList)) {
            return false;
        }
        for (DevicePreprocessDTO devicePreprocessDTO : devicePreprocessDTOList) {
            if (Objects.isNull(devicePreprocessDTO)) continue;
            return Objects.equals(devicePreprocessDTO.getDeviceType(), DeviceTypeEnum.a);
        }
        return false;
    }

    private void a(Map<String, String> map, boolean condition, String key, String value) {
        if (condition) {
            map.put(key, value);
        }
    }

    private void a(com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent, com.tplink.smb.omada.anomaly.core.domain.model.b.b detectTimeRange) {
        for (c causeEnum : l) {
            com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = this.h.a(detectTimeRange.a(), detectTimeRange.b(), null, detectTimeRange.d(), causeEnum);
            anomalyEvent.d(cause);
        }
    }

    @Override
    public void a(String omadacId, String siteId, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEventSet, Map<String, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b>> causeMap, com.tplink.smb.omada.anomaly.core.domain.model.b.a associateResult) {
        a.debug("BATCH AP DISCONNECT omadac : {} siteId : {} is : {}", new Object[]{omadacId, siteId, causeMap});
        for (com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent : anomalyEventSet) {
            BatchApMacsDTO batchApMacsDTO;
            if (Objects.isNull(anomalyEvent.B()) || !(anomalyEvent.B() instanceof BatchApMacsDTO) || !Objects.nonNull((batchApMacsDTO = (BatchApMacsDTO)anomalyEvent.B()).getApMacs())) continue;
            this.a(omadacId, siteId, anomalyEvent, causeMap, associateResult, batchApMacsDTO.getApMacs());
        }
    }

    private void a(String omadacId, String siteId, com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent, Map<String, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b>> causeMap, com.tplink.smb.omada.anomaly.core.domain.model.b.a associateResult, Set<String> macs) {
        c causeEnum = com.tplink.smb.omada.anomaly.api.b.c.d;
        for (String mac : macs) {
            Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> associateCauses = causeMap.get(com.tplink.smb.omada.anomaly.core.domain.model.rule.b.a(mac, causeEnum));
            long intervalTime = com.tplink.smb.omada.anomaly.api.b.f.a.equals((Object)this.c()) ? com.tplink.smb.omada.anomaly.api.b.f.b.c() : this.c().c();
            List filteredCauses = Optional.ofNullable(associateCauses).orElse(Collections.emptySet()).stream().filter(anomalyCause -> anomalyEvent.k() >= anomalyCause.k() && anomalyEvent.k() - anomalyCause.k() < intervalTime).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(filteredCauses)) continue;
            com.tplink.smb.omada.anomaly.core.domain.model.a.b cause = (com.tplink.smb.omada.anomaly.core.domain.model.a.b)filteredCauses.get(filteredCauses.size() - 1);
            associateResult.a(com.tplink.smb.omada.anomaly.core.domain.model.a.e.a().a(com.tplink.smb.omada.anomaly.core.domain.model.a.e.a(anomalyEvent.f(), cause.f())).a(omadacId).b(siteId).a(anomalyEvent.f()).b(cause.f()).a(k.contains(causeEnum)).a());
            return;
        }
    }

    @KeepClass
    static class DisconnectRecord {
        private String devMac;
        private Long lastDisconnectTime;

        @Generated
        public String getDevMac() {
            return this.devMac;
        }

        @Generated
        public Long getLastDisconnectTime() {
            return this.lastDisconnectTime;
        }

        @Generated
        public void setDevMac(String devMac) {
            this.devMac = devMac;
        }

        @Generated
        public void setLastDisconnectTime(Long lastDisconnectTime) {
            this.lastDisconnectTime = lastDisconnectTime;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof DisconnectRecord)) {
                return false;
            }
            DisconnectRecord other = (DisconnectRecord)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$lastDisconnectTime = this.getLastDisconnectTime();
            Long other$lastDisconnectTime = other.getLastDisconnectTime();
            if (this$lastDisconnectTime == null ? other$lastDisconnectTime != null : !((Object)this$lastDisconnectTime).equals(other$lastDisconnectTime)) {
                return false;
            }
            String this$devMac = this.getDevMac();
            String other$devMac = other.getDevMac();
            return !(this$devMac == null ? other$devMac != null : !this$devMac.equals(other$devMac));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DisconnectRecord;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $lastDisconnectTime = this.getLastDisconnectTime();
            result = result * 59 + ($lastDisconnectTime == null ? 43 : ((Object)$lastDisconnectTime).hashCode());
            String $devMac = this.getDevMac();
            result = result * 59 + ($devMac == null ? 43 : $devMac.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BatchApDisconnectDetector.DisconnectRecord(devMac=" + this.getDevMac() + ", lastDisconnectTime=" + this.getLastDisconnectTime() + ")";
        }

        @Generated
        public DisconnectRecord() {
        }

        @Generated
        public DisconnectRecord(String devMac, Long lastDisconnectTime) {
            this.devMac = devMac;
            this.lastDisconnectTime = lastDisconnectTime;
        }
    }
}

