/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.eap.hardware;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.A;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.AbstractDeviceDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.ApCpuUtilDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.c.d;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.a.c;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.b;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.eap.cause.ExcessiveTrafficCauseDetector;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.DeviceObjectDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.wired.lannetwork.dto.LanNetworkDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.wired.lannetwork.dto.QueryLanNetworkDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.SsidBriefDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.dto.ApPortalSettingDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.dto.ApSsidPortalSettingDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HighCpuUtilDetector
implements a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(HighCpuUtilDetector.class);
    private static final int b = 80;
    private static final int c = 20;
    private static final int d = 60;
    private static final long e = 30000L;
    private static final long f = OmadacType.s() ? 150L : 30L;
    private static final List<com.tplink.smb.omada.anomaly.api.b.c> g = new ArrayList<com.tplink.smb.omada.anomaly.api.b.c>(Collections.singletonList(com.tplink.smb.omada.anomaly.api.b.c.bh));
    private static final List<com.tplink.smb.omada.anomaly.api.b.c> h = new ArrayList<com.tplink.smb.omada.anomaly.api.b.c>(Arrays.asList(com.tplink.smb.omada.anomaly.api.b.c.bh, com.tplink.smb.omada.anomaly.api.b.c.aM));
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a i;
    @Autowired
    private e j;
    @Autowired
    private d k;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.model.rule.a.a l;
    @Autowired
    private c m;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.a n;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.wired.lannetwork.a o;

    @Override
    public com.tplink.smb.omada.anomaly.api.b.c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.aK;
    }

    @Override
    public f c() {
        return com.tplink.smb.omada.anomaly.api.b.f.c;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.api.b.c> d() {
        return g;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.api.b.c> f() {
        return h;
    }

    @Override
    public void a(String omadacId, String siteId, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEventSet, Map<String, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b>> causeMap, com.tplink.smb.omada.anomaly.core.domain.model.b.a associateResult) {
        ExcessiveTrafficCauseDetector.a(anomalyEventSet, causeMap, new com.tplink.smb.omada.anomaly.api.b.c[0]);
        for (com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent : anomalyEventSet) {
            String deviceMac = anomalyEvent.g();
            Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> loopBackCause = causeMap.get(com.tplink.smb.omada.anomaly.core.domain.model.rule.b.a(deviceMac, com.tplink.smb.omada.anomaly.api.b.c.aM));
            this.a(omadacId, siteId, associateResult, anomalyEvent, loopBackCause, deviceMac, true);
        }
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b detectTimeRange, String mac, List<DevicePreprocessDTO> devicePreDataList) {
        if (CollectionUtils.isEmpty(devicePreDataList)) {
            return Collections.emptyList();
        }
        AnomalyEventSettingDTO anomalyEventSetting = detectTimeRange.e().get(this.a().a());
        int highCpuRiskThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSetting, "threshold", 90);
        int highCpuRatioThreshold = com.tplink.smb.omada.anomaly.core.port.f.a.a(anomalyEventSetting, "count", 80);
        HashMap<A, Long> multiTxThresholdMap = new HashMap();
        long detectTime = detectTimeRange.d();
        TreeMap<Long, ApCpuUtilDTO> cpuUtilDTOMap = new TreeMap<Long, ApCpuUtilDTO>();
        TreeMap<Long, APCpuUtil> cpuUtilMap = new TreeMap<Long, APCpuUtil>();
        int highCpuUtilCount = this.a(devicePreDataList, highCpuRiskThreshold, detectTime, cpuUtilDTOMap, cpuUtilMap);
        if (CollectionUtils.isEmptyMap(cpuUtilDTOMap) || cpuUtilDTOMap.size() * 100 < 1200) {
            return Collections.emptyList();
        }
        if (a.isDebugEnabled()) {
            a.debug("high cpu util anomaly detect for mac {}  omadac {} site {}, cpuUtil map is: {}", new Object[]{mac, detectTimeRange.a(), detectTimeRange.b(), x.a(cpuUtilMap)});
        }
        if (highCpuUtilCount * 100 >= cpuUtilMap.size() * highCpuRatioThreshold) {
            com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.i.a()).a(mac).c(detectTimeRange.a()).d(detectTimeRange.b()).a(detectTime).a(this.a()).a(this.a(anomalyEventSetting)).a();
            DeviceObjectDTO deviceObjectDTO = this.j.b(detectTimeRange.a(), detectTimeRange.b(), mac);
            HashMap<String, com.tplink.smb.omada.anomaly.core.domain.model.a.b> causes = new HashMap<String, com.tplink.smb.omada.anomaly.core.domain.model.a.b>();
            ArrayList<ApCpuUtilDTO> cpuUtilDTOList = new ArrayList<ApCpuUtilDTO>(cpuUtilDTOMap.values());
            if (CollectionUtils.isEmptyMap(multiTxThresholdMap)) {
                multiTxThresholdMap = this.a(detectTimeRange.a(), detectTimeRange.b());
            }
            String upSwitchMac = this.l.g(detectTimeRange.a(), detectTimeRange.b(), mac);
            this.a(mac, causes, detectTimeRange, upSwitchMac, cpuUtilDTOList, multiTxThresholdMap, deviceObjectDTO);
            if (cpuUtilMap.size() < 20) {
                IntStream.range(0, 20).mapToLong(i2 -> detectTime - (long)(20 - i2) * 30000L).forEach(time -> cpuUtilMap.putIfAbsent(time, new APCpuUtil(time)));
            }
            anomalyEvent.a(CollectionUtils.toStringMap((String[])new String[]{"devMac", mac}), CollectionUtils.toStringMap((String[])new String[]{"devMac", mac, "count", String.valueOf(highCpuRatioThreshold), "threshold", String.valueOf(highCpuRiskThreshold)}), Collections.singletonMap("cpuUtils", cpuUtilMap.values()), Collections.singletonMap(mac, deviceObjectDTO), null, CollectionUtils.isEmptyMap(causes) ? null : causes);
            a.debug("detect {} for AP {}", (Object)this.a(), (Object)mac);
            ArrayList<com.tplink.smb.omada.anomaly.core.domain.model.a.b> events = new ArrayList<com.tplink.smb.omada.anomaly.core.domain.model.a.b>();
            events.add(anomalyEvent);
            if (causes.containsKey(com.tplink.smb.omada.anomaly.api.b.c.aL.a())) {
                events.add((com.tplink.smb.omada.anomaly.core.domain.model.a.b)causes.get(com.tplink.smb.omada.anomaly.api.b.c.aL.a()));
            }
            return events;
        }
        return Collections.emptyList();
    }

    private int a(List<DevicePreprocessDTO> devicePreDataList, int highCpuRiskThreshold, long detectTime, Map<Long, ApCpuUtilDTO> cpuUtilDTOMap, Map<Long, APCpuUtil> cpuUtilMap) {
        int highCpuUtilCount = 0;
        for (DevicePreprocessDTO devicePreprocessDTO : devicePreDataList) {
            AbstractDeviceDTO abstractDeviceDTO;
            if (devicePreprocessDTO.getPreprocessData() == null || Objects.isNull(abstractDeviceDTO = devicePreprocessDTO.getPreprocessData().get(this.a().a()))) continue;
            ApCpuUtilDTO apCpuUtilDTO = (ApCpuUtilDTO)abstractDeviceDTO;
            apCpuUtilDTO.setTime(Long.valueOf(com.tplink.smb.omada.anomaly.core.port.f.a.a(apCpuUtilDTO.getTime(), 30000L, detectTime)));
            cpuUtilDTOMap.putIfAbsent(apCpuUtilDTO.getTime(), apCpuUtilDTO);
            cpuUtilMap.putIfAbsent(apCpuUtilDTO.getTime(), new APCpuUtil(apCpuUtilDTO.getTime(), apCpuUtilDTO.getCpuUtil()));
            if (apCpuUtilDTO.getCpuUtil() == null || apCpuUtilDTO.getCpuUtil() < highCpuRiskThreshold) continue;
            ++highCpuUtilCount;
        }
        return highCpuUtilCount;
    }

    private Map<A, Long> a(String omadacId, String siteId) {
        List<SsidBriefDTO> ssidBriefDTOList = this.k.a(omadacId, siteId);
        Map<Integer, Integer> ssidCountMap = ssidBriefDTOList.stream().collect(Collectors.groupingBy(SsidBriefDTO::getBand, Collectors.summingInt(p2 -> 1)));
        int ssidCount2g = 0;
        int ssidCount5g = 0;
        int ssidCount5g2 = 0;
        int ssidCount6g = 0;
        for (Map.Entry<Integer, Integer> entry : ssidCountMap.entrySet()) {
            Integer bandInfo = entry.getKey();
            Integer bandCount = entry.getValue();
            if (com.tplink.smb.omada.anomaly.core.port.f.a.a(bandInfo)) {
                ssidCount2g += bandCount.intValue();
            }
            if (com.tplink.smb.omada.anomaly.core.port.f.a.b(bandInfo)) {
                ssidCount5g += bandCount.intValue();
            }
            if (com.tplink.smb.omada.anomaly.core.port.f.a.c(bandInfo)) {
                ssidCount5g2 += bandCount.intValue();
            }
            if (!com.tplink.smb.omada.anomaly.core.port.f.a.d(bandInfo)) continue;
            ssidCount6g += bandCount.intValue();
        }
        long baseThreshold = 5000000L;
        HashMap<A, Long> multiTxThresholdMap = new HashMap<A, Long>();
        multiTxThresholdMap.put(A.a, baseThreshold / (long)(ssidCount2g == 0 ? 1 : ssidCount2g) * f);
        multiTxThresholdMap.put(A.b, baseThreshold / (long)(ssidCount5g == 0 ? 1 : ssidCount5g) * f);
        multiTxThresholdMap.put(A.c, baseThreshold / (long)(ssidCount5g2 == 0 ? 1 : ssidCount5g2) * f);
        multiTxThresholdMap.put(A.d, baseThreshold / (long)(ssidCount6g == 0 ? 1 : ssidCount6g) * f);
        return multiTxThresholdMap;
    }

    private void a(String apMac, Map<String, com.tplink.smb.omada.anomaly.core.domain.model.a.b> causes, com.tplink.smb.omada.anomaly.core.domain.model.b.b detectTimeRange, String upSwitchMac, List<ApCpuUtilDTO> cpuUtilDTOList, Map<A, Long> multiTxThresholdMap, DeviceObjectDTO deviceObject) {
        if (CollectionUtils.isEmpty(cpuUtilDTOList) || cpuUtilDTOList.size() <= 2) {
            return;
        }
        String omadacId = detectTimeRange.a();
        String siteId = detectTimeRange.b();
        com.tplink.smb.omada.anomaly.api.b.c multiTrafficCause = com.tplink.smb.omada.anomaly.api.b.c.aL;
        long detectTime = detectTimeRange.d();
        TreeMap<Long, APMulticastTx> apMulPktsMap = new TreeMap<Long, APMulticastTx>();
        int highMulPktsCount = 0;
        ApCpuUtilDTO lastCpuUtilDTO = cpuUtilDTOList.get(0);
        for (int index = 1; index < cpuUtilDTOList.size(); ++index) {
            ApCpuUtilDTO cpuUtilDTO = cpuUtilDTOList.get(index);
            APMulticastTx apMulticastTx = this.a(cpuUtilDTO, lastCpuUtilDTO, multiTxThresholdMap, deviceObject);
            apMulPktsMap.putIfAbsent(cpuUtilDTO.getTime(), apMulticastTx);
            if (Boolean.TRUE.equals(apMulticastTx.getHighMulticast())) {
                ++highMulPktsCount;
            }
            apMulticastTx.setHighMulticast(null);
            lastCpuUtilDTO = cpuUtilDTO;
        }
        if (highMulPktsCount * 100 >= apMulPktsMap.size() * 80) {
            com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.i.a()).a(apMac).c(omadacId).d(siteId).a(detectTime).a(multiTrafficCause).d(Collections.singletonMap(apMac, deviceObject)).b(true).a();
            Map<String, com.tplink.smb.omada.anomaly.core.domain.model.a.a> adviceMap = this.a(apMac, upSwitchMac, omadacId, siteId);
            adviceMap.put(com.tplink.smb.omada.anomaly.api.b.b.v.a(), this.m.a());
            anomalyEvent.g(adviceMap);
            int trafficSamples = 19;
            if (apMulPktsMap.size() < 19) {
                IntStream.range(0, 19).mapToLong(i2 -> detectTime - (long)(19 - i2) * 30000L).forEach(time -> apMulPktsMap.putIfAbsent(time, new APMulticastTx(time)));
            }
            anomalyEvent.c(Collections.singletonMap("multiPkts", apMulPktsMap.values()));
            a.debug("detect cause {} for AP {}", (Object)multiTrafficCause.a(), (Object)apMac);
            causes.put(multiTrafficCause.a(), anomalyEvent);
        }
    }

    private Map<String, com.tplink.smb.omada.anomaly.core.domain.model.a.a> a(String apMac, String upSwitchMac, String omadacId, String siteId) {
        HashMap<String, com.tplink.smb.omada.anomaly.core.domain.model.a.a> adviceMap = new HashMap<String, com.tplink.smb.omada.anomaly.core.domain.model.a.a>();
        if (T.a((String)upSwitchMac) || T.a((String)apMac)) {
            return adviceMap;
        }
        OperationResponse apSsidSettingResult = this.n.a(apMac);
        if (Objects.isNull(apSsidSettingResult) || Objects.isNull(apSsidSettingResult.getResult()) || CollectionUtils.isEmpty((Collection)((ApPortalSettingDTO)apSsidSettingResult.getResult()).getSsidList())) {
            return adviceMap;
        }
        List ssidIdList = ((ApPortalSettingDTO)apSsidSettingResult.getResult()).getSsidList().stream().map(ApSsidPortalSettingDTO::getId).collect(Collectors.toList());
        List<SsidBriefDTO> ssidBriefDTOList = this.k.a(omadacId, siteId);
        if (CollectionUtils.isEmpty(ssidBriefDTOList)) {
            return adviceMap;
        }
        Map<String, Integer> ssidVlanMap = ssidBriefDTOList.stream().collect(Collectors.toMap(SsidBriefDTO::getId, SsidBriefDTO::getVlanId));
        OperationResponse lanNetworkDTOResult = this.o.c(QueryLanNetworkDTO.builder().omadacId(omadacId).siteId(siteId).build());
        if (Objects.nonNull(lanNetworkDTOResult) && CollectionUtils.isNotEmpty((Collection)((Collection)lanNetworkDTOResult.getResult()))) {
            Map<Integer, Boolean> vlanIgmpSnoopingMap = ((List)lanNetworkDTOResult.getResult()).stream().filter(lanNetworkDTO -> Objects.nonNull(lanNetworkDTO.getVlan())).collect(Collectors.toMap(LanNetworkDTO::getVlan, LanNetworkDTO::getIgmpSnoopEnable));
            boolean hasDisabledIgmpSnooping = ssidIdList.stream().filter(ssidId -> Objects.nonNull(ssidVlanMap.get(ssidId))).map(ssidVlanMap::get).anyMatch(vlanId -> !Boolean.TRUE.equals(vlanIgmpSnoopingMap.get(vlanId)));
            if (hasDisabledIgmpSnooping) {
                adviceMap.put(com.tplink.smb.omada.anomaly.api.b.b.w.a(), this.m.a());
            }
        }
        return adviceMap;
    }

    private APMulticastTx a(ApCpuUtilDTO cpuUtilDTO, ApCpuUtilDTO lastCpuUtilDTO, Map<A, Long> multiTxThresholdMap, DeviceObjectDTO deviceObject) {
        boolean isSupport6g = Boolean.TRUE.equals(deviceObject.getSupport6g());
        boolean isSupport5g2 = Boolean.TRUE.equals(deviceObject.getSupport5g2());
        boolean apSupportRadios = com.tplink.smb.omada.anomaly.core.port.f.a.a(isSupport6g, isSupport5g2);
        APMulticastTx apMulticastTx = new APMulticastTx();
        apMulticastTx.setTime(cpuUtilDTO.getTime());
        boolean isTrafficExcessive = false;
        for (A radioEnum : apSupportRadios) {
            long threshold;
            long txMulticast = this.a(radioEnum, cpuUtilDTO, lastCpuUtilDTO);
            this.a(apMulticastTx, radioEnum, txMulticast, isSupport5g2);
            if (isTrafficExcessive || txMulticast < (threshold = multiTxThresholdMap.getOrDefault(radioEnum, Long.MAX_VALUE).longValue())) continue;
            isTrafficExcessive = true;
        }
        if (isTrafficExcessive) {
            apMulticastTx.setHighMulticast(true);
        }
        return apMulticastTx;
    }

    private long a(A radioEnum, ApCpuUtilDTO cpuUtilDTO, ApCpuUtilDTO lastCpuUtilDTO) {
        long lastTxMulticast = 0L;
        long thisTxMulticast = 0L;
        switch (radioEnum) {
            case a: {
                lastTxMulticast = Optional.ofNullable(lastCpuUtilDTO.getTxMulticast2g()).orElse(0L);
                thisTxMulticast = Optional.ofNullable(cpuUtilDTO.getTxMulticast2g()).orElse(0L);
                break;
            }
            case b: {
                lastTxMulticast = Optional.ofNullable(lastCpuUtilDTO.getTxMulticast5g()).orElse(0L);
                thisTxMulticast = Optional.ofNullable(cpuUtilDTO.getTxMulticast5g()).orElse(0L);
                break;
            }
            case c: {
                lastTxMulticast = Optional.ofNullable(lastCpuUtilDTO.getTxMulticast5g2()).orElse(0L);
                thisTxMulticast = Optional.ofNullable(cpuUtilDTO.getTxMulticast5g2()).orElse(0L);
                break;
            }
            case d: {
                lastTxMulticast = Optional.ofNullable(lastCpuUtilDTO.getTxMulticast6g()).orElse(0L);
                thisTxMulticast = Optional.ofNullable(cpuUtilDTO.getTxMulticast6g()).orElse(0L);
                break;
            }
        }
        if (thisTxMulticast == 0L) {
            return lastTxMulticast;
        }
        if (lastTxMulticast > thisTxMulticast) {
            return thisTxMulticast;
        }
        return thisTxMulticast - lastTxMulticast;
    }

    private void a(APMulticastTx apMulticastTx, A radioEnum, long txMulticast, boolean isSupport5g2) {
        switch (radioEnum) {
            case a: {
                apMulticastTx.setTxMulPkts2g(txMulticast);
                break;
            }
            case b: {
                if (isSupport5g2) {
                    apMulticastTx.setTxMulPkts5g1(txMulticast);
                    break;
                }
                apMulticastTx.setTxMulPkts5g(txMulticast);
                break;
            }
            case c: {
                apMulticastTx.setTxMulPkts5g2(txMulticast);
                break;
            }
            case d: {
                apMulticastTx.setTxMulPkts6g(txMulticast);
                break;
            }
        }
    }

    @KeepClass
    private static class APCpuUtil {
        private Long time;
        private Integer cpuUtil;

        APCpuUtil(long time) {
            this.time = time;
        }

        @Generated
        public Long getTime() {
            return this.time;
        }

        @Generated
        public Integer getCpuUtil() {
            return this.cpuUtil;
        }

        @Generated
        public void setTime(Long time) {
            this.time = time;
        }

        @Generated
        public void setCpuUtil(Integer cpuUtil) {
            this.cpuUtil = cpuUtil;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof APCpuUtil)) {
                return false;
            }
            APCpuUtil other = (APCpuUtil)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$time = this.getTime();
            Long other$time = other.getTime();
            if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
                return false;
            }
            Integer this$cpuUtil = this.getCpuUtil();
            Integer other$cpuUtil = other.getCpuUtil();
            return !(this$cpuUtil == null ? other$cpuUtil != null : !((Object)this$cpuUtil).equals(other$cpuUtil));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof APCpuUtil;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
            Integer $cpuUtil = this.getCpuUtil();
            result = result * 59 + ($cpuUtil == null ? 43 : ((Object)$cpuUtil).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HighCpuUtilDetector.APCpuUtil(time=" + this.getTime() + ", cpuUtil=" + this.getCpuUtil() + ")";
        }

        @Generated
        public APCpuUtil(Long time, Integer cpuUtil) {
            this.time = time;
            this.cpuUtil = cpuUtil;
        }
    }

    @KeepClass
    private static class APMulticastTx {
        private Long time;
        private Long txMulPkts2g;
        private Long txMulPkts5g;
        private Long txMulPkts5g1;
        private Long txMulPkts5g2;
        private Long txMulPkts6g;
        private Boolean highMulticast;

        APMulticastTx(long time) {
            this.time = time;
        }

        @Generated
        public Long getTime() {
            return this.time;
        }

        @Generated
        public Long getTxMulPkts2g() {
            return this.txMulPkts2g;
        }

        @Generated
        public Long getTxMulPkts5g() {
            return this.txMulPkts5g;
        }

        @Generated
        public Long getTxMulPkts5g1() {
            return this.txMulPkts5g1;
        }

        @Generated
        public Long getTxMulPkts5g2() {
            return this.txMulPkts5g2;
        }

        @Generated
        public Long getTxMulPkts6g() {
            return this.txMulPkts6g;
        }

        @Generated
        public Boolean getHighMulticast() {
            return this.highMulticast;
        }

        @Generated
        public void setTime(Long time) {
            this.time = time;
        }

        @Generated
        public void setTxMulPkts2g(Long txMulPkts2g) {
            this.txMulPkts2g = txMulPkts2g;
        }

        @Generated
        public void setTxMulPkts5g(Long txMulPkts5g) {
            this.txMulPkts5g = txMulPkts5g;
        }

        @Generated
        public void setTxMulPkts5g1(Long txMulPkts5g1) {
            this.txMulPkts5g1 = txMulPkts5g1;
        }

        @Generated
        public void setTxMulPkts5g2(Long txMulPkts5g2) {
            this.txMulPkts5g2 = txMulPkts5g2;
        }

        @Generated
        public void setTxMulPkts6g(Long txMulPkts6g) {
            this.txMulPkts6g = txMulPkts6g;
        }

        @Generated
        public void setHighMulticast(Boolean highMulticast) {
            this.highMulticast = highMulticast;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof APMulticastTx)) {
                return false;
            }
            APMulticastTx other = (APMulticastTx)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$time = this.getTime();
            Long other$time = other.getTime();
            if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
                return false;
            }
            Long this$txMulPkts2g = this.getTxMulPkts2g();
            Long other$txMulPkts2g = other.getTxMulPkts2g();
            if (this$txMulPkts2g == null ? other$txMulPkts2g != null : !((Object)this$txMulPkts2g).equals(other$txMulPkts2g)) {
                return false;
            }
            Long this$txMulPkts5g = this.getTxMulPkts5g();
            Long other$txMulPkts5g = other.getTxMulPkts5g();
            if (this$txMulPkts5g == null ? other$txMulPkts5g != null : !((Object)this$txMulPkts5g).equals(other$txMulPkts5g)) {
                return false;
            }
            Long this$txMulPkts5g1 = this.getTxMulPkts5g1();
            Long other$txMulPkts5g1 = other.getTxMulPkts5g1();
            if (this$txMulPkts5g1 == null ? other$txMulPkts5g1 != null : !((Object)this$txMulPkts5g1).equals(other$txMulPkts5g1)) {
                return false;
            }
            Long this$txMulPkts5g2 = this.getTxMulPkts5g2();
            Long other$txMulPkts5g2 = other.getTxMulPkts5g2();
            if (this$txMulPkts5g2 == null ? other$txMulPkts5g2 != null : !((Object)this$txMulPkts5g2).equals(other$txMulPkts5g2)) {
                return false;
            }
            Long this$txMulPkts6g = this.getTxMulPkts6g();
            Long other$txMulPkts6g = other.getTxMulPkts6g();
            if (this$txMulPkts6g == null ? other$txMulPkts6g != null : !((Object)this$txMulPkts6g).equals(other$txMulPkts6g)) {
                return false;
            }
            Boolean this$highMulticast = this.getHighMulticast();
            Boolean other$highMulticast = other.getHighMulticast();
            return !(this$highMulticast == null ? other$highMulticast != null : !((Object)this$highMulticast).equals(other$highMulticast));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof APMulticastTx;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
            Long $txMulPkts2g = this.getTxMulPkts2g();
            result = result * 59 + ($txMulPkts2g == null ? 43 : ((Object)$txMulPkts2g).hashCode());
            Long $txMulPkts5g = this.getTxMulPkts5g();
            result = result * 59 + ($txMulPkts5g == null ? 43 : ((Object)$txMulPkts5g).hashCode());
            Long $txMulPkts5g1 = this.getTxMulPkts5g1();
            result = result * 59 + ($txMulPkts5g1 == null ? 43 : ((Object)$txMulPkts5g1).hashCode());
            Long $txMulPkts5g2 = this.getTxMulPkts5g2();
            result = result * 59 + ($txMulPkts5g2 == null ? 43 : ((Object)$txMulPkts5g2).hashCode());
            Long $txMulPkts6g = this.getTxMulPkts6g();
            result = result * 59 + ($txMulPkts6g == null ? 43 : ((Object)$txMulPkts6g).hashCode());
            Boolean $highMulticast = this.getHighMulticast();
            result = result * 59 + ($highMulticast == null ? 43 : ((Object)$highMulticast).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HighCpuUtilDetector.APMulticastTx(time=" + this.getTime() + ", txMulPkts2g=" + this.getTxMulPkts2g() + ", txMulPkts5g=" + this.getTxMulPkts5g() + ", txMulPkts5g1=" + this.getTxMulPkts5g1() + ", txMulPkts5g2=" + this.getTxMulPkts5g2() + ", txMulPkts6g=" + this.getTxMulPkts6g() + ", highMulticast=" + this.getHighMulticast() + ")";
        }

        @Generated
        public APMulticastTx() {
        }
    }
}

