/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.eap.cause;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.A;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.traffic.ApExcessiveTrafficDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.a;
import com.tplink.smb.omada.anomaly.core.domain.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.b;
import com.tplink.smb.omada.anomaly.core.domain.model.rule.c;
import com.tplink.smb.omada.client.api.internal.dto.BatchApClientTrafficQueryDTO;
import com.tplink.smb.omada.client.api.internal.dto.clienthealth.ApTopClientTrafficDTO;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.ClientObjectDTO;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.DeviceObjectDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExcessiveTrafficCauseDetector
implements c {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(ExcessiveTrafficCauseDetector.class);
    private static final double b = 0.8;
    private static final int c = OmadacType.s() ? 4 : 20;
    private static final double d = 0.6;
    private static final long e = OmadacType.s() ? 150000L : 30000L;
    private static final long f = 125000L;
    private static final double g = 0.6;
    @Autowired
    private a h;
    @Autowired
    private com.tplink.smb.omada.client.api.internal.c i;
    @Autowired
    private e j;

    @Override
    public com.tplink.smb.omada.anomaly.api.b.c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.bh;
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b timeRange, Map<String, List<DevicePreprocessDTO>> preprocessDataMap, Set<String> devMacs) {
        HashMap<String, com.tplink.smb.omada.anomaly.core.domain.model.a.b> apTrafficCauseMap = new HashMap<String, com.tplink.smb.omada.anomaly.core.domain.model.a.b>();
        devMacs.forEach(apMac -> {
            List preprocessDataList = (List)preprocessDataMap.get(apMac);
            if (CollectionUtils.isEmpty((Collection)preprocessDataList)) {
                return;
            }
            List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEvents = this.a(timeRange, (String)apMac, preprocessDataList);
            if (CollectionUtils.isNotEmpty(anomalyEvents)) {
                apTrafficCauseMap.put((String)apMac, anomalyEvents.get(0));
            }
        });
        if (CollectionUtils.isEmptyMap(apTrafficCauseMap)) {
            return Collections.emptyList();
        }
        ArrayList<ApTopClientTrafficDTO> apTopClientTrafficDTOList = new ArrayList();
        try {
            BatchApClientTrafficQueryDTO clientTrafficQueryDTO = new BatchApClientTrafficQueryDTO(timeRange.a(), timeRange.b(), new ArrayList(apTrafficCauseMap.keySet()));
            apTopClientTrafficDTOList = this.i.a(clientTrafficQueryDTO);
        }
        catch (Exception e2) {
            a.warn("exception occurred while getApTopClientTrafficList for omadac {} site {}, exception:{}", new Object[]{timeRange.a(), timeRange.b(), e2.getMessage(), e2});
        }
        this.a(apTrafficCauseMap, apTopClientTrafficDTOList);
        return new ArrayList<com.tplink.smb.omada.anomaly.core.domain.model.a.b>(apTrafficCauseMap.values());
    }

    @Override
    public List<com.tplink.smb.omada.anomaly.core.domain.model.a.b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange, String mac, List<DevicePreprocessDTO> devicePreDataList) {
        TreeMap trafficDTOMap = devicePreDataList.stream().filter(preprocessDataDTO -> CollectionUtils.isNotEmptyMap(preprocessDataDTO.getPreprocessData())).map(preprocessDataDTO -> preprocessDataDTO.getPreprocessData().get(this.a().a())).filter(Objects::nonNull).map(abstractDeviceDTO -> (ApExcessiveTrafficDTO)abstractDeviceDTO).collect(Collectors.toMap(ApExcessiveTrafficDTO::getTime, trafficDTO -> trafficDTO, (a2, b2) -> a2, TreeMap::new));
        if (CollectionUtils.isEmptyMap((Map)trafficDTOMap) || (double)trafficDTOMap.size() < (double)c * 0.6) {
            return Collections.emptyList();
        }
        String omadacId = anomalyDetectTimeRange.a();
        String siteId = anomalyDetectTimeRange.b();
        long detectTime = anomalyDetectTimeRange.d();
        DeviceObjectDTO deviceObject = this.j.b(anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b(), mac);
        TreeMap<Long, ApExcessiveTraffic> trafficMap = new TreeMap<Long, ApExcessiveTraffic>();
        Iterator iterator = trafficDTOMap.entrySet().iterator();
        ApExcessiveTrafficDTO lastTrafficDTO = (ApExcessiveTrafficDTO)iterator.next().getValue();
        int excessiveCount = 0;
        while (iterator.hasNext()) {
            ApExcessiveTrafficDTO trafficDTO2 = (ApExcessiveTrafficDTO)iterator.next().getValue();
            ApExcessiveTraffic apExcessiveTraffic = this.a(trafficDTO2, lastTrafficDTO, detectTime, deviceObject);
            if (Boolean.TRUE.equals(apExcessiveTraffic.getExcessive())) {
                ++excessiveCount;
            }
            apExcessiveTraffic.setExcessive(null);
            trafficMap.putIfAbsent(apExcessiveTraffic.getTime(), apExcessiveTraffic);
            lastTrafficDTO = trafficDTO2;
        }
        if (CollectionUtils.isEmptyMap(trafficMap) || (double)trafficMap.size() < (double)c * 0.6) {
            return Collections.emptyList();
        }
        if (a.isDebugEnabled()) {
            a.debug("excessive traffic anomaly detect for mac {}  omadac {} site {}, traffic map is: {}", new Object[]{mac, omadacId, siteId, x.a(trafficMap)});
            a.debug("excessive traffic count is {} for AP {}", (Object)excessiveCount, (Object)mac);
        }
        if ((double)excessiveCount >= (double)trafficMap.size() * 0.8) {
            com.tplink.smb.omada.anomaly.core.domain.model.a.b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.h.a()).a(mac).c(omadacId).d(siteId).a(detectTime).a(this.a()).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(this.a())).b(true).a();
            int trafficSamples = c - 1;
            if (trafficMap.size() < trafficSamples) {
                IntStream.range(0, trafficSamples).mapToLong(i2 -> detectTime - (long)(trafficSamples - i2) * e).forEach(time -> {
                    ApExcessiveTraffic apExcessiveTraffic = new ApExcessiveTraffic();
                    apExcessiveTraffic.setTime(time);
                    trafficMap.putIfAbsent(time, apExcessiveTraffic);
                });
            }
            anomalyEvent.c(CollectionUtils.toMap((Object[])new Object[]{"apTraffic", trafficMap.values()}));
            a.debug("detect cause {} for AP {}", (Object)this.a(), (Object)mac);
            return Collections.singletonList(anomalyEvent);
        }
        return Collections.emptyList();
    }

    private void a(Map<String, com.tplink.smb.omada.anomaly.core.domain.model.a.b> apTrafficCauseMap, List<ApTopClientTrafficDTO> apTopClientTrafficDTOList) {
        if (CollectionUtils.isEmpty(apTopClientTrafficDTOList)) {
            return;
        }
        apTopClientTrafficDTOList.forEach(apTrafficDTO -> {
            String apMac = apTrafficDTO.getApMac();
            if (T.a((String)apMac) || CollectionUtils.isEmpty((Collection)apTrafficDTO.getClientList())) {
                return;
            }
            com.tplink.smb.omada.anomaly.core.domain.model.a.b apTrafficCause = (com.tplink.smb.omada.anomaly.core.domain.model.a.b)apTrafficCauseMap.get(apMac);
            if (Objects.isNull(apTrafficCause)) {
                return;
            }
            HashMap<String, Object> detail = CollectionUtils.isNotEmptyMap(apTrafficCause.r()) ? apTrafficCause.r() : new HashMap<String, Object>();
            HashMap<String, ClientObjectDTO> clients = CollectionUtils.isNotEmptyMap(apTrafficCause.t()) ? apTrafficCause.t() : new HashMap<String, ClientObjectDTO>();
            ArrayList clientTrafficList = new ArrayList();
            apTrafficDTO.getClientList().forEach(clientTrafficBriefDTO -> {
                clientTrafficList.add(new ClientTraffic(clientTrafficBriefDTO.getClientMac(), clientTrafficBriefDTO.getDownLoad() + clientTrafficBriefDTO.getUpLoad()));
                ClientObjectDTO clientObjectDTO = ClientObjectDTO.builder().name(clientTrafficBriefDTO.getClientName()).ip(clientTrafficBriefDTO.getIp()).build();
                clients.putIfAbsent(clientTrafficBriefDTO.getClientMac(), clientObjectDTO);
            });
            if (CollectionUtils.isNotEmpty(clientTrafficList)) {
                detail.put("topTraffic", clientTrafficList);
                apTrafficCause.c(detail);
                apTrafficCause.e(clients);
            }
            apTrafficCauseMap.put(apMac, apTrafficCause);
        });
    }

    public static void a(Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b> anomalyEventSet, Map<String, Set<com.tplink.smb.omada.anomaly.core.domain.model.a.b>> causeMap, com.tplink.smb.omada.anomaly.api.b.c ... vagueCauseEnums) {
        anomalyEventSet.forEach(anomalyEvent -> {
            com.tplink.smb.omada.anomaly.core.domain.model.a.b deviceTrafficCause;
            String deviceMac = anomalyEvent.g();
            Set deviceTrafficCauses = (Set)causeMap.get(com.tplink.smb.omada.anomaly.core.domain.model.rule.b.a(deviceMac, com.tplink.smb.omada.anomaly.api.b.c.bh));
            if (CollectionUtils.isNotEmpty((Collection)deviceTrafficCauses) && Objects.nonNull(deviceTrafficCause = (com.tplink.smb.omada.anomaly.core.domain.model.a.b)deviceTrafficCauses.stream().filter(anomalyCause -> Math.abs(anomalyEvent.k() - anomalyCause.k()) < 600000L).findFirst().orElse(null))) {
                a.debug("find and put cause device_excessive_traffic for ap {}, anomaly code is {}", (Object)deviceMac, (Object)anomalyEvent.m());
                anomalyEvent.d(deviceTrafficCause);
            }
            if (CollectionUtils.isEmptyMap(anomalyEvent.u())) {
                if (Objects.nonNull(vagueCauseEnums) && vagueCauseEnums.length > 0) {
                    Arrays.stream(vagueCauseEnums).forEach(vagueCauseEnum -> anomalyEvent.d(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(deviceMac, vagueCauseEnum, anomalyEvent.k())));
                } else {
                    anomalyEvent.d(com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(com.tplink.smb.omada.anomaly.api.b.c.eG).a());
                }
                a.debug("no device_excessive_traffic cause for ap {} anomaly {}, put vague cause {}", new Object[]{deviceMac, anomalyEvent.m(), anomalyEvent.u()});
            }
        });
    }

    private ApExcessiveTraffic a(ApExcessiveTrafficDTO trafficDTO, ApExcessiveTrafficDTO lastTrafficDTO, long detectTime, DeviceObjectDTO deviceObject) {
        boolean isSupport6g = Boolean.TRUE.equals(deviceObject.getSupport6g());
        boolean isSupport5g2 = Boolean.TRUE.equals(deviceObject.getSupport5g2());
        boolean apSupportRadios = com.tplink.smb.omada.anomaly.core.port.f.a.a(isSupport6g, isSupport5g2);
        ApExcessiveTraffic apTraffic = new ApExcessiveTraffic();
        apTraffic.setTime(com.tplink.smb.omada.anomaly.core.port.f.a.a(trafficDTO.getTime(), e, detectTime));
        long timeInterval = TimeUnit.MILLISECONDS.toSeconds(trafficDTO.getTime() - lastTrafficDTO.getTime());
        boolean isTrafficExcessive = false;
        for (A radioEnum : apSupportRadios) {
            long threshold;
            boolean isReset;
            ApExcessiveTrafficDTO.RadioTraffic traffic = (ApExcessiveTrafficDTO.RadioTraffic)trafficDTO.getRadioTrafficMap().get(radioEnum);
            if (Objects.isNull(traffic)) continue;
            ApExcessiveTrafficDTO.RadioTraffic lastTraffic = (ApExcessiveTrafficDTO.RadioTraffic)lastTrafficDTO.getRadioTrafficMap().get(radioEnum);
            long rx = traffic.getRx() - (Objects.isNull(lastTraffic) ? 0L : lastTraffic.getRx());
            long tx = traffic.getTx() - (Objects.isNull(lastTraffic) ? 0L : lastTraffic.getTx());
            boolean bl = isReset = rx < 0L || tx < 0L;
            if (isReset) {
                rx = traffic.getRx();
                tx = traffic.getTx();
            }
            this.a(apTraffic, radioEnum, rx, tx, isSupport5g2);
            if (isTrafficExcessive || rx < (threshold = (long)((double)ExcessiveTrafficCauseDetector.a(traffic.getTxRate()) * 0.6 * (double)timeInterval * 125000.0)) && tx < threshold) continue;
            isTrafficExcessive = true;
        }
        apTraffic.setExcessive(isTrafficExcessive);
        return apTraffic;
    }

    private void a(ApExcessiveTraffic apTraffic, A radioEnum, long rx, long tx, boolean isSupport5g2) {
        switch (radioEnum) {
            case a: {
                apTraffic.setRxPkts2g(rx);
                apTraffic.setTxPkts2g(tx);
                break;
            }
            case b: {
                if (isSupport5g2) {
                    apTraffic.setRxPkts5g1(rx);
                    apTraffic.setTxPkts5g1(tx);
                    break;
                }
                apTraffic.setRxPkts5g(rx);
                apTraffic.setTxPkts5g(tx);
                break;
            }
            case c: {
                apTraffic.setRxPkts5g2(rx);
                apTraffic.setTxPkts5g2(tx);
                break;
            }
            case d: {
                apTraffic.setRxPkts6g(rx);
                apTraffic.setTxPkts6g(tx);
                break;
            }
        }
    }

    private static long a(String txRate) {
        if (T.a((String)txRate)) {
            return 0L;
        }
        return Long.parseLong(txRate.substring(0, txRate.lastIndexOf(46)));
    }

    @KeepClass
    private static class ApExcessiveTraffic {
        private Long time;
        private Long txPkts2g;
        private Long rxPkts2g;
        private Long txPkts5g;
        private Long rxPkts5g;
        private Long txPkts5g1;
        private Long rxPkts5g1;
        private Long txPkts5g2;
        private Long rxPkts5g2;
        private Long txPkts6g;
        private Long rxPkts6g;
        private Boolean excessive;

        @Generated
        public Long getTime() {
            return this.time;
        }

        @Generated
        public Long getTxPkts2g() {
            return this.txPkts2g;
        }

        @Generated
        public Long getRxPkts2g() {
            return this.rxPkts2g;
        }

        @Generated
        public Long getTxPkts5g() {
            return this.txPkts5g;
        }

        @Generated
        public Long getRxPkts5g() {
            return this.rxPkts5g;
        }

        @Generated
        public Long getTxPkts5g1() {
            return this.txPkts5g1;
        }

        @Generated
        public Long getRxPkts5g1() {
            return this.rxPkts5g1;
        }

        @Generated
        public Long getTxPkts5g2() {
            return this.txPkts5g2;
        }

        @Generated
        public Long getRxPkts5g2() {
            return this.rxPkts5g2;
        }

        @Generated
        public Long getTxPkts6g() {
            return this.txPkts6g;
        }

        @Generated
        public Long getRxPkts6g() {
            return this.rxPkts6g;
        }

        @Generated
        public Boolean getExcessive() {
            return this.excessive;
        }

        @Generated
        public void setTime(Long time) {
            this.time = time;
        }

        @Generated
        public void setTxPkts2g(Long txPkts2g) {
            this.txPkts2g = txPkts2g;
        }

        @Generated
        public void setRxPkts2g(Long rxPkts2g) {
            this.rxPkts2g = rxPkts2g;
        }

        @Generated
        public void setTxPkts5g(Long txPkts5g) {
            this.txPkts5g = txPkts5g;
        }

        @Generated
        public void setRxPkts5g(Long rxPkts5g) {
            this.rxPkts5g = rxPkts5g;
        }

        @Generated
        public void setTxPkts5g1(Long txPkts5g1) {
            this.txPkts5g1 = txPkts5g1;
        }

        @Generated
        public void setRxPkts5g1(Long rxPkts5g1) {
            this.rxPkts5g1 = rxPkts5g1;
        }

        @Generated
        public void setTxPkts5g2(Long txPkts5g2) {
            this.txPkts5g2 = txPkts5g2;
        }

        @Generated
        public void setRxPkts5g2(Long rxPkts5g2) {
            this.rxPkts5g2 = rxPkts5g2;
        }

        @Generated
        public void setTxPkts6g(Long txPkts6g) {
            this.txPkts6g = txPkts6g;
        }

        @Generated
        public void setRxPkts6g(Long rxPkts6g) {
            this.rxPkts6g = rxPkts6g;
        }

        @Generated
        public void setExcessive(Boolean excessive) {
            this.excessive = excessive;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof ApExcessiveTraffic)) {
                return false;
            }
            ApExcessiveTraffic other = (ApExcessiveTraffic)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$time = this.getTime();
            Long other$time = other.getTime();
            if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
                return false;
            }
            Long this$txPkts2g = this.getTxPkts2g();
            Long other$txPkts2g = other.getTxPkts2g();
            if (this$txPkts2g == null ? other$txPkts2g != null : !((Object)this$txPkts2g).equals(other$txPkts2g)) {
                return false;
            }
            Long this$rxPkts2g = this.getRxPkts2g();
            Long other$rxPkts2g = other.getRxPkts2g();
            if (this$rxPkts2g == null ? other$rxPkts2g != null : !((Object)this$rxPkts2g).equals(other$rxPkts2g)) {
                return false;
            }
            Long this$txPkts5g = this.getTxPkts5g();
            Long other$txPkts5g = other.getTxPkts5g();
            if (this$txPkts5g == null ? other$txPkts5g != null : !((Object)this$txPkts5g).equals(other$txPkts5g)) {
                return false;
            }
            Long this$rxPkts5g = this.getRxPkts5g();
            Long other$rxPkts5g = other.getRxPkts5g();
            if (this$rxPkts5g == null ? other$rxPkts5g != null : !((Object)this$rxPkts5g).equals(other$rxPkts5g)) {
                return false;
            }
            Long this$txPkts5g1 = this.getTxPkts5g1();
            Long other$txPkts5g1 = other.getTxPkts5g1();
            if (this$txPkts5g1 == null ? other$txPkts5g1 != null : !((Object)this$txPkts5g1).equals(other$txPkts5g1)) {
                return false;
            }
            Long this$rxPkts5g1 = this.getRxPkts5g1();
            Long other$rxPkts5g1 = other.getRxPkts5g1();
            if (this$rxPkts5g1 == null ? other$rxPkts5g1 != null : !((Object)this$rxPkts5g1).equals(other$rxPkts5g1)) {
                return false;
            }
            Long this$txPkts5g2 = this.getTxPkts5g2();
            Long other$txPkts5g2 = other.getTxPkts5g2();
            if (this$txPkts5g2 == null ? other$txPkts5g2 != null : !((Object)this$txPkts5g2).equals(other$txPkts5g2)) {
                return false;
            }
            Long this$rxPkts5g2 = this.getRxPkts5g2();
            Long other$rxPkts5g2 = other.getRxPkts5g2();
            if (this$rxPkts5g2 == null ? other$rxPkts5g2 != null : !((Object)this$rxPkts5g2).equals(other$rxPkts5g2)) {
                return false;
            }
            Long this$txPkts6g = this.getTxPkts6g();
            Long other$txPkts6g = other.getTxPkts6g();
            if (this$txPkts6g == null ? other$txPkts6g != null : !((Object)this$txPkts6g).equals(other$txPkts6g)) {
                return false;
            }
            Long this$rxPkts6g = this.getRxPkts6g();
            Long other$rxPkts6g = other.getRxPkts6g();
            if (this$rxPkts6g == null ? other$rxPkts6g != null : !((Object)this$rxPkts6g).equals(other$rxPkts6g)) {
                return false;
            }
            Boolean this$excessive = this.getExcessive();
            Boolean other$excessive = other.getExcessive();
            return !(this$excessive == null ? other$excessive != null : !((Object)this$excessive).equals(other$excessive));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApExcessiveTraffic;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
            Long $txPkts2g = this.getTxPkts2g();
            result = result * 59 + ($txPkts2g == null ? 43 : ((Object)$txPkts2g).hashCode());
            Long $rxPkts2g = this.getRxPkts2g();
            result = result * 59 + ($rxPkts2g == null ? 43 : ((Object)$rxPkts2g).hashCode());
            Long $txPkts5g = this.getTxPkts5g();
            result = result * 59 + ($txPkts5g == null ? 43 : ((Object)$txPkts5g).hashCode());
            Long $rxPkts5g = this.getRxPkts5g();
            result = result * 59 + ($rxPkts5g == null ? 43 : ((Object)$rxPkts5g).hashCode());
            Long $txPkts5g1 = this.getTxPkts5g1();
            result = result * 59 + ($txPkts5g1 == null ? 43 : ((Object)$txPkts5g1).hashCode());
            Long $rxPkts5g1 = this.getRxPkts5g1();
            result = result * 59 + ($rxPkts5g1 == null ? 43 : ((Object)$rxPkts5g1).hashCode());
            Long $txPkts5g2 = this.getTxPkts5g2();
            result = result * 59 + ($txPkts5g2 == null ? 43 : ((Object)$txPkts5g2).hashCode());
            Long $rxPkts5g2 = this.getRxPkts5g2();
            result = result * 59 + ($rxPkts5g2 == null ? 43 : ((Object)$rxPkts5g2).hashCode());
            Long $txPkts6g = this.getTxPkts6g();
            result = result * 59 + ($txPkts6g == null ? 43 : ((Object)$txPkts6g).hashCode());
            Long $rxPkts6g = this.getRxPkts6g();
            result = result * 59 + ($rxPkts6g == null ? 43 : ((Object)$rxPkts6g).hashCode());
            Boolean $excessive = this.getExcessive();
            result = result * 59 + ($excessive == null ? 43 : ((Object)$excessive).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExcessiveTrafficCauseDetector.ApExcessiveTraffic(time=" + this.getTime() + ", txPkts2g=" + this.getTxPkts2g() + ", rxPkts2g=" + this.getRxPkts2g() + ", txPkts5g=" + this.getTxPkts5g() + ", rxPkts5g=" + this.getRxPkts5g() + ", txPkts5g1=" + this.getTxPkts5g1() + ", rxPkts5g1=" + this.getRxPkts5g1() + ", txPkts5g2=" + this.getTxPkts5g2() + ", rxPkts5g2=" + this.getRxPkts5g2() + ", txPkts6g=" + this.getTxPkts6g() + ", rxPkts6g=" + this.getRxPkts6g() + ", excessive=" + this.getExcessive() + ")";
        }

        @Generated
        public ApExcessiveTraffic() {
        }
    }

    @KeepClass
    private static class ClientTraffic {
        private String clientMac;
        private Long traffic;

        @Generated
        public String getClientMac() {
            return this.clientMac;
        }

        @Generated
        public Long getTraffic() {
            return this.traffic;
        }

        @Generated
        public void setClientMac(String clientMac) {
            this.clientMac = clientMac;
        }

        @Generated
        public void setTraffic(Long traffic) {
            this.traffic = traffic;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof ClientTraffic)) {
                return false;
            }
            ClientTraffic other = (ClientTraffic)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$traffic = this.getTraffic();
            Long other$traffic = other.getTraffic();
            if (this$traffic == null ? other$traffic != null : !((Object)this$traffic).equals(other$traffic)) {
                return false;
            }
            String this$clientMac = this.getClientMac();
            String other$clientMac = other.getClientMac();
            return !(this$clientMac == null ? other$clientMac != null : !this$clientMac.equals(other$clientMac));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClientTraffic;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $traffic = this.getTraffic();
            result = result * 59 + ($traffic == null ? 43 : ((Object)$traffic).hashCode());
            String $clientMac = this.getClientMac();
            result = result * 59 + ($clientMac == null ? 43 : $clientMac.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExcessiveTrafficCauseDetector.ClientTraffic(clientMac=" + this.getClientMac() + ", traffic=" + this.getTraffic() + ")";
        }

        @Generated
        public ClientTraffic(String clientMac, Long traffic) {
            this.clientMac = clientMac;
            this.traffic = traffic;
        }
    }
}

