/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.rule.eap.cause;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.anomaly.api.b.c;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.AbstractDeviceDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.ApIpRecDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.e;
import com.tplink.smb.omada.anomaly.core.domain.model.a.b;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.DeviceObjectDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApIpConflictDetector
implements com.tplink.smb.omada.anomaly.core.domain.model.rule.a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(ApIpConflictDetector.class);
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a b;
    @Autowired
    private e c;

    @Override
    public c a() {
        return com.tplink.smb.omada.anomaly.api.b.c.d;
    }

    @Override
    public f c() {
        return f.b;
    }

    @Override
    public List<b> a(com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange, Map<String, List<DevicePreprocessDTO>> devicePreprocessDataMap) {
        HashMap<String, List<ApMacAndTimeInfoDTO>> apIpMap = new HashMap<String, List<ApMacAndTimeInfoDTO>>();
        for (Map.Entry<String, List<DevicePreprocessDTO>> entry : devicePreprocessDataMap.entrySet()) {
            String mac = entry.getKey();
            List<DevicePreprocessDTO> ipInfoList = entry.getValue();
            if (CollectionUtils.isEmpty(ipInfoList)) continue;
            this.a(apIpMap, mac, ipInfoList);
        }
        if (a.isDebugEnabled()) {
            a.debug("all ap of omadac : {} siteId : {} group by ip is {}", new Object[]{anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b(), x.a(apIpMap)});
        }
        return this.b(anomalyDetectTimeRange, apIpMap);
    }

    private void a(Map<String, List<ApMacAndTimeInfoDTO>> apIpMap, String mac, List<DevicePreprocessDTO> ipInfoList) {
        ApIpRecDTO apIpRecDTO = new ApIpRecDTO(Long.valueOf(0L), null);
        for (DevicePreprocessDTO devicePreprocessDTO : ipInfoList) {
            ApIpRecDTO ipRecord;
            AbstractDeviceDTO dto;
            if (Objects.isNull(devicePreprocessDTO) || Objects.isNull(devicePreprocessDTO.getPreprocessData()) || Objects.isNull(dto = devicePreprocessDTO.getPreprocessData().get(this.a().a())) || !(dto instanceof ApIpRecDTO) || !Objects.nonNull((ipRecord = (ApIpRecDTO)dto).getIp()) || !Objects.nonNull(ipRecord.getTimestamp()) || ipRecord.getTimestamp() <= apIpRecDTO.getTimestamp()) continue;
            apIpRecDTO = ipRecord;
        }
        if (Objects.nonNull(apIpRecDTO.getTimestamp()) && Objects.nonNull(apIpRecDTO.getIp())) {
            long timestamp = apIpRecDTO.getTimestamp();
            String ip = apIpRecDTO.getIp();
            List apMacAndTimeInfoList = apIpMap.computeIfAbsent(ip, s2 -> new ArrayList());
            apMacAndTimeInfoList.add(new ApMacAndTimeInfoDTO(mac, timestamp));
        }
    }

    private List<b> b(com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange, Map<String, List<ApMacAndTimeInfoDTO>> apIpMap) {
        ArrayList<b> anomalyEvents = new ArrayList<b>();
        for (Map.Entry<String, List<ApMacAndTimeInfoDTO>> entry : apIpMap.entrySet()) {
            String ip = entry.getKey();
            List<ApMacAndTimeInfoDTO> apMacAndTimeInfoList = entry.getValue();
            if (CollectionUtils.isEmpty(apMacAndTimeInfoList) || apMacAndTimeInfoList.size() == 1) continue;
            long oneMin = 60000L;
            HashMap timeIps = new HashMap();
            apMacAndTimeInfoList.forEach(item -> {
                long t2 = item.getTimestamp() / oneMin;
                List macs = timeIps.computeIfAbsent(t2, time -> new ArrayList());
                macs.add(item.getMac());
            });
            for (Map.Entry entry1 : timeIps.entrySet()) {
                anomalyEvents.addAll(this.b(anomalyDetectTimeRange, ip, (List)entry1.getValue()));
            }
        }
        if (a.isDebugEnabled()) {
            a.debug("Detect Ap Ip conflict events : {} of omadac : {} siteId : {} at {}", new Object[]{x.a(anomalyEvents), anomalyDetectTimeRange.a(), anomalyDetectTimeRange.b(), anomalyDetectTimeRange.d()});
        }
        return anomalyEvents;
    }

    private List<b> b(com.tplink.smb.omada.anomaly.core.domain.model.b.b anomalyDetectTimeRange, String ip, List<String> macs) {
        if (CollectionUtils.isEmpty(macs) || macs.size() == 1) {
            return Collections.emptyList();
        }
        ArrayList<b> anomalyEvents = new ArrayList<b>();
        int size = macs.size();
        String omadacId = anomalyDetectTimeRange.a();
        String siteId = anomalyDetectTimeRange.b();
        ArrayList apMacAndIps = new ArrayList();
        HashMap deviceObjects = new HashMap();
        macs.forEach(mac -> {
            apMacAndIps.add(new ApMacAndIpDTO((String)mac, ip));
            deviceObjects.put(mac, this.c.a(omadacId, siteId, (String)mac));
        });
        for (int i2 = 0; i2 < size; ++i2) {
            b anomalyEvent = com.tplink.smb.omada.anomaly.core.domain.model.a.b.d().a(this.b.a()).a(macs.get(i2)).c(anomalyDetectTimeRange.a()).d(anomalyDetectTimeRange.b()).a(anomalyDetectTimeRange.d()).a(this.a()).a(this.a().c()).g(com.tplink.smb.omada.anomaly.core.domain.model.a.b.a(this.a())).b(true).a();
            int nextMacIndex = (i2 + 1) % size;
            anomalyEvent.a(CollectionUtils.toStringMap((String[])new String[]{"devMac", macs.get(nextMacIndex)}), null, Collections.singletonMap("devices", apMacAndIps), new HashMap<String, DeviceObjectDTO>(deviceObjects), null, null);
            anomalyEvents.add(anomalyEvent);
        }
        return anomalyEvents;
    }

    static class ApMacAndTimeInfoDTO {
        @a
        private String mac;
        private Long timestamp;

        @Generated
        public String getMac() {
            return this.mac;
        }

        @Generated
        public Long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public void setMac(String mac) {
            this.mac = mac;
        }

        @Generated
        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof ApMacAndTimeInfoDTO)) {
                return false;
            }
            ApMacAndTimeInfoDTO other = (ApMacAndTimeInfoDTO)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$timestamp = this.getTimestamp();
            Long other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            String this$mac = this.getMac();
            String other$mac = other.getMac();
            return !(this$mac == null ? other$mac != null : !this$mac.equals(other$mac));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApMacAndTimeInfoDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            String $mac = this.getMac();
            result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ApIpConflictDetector.ApMacAndTimeInfoDTO(mac=" + this.getMac() + ", timestamp=" + this.getTimestamp() + ")";
        }

        @Generated
        public ApMacAndTimeInfoDTO() {
        }

        @Generated
        public ApMacAndTimeInfoDTO(String mac, Long timestamp) {
            this.mac = mac;
            this.timestamp = timestamp;
        }
    }

    static class ApMacAndIpDTO {
        @a
        private String devMac;
        private String ip;

        @Generated
        public String getDevMac() {
            return this.devMac;
        }

        @Generated
        public String getIp() {
            return this.ip;
        }

        @Generated
        public void setDevMac(String devMac) {
            this.devMac = devMac;
        }

        @Generated
        public void setIp(String ip) {
            this.ip = ip;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof ApMacAndIpDTO)) {
                return false;
            }
            ApMacAndIpDTO other = (ApMacAndIpDTO)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$devMac = this.getDevMac();
            String other$devMac = other.getDevMac();
            if (this$devMac == null ? other$devMac != null : !this$devMac.equals(other$devMac)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            return !(this$ip == null ? other$ip != null : !this$ip.equals(other$ip));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApMacAndIpDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $devMac = this.getDevMac();
            result = result * 59 + ($devMac == null ? 43 : $devMac.hashCode());
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ApIpConflictDetector.ApMacAndIpDTO(devMac=" + this.getDevMac() + ", ip=" + this.getIp() + ")";
        }

        @Generated
        public ApMacAndIpDTO() {
        }

        @Generated
        public ApMacAndIpDTO(String devMac, String ip) {
            this.devMac = devMac;
            this.ip = ip;
        }
    }
}

