/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.model.prehandle;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.anomaly.api.b.t;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.AbstractDeviceDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.common.DeviceAdoptDataDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.common.RebootDataDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.ApConnectEventDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.ParentApDisconnectAndNoDetectedDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.ParentApDisconnectDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.networking.OsgConnectEventDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.networking.OswConnectEventDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.c;
import com.tplink.smb.omada.anomaly.core.domain.a.i;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.DevicePreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.a;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.e;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.f;
import com.tplink.smb.omada.anomaly.core.port.cache.k;
import com.tplink.smb.omada.anomaly.core.port.cache.o;
import com.tplink.smb.omada.anomaly.core.port.cache.p;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceStatusEnum;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.insight.api.internal.eventcenter.ApInfoDTO;
import com.tplink.smb.omada.insight.api.internal.eventcenter.DeviceEventDTO;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.DeviceObjectDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.OswNodeWithUpAndDownLinkDTO;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class h
implements DomainEventSubscriber<DeviceEventDTO> {
    @Generated
    private static final Logger b = LoggerFactory.getLogger(h.class);
    @Autowired
    private k c;
    @Autowired
    private o d;
    static final Set<DeviceStatusEnum> a = new HashSet<DeviceStatusEnum>(Arrays.asList(DeviceStatusEnum.a, DeviceStatusEnum.s, DeviceStatusEnum.t));
    @Autowired
    @Qualifier(value="insightDeviceEventWorkGroup")
    private ExecutorService e;
    @Autowired
    private e f;
    @Autowired
    private p g;
    @Autowired
    private i h;
    @Autowired
    private c i;
    @Autowired
    private f j;
    @Autowired
    private com.tplink.smb.omada.insight.a.a k;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.e l;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.topology.a m;

    @PostConstruct
    public void a() {
        DomainEventBusHolder.getHandlerRegistry().register(DeviceEventDTO.class, (DomainEventSubscriber)this, this.e);
    }

    public void a(DeviceEventDTO event) {
        if (!event.validate()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        b.debug("Accept deviceEvent {}", (Object)event);
        DeviceTypeEnum deviceType = DeviceTypeEnum.b((String)event.getDeviceType());
        DeviceEventDTO.DeviceEventType eventType = DeviceEventDTO.DeviceEventType.resolve((String)event.getEventType());
        if (Objects.equals(eventType, DeviceEventDTO.DeviceEventType.POE_OFF)) {
            this.j(event);
            this.k.c(System.currentTimeMillis() - startTime, event.getClass().getSimpleName(), "insight");
            return;
        }
        List<String> validMacs = this.a(event.getMacs(), event.getOmadacId(), event.getSiteId(), deviceType, eventType);
        if (CollectionUtils.isEmpty(validMacs)) {
            return;
        }
        event.setMacs(validMacs);
        if (Objects.equals(eventType, DeviceEventDTO.DeviceEventType.DISCONNECTED) && Boolean.TRUE.equals(event.getLogRecord())) {
            this.i(event);
        }
        if (Objects.equals(eventType, DeviceEventDTO.DeviceEventType.FORGET)) {
            this.i(event);
        }
        if (Objects.equals(eventType, DeviceEventDTO.DeviceEventType.REBOOT)) {
            this.b(event);
            this.k.c(System.currentTimeMillis() - startTime, event.getClass().getSimpleName(), "insight");
            return;
        }
        block0 : switch (deviceType) {
            case a: {
                if (Objects.isNull(eventType)) {
                    return;
                }
                switch (eventType) {
                    case ADOPT_SUCCESS: {
                        this.c(event);
                        break block0;
                    }
                    case DISCONNECTED: {
                        this.e(event);
                        this.d(event);
                        break block0;
                    }
                    case ISOLATED: {
                        this.g(event);
                        break block0;
                    }
                }
                break;
            }
            case c: {
                switch (eventType) {
                    case ADOPT_SUCCESS: {
                        this.c(event);
                        break block0;
                    }
                    case DISCONNECTED: {
                        this.f(event);
                        break block0;
                    }
                }
                break;
            }
            case b: {
                switch (eventType) {
                    case ADOPT_SUCCESS: {
                        this.c(event);
                        break block0;
                    }
                    case DISCONNECTED: {
                        this.h(event);
                        break block0;
                    }
                }
                break;
            }
        }
        this.k.c(System.currentTimeMillis() - startTime, event.getClass().getSimpleName(), "insight");
    }

    private void b(DeviceEventDTO eventDTO) {
        if (CollectionUtils.isEmpty((Collection)eventDTO.getMacs())) {
            return;
        }
        if (DeviceTypeEnum.c.c(eventDTO.getDeviceType())) {
            return;
        }
        RebootDataDTO rebootDataDTO = new RebootDataDTO();
        rebootDataDTO.setInvalidTimeStamp(Long.valueOf(System.currentTimeMillis()));
        eventDTO.getMacs().forEach(mac -> {
            this.g.a(eventDTO.getOmadacId(), eventDTO.getSiteId(), (String)mac, rebootDataDTO);
            this.d.a(eventDTO.getOmadacId(), eventDTO.getSiteId(), (String)mac, t.b.a(), eventDTO.getTimestamp());
        });
    }

    private void c(DeviceEventDTO eventDTO) {
        String omadacId = eventDTO.getOmadacId();
        String siteId = eventDTO.getSiteId();
        long timestamp = eventDTO.getTimestamp();
        List macs = eventDTO.getMacs();
        for (String mac : macs) {
            DeviceAdoptDataDTO deviceAdoptDataDTO = new DeviceAdoptDataDTO();
            deviceAdoptDataDTO.setAdoptTime(Long.valueOf(timestamp));
            this.c.a(omadacId, siteId, mac, deviceAdoptDataDTO);
        }
    }

    private void d(DeviceEventDTO eventDTO) {
        String omadacId = eventDTO.getOmadacId();
        String siteId = eventDTO.getSiteId();
        long timestamp = eventDTO.getTimestamp();
        List macs = Optional.ofNullable(eventDTO.getMacs()).orElse(Collections.emptyList());
        for (String mac : macs) {
            if (T.c((String)mac)) continue;
            this.j.a(omadacId, siteId, mac, timestamp);
        }
    }

    private void e(DeviceEventDTO eventDTO) {
        if (!Boolean.TRUE.equals(eventDTO.getLogRecord())) {
            return;
        }
        String omadacId = eventDTO.getOmadacId();
        String siteId = eventDTO.getSiteId();
        long timestamp = eventDTO.getTimestamp();
        List macs = eventDTO.getMacs();
        Map apInfoMap = Optional.ofNullable(eventDTO.getApInfoMap()).orElse(new HashMap(0));
        for (String mac : macs) {
            DevicePreprocessDTO realtimePreData = DevicePreprocessDTO.builder().omadacId(omadacId).siteId(siteId).mac(mac).deviceType(DeviceTypeEnum.a).time(timestamp).build();
            DeviceAdoptDataDTO lastAdoptData = this.c.a(omadacId, siteId, mac);
            if (Objects.isNull(lastAdoptData)) {
                b.debug("skip handle disconnect event of device {} in omadacId : {} siteId : {} for no adopt success record.", new Object[]{mac, omadacId, siteId});
                continue;
            }
            long lastAdoptTime = lastAdoptData.getAdoptTime();
            if (lastAdoptTime > timestamp) {
                this.c.a(omadacId, siteId, mac, lastAdoptData);
            }
            this.d.a(omadacId, siteId, mac, t.a.a(), timestamp);
            this.a(apInfoMap, realtimePreData, mac);
            String upSwitchMac = Optional.ofNullable((ApInfoDTO)apInfoMap.get(mac)).map(ApInfoDTO::getUpSwitchMac).orElse(null);
            realtimePreData.putPreprocessData(com.tplink.smb.omada.anomaly.api.b.c.A, (AbstractDeviceDTO)new ParentApDisconnectDTO(mac, upSwitchMac));
            a preprocessData = com.tplink.smb.omada.anomaly.core.domain.model.prehandle.a.a().a();
            ApConnectEventDTO apConnectEventDTO = new ApConnectEventDTO();
            apConnectEventDTO.setDisconnectTime(eventDTO.getTimestamp());
            apConnectEventDTO.setAdoptSuccessTime(Long.valueOf(lastAdoptTime));
            apConnectEventDTO.setUpSwitchMac(upSwitchMac);
            preprocessData.a(com.tplink.smb.omada.anomaly.api.b.f.e, com.tplink.smb.omada.anomaly.api.b.c.a, (AbstractDeviceDTO)apConnectEventDTO);
            if (CollectionUtils.isNotEmptyMap(preprocessData.f())) {
                DevicePreprocessDTO devicePreprocessDTO = DevicePreprocessDTO.builder().mac(mac).time(timestamp).deviceType(DeviceTypeEnum.a).preprocessData(preprocessData.f()).build();
                this.f.a(omadacId, siteId, com.tplink.smb.omada.anomaly.api.b.f.e, devicePreprocessDTO, timestamp);
                b.debug("Save ap networking hourly preData to cache : {} : {} : {}", new Object[]{omadacId, siteId, devicePreprocessDTO});
            }
            if (!CollectionUtils.isNotEmptyMap(realtimePreData.getPreprocessData())) continue;
            this.h.a(realtimePreData);
        }
    }

    private void a(Map<String, ApInfoDTO> apInfoMap, DevicePreprocessDTO realtimePreData, String mac) {
        ApInfoDTO apInfoDTO = apInfoMap.get(mac);
        if (Objects.nonNull(apInfoDTO)) {
            DeviceStatusEnum statusEnum;
            String upApMac = apInfoDTO.getParentApMac();
            Integer upApStatus = apInfoDTO.getParentApStatus();
            if (Objects.nonNull(upApMac) && a.contains(statusEnum = DeviceStatusEnum.a((Integer)upApStatus))) {
                realtimePreData.putPreprocessData(com.tplink.smb.omada.anomaly.api.b.c.B, (AbstractDeviceDTO)new ParentApDisconnectAndNoDetectedDTO(upApMac, mac, statusEnum));
            }
        }
    }

    private void f(DeviceEventDTO eventDTO) {
        if (!Boolean.TRUE.equals(eventDTO.getLogRecord())) {
            return;
        }
        String omadacId = eventDTO.getOmadacId();
        String siteId = eventDTO.getSiteId();
        long timestamp = eventDTO.getTimestamp();
        List macs = eventDTO.getMacs();
        for (String mac : macs) {
            DeviceAdoptDataDTO lastAdoptData = this.c.a(omadacId, siteId, mac);
            if (Objects.isNull(lastAdoptData)) continue;
            long lastAdoptTime = lastAdoptData.getAdoptTime();
            if (lastAdoptTime > timestamp) {
                this.c.a(omadacId, siteId, mac, lastAdoptData);
            }
            a preprocessData = com.tplink.smb.omada.anomaly.core.domain.model.prehandle.a.a().a();
            OswConnectEventDTO oswConnectEventDTO = new OswConnectEventDTO();
            oswConnectEventDTO.setDisconnectTime(eventDTO.getTimestamp());
            oswConnectEventDTO.setAdoptSuccessTime(Long.valueOf(lastAdoptTime));
            preprocessData.a(com.tplink.smb.omada.anomaly.api.b.f.e, com.tplink.smb.omada.anomaly.api.b.c.bv, (AbstractDeviceDTO)oswConnectEventDTO);
            if (!CollectionUtils.isNotEmptyMap(preprocessData.f())) continue;
            this.f.a(omadacId, siteId, com.tplink.smb.omada.anomaly.api.b.f.e, DevicePreprocessDTO.builder().mac(mac).time(timestamp).deviceType(DeviceTypeEnum.c).preprocessData(preprocessData.f()).build(), timestamp);
        }
    }

    private void g(DeviceEventDTO eventDTO) {
        boolean needDetect = Boolean.TRUE.equals(eventDTO.getLogRecord());
        String omadacId = eventDTO.getOmadacId();
        String siteId = eventDTO.getSiteId();
        long timestamp = eventDTO.getTimestamp();
        List macs = eventDTO.getMacs();
        Map apInfoMap = Optional.ofNullable(eventDTO.getApInfoMap()).orElse(new HashMap(0));
        for (String mac : macs) {
            ApInfoDTO apInfoDTO = (ApInfoDTO)apInfoMap.get(mac);
            String parentMac = null;
            Integer parentApStatus = null;
            Boolean wiredAp = null;
            if (Objects.nonNull(apInfoDTO)) {
                parentMac = apInfoDTO.getParentApMac();
                parentApStatus = apInfoDTO.getParentApStatus();
                wiredAp = apInfoDTO.getWiredAp();
            }
            if (needDetect) {
                this.d.a(omadacId, siteId, mac, timestamp, parentMac, parentApStatus, wiredAp);
            }
            this.d.a(omadacId, siteId, mac, t.c.a(), timestamp);
        }
    }

    private void h(DeviceEventDTO eventDTO) {
        if (!Boolean.TRUE.equals(eventDTO.getLogRecord())) {
            return;
        }
        String omadacId = eventDTO.getOmadacId();
        String siteId = eventDTO.getSiteId();
        long timestamp = eventDTO.getTimestamp();
        List macs = eventDTO.getMacs();
        for (String mac : macs) {
            DeviceAdoptDataDTO lastAdoptData = this.c.a(omadacId, siteId, mac);
            if (Objects.isNull(lastAdoptData)) continue;
            long lastAdoptTime = lastAdoptData.getAdoptTime();
            if (lastAdoptTime > timestamp) {
                this.c.a(omadacId, siteId, mac, lastAdoptData);
            }
            a preprocessData = com.tplink.smb.omada.anomaly.core.domain.model.prehandle.a.a().a();
            OsgConnectEventDTO osgConnectEventDTO = new OsgConnectEventDTO();
            osgConnectEventDTO.setDisconnectTime(eventDTO.getTimestamp());
            osgConnectEventDTO.setAdoptSuccessTime(Long.valueOf(lastAdoptTime));
            preprocessData.a(com.tplink.smb.omada.anomaly.api.b.f.e, com.tplink.smb.omada.anomaly.api.b.c.cO, (AbstractDeviceDTO)osgConnectEventDTO);
            if (!CollectionUtils.isNotEmptyMap(preprocessData.f())) continue;
            this.f.a(omadacId, siteId, com.tplink.smb.omada.anomaly.api.b.f.e, DevicePreprocessDTO.builder().mac(mac).time(timestamp).preprocessData(preprocessData.f()).deviceType(DeviceTypeEnum.b).build(), timestamp);
        }
    }

    private List<String> a(List<String> macs, String omadacId, String siteId, DeviceTypeEnum deviceType, DeviceEventDTO.DeviceEventType eventType) {
        if (CollectionUtils.isEmpty(macs)) {
            return Collections.emptyList();
        }
        ArrayList<String> validMacs = new ArrayList<String>();
        for (String mac : macs) {
            DeviceObjectDTO deviceObjectDTO = this.l.b(omadacId, siteId, mac, deviceType);
            if (Objects.nonNull(deviceObjectDTO) && Boolean.TRUE.equals(deviceObjectDTO.getSupportAnomaly())) {
                validMacs.add(mac);
                continue;
            }
            b.debug("filter device event {} of device {} of omadacId : {} siteId : {} for not support anomaly detect", new Object[]{eventType, mac, omadacId, siteId});
        }
        return validMacs;
    }

    private void i(DeviceEventDTO eventDTO) {
        String omadacId = eventDTO.getOmadacId();
        String siteId = eventDTO.getSiteId();
        Long endTime = eventDTO.getTimestamp();
        if (Objects.isNull(endTime)) {
            endTime = System.currentTimeMillis();
        }
        List macs = eventDTO.getMacs();
        this.i.b(omadacId, siteId, macs, endTime);
    }

    private void j(DeviceEventDTO eventDTO) {
        Map oswPortMap = eventDTO.getOswPortMap();
        if (CollectionUtils.isEmptyMap((Map)oswPortMap)) {
            return;
        }
        String omadacId = eventDTO.getOmadacId();
        String siteId = eventDTO.getSiteId();
        HashSet<String> apMacs = new HashSet<String>();
        for (Map.Entry entry : oswPortMap.entrySet()) {
            String oswMac = (String)entry.getKey();
            OswNodeWithUpAndDownLinkDTO oswNodeWithUpAndDownLinkDTO = Optional.ofNullable(this.m.b(omadacId, siteId, oswMac)).map(OperationResponse::getResult).orElse(null);
            if (Objects.isNull(oswNodeWithUpAndDownLinkDTO) || CollectionUtils.isEmptyMap((Map)oswNodeWithUpAndDownLinkDTO.getDownLinkMap())) continue;
            Map downLinkMap = oswNodeWithUpAndDownLinkDTO.getDownLinkMap();
            Set poeOffPort = (Set)entry.getValue();
            for (Integer port : poeOffPort) {
                Set nodeSet = (Set)downLinkMap.get(port);
                if (CollectionUtils.isEmpty((Collection)nodeSet)) continue;
                apMacs.addAll(nodeSet.stream().filter(node -> DeviceTypeEnum.a.c(node.getType())).map(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a::getMac).collect(Collectors.toSet()));
            }
        }
        this.a(omadacId, siteId, apMacs);
    }

    private void a(String omadacId, String siteId, Set<String> apMacs) {
        if (CollectionUtils.isNotEmpty(apMacs)) {
            Map<String, RebootDataDTO> rebootDataDTOMap = this.g.a(omadacId, siteId);
            if (CollectionUtils.isEmptyMap(rebootDataDTOMap)) {
                return;
            }
            for (String apMac : apMacs) {
                RebootDataDTO rebootDataDTO = rebootDataDTOMap.get(apMac);
                if (Objects.isNull(rebootDataDTO)) continue;
                rebootDataDTO.setInvalidTimeStamp(Long.valueOf(System.currentTimeMillis()));
                this.g.a(omadacId, siteId, apMac, rebootDataDTO);
            }
        }
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((DeviceEventDTO)object);
    }
}

