/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.b;

import com.tplink.smb.omada.anomaly.core.domain.b.c;
import com.tplink.smb.omada.anomaly.core.domain.b.d;
import com.tplink.smb.omada.anomaly.core.domain.b.f;
import com.tplink.smb.omada.anomaly.core.domain.b.g;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.f.e;
import com.tplink.smb.omada.manager.configuration.api.internal.site.a;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QuerySiteTemplateDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.SiteStatusDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.SiteTemplateDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.UpdateSiteStatusDTO;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class b {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    private static final Integer b = 10;
    @Autowired
    private a c;
    @Autowired
    private com.tplink.smb.omada.lock.a.c d;
    @Qualifier(value="commBlockingThreadPool")
    @Autowired
    private ExecutorService e;

    public OperationResponse a(@Nonnull d targetOmadacId, @Nonnull g targetSiteTemplateId, @Nonnull c onSyncConfig) {
        OperationResponse siteTemplateResponse;
        QuerySiteTemplateDTO querySiteTemplateDTO = new QuerySiteTemplateDTO();
        querySiteTemplateDTO.setOmadacId(targetOmadacId.a());
        querySiteTemplateDTO.setSiteTemplateId(targetSiteTemplateId.a());
        try {
            siteTemplateResponse = this.c.a(querySiteTemplateDTO);
        }
        catch (Exception e2) {
            a.warn("fail to get site template of omadacId : {} siteId : {}", (Object)targetOmadacId.a(), (Object)targetSiteTemplateId.a());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.b);
        }
        if (Objects.isNull(siteTemplateResponse) || !siteTemplateResponse.success() || Objects.isNull(siteTemplateResponse.getResult())) {
            return OperationResponse.SUCCESS;
        }
        SiteTemplateDTO siteTemplateDTO = (SiteTemplateDTO)siteTemplateResponse.getResult();
        List siteIdList = Optional.ofNullable(siteTemplateDTO.getSiteIdList()).orElse(Collections.emptyList()).stream().map(f::new).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(siteIdList)) {
            return OperationResponse.SUCCESS;
        }
        int configSyncRounds = 1;
        int siteSize = siteIdList.size();
        if (siteSize > b) {
            int remainder = siteSize % b;
            configSyncRounds = remainder == 0 ? siteSize / b : siteSize / b + 1;
        }
        for (int count = 0; count < configSyncRounds; ++count) {
            Integer start = b * count;
            Integer end = Math.min(b * (count + 1), siteSize);
            List subList = siteIdList.subList(start, end);
            this.e.execute(() -> {
                try {
                    this.a(targetOmadacId.a(), targetSiteTemplateId.a(), onSyncConfig, (List<f>)subList);
                }
                catch (Exception e2) {
                    a.error("doTemplateSettingSyncConfig msg:{} ", (Object)e2.getMessage(), (Object)e2);
                }
            });
        }
        return OperationResponse.SUCCESS;
    }

    private void a(@Nonnull String targetOmadacId, @Nonnull String targetSiteTemplateId, @Nonnull c onSyncConfig, List<f> siteIdList) {
        List initSiteStatus = siteIdList.stream().map(siteId -> new SiteStatusDTO(siteId.a(), Integer.valueOf(com.tplink.smb.omada.common.f.e.c.a()))).collect(Collectors.toList());
        this.c.a(new UpdateSiteStatusDTO(targetOmadacId, initSiteStatus));
        ArrayList updateResult = new ArrayList();
        siteIdList.forEach(siteId -> this.d.b(targetOmadacId, siteId.a(), () -> {
            OperationResponse response = OperationResponse.GENERAL_ERROR;
            try {
                response = onSyncConfig.syncConfig(new d(targetOmadacId), (f)siteId);
                if (!response.success()) {
                    a.warn("omadacId={}, siteId={} do sync site config from siteTemplate={} failed. errormsg={}, function name={}", new Object[]{targetOmadacId, siteId.a(), targetSiteTemplateId, response.getMsg(), onSyncConfig.getClass().getName()});
                }
            }
            catch (Exception e2) {
                a.warn("omadacId={}, siteId={} do sync site config from siteTemplate={} failed with exception. function name={}", new Object[]{targetOmadacId, siteId.a(), targetSiteTemplateId, onSyncConfig.getClass().getName(), e2});
            }
            finally {
                if (response.success() || Objects.equals(com.tplink.smb.omada.common.g.b.Oj.b(), response.getErrorCode())) {
                    updateResult.add(new SiteStatusDTO(siteId.a(), Integer.valueOf(com.tplink.smb.omada.common.f.e.b.a())));
                } else {
                    updateResult.add(new SiteStatusDTO(siteId.a(), Integer.valueOf(com.tplink.smb.omada.common.f.e.d.a())));
                }
            }
            return response;
        }, () -> {
            a.info("Sync site failed because other operations are being performed on omadacId {} and site {}", (Object)targetOmadacId, siteId);
            updateResult.add(new SiteStatusDTO(siteId.a(), Integer.valueOf(com.tplink.smb.omada.common.f.e.d.a())));
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fi);
        }));
        this.c.a(new UpdateSiteStatusDTO(targetOmadacId, updateResult));
    }
}

