/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.a;

import com.tplink.nbu.common.pii.utils.PIIJacksonUtil;
import com.tplink.smb.omada.anomaly.api.b.B;
import com.tplink.smb.omada.anomaly.api.b.G;
import com.tplink.smb.omada.anomaly.api.b.f;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.OsgHealthDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.WanHealthLevelDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.WanMarkDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osw.OswHealthDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.a.a;
import com.tplink.smb.omada.anomaly.core.domain.a.a.c;
import com.tplink.smb.omada.anomaly.core.domain.a.a.e;
import com.tplink.smb.omada.anomaly.core.domain.a.a.g;
import com.tplink.smb.omada.anomaly.core.domain.a.a.i;
import com.tplink.smb.omada.anomaly.core.domain.a.a.m;
import com.tplink.smb.omada.anomaly.core.domain.model.a.b;
import com.tplink.smb.omada.anomaly.core.domain.model.health.dto.ServiceHealthTransferDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.prehandle.health.HealthPreprocessDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.setting.AnomalyEventSettingDTO;
import com.tplink.smb.omada.anomaly.core.port.cache.health.AggregateHealthPreprocessDTO;
import com.tplink.smb.omada.client.api.internal.dto.ClientStatisticsDTO;
import com.tplink.smb.omada.client.api.internal.h;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceStatusEnum;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.DeviceOutlineDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.toolkit.trace.RunnableWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class k {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(k.class);
    @Autowired
    private a b;
    @Autowired
    private g c;
    @Autowired
    private c d;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.port.cache.health.c.a e;
    @Autowired
    private e f;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.port.cache.health.b.a g;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a.k h;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.port.cache.health.b.c i;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.model.prehandle.health.c j;
    @Autowired
    private com.tplink.smb.omada.insight.a.a k;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.device.b l;
    @Autowired
    private com.tplink.smb.omada.insight.api.c.a m;
    @Autowired
    private com.tplink.smb.omada.insight.core.a.a n;
    @Autowired
    @Qualifier(value="scheduleAnomalyWorkGroup")
    private ScheduledExecutorService o;
    @Autowired
    private com.tplink.smb.omada.judgement.a.e p;
    @Autowired
    private m q;
    @Autowired
    private i r;
    @Autowired
    private com.tplink.smb.omada.client.api.internal.g s;
    @Autowired
    private h t;

    public void a(f anomalyDetectPeriod, Integer partition, long scheduledTime) {
        long anomalyDetectTime = com.tplink.smb.omada.anomaly.core.port.f.a.b(anomalyDetectPeriod, scheduledTime);
        Map omadacSiteMap = this.m.a(partition.intValue());
        if (a.isDebugEnabled()) {
            a.debug("partition {} corresponding health omadacId & siteId: {}", (Object)partition, (Object)x.a((Object)omadacSiteMap));
        }
        if (CollectionUtils.isEmpty((Map)omadacSiteMap)) {
            return;
        }
        for (Map.Entry entry : omadacSiteMap.entrySet()) {
            String omadacId = (String)entry.getKey();
            Set siteIds = (Set)entry.getValue();
            if (!this.p.a(omadacId, "health:v2")) {
                com.tplink.smb.omada.anomaly.api.e.a.a((Logger)a, (String)"omadacId = {} is not support capability of health v2", (Object[])new Object[]{omadacId});
                continue;
            }
            siteIds.forEach(siteId -> this.a(anomalyDetectPeriod, omadacId, (String)siteId, anomalyDetectTime));
        }
    }

    private void a(f anomalyDetectPeriod, String omadacId, String siteId, long anomalyDetectTime) {
        com.tplink.smb.omada.anomaly.api.e.a.a((Logger)a, (String)"health v2 for omada {} site {}, period {}, time {}", (Object[])new Object[]{omadacId, siteId, anomalyDetectPeriod, anomalyDetectTime});
        int delay = this.n.a(siteId, anomalyDetectPeriod);
        long timestamp = anomalyDetectTime / 1000L;
        this.o.schedule((Runnable)RunnableWrapper.of(() -> {
            try {
                this.a(omadacId, siteId, timestamp);
            }
            catch (Exception e2) {
                a.warn("timing healthv2 exception: {}", (Object)e2.getMessage(), (Object)e2);
            }
        }), (long)delay, TimeUnit.SECONDS);
    }

    public void a(String omadacId, String siteId, long time, List<b> anomalyEvents, Map<String, AnomalyEventSettingDTO> anomalyEventSettings) {
        long startTime;
        List<AggregateHealthPreprocessDTO> aggregateDeviceDataList = this.j.a(omadacId, siteId, time, B.a);
        List<AggregateHealthPreprocessDTO> aggregateClientDataList = this.j.a(omadacId, siteId, time, B.b);
        Map<String, List<HealthPreprocessDTO>> apPreDataMap = this.a(aggregateDeviceDataList);
        Map<String, List<HealthPreprocessDTO>> clientPreDataMap = this.a(aggregateClientDataList);
        Map<String, OswHealthDTO> oswHealthDTOMap = this.e.a(omadacId, siteId, time);
        Map<String, OsgHealthDTO> osgHealthDTOMap = this.g.a(omadacId, siteId, time);
        Map<String, WanMarkDTO> wanMarkDTOMap = this.i.a(omadacId, siteId, time);
        com.tplink.smb.omada.manager.device.api.internal.device.dto.a queryDeviceListRequest = new com.tplink.smb.omada.manager.device.api.internal.device.dto.a();
        queryDeviceListRequest.a(omadacId);
        queryDeviceListRequest.b(siteId);
        Map deviceOutlineDTOMap = this.l.a(queryDeviceListRequest);
        if (CollectionUtils.isEmpty((Map)deviceOutlineDTOMap)) {
            a.debug("no devices needed to be calculate scores.omadacId:{}, site:{}", (Object)omadacId, (Object)siteId);
            return;
        }
        try {
            startTime = System.currentTimeMillis();
            List<b> anomalyEventListForAp = this.b(anomalyEvents);
            a.debug("start ap health omadac = {}, site = {}", (Object)omadacId, (Object)siteId);
            this.b.a(omadacId, siteId, apPreDataMap, time, anomalyEventListForAp, deviceOutlineDTOMap.getOrDefault(DeviceTypeEnum.a, Collections.emptyList()));
            this.k.a(System.currentTimeMillis() - startTime, "ap");
        }
        catch (Exception e2) {
            a.warn("exception occurred while calculating 10min ap health score, exception:{}", (Object)e2.getMessage(), (Object)e2);
        }
        try {
            startTime = System.currentTimeMillis();
            a.debug("start client health omadac = {}, site = {}", (Object)omadacId, (Object)siteId);
            this.d.a(omadacId, siteId, clientPreDataMap, time);
            this.k.a(System.currentTimeMillis() - startTime, "client");
        }
        catch (Exception e3) {
            a.warn("exception occurred while calculating 10min client health score, exception:{}", (Object)e3.getMessage(), (Object)e3);
        }
        try {
            long startTime2 = System.currentTimeMillis();
            a.debug("start osw health omadac = {}, site = {}", (Object)omadacId, (Object)siteId);
            this.c.a(omadacId, siteId, oswHealthDTOMap, time, deviceOutlineDTOMap.getOrDefault(DeviceTypeEnum.c, Collections.emptyList()));
            this.k.a(System.currentTimeMillis() - startTime2, "osw");
        }
        catch (Exception e4) {
            a.warn("exception occurred while calculating 10min osw health score, exception:{}", (Object)e4.getMessage(), (Object)e4);
        }
        try {
            long startTime3 = System.currentTimeMillis();
            this.h.a(omadacId, siteId, wanMarkDTOMap, time, deviceOutlineDTOMap.getOrDefault(DeviceTypeEnum.b, Collections.emptyList()));
            this.k.a(System.currentTimeMillis() - startTime3, "wan");
        }
        catch (Exception e5) {
            a.warn("exception occurred while calculating 10min wan health score, exception:{}", (Object)e5.getMessage(), (Object)e5);
        }
        try {
            long startTime4 = System.currentTimeMillis();
            a.debug("start osg health omadac = {}, site = {}", (Object)omadacId, (Object)siteId);
            this.f.a(omadacId, siteId, osgHealthDTOMap, time, deviceOutlineDTOMap.getOrDefault(DeviceTypeEnum.b, Collections.emptyList()));
            this.k.a(System.currentTimeMillis() - startTime4, "osg");
        }
        catch (Exception e6) {
            a.warn("exception occurred while calculating 10min osg health score, exception:{}", (Object)e6.getMessage(), (Object)e6);
        }
    }

    public void a(String omadacId, String siteId, long time) {
        long startTime;
        long startTime2;
        List<AggregateHealthPreprocessDTO> aggregateDeviceDataList = this.j.a(omadacId, siteId, time, B.a);
        Map<String, List<HealthPreprocessDTO>> apPreDataMap = this.a(aggregateDeviceDataList);
        Map<String, OswHealthDTO> oswHealthDTOMap = this.e.a(omadacId, siteId, time);
        Map<String, OsgHealthDTO> osgHealthDTOMap = this.g.a(omadacId, siteId, time);
        Map<String, WanMarkDTO> wanMarkDTOMap = this.i.a(omadacId, siteId, time);
        com.tplink.smb.omada.manager.device.api.internal.device.dto.a queryDeviceListRequest = new com.tplink.smb.omada.manager.device.api.internal.device.dto.a();
        queryDeviceListRequest.a(omadacId);
        queryDeviceListRequest.b(siteId);
        Map deviceOutlineDTOMap = this.l.a(queryDeviceListRequest);
        if (CollectionUtils.isEmpty((Map)deviceOutlineDTOMap)) {
            a.debug("no devices needed to be calculate scores.omadacId:{}, site:{}", (Object)omadacId, (Object)siteId);
            return;
        }
        List<String> onlineAp = deviceOutlineDTOMap.getOrDefault(DeviceTypeEnum.a, Collections.emptyList()).stream().filter(device -> Optional.ofNullable(DeviceStatusEnum.a((Integer)device.getStatus())).map(DeviceStatusEnum::e).orElse(false)).map(DeviceOutlineDTO::getMac).toList();
        List<String> wirelessRouter = deviceOutlineDTOMap.getOrDefault(DeviceTypeEnum.b, Collections.emptyList()).stream().filter(device -> Optional.ofNullable(DeviceStatusEnum.a((Integer)device.getStatus())).map(DeviceStatusEnum::e).orElse(false)).filter(device -> Boolean.TRUE.equals(device.getWirelessRouter())).map(DeviceOutlineDTO::getMac).toList();
        Map<String, Integer> deviceMacConnectedNumMap = this.a(omadacId, siteId, apPreDataMap.keySet());
        Boolean clientHealthEnable = false;
        OperationResponse clientHealthEnableResponse = this.t.e(omadacId);
        if (clientHealthEnableResponse.success()) {
            clientHealthEnable = Boolean.TRUE.equals(clientHealthEnableResponse.getResult());
        }
        ServiceHealthTransferDTO serviceHealthTransferDTO = new ServiceHealthTransferDTO();
        serviceHealthTransferDTO.setOnlineAp(onlineAp);
        serviceHealthTransferDTO.setOnlineWirelessRouter(wirelessRouter);
        try {
            startTime2 = System.currentTimeMillis();
            this.b.a(omadacId, siteId, apPreDataMap, time, deviceOutlineDTOMap.getOrDefault(DeviceTypeEnum.a, Collections.emptyList()), deviceMacConnectedNumMap, serviceHealthTransferDTO);
            this.k.b(System.currentTimeMillis() - startTime2, "ap");
        }
        catch (Exception e2) {
            a.warn("exception occurred while calculating 10min ap health score, exception:{}", (Object)e2.getMessage(), (Object)e2);
        }
        try {
            startTime2 = System.currentTimeMillis();
            this.c.a(omadacId, siteId, oswHealthDTOMap, time, deviceOutlineDTOMap.getOrDefault(DeviceTypeEnum.c, Collections.emptyList()), serviceHealthTransferDTO);
            this.k.b(System.currentTimeMillis() - startTime2, "osw");
        }
        catch (Exception e3) {
            a.warn("exception occurred while calculating 10min osw health score, exception:{}", (Object)e3.getMessage(), (Object)e3);
        }
        HashMap<String, WanHealthLevelDTO> wanLevelMap = new HashMap<String, WanHealthLevelDTO>();
        try {
            startTime = System.currentTimeMillis();
            this.h.a(omadacId, siteId, wanMarkDTOMap, time, deviceOutlineDTOMap.getOrDefault(DeviceTypeEnum.b, Collections.emptyList()), wanLevelMap, serviceHealthTransferDTO);
            this.k.b(System.currentTimeMillis() - startTime, "wan");
        }
        catch (Exception e4) {
            a.warn("exception occurred while calculating 10min wan health score, exception:{}", (Object)e4.getMessage(), (Object)e4);
        }
        try {
            startTime = System.currentTimeMillis();
            this.f.a(omadacId, siteId, osgHealthDTOMap, time, deviceOutlineDTOMap.getOrDefault(DeviceTypeEnum.b, Collections.emptyList()), wanLevelMap, serviceHealthTransferDTO);
            this.k.b(System.currentTimeMillis() - startTime, "osg");
        }
        catch (Exception e5) {
            a.warn("exception occurred while calculating 10min osg health score, exception:{}", (Object)e5.getMessage(), (Object)e5);
        }
        try {
            long startTime3 = System.currentTimeMillis();
            this.q.a(omadacId, siteId, time, deviceMacConnectedNumMap, serviceHealthTransferDTO, clientHealthEnable);
            this.k.b(System.currentTimeMillis() - startTime3, "wifi");
        }
        catch (Exception e6) {
            a.warn("exception occurred while calculating 10min wifi health score, exception:{}", (Object)e6.getMessage(), (Object)e6);
        }
        try {
            long startTime4 = System.currentTimeMillis();
            this.r.a(omadacId, siteId, time, deviceOutlineDTOMap.getOrDefault(DeviceTypeEnum.b, Collections.emptyList()), serviceHealthTransferDTO, clientHealthEnable);
            this.k.b(System.currentTimeMillis() - startTime4, "site");
        }
        catch (Exception e7) {
            a.warn("exception occurred while calculating 10min site health score, exception:{}", (Object)e7.getMessage(), (Object)e7);
        }
    }

    private Map<String, Integer> a(String omadacId, String siteId, Set<String> macs) {
        Map deviceMacClientStatisticMap;
        HashMap<String, Integer> deviceMacConnectedNumMap = new HashMap<String, Integer>();
        HashSet<String> siteIds = new HashSet<String>();
        siteIds.add(siteId);
        try {
            deviceMacClientStatisticMap = this.s.a(omadacId, siteIds, macs);
        }
        catch (Exception e2) {
            a.warn("Health: Fail to call client internal api omadacId: {}, siteId: {}, deviceMacs:{}", new Object[]{omadacId, siteId, PIIJacksonUtil.parseToStr(macs), e2});
            deviceMacClientStatisticMap = Collections.emptyMap();
        }
        for (String mac : macs) {
            ClientStatisticsDTO clientStatisticsDTO = (ClientStatisticsDTO)deviceMacClientStatisticMap.get(mac);
            if (Objects.isNull(clientStatisticsDTO)) {
                deviceMacConnectedNumMap.put(mac, 0);
                continue;
            }
            Integer connectedNum = Optional.of(clientStatisticsDTO).map(ClientStatisticsDTO::getTotal).orElse(0);
            deviceMacConnectedNumMap.put(mac, connectedNum);
        }
        return deviceMacConnectedNumMap;
    }

    public void a(Integer partition, long end) {
        long start = end - 3600L;
        this.a(start, end, N.c, partition);
    }

    public void b(Integer partition, long end) {
        long start = end - 3600L;
        this.b(start, end, N.c, partition);
    }

    public void c(Integer partition, long end) {
        long start = end - 7200L;
        this.a(start, end, G.b, partition);
    }

    public void d(Integer partition, long end) {
        long start = end - 86400L;
        this.a(start, end, N.d, partition);
        this.a(start, end, G.c, partition);
    }

    public void e(Integer partition, long end) {
        long start = end - 86400L;
        this.b(start, end, N.d, partition);
    }

    public void f(Integer partition, long end) {
        long start = end - 259200L;
        this.a(start, end, G.d, partition);
    }

    public void a(long timestamp) {
        if (OmadacType.r() || OmadacType.s()) {
            long daily = timestamp / 86400L * 86400L - 31536000L;
            this.b.a(daily);
            this.d.a(daily);
            this.c.a(daily);
            this.f.a(daily);
            this.h.a(daily);
            this.h.b(daily);
        }
    }

    private Map<String, List<HealthPreprocessDTO>> a(List<AggregateHealthPreprocessDTO> aggregateHealthDTOList) {
        HashSet preprocessDataSet = new HashSet();
        aggregateHealthDTOList.forEach(aggregateHealthDTO -> preprocessDataSet.addAll(aggregateHealthDTO.getPreprocessDataList()));
        HashMap<String, List<HealthPreprocessDTO>> preDataMap = new HashMap<String, List<HealthPreprocessDTO>>();
        for (HealthPreprocessDTO preprocessDTO : preprocessDataSet) {
            String mac = preprocessDTO.getMac();
            List preprocessDTOList = preDataMap.computeIfAbsent(mac, key -> new ArrayList());
            preprocessDTOList.add(preprocessDTO);
        }
        return preDataMap;
    }

    private void a(long start, long end, N granularity, Integer partition) {
        Map omadacSiteMap = switch (granularity) {
            case N.c -> this.m.a(partition.intValue());
            case N.d -> this.m.b(partition.intValue());
            default -> this.m.b(partition.intValue());
        };
        if (CollectionUtils.isEmpty((Map)omadacSiteMap)) {
            return;
        }
        for (Map.Entry entry : omadacSiteMap.entrySet()) {
            String omadacId = (String)entry.getKey();
            if (!this.p.a(omadacId, "health:v1")) continue;
            Set siteIds = (Set)entry.getValue();
            siteIds.forEach(siteId -> {
                try {
                    this.b.a(start, end, granularity, omadacId, (String)siteId);
                }
                catch (Exception e2) {
                    a.warn("exception occurred while calculating {} ap health score, exception:{}", new Object[]{granularity, e2.getMessage(), e2});
                }
            });
            siteIds.forEach(siteId -> {
                try {
                    this.d.a(omadacId, (String)siteId, granularity, start, end);
                }
                catch (Exception e2) {
                    a.warn("exception occurred while calculating {} client health score, exception:{}", new Object[]{granularity, e2.getMessage(), e2});
                }
            });
            siteIds.forEach(siteId -> {
                try {
                    this.c.a(start, end, granularity, omadacId, (String)siteId);
                }
                catch (Exception e2) {
                    a.warn("exception occurred while calculating {} osw health score, exception:{}", new Object[]{granularity, e2.getMessage(), e2});
                }
            });
            siteIds.forEach(siteId -> {
                try {
                    this.f.a(start, end, granularity, omadacId, (String)siteId);
                }
                catch (Exception e2) {
                    a.warn("exception occurred while calculating {} osg health score, exception:{}", new Object[]{granularity, e2.getMessage(), e2});
                }
            });
        }
    }

    private void b(long start, long end, N granularity, Integer partition) {
        Map omadacSiteMap = switch (granularity) {
            case N.c -> this.m.a(partition.intValue());
            case N.d -> this.m.b(partition.intValue());
            default -> this.m.b(partition.intValue());
        };
        if (CollectionUtils.isEmpty((Map)omadacSiteMap)) {
            return;
        }
        for (Map.Entry entry : omadacSiteMap.entrySet()) {
            String omadacId = (String)entry.getKey();
            if (!this.p.a(omadacId, "health:v2") || this.p.a(omadacId, "health:v2:no_aggregation")) continue;
            Set siteIds = (Set)entry.getValue();
            this.b.a(start, end, granularity, omadacId, siteIds);
            this.c.a(start, end, granularity, omadacId, siteIds);
            this.f.a(start, end, granularity, omadacId, siteIds);
            this.h.a(start, end, granularity, omadacId, siteIds);
            OperationResponse clientHealthEnableResponse = this.t.e(omadacId);
            if (clientHealthEnableResponse.success() && Boolean.TRUE.equals(clientHealthEnableResponse.getResult())) {
                this.a(start, end, granularity, omadacId, siteIds);
            }
            this.b(start, end, granularity, omadacId, siteIds);
            this.c(start, end, granularity, omadacId, siteIds);
        }
    }

    private void a(long start, long end, N granularity, String omadacId, Set<String> siteIds) {
        siteIds.forEach(siteId -> {
            try {
                this.d.b(omadacId, (String)siteId, granularity, start, end);
            }
            catch (Exception e2) {
                a.warn("exception occurred while calculating {} client health score, exception:{}", new Object[]{granularity, e2.getMessage(), e2});
            }
        });
    }

    private void b(long start, long end, N granularity, String omadacId, Set<String> siteIds) {
        siteIds.forEach(siteId -> {
            try {
                this.r.a(omadacId, (String)siteId, granularity, start, end);
            }
            catch (Exception e2) {
                a.warn("exception occurred while calculating {} site health score, exception:{}", new Object[]{granularity, e2.getMessage(), e2});
            }
        });
    }

    private void c(long start, long end, N granularity, String omadacId, Set<String> siteIds) {
        siteIds.forEach(siteId -> {
            try {
                this.q.a(omadacId, (String)siteId, granularity, start, end);
            }
            catch (Exception e2) {
                a.warn("exception occurred while calculating {} wifi health score, exception:{}", new Object[]{granularity, e2.getMessage(), e2});
            }
        });
    }

    private void a(long start, long end, G granularity, Integer partition) {
        Map omadacSiteMap = switch (granularity) {
            case G.b -> this.m.a(partition.intValue());
            case G.c, G.d -> this.m.b(partition.intValue());
            default -> this.m.b(partition.intValue());
        };
        if (CollectionUtils.isEmpty((Map)omadacSiteMap)) {
            return;
        }
        for (Map.Entry entry : omadacSiteMap.entrySet()) {
            Set siteIds = (Set)entry.getValue();
            String omadacId = (String)entry.getKey();
            if (!this.p.a(omadacId, "health:v1")) continue;
            siteIds.forEach(siteId -> {
                try {
                    this.h.a(start, end, granularity, omadacId, (String)siteId);
                }
                catch (Exception e2) {
                    a.warn("exception occurred while calculating {} wan health score, exception:{}", new Object[]{granularity, e2.getMessage(), e2});
                }
            });
        }
    }

    private List<b> b(List<b> anomalyEvents) {
        if (Objects.isNull(anomalyEvents)) {
            return Collections.emptyList();
        }
        return anomalyEvents.stream().filter(anomalyEvent -> Objects.equals(anomalyEvent.m(), com.tplink.smb.omada.anomaly.api.b.c.aK) || Objects.equals(anomalyEvent.m(), com.tplink.smb.omada.anomaly.api.b.c.aJ)).collect(Collectors.toList());
    }
}

