/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.domain.a.a;

import com.tplink.smb.omada.anomaly.api.d.f.b.a;
import com.tplink.smb.omada.anomaly.api.dto.health.BaseHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.DeviceHealthScoreQueryDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.ap.ApHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.client.ClientHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.wifi.WifiHealthDTO;
import com.tplink.smb.omada.anomaly.core.b.a.d;
import com.tplink.smb.omada.anomaly.core.domain.a.a.o;
import com.tplink.smb.omada.anomaly.core.domain.model.health.dto.ApConnectedNumDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.health.dto.RadioConnectDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.health.dto.RecommendConnectDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.health.dto.ServiceHealthTransferDTO;
import com.tplink.smb.omada.anomaly.core.domain.model.health.dto.WirelessCapacityDTO;
import com.tplink.smb.omada.anomaly.core.port.cache.WirelessCapacityCache;
import com.tplink.smb.omada.anomaly.core.port.f.c;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.judgement.a.e;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class m {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(m.class);
    @Autowired
    private com.tplink.smb.omada.anomaly.api.d.a.c.a b;
    @Autowired
    private com.tplink.smb.omada.anomaly.api.d.b.c.a c;
    @Autowired
    private com.tplink.smb.omada.anomaly.api.d.f.c.a d;
    @Autowired
    private a e;
    @Autowired
    private com.tplink.smb.omada.anomaly.api.d.f.a.a f;
    @Autowired
    private o g;
    @Autowired
    private e h;

    public void a(String omadacId, String siteId, long time, Map<String, Integer> deviceMacConnectedNumMap, ServiceHealthTransferDTO serviceHealthTransferDTO, Boolean clientHealthEnable) {
        long endTime = com.tplink.smb.omada.anomaly.core.port.f.c.a(600L, time);
        long startTime = endTime - 600L;
        WifiHealthDTO wifiHealthDTO = new WifiHealthDTO(omadacId, siteId, Long.valueOf(time));
        List apHealthScoreDTOS = this.b.d(new DeviceHealthScoreQueryDTO(omadacId, siteId, Long.valueOf(startTime), Long.valueOf(endTime)));
        ArrayList<Integer> channelUtilScores = new ArrayList<Integer>();
        ArrayList<Integer> channelInterScores = new ArrayList<Integer>();
        HashMap<String, ApHealthScoreDTO> deviceMacApHealthMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)apHealthScoreDTOS)) {
            for (ApHealthScoreDTO apHealthScoreDTO : apHealthScoreDTOS) {
                channelUtilScores.add(apHealthScoreDTO.getChannelUtilScore());
                channelInterScores.add(apHealthScoreDTO.getInterUtilScore());
                deviceMacApHealthMap = apHealthScoreDTOS.stream().collect(Collectors.toMap(BaseHealthScoreDTO::getMac, Function.identity(), (v1, v2) -> v2));
            }
            a.debug("omadacId: {}, siteId: {}, time: {}, channelUtilScores: {}, channelInterScores: {}", new Object[]{omadacId, siteId, time, channelUtilScores, channelInterScores});
        } else {
            a.debug("Find ap health score empty, omadacId: {}, siteId: {}, time: {}", new Object[]{omadacId, siteId, time});
        }
        ArrayList<Integer> associateScores = new ArrayList<Integer>();
        ArrayList<Integer> rssiScores = new ArrayList<Integer>();
        if (Boolean.TRUE.equals(clientHealthEnable)) {
            List clientHealthScoreDTOS = this.c.b(new DeviceHealthScoreQueryDTO(omadacId, siteId, Long.valueOf(startTime), Long.valueOf(endTime)));
            if (!CollectionUtils.isEmpty((Collection)clientHealthScoreDTOS)) {
                for (ClientHealthScoreDTO clientHealthScoreDTO : clientHealthScoreDTOS) {
                    associateScores.add(clientHealthScoreDTO.getAssociationTimeScore());
                    rssiScores.add(clientHealthScoreDTO.getRssiScore());
                }
                a.debug("omadacId: {}, siteId: {}, time: {}, associateScores: {}, rssiScores: {}", new Object[]{omadacId, siteId, time, associateScores, rssiScores});
            } else {
                a.debug("Find client health score empty, omadacId: {}, siteId: {}, time: {}", new Object[]{omadacId, siteId, time});
            }
        }
        Integer wirelessCapacity = -1;
        HashMap<String, ApConnectedNumDTO> deviceMacConnectedAndRecommendMap = new HashMap<String, ApConnectedNumDTO>();
        Map<String, Integer> deviceMacRecommendConnectMap = this.a(omadacId, deviceMacApHealthMap);
        HashSet<String> onlineWireless = new HashSet<String>(serviceHealthTransferDTO.getOnlineAp());
        onlineWireless.addAll(serviceHealthTransferDTO.getOnlineWirelessRouter());
        for (Map.Entry<String, Integer> entry : deviceMacRecommendConnectMap.entrySet()) {
            String deviceMac = entry.getKey();
            if (!onlineWireless.contains(deviceMac)) continue;
            Integer recommendConnectNum = entry.getValue();
            Integer connectedNum = deviceMacConnectedNumMap.getOrDefault(deviceMac, 0);
            ApConnectedNumDTO connectedNumDTO = new ApConnectedNumDTO(recommendConnectNum, connectedNum);
            deviceMacConnectedAndRecommendMap.put(deviceMac, connectedNumDTO);
        }
        wirelessCapacity = this.a(deviceMacConnectedAndRecommendMap);
        wifiHealthDTO.setChannelUtilScore(this.a(channelUtilScores));
        wifiHealthDTO.setInterUtilScore(this.a(channelInterScores));
        wifiHealthDTO.setAccessTimeScore(this.a(associateScores));
        wifiHealthDTO.setRssiScore(this.a(rssiScores));
        wifiHealthDTO.setAccessCapacityScore(wirelessCapacity);
        wifiHealthDTO.setScore(Integer.valueOf(com.tplink.smb.omada.anomaly.core.b.a.d.b(wifiHealthDTO.getChannelUtilScore(), wifiHealthDTO.getInterUtilScore(), wifiHealthDTO.getAccessTimeScore(), wifiHealthDTO.getRssiScore(), wifiHealthDTO.getAccessCapacityScore())));
        com.tplink.smb.omada.anomaly.api.e.a.a((Logger)a, (String)"transfer transferWifiHealthDTO v2 omadacId: {} siteId: {}, time:{},  score data: {}", (Object[])new Object[]{omadacId, siteId, time, wifiHealthDTO});
        this.d.a(wifiHealthDTO);
        serviceHealthTransferDTO.setWifiHealthDTO(wifiHealthDTO);
    }

    private Map<String, Integer> a(String omadacId, Map<String, ApHealthScoreDTO> deviceMacApHealthMap) {
        if (CollectionUtils.isEmpty(deviceMacApHealthMap)) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> deviceMacRecommendConnectedNumMap = new HashMap<String, Integer>();
        for (Map.Entry<String, ApHealthScoreDTO> entry : deviceMacApHealthMap.entrySet()) {
            String deviceMac = entry.getKey();
            ApHealthScoreDTO apHealthScoreDTO = entry.getValue();
            String model = apHealthScoreDTO.getModel();
            String modelVersion = apHealthScoreDTO.getModelVersion();
            if (this.h.a(omadacId, "health:v2:wireless_capacity_json")) {
                a.debug("support health wireless capacity json, omadacId: {}", (Object)omadacId);
                this.a(omadacId, deviceMac, model, modelVersion, deviceMacRecommendConnectedNumMap);
                continue;
            }
            this.b(omadacId, deviceMac, model, modelVersion, deviceMacRecommendConnectedNumMap);
        }
        return deviceMacRecommendConnectedNumMap;
    }

    private void a(String omadacId, String mac, String model, String modelVersion, Map<String, Integer> deviceMacRecommendConnectedNumMap) {
        OptionalInt minRecommentConnectedNum;
        Set<WirelessCapacityCache.RecommendConnectType> radio6gConnect;
        OptionalInt minRecommentConnectedNum2;
        Set<WirelessCapacityCache.RecommendConnectType> radio5g2Connect;
        OptionalInt minRecommentConnectedNum3;
        Set<WirelessCapacityCache.RecommendConnectType> radio5gConnect;
        OptionalInt minRecommentConnectedNum4;
        Map<String, WirelessCapacityCache.WirelessCapacityType> wirelessCapacityCache = WirelessCapacityCache.a();
        if (CollectionUtils.isEmpty(wirelessCapacityCache)) {
            a.info("wireless capacity cache is empty, omadacId: {}", (Object)omadacId);
            return;
        }
        WirelessCapacityCache.WirelessCapacityType wirelessCapacityType = wirelessCapacityCache.get(WirelessCapacityCache.a(model, modelVersion));
        if (Objects.isNull(wirelessCapacityType)) {
            a.info("Failed to get wireless capacity config, model: {}, modelVersion: {}", (Object)model, (Object)modelVersion);
            return;
        }
        int recommentConnectedNum = 0;
        Set<WirelessCapacityCache.RecommendConnectType> radio2gConnect = wirelessCapacityType.c();
        if (!CollectionUtils.isEmpty(radio2gConnect) && (minRecommentConnectedNum4 = radio2gConnect.stream().map(WirelessCapacityCache.RecommendConnectType::b).mapToInt(Integer::intValue).min()).isPresent()) {
            recommentConnectedNum += minRecommentConnectedNum4.getAsInt();
        }
        if (!CollectionUtils.isEmpty(radio5gConnect = wirelessCapacityType.d()) && (minRecommentConnectedNum3 = radio5gConnect.stream().map(WirelessCapacityCache.RecommendConnectType::b).mapToInt(Integer::intValue).min()).isPresent()) {
            recommentConnectedNum += minRecommentConnectedNum3.getAsInt();
        }
        if (!CollectionUtils.isEmpty(radio5g2Connect = wirelessCapacityType.e()) && (minRecommentConnectedNum2 = radio5g2Connect.stream().map(WirelessCapacityCache.RecommendConnectType::b).mapToInt(Integer::intValue).min()).isPresent()) {
            recommentConnectedNum += minRecommentConnectedNum2.getAsInt();
        }
        if (!CollectionUtils.isEmpty(radio6gConnect = wirelessCapacityType.f()) && (minRecommentConnectedNum = radio6gConnect.stream().map(WirelessCapacityCache.RecommendConnectType::b).mapToInt(Integer::intValue).min()).isPresent()) {
            recommentConnectedNum += minRecommentConnectedNum.getAsInt();
        }
        deviceMacRecommendConnectedNumMap.put(mac, recommentConnectedNum);
    }

    private void b(String omadacId, String mac, String model, String modelVersion, Map<String, Integer> deviceMacRecommendConnectedNumMap) {
        WirelessCapacityDTO wirelessCapacityDTO = this.g.a(model, modelVersion);
        if (Objects.isNull(wirelessCapacityDTO)) {
            a.info("Failed to get wireless capacity config, omadacId: {}, model: {}, modelVersion: {}", new Object[]{omadacId, model, modelVersion});
            return;
        }
        RecommendConnectDTO recommendConnectDTO = wirelessCapacityDTO.getRecommendConnectDTO();
        if (Objects.nonNull(recommendConnectDTO)) {
            OptionalInt minRecommentConnectedNum;
            List<RadioConnectDTO> radio6gConnect;
            OptionalInt minRecommentConnectedNum2;
            List<RadioConnectDTO> radio5g2Connect;
            OptionalInt minRecommentConnectedNum3;
            List<RadioConnectDTO> radio5gConnect;
            OptionalInt minRecommentConnectedNum4;
            int recommentConnectedNum = 0;
            List<RadioConnectDTO> radio2gConnect = recommendConnectDTO.getRadio2gConnect();
            if (!CollectionUtils.isEmpty(radio2gConnect) && (minRecommentConnectedNum4 = radio2gConnect.stream().map(RadioConnectDTO::getRecommendConnectNum).mapToInt(Integer::intValue).min()).isPresent()) {
                recommentConnectedNum += minRecommentConnectedNum4.getAsInt();
            }
            if (!CollectionUtils.isEmpty(radio5gConnect = recommendConnectDTO.getRadio5gConnect()) && (minRecommentConnectedNum3 = radio5gConnect.stream().map(RadioConnectDTO::getRecommendConnectNum).mapToInt(Integer::intValue).min()).isPresent()) {
                recommentConnectedNum += minRecommentConnectedNum3.getAsInt();
            }
            if (!CollectionUtils.isEmpty(radio5g2Connect = recommendConnectDTO.getRadio5g2Connect()) && (minRecommentConnectedNum2 = radio5g2Connect.stream().map(RadioConnectDTO::getRecommendConnectNum).mapToInt(Integer::intValue).min()).isPresent()) {
                recommentConnectedNum += minRecommentConnectedNum2.getAsInt();
            }
            if (!CollectionUtils.isEmpty(radio6gConnect = recommendConnectDTO.getRadio6gConnect()) && (minRecommentConnectedNum = radio6gConnect.stream().map(RadioConnectDTO::getRecommendConnectNum).mapToInt(Integer::intValue).min()).isPresent()) {
                recommentConnectedNum += minRecommentConnectedNum.getAsInt();
            }
            deviceMacRecommendConnectedNumMap.put(mac, recommentConnectedNum);
        }
    }

    private Integer a(List<Integer> scores) {
        if (CollectionUtils.isEmpty(scores)) {
            return -1;
        }
        HashMap<Integer, Integer> scoreCountMap = new HashMap<Integer, Integer>();
        for (Integer score : scores) {
            if (Objects.equals(score, -1) || Objects.equals(score, 0)) continue;
            Integer count = (Integer)scoreCountMap.get(score);
            if (Objects.isNull(count)) {
                scoreCountMap.put(score, 1);
                continue;
            }
            scoreCountMap.put(score, count + 1);
        }
        if (CollectionUtils.isEmpty(scoreCountMap)) {
            return -1;
        }
        int nineTenCount = scoreCountMap.getOrDefault(9, 0) + scoreCountMap.getOrDefault(10, 0);
        int sevenEightCount = scoreCountMap.getOrDefault(7, 0) + scoreCountMap.getOrDefault(8, 0);
        if ((float)nineTenCount >= (float)scoreCountMap.size() * 0.8f) {
            return 100;
        }
        if ((float)(sevenEightCount + nineTenCount) >= (float)scoreCountMap.size() * 0.8f) {
            return 80;
        }
        Integer totalScore = 0;
        Integer totalCount = 0;
        for (Map.Entry entry : scoreCountMap.entrySet()) {
            totalScore = totalScore + (Integer)entry.getKey() * (Integer)entry.getValue();
            totalCount = totalCount + (Integer)entry.getValue();
        }
        return Math.round((float)totalScore.intValue() / (float)totalCount.intValue() * 10.0f);
    }

    private Integer a(Map<String, ApConnectedNumDTO> deviceMacConnectedNumMap) {
        if (CollectionUtils.isEmpty(deviceMacConnectedNumMap)) {
            return -1;
        }
        int deviceNum = deviceMacConnectedNumMap.size();
        Integer score = 0;
        ArrayList<Float> deviations = new ArrayList<Float>();
        for (Map.Entry<String, ApConnectedNumDTO> entry : deviceMacConnectedNumMap.entrySet()) {
            ApConnectedNumDTO connectedNumDTO = entry.getValue();
            if (Objects.equals(connectedNumDTO.getRecommendConnectNum(), 0)) continue;
            float deviation = (float)connectedNumDTO.getConnectedNum().intValue() / (float)connectedNumDTO.getRecommendConnectNum().intValue();
            score = score + this.a(deviation);
            deviations.add(Float.valueOf(deviation));
        }
        if (CollectionUtils.isEmpty(deviations)) {
            return -1;
        }
        Integer scoreAvg = score / deviceNum;
        float standardDeviation = this.b(deviations);
        return Math.max(0, (scoreAvg - this.b(standardDeviation)) * 10);
    }

    private int a(float deviation) {
        if (deviation < 0.5f) {
            return 10;
        }
        if (deviation < 1.0f) {
            return 8;
        }
        if (deviation < 1.5f) {
            return 6;
        }
        if (deviation < 2.0f) {
            return 4;
        }
        return 0;
    }

    private float b(List<Float> deviations) {
        float sum = 0.0f;
        float standardDeviation = 0.0f;
        for (Float deviation : deviations) {
            sum += deviation.floatValue();
        }
        float mean = sum / (float)deviations.size();
        for (Float deviation : deviations) {
            standardDeviation = (float)((double)standardDeviation + Math.pow(deviation.floatValue() - mean, 2.0));
        }
        return (float)Math.sqrt(standardDeviation / (float)deviations.size());
    }

    private int b(float standardDeviation) {
        if (standardDeviation < 0.5f) {
            return 0;
        }
        if (standardDeviation < 1.0f) {
            return 1;
        }
        if (standardDeviation < 1.5f) {
            return 2;
        }
        return 3;
    }

    public void a(String omadacId, String siteId, N granularityEnum, long startSec, long endSec) {
        a.debug("statistic wifi health v2 {} omadacId: {} siteId: {} start:{}, end:{}", new Object[]{granularityEnum.a(), omadacId, siteId, startSec, endSec});
        if (granularityEnum.equals((Object)N.c)) {
            this.a(omadacId, siteId, startSec, endSec);
        } else if (granularityEnum.equals((Object)N.d)) {
            this.b(omadacId, siteId, startSec, endSec);
        }
    }

    private void a(String omadacId, String siteId, long startSec, long endSec) {
        WifiHealthDTO wifiHealthAggregationDTO = new WifiHealthDTO();
        wifiHealthAggregationDTO.setOmadacId(omadacId);
        wifiHealthAggregationDTO.setSiteId(siteId);
        wifiHealthAggregationDTO.setTimestamp(Long.valueOf(endSec));
        DeviceHealthScoreQueryDTO healthScoreQueryDTO = new DeviceHealthScoreQueryDTO(omadacId, siteId, Long.valueOf(startSec), Long.valueOf(endSec));
        List wifiHealthDTOS = this.d.a(healthScoreQueryDTO);
        if (CollectionUtils.isEmpty((Collection)wifiHealthDTOS)) {
            return;
        }
        Integer accessTimeScore = 0;
        Integer channelUtilScore = 0;
        Integer interUtilScore = 0;
        Integer accessCapacityScore = 0;
        Integer rssiScore = 0;
        Integer accessTimeSize = 0;
        Integer channelUtilSize = 0;
        Integer interUtilSize = 0;
        Integer accessCapacitySize = 0;
        Integer rssiSize = 0;
        for (WifiHealthDTO wifiHealthDTO : wifiHealthDTOS) {
            Integer n2;
            if (this.a(wifiHealthDTO.getAccessTimeScore())) {
                accessTimeScore = accessTimeScore + wifiHealthDTO.getAccessTimeScore();
                n2 = accessTimeSize;
                accessTimeSize = accessTimeSize + 1;
            }
            if (this.a(wifiHealthDTO.getChannelUtilScore())) {
                channelUtilScore = channelUtilScore + wifiHealthDTO.getChannelUtilScore();
                n2 = channelUtilSize;
                channelUtilSize = channelUtilSize + 1;
            }
            if (this.a(wifiHealthDTO.getInterUtilScore())) {
                interUtilScore = interUtilScore + wifiHealthDTO.getInterUtilScore();
                n2 = interUtilSize;
                interUtilSize = interUtilSize + 1;
            }
            if (this.a(wifiHealthDTO.getAccessCapacityScore())) {
                accessCapacityScore = accessCapacityScore + wifiHealthDTO.getAccessCapacityScore();
                n2 = accessCapacitySize;
                accessCapacitySize = accessCapacitySize + 1;
            }
            if (!this.a(wifiHealthDTO.getRssiScore())) continue;
            rssiScore = rssiScore + wifiHealthDTO.getRssiScore();
            n2 = rssiSize;
            rssiSize = rssiSize + 1;
        }
        wifiHealthAggregationDTO.setAccessTimeScore(Integer.valueOf(accessTimeSize == 0 ? -1 : Math.round((float)accessTimeScore.intValue() / (float)accessTimeSize.intValue())));
        wifiHealthAggregationDTO.setChannelUtilScore(Integer.valueOf(channelUtilSize == 0 ? -1 : Math.round((float)channelUtilScore.intValue() / (float)channelUtilSize.intValue())));
        wifiHealthAggregationDTO.setInterUtilScore(Integer.valueOf(interUtilSize == 0 ? -1 : Math.round((float)interUtilScore.intValue() / (float)interUtilSize.intValue())));
        wifiHealthAggregationDTO.setAccessCapacityScore(Integer.valueOf(accessCapacitySize == 0 ? -1 : Math.round((float)accessCapacityScore.intValue() / (float)accessCapacitySize.intValue())));
        wifiHealthAggregationDTO.setRssiScore(Integer.valueOf(rssiSize == 0 ? -1 : Math.round((float)rssiScore.intValue() / (float)rssiSize.intValue())));
        wifiHealthAggregationDTO.setScore(Integer.valueOf(com.tplink.smb.omada.anomaly.core.b.a.d.b(wifiHealthAggregationDTO.getAccessTimeScore(), wifiHealthAggregationDTO.getChannelUtilScore(), wifiHealthAggregationDTO.getInterUtilScore(), wifiHealthAggregationDTO.getAccessCapacityScore(), wifiHealthAggregationDTO.getRssiScore())));
        this.e.a(wifiHealthAggregationDTO);
    }

    private void b(String omadacId, String siteId, long startSec, long endSec) {
        WifiHealthDTO wifiHealthAggregationDTO = new WifiHealthDTO();
        wifiHealthAggregationDTO.setOmadacId(omadacId);
        wifiHealthAggregationDTO.setSiteId(siteId);
        wifiHealthAggregationDTO.setTimestamp(Long.valueOf(endSec));
        DeviceHealthScoreQueryDTO healthScoreQueryDTO = new DeviceHealthScoreQueryDTO(omadacId, siteId, Long.valueOf(startSec), Long.valueOf(endSec));
        List wifiHealthDTOS = this.e.a(healthScoreQueryDTO);
        if (CollectionUtils.isEmpty((Collection)wifiHealthDTOS)) {
            return;
        }
        Integer accessTimeScore = 0;
        Integer channelUtilScore = 0;
        Integer interUtilScore = 0;
        Integer accessCapacityScore = 0;
        Integer rssiScore = 0;
        Integer accessTimeSize = 0;
        Integer channelUtilSize = 0;
        Integer interUtilSize = 0;
        Integer accessCapacitySize = 0;
        Integer rssiSize = 0;
        for (WifiHealthDTO wifiHealthDTO : wifiHealthDTOS) {
            Integer n2;
            if (this.a(wifiHealthDTO.getAccessTimeScore())) {
                accessTimeScore = accessTimeScore + wifiHealthDTO.getAccessTimeScore();
                n2 = accessTimeSize;
                accessTimeSize = accessTimeSize + 1;
            }
            if (this.a(wifiHealthDTO.getChannelUtilScore())) {
                channelUtilScore = channelUtilScore + wifiHealthDTO.getChannelUtilScore();
                n2 = channelUtilSize;
                channelUtilSize = channelUtilSize + 1;
            }
            if (this.a(wifiHealthDTO.getInterUtilScore())) {
                interUtilScore = interUtilScore + wifiHealthDTO.getInterUtilScore();
                n2 = interUtilSize;
                interUtilSize = interUtilSize + 1;
            }
            if (this.a(wifiHealthDTO.getAccessCapacityScore())) {
                accessCapacityScore = accessCapacityScore + wifiHealthDTO.getAccessCapacityScore();
                n2 = accessCapacitySize;
                accessCapacitySize = accessCapacitySize + 1;
            }
            if (!this.a(wifiHealthDTO.getRssiScore())) continue;
            rssiScore = rssiScore + wifiHealthDTO.getRssiScore();
            n2 = rssiSize;
            rssiSize = rssiSize + 1;
        }
        wifiHealthAggregationDTO.setAccessTimeScore(Integer.valueOf(accessTimeSize == 0 ? -1 : Math.round((float)accessTimeScore.intValue() / (float)accessTimeSize.intValue())));
        wifiHealthAggregationDTO.setChannelUtilScore(Integer.valueOf(channelUtilSize == 0 ? -1 : Math.round((float)channelUtilScore.intValue() / (float)channelUtilSize.intValue())));
        wifiHealthAggregationDTO.setInterUtilScore(Integer.valueOf(interUtilSize == 0 ? -1 : Math.round((float)interUtilScore.intValue() / (float)interUtilSize.intValue())));
        wifiHealthAggregationDTO.setAccessCapacityScore(Integer.valueOf(accessCapacitySize == 0 ? -1 : Math.round((float)accessCapacityScore.intValue() / (float)accessCapacitySize.intValue())));
        wifiHealthAggregationDTO.setRssiScore(Integer.valueOf(rssiSize == 0 ? -1 : Math.round((float)rssiScore.intValue() / (float)rssiSize.intValue())));
        wifiHealthAggregationDTO.setScore(Integer.valueOf(com.tplink.smb.omada.anomaly.core.b.a.d.b(wifiHealthAggregationDTO.getAccessTimeScore(), wifiHealthAggregationDTO.getChannelUtilScore(), wifiHealthAggregationDTO.getInterUtilScore(), wifiHealthAggregationDTO.getAccessCapacityScore(), wifiHealthAggregationDTO.getRssiScore())));
        this.f.a(wifiHealthAggregationDTO);
    }

    public List<WifiHealthDTO> a(DeviceHealthScoreQueryDTO query, N granularity) {
        switch (granularity) {
            case b: {
                return this.d.a(query);
            }
            case c: {
                return this.e.a(query);
            }
            case d: {
                return this.f.a(query);
            }
        }
        return Collections.emptyList();
    }

    private boolean a(Integer score) {
        return !Objects.isNull(score) && !Objects.equals(score, -1) && !Objects.equals(score, 0);
    }
}

