/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.c.a;

import com.tplink.smb.omada.anomaly.api.b.r;
import com.tplink.smb.omada.anomaly.api.dto.health.BaseHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.DeviceHealthDetailQueryDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.DeviceHealthScoreQueryDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.DeviceScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.ReportV2HealthQueryDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.ap.ApHealthAggregationDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.ap.ApHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.client.ClientHealthAggregationDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.client.ClientHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.OsgHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.WanHealthLevelDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osw.OswHealthAggregationDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osw.OswHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.site.SiteHealthDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.wifi.WifiHealthDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.AggregationHealthDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.AnomalyStatDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.ClientHealthInternalDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.ClientHealthV2InternalDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.DashboardHealthInternalDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.GatewayHealthDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.HealthScoreByMacAndTypeQueryDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.HealthScoreQueryDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.RealTimeHealthQueryDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.ReportV2DeviceHealthTrendDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.ReportV2SiteHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.ReportV2WifiHealthDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.SiteClientHealthRequestDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.SiteClientHealthResultDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.SiteHealthQueryDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.SiteHealthScoreQueryDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.SiteHealthScoreResultDTO;
import com.tplink.smb.omada.anomaly.api.internal.health.SiteListHealthScoreQueryDTO;
import com.tplink.smb.omada.anomaly.core.domain.a.a.c;
import com.tplink.smb.omada.anomaly.core.domain.a.a.e;
import com.tplink.smb.omada.anomaly.core.domain.a.a.g;
import com.tplink.smb.omada.anomaly.core.domain.a.a.i;
import com.tplink.smb.omada.anomaly.core.domain.a.a.k;
import com.tplink.smb.omada.anomaly.core.domain.a.a.m;
import com.tplink.smb.omada.client.api.web.vo.clienthealth.SiteClientHealthRealtimeStatVO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.monitor.api.internal.statistic.dto.OsgHealthStatDTO;
import com.tplink.smb.omada.monitor.api.internal.statistic.dto.b;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class a
implements com.tplink.smb.omada.anomaly.api.internal.health.b {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a.a b;
    @Autowired
    private c c;
    @Autowired
    private g d;
    @Autowired
    private e e;
    @Autowired
    private k f;
    @Autowired
    private com.tplink.smb.omada.monitor.api.internal.statistic.a g;
    @Autowired
    private m h;
    @Autowired
    private i i;

    public Map<String, ApHealthScoreDTO> a(HealthScoreQueryDTO dto) {
        String omadacId = dto.getOmadacId();
        String siteId = dto.getSiteId();
        long time = System.currentTimeMillis() / 1000L / 600L * 600L;
        DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO = new DeviceHealthScoreQueryDTO(omadacId, siteId, Long.valueOf(time - 600L), Long.valueOf(time));
        List<ApHealthScoreDTO> healthScoreDTOList = this.b.a(deviceHealthScoreQueryDTO, N.b);
        HashMap<String, ApHealthScoreDTO> healthMap = new HashMap<String, ApHealthScoreDTO>();
        healthScoreDTOList.forEach(healthScoreDTO -> healthMap.compute(healthScoreDTO.getMac(), (mac, previous) -> {
            if (Objects.isNull(previous)) {
                return healthScoreDTO;
            }
            if (healthScoreDTO.getTimestamp() > previous.getTimestamp()) {
                return healthScoreDTO;
            }
            return previous;
        }));
        return healthMap;
    }

    public List<OswHealthScoreDTO> b(HealthScoreQueryDTO dto) {
        String omadacId = dto.getOmadacId();
        String siteId = dto.getSiteId();
        List macList = dto.getMacList();
        ArrayList<OswHealthScoreDTO> healthScoreDTOS = new ArrayList<OswHealthScoreDTO>();
        long time = System.currentTimeMillis() / 1000L / 600L * 600L;
        DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO = new DeviceHealthScoreQueryDTO(omadacId, siteId, Long.valueOf(time - 600L), Long.valueOf(time));
        macList.forEach(mac -> {
            deviceHealthScoreQueryDTO.setMac(mac);
            List<OswHealthScoreDTO> healthList = this.d.a(deviceHealthScoreQueryDTO, N.b);
            if (healthList.isEmpty()) {
                healthScoreDTOS.add(new OswHealthScoreDTO(omadacId, siteId, mac, Long.valueOf(time), Integer.valueOf(-1)));
            } else {
                ArrayList scoreDTOList = new ArrayList(healthList.stream().collect(Collectors.toMap(BaseHealthScoreDTO::getTimestamp, v2 -> v2, (v1, v2) -> v2, TreeMap::new)).values());
                healthScoreDTOS.add((OswHealthScoreDTO)scoreDTOList.get(scoreDTOList.size() - 1));
            }
        });
        return healthScoreDTOS;
    }

    public Map<String, Integer> a(SiteHealthScoreQueryDTO dto) {
        String omadacId = dto.getOmadacId();
        String siteId = dto.getSiteId();
        HashMap<String, Integer> scoreMap = new HashMap<String, Integer>();
        long endTime = System.currentTimeMillis() / 1000L / 600L * 600L;
        if (dto.getSourceTime() != null) {
            endTime = dto.getSourceTime() / 1000L / 600L * 600L;
        }
        long start = endTime - 1200L;
        DeviceHealthScoreQueryDTO queryDTO = new DeviceHealthScoreQueryDTO(omadacId, siteId, Long.valueOf(start), Long.valueOf(endTime));
        List<DeviceScoreDTO> apHealthScoreDTOList = this.b.b(queryDTO);
        List<DeviceScoreDTO> osgHealthScoreDTOList = this.e.b(queryDTO);
        List<DeviceScoreDTO> oswHealthScoreDTOList = this.d.b(queryDTO);
        HashMap apScoreMap = new HashMap(8);
        HashMap osgScoreMap = new HashMap(8);
        HashMap oswScoreMap = new HashMap(8);
        if (!CollectionUtils.isEmpty(apHealthScoreDTOList)) {
            apHealthScoreDTOList.forEach(apHealthScoreDTO -> apScoreMap.putIfAbsent(apHealthScoreDTO.getMac(), apHealthScoreDTO.getScore()));
        }
        if (!CollectionUtils.isEmpty(osgHealthScoreDTOList)) {
            osgHealthScoreDTOList.forEach(osgHealthScoreDTO -> osgScoreMap.putIfAbsent(osgHealthScoreDTO.getMac(), osgHealthScoreDTO.getScore()));
        }
        if (!CollectionUtils.isEmpty(oswHealthScoreDTOList)) {
            oswHealthScoreDTOList.forEach(oswHealthScoreDTO -> oswScoreMap.putIfAbsent(oswHealthScoreDTO.getMac(), oswHealthScoreDTO.getScore()));
        }
        scoreMap.putAll(apScoreMap);
        scoreMap.putAll(osgScoreMap);
        scoreMap.putAll(oswScoreMap);
        return scoreMap;
    }

    public SiteHealthScoreResultDTO a(SiteListHealthScoreQueryDTO dto) {
        List siteIdList = dto.getSiteIdList();
        String oamdacId = dto.getOmadacId();
        SiteHealthScoreResultDTO siteHealthScoreResultDTO = new SiteHealthScoreResultDTO();
        siteHealthScoreResultDTO.setOamdacId(oamdacId);
        if (CollectionUtils.isEmpty((Collection)siteIdList) || Objects.isNull(oamdacId)) {
            return siteHealthScoreResultDTO;
        }
        HashMap deviceHealthMap = new HashMap();
        siteIdList.forEach(siteId -> {
            SiteHealthScoreQueryDTO siteHealthScoreQueryDTO = new SiteHealthScoreQueryDTO();
            siteHealthScoreQueryDTO.setOmadacId(oamdacId);
            siteHealthScoreQueryDTO.setSiteId(siteId);
            Map<String, Integer> siteDeviceHealthMap = this.a(siteHealthScoreQueryDTO);
            if (!CollectionUtils.isEmpty(siteDeviceHealthMap)) {
                deviceHealthMap.putAll(siteDeviceHealthMap);
            }
        });
        siteHealthScoreResultDTO.setDeviceHealth(deviceHealthMap);
        return siteHealthScoreResultDTO;
    }

    public SiteClientHealthResultDTO a(SiteClientHealthRequestDTO request) {
        String omadacId = request.getOmadacId();
        String siteId = request.getSiteId();
        long queryTime = request.getTimestamp() == null ? System.currentTimeMillis() : request.getTimestamp();
        long time = queryTime / 1000L / 600L * 600L;
        DeviceHealthScoreQueryDTO queryDTO = new DeviceHealthScoreQueryDTO(omadacId, siteId, Long.valueOf(time - 1200L), Long.valueOf(time));
        List<DeviceScoreDTO> clientHealthScoreDTOList = this.c.a(queryDTO);
        SiteClientHealthResultDTO siteClientHealthResultDTO = new SiteClientHealthResultDTO();
        if (!CollectionUtils.isEmpty(clientHealthScoreDTOList)) {
            siteClientHealthResultDTO.setSiteId(request.getSiteId());
            ArrayList clientHealthInternalDTOList = new ArrayList();
            clientHealthScoreDTOList.forEach(deviceScoreDTO -> clientHealthInternalDTOList.add(new ClientHealthInternalDTO(deviceScoreDTO.getMac(), deviceScoreDTO.getScore())));
            siteClientHealthResultDTO.setClientHealthDTOList(clientHealthInternalDTOList);
        }
        return siteClientHealthResultDTO;
    }

    public DashboardHealthInternalDTO b(SiteHealthScoreQueryDTO dto) {
        b request;
        Map osgHealthStatDTOMap;
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 1200L;
        String omadacId = dto.getOmadacId();
        String siteId = dto.getSiteId();
        DashboardHealthInternalDTO dashboardHealthInternalDTO = new DashboardHealthInternalDTO();
        AggregationHealthDTO apHealthDTO = new AggregationHealthDTO(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
        AggregationHealthDTO switchHealthDTO = new AggregationHealthDTO(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
        AggregationHealthDTO wirelessClientHealthDTO = new AggregationHealthDTO(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
        AggregationHealthDTO wiredClientHealthDTO = new AggregationHealthDTO(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
        List<Object> wanHealthList = new ArrayList();
        GatewayHealthDTO gatewayHealthDTO = new GatewayHealthDTO();
        DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO = new DeviceHealthScoreQueryDTO(omadacId, siteId, Long.valueOf(start), Long.valueOf(end));
        Map<String, Integer> apHealthScoreMap = this.b.b(deviceHealthScoreQueryDTO).stream().collect(Collectors.toMap(DeviceScoreDTO::getMac, DeviceScoreDTO::getScore));
        this.a(apHealthDTO, apHealthScoreMap);
        Map<String, Integer> oswHealthScoreMap = this.d.b(deviceHealthScoreQueryDTO).stream().collect(Collectors.toMap(DeviceScoreDTO::getMac, DeviceScoreDTO::getScore));
        this.a(switchHealthDTO, oswHealthScoreMap);
        SiteClientHealthRealtimeStatVO siteClientHealthRealtimeStat = new SiteClientHealthRealtimeStatVO();
        List<ClientHealthAggregationDTO> clientHealthScoreDTOList = this.c.b(deviceHealthScoreQueryDTO, N.b);
        if (!CollectionUtils.isEmpty(clientHealthScoreDTOList)) {
            ClientHealthAggregationDTO clientHealthAggregationDTO = (ClientHealthAggregationDTO)clientHealthScoreDTOList.stream().sorted(Comparator.comparing(ClientHealthAggregationDTO::getTime).reversed()).collect(Collectors.toList()).get(0);
            wiredClientHealthDTO.setGood(clientHealthAggregationDTO.getWiredGood());
            wiredClientHealthDTO.setFair(clientHealthAggregationDTO.getWiredFair());
            wiredClientHealthDTO.setPoor(clientHealthAggregationDTO.getWiredPoor());
            wiredClientHealthDTO.setNoData(clientHealthAggregationDTO.getWiredNoData());
            wirelessClientHealthDTO.setGood(clientHealthAggregationDTO.getWirelessGood());
            wirelessClientHealthDTO.setFair(clientHealthAggregationDTO.getWirelessFair());
            wirelessClientHealthDTO.setPoor(clientHealthAggregationDTO.getWirelessPoor());
            wirelessClientHealthDTO.setNoData(clientHealthAggregationDTO.getWirelessNoData());
        }
        List<DeviceScoreDTO> osgHealthScoreList = this.e.c(deviceHealthScoreQueryDTO);
        String mainGatewayMac = null;
        if (!CollectionUtils.isEmpty(osgHealthScoreList) && !CollectionUtils.isEmpty((Map)(osgHealthStatDTOMap = this.g.a(request = new b(omadacId, siteId, mainGatewayMac = osgHealthScoreList.get(0).getMac(), Long.valueOf(start), Long.valueOf(end), N.a))))) {
            ArrayList osgHealthStatDTOList = new ArrayList(osgHealthStatDTOMap.values());
            osgHealthStatDTOList.sort(Comparator.comparing(OsgHealthStatDTO::getTime).reversed());
            OsgHealthStatDTO osgHealthStatDTO = (OsgHealthStatDTO)osgHealthStatDTOList.get(0);
            gatewayHealthDTO.setCpuUtil(osgHealthStatDTO.getCpuUtil());
            gatewayHealthDTO.setMemUtil(osgHealthStatDTO.getMemUtil());
            gatewayHealthDTO.setHealthScore(osgHealthScoreList.get(0).getScore());
        }
        if (gatewayHealthDTO.getHealthScore() == null || gatewayHealthDTO.getHealthScore() <= 0) {
            wanHealthList = Collections.emptyList();
        } else {
            DeviceHealthDetailQueryDTO deviceHealthDetailQueryDTO = new DeviceHealthDetailQueryDTO(omadacId, siteId, Long.valueOf(end));
            deviceHealthDetailQueryDTO.setMac(mainGatewayMac);
            List<WanHealthLevelDTO> dtoList = this.f.a(deviceHealthDetailQueryDTO);
            Map<Integer, String> wanDialCauseCodeMap = this.f.a(omadacId, siteId, end);
            wanHealthList = com.tplink.smb.omada.anomaly.api.c.b.a(dtoList, wanDialCauseCodeMap);
        }
        dashboardHealthInternalDTO.setEapHealth(apHealthDTO);
        dashboardHealthInternalDTO.setSwitchHealth(switchHealthDTO);
        dashboardHealthInternalDTO.setGatewayHealth(gatewayHealthDTO);
        dashboardHealthInternalDTO.setWanHealth(wanHealthList);
        dashboardHealthInternalDTO.setWiredClientsHealth(wiredClientHealthDTO);
        dashboardHealthInternalDTO.setWirelessClientsHealth(wirelessClientHealthDTO);
        if (Boolean.TRUE.equals(dto.getIgnoreIncidentCount())) {
            return dashboardHealthInternalDTO;
        }
        dashboardHealthInternalDTO.setAnomalyStatDTO(new AnomalyStatDTO(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0)));
        a.debug("query dashboard health info:{}", (Object)dashboardHealthInternalDTO);
        return dashboardHealthInternalDTO;
    }

    private void a(AggregationHealthDTO aggregationHealthDTO, Map<String, Integer> healthScoreMap) {
        if (!CollectionUtils.isEmpty(healthScoreMap)) {
            AtomicInteger goodNum = new AtomicInteger();
            AtomicInteger fairNum = new AtomicInteger();
            AtomicInteger poorNum = new AtomicInteger();
            healthScoreMap.forEach((mac, health) -> {
                switch (Objects.requireNonNull(r.a((int)health))) {
                    case a: {
                        goodNum.getAndIncrement();
                        break;
                    }
                    case b: {
                        fairNum.getAndIncrement();
                        break;
                    }
                    case c: {
                        poorNum.getAndIncrement();
                        break;
                    }
                }
            });
            aggregationHealthDTO.setPoor(Integer.valueOf(poorNum.get()));
            aggregationHealthDTO.setFair(Integer.valueOf(fairNum.get()));
            aggregationHealthDTO.setGood(Integer.valueOf(goodNum.get()));
        }
    }

    public Map<Integer, Integer> a(RealTimeHealthQueryDTO dto) {
        DeviceHealthDetailQueryDTO queryDTO = new DeviceHealthDetailQueryDTO(dto.getOmadacId(), dto.getSiteId(), dto.getTime());
        List<WanHealthLevelDTO> dtoList = this.f.a(queryDTO);
        HashMap<Integer, Integer> wanHealthMap = new HashMap<Integer, Integer>();
        if (!CollectionUtils.isEmpty(dtoList)) {
            Map portStatusMap = dtoList.get(0).getHealthMap();
            portStatusMap.forEach((port, status) -> {
                if (Objects.isNull(status) || status > 3) {
                    wanHealthMap.put((Integer)port, 3);
                } else {
                    wanHealthMap.put((Integer)port, (Integer)status);
                }
            });
        }
        return wanHealthMap;
    }

    public List<ClientHealthInternalDTO> c(HealthScoreQueryDTO dto) {
        String omadacId = dto.getOmadacId();
        String siteId = dto.getSiteId();
        List macList = dto.getMacList();
        if (Objects.isNull(macList) || CollectionUtils.isEmpty((Collection)macList)) {
            return Collections.emptyList();
        }
        ArrayList<ClientHealthInternalDTO> result = new ArrayList<ClientHealthInternalDTO>();
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 600L;
        if (Objects.nonNull(dto.getStart()) && Objects.nonNull(dto.getEnd())) {
            end = dto.getEnd();
            start = dto.getStart();
        }
        DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO = new DeviceHealthScoreQueryDTO(omadacId, siteId, Long.valueOf(start), Long.valueOf(end));
        macList.forEach(mac -> {
            deviceHealthScoreQueryDTO.setMac(mac);
            ClientHealthScoreDTO scoreDTO = this.f(deviceHealthScoreQueryDTO);
            ClientHealthInternalDTO clientHealthInternalDTO = ClientHealthInternalDTO.toInternalDTO((ClientHealthScoreDTO)scoreDTO);
            if (Objects.isNull(clientHealthInternalDTO)) {
                clientHealthInternalDTO = ClientHealthInternalDTO.createNoHealthInternalDTO((String)mac, (Long)deviceHealthScoreQueryDTO.getEnd());
            }
            result.add(clientHealthInternalDTO);
        });
        return result;
    }

    public Map<String, Integer> a(HealthScoreByMacAndTypeQueryDTO dto) {
        String omadacId = dto.getOmadacId();
        String siteId = dto.getSiteId();
        Map macTypeMap = dto.getMacAndTypeMap();
        if (Objects.isNull(macTypeMap)) {
            return new HashMap<String, Integer>(0);
        }
        long time = System.currentTimeMillis() / 1000L;
        long start = time - 1200L;
        HashMap<String, Integer> result = new HashMap<String, Integer>(4);
        for (Map.Entry entry : macTypeMap.entrySet()) {
            String mac = (String)entry.getKey();
            Integer type = (Integer)entry.getValue();
            if (Objects.isNull(mac) || Objects.isNull(type)) continue;
            DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO = new DeviceHealthScoreQueryDTO(omadacId, siteId, mac, Long.valueOf(start), Long.valueOf(time));
            switch (type) {
                case 0: {
                    result.put(mac, this.b(deviceHealthScoreQueryDTO));
                    break;
                }
                case 1: {
                    result.put(mac, this.c(deviceHealthScoreQueryDTO));
                    break;
                }
                case 2: {
                    result.put(mac, this.d(deviceHealthScoreQueryDTO));
                    break;
                }
                case 3: {
                    result.put(mac, this.e(deviceHealthScoreQueryDTO));
                    break;
                }
            }
        }
        return result;
    }

    public OperationResponse a(ClientHealthV2InternalDTO dto) {
        a.debug("Add client health score, omadacId: {}, siteId: {}, ClientHealthV2InternalDTO: {}", new Object[]{dto.getOmadacId(), dto.getSiteId(), dto});
        return this.c.a(dto.getOmadacId(), dto.getSiteId(), dto.getTime(), dto.getClientHealthScores());
    }

    public List<ClientHealthInternalDTO> a(DeviceHealthScoreQueryDTO dto) {
        if (T.c((String)dto.getMac())) {
            return Collections.emptyList();
        }
        List<ClientHealthScoreDTO> healthList = this.c.a(dto, N.b);
        a.debug("getClientHealthScoreByTimeRange query is {}, scoreList is {}", (Object)dto, healthList);
        List<ClientHealthInternalDTO> result = Optional.ofNullable(healthList).orElseGet(Collections::emptyList).stream().map(scoreDTO -> ClientHealthInternalDTO.toInternalDTO((ClientHealthScoreDTO)scoreDTO)).filter(Objects::nonNull).toList();
        return result;
    }

    public ReportV2SiteHealthScoreDTO a(ReportV2HealthQueryDTO queryDTO) {
        N granularity = N.d((long)queryDTO.getStart(), (long)queryDTO.getEnd());
        DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO = new DeviceHealthScoreQueryDTO(queryDTO.getOmadacId(), queryDTO.getSiteId(), queryDTO.getStart(), queryDTO.getEnd());
        List<SiteHealthDTO> siteHealthList = this.i.a(deviceHealthScoreQueryDTO, granularity);
        if (CollectionUtils.isEmpty(siteHealthList)) {
            return new ReportV2SiteHealthScoreDTO(Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1));
        }
        Integer siteHealthScoreTotal = 0;
        Integer wifiHealthScoreTotal = 0;
        Integer deviceHealthScoreTotal = 0;
        Integer clientHealthScoreTotal = 0;
        Integer wanHealthScoreTotal = 0;
        Integer siteHealthScoreSize = 0;
        Integer wifiHealthScoreSize = 0;
        Integer deviceHealthScoreSize = 0;
        Integer clientHealthScoreSize = 0;
        Integer wanHealthScoreSize = 0;
        for (SiteHealthDTO siteHealthDTO : siteHealthList) {
            if (siteHealthDTO.getScore() != null && siteHealthDTO.getScore() >= 0) {
                siteHealthScoreTotal = siteHealthScoreTotal + siteHealthDTO.getScore();
                siteHealthScoreSize = siteHealthScoreSize + 1;
            }
            if (siteHealthDTO.getWifiHealthScore() != null && siteHealthDTO.getWifiHealthScore() >= 0) {
                wifiHealthScoreTotal = wifiHealthScoreTotal + siteHealthDTO.getWifiHealthScore();
                wifiHealthScoreSize = wifiHealthScoreSize + 1;
            }
            if (siteHealthDTO.getDeviceHealthScore() != null && siteHealthDTO.getDeviceHealthScore() >= 0) {
                deviceHealthScoreTotal = deviceHealthScoreTotal + siteHealthDTO.getDeviceHealthScore();
                deviceHealthScoreSize = deviceHealthScoreSize + 1;
            }
            if (siteHealthDTO.getClientHealthScore() != null && siteHealthDTO.getClientHealthScore() >= 0) {
                clientHealthScoreTotal = clientHealthScoreTotal + siteHealthDTO.getClientHealthScore();
                clientHealthScoreSize = clientHealthScoreSize + 1;
            }
            if (siteHealthDTO.getWanHealthScore() == null || siteHealthDTO.getWanHealthScore() < 0) continue;
            wanHealthScoreTotal = wanHealthScoreTotal + siteHealthDTO.getWanHealthScore();
            wanHealthScoreSize = wanHealthScoreSize + 1;
        }
        Integer siteHealthScoreAvg = -1;
        Integer wifiHealthScoreAvg = -1;
        Integer deviceHealthScoreAvg = -1;
        Integer clientHealthScoreAvg = -1;
        Integer wanHealthScoreAvg = -1;
        if (siteHealthScoreSize != 0) {
            siteHealthScoreAvg = siteHealthScoreTotal / siteHealthScoreSize;
        }
        if (wifiHealthScoreSize != 0) {
            wifiHealthScoreAvg = wifiHealthScoreTotal / wifiHealthScoreSize;
        }
        if (deviceHealthScoreSize != 0) {
            deviceHealthScoreAvg = deviceHealthScoreTotal / deviceHealthScoreSize;
        }
        if (clientHealthScoreSize != 0) {
            clientHealthScoreAvg = clientHealthScoreTotal / clientHealthScoreSize;
        }
        if (wanHealthScoreSize != 0) {
            wanHealthScoreAvg = wanHealthScoreTotal / wanHealthScoreSize;
        }
        return new ReportV2SiteHealthScoreDTO(siteHealthScoreAvg, wifiHealthScoreAvg, deviceHealthScoreAvg, clientHealthScoreAvg, wanHealthScoreAvg);
    }

    public List<ReportV2DeviceHealthTrendDTO> b(ReportV2HealthQueryDTO queryDTO) {
        List<ReportV2DeviceHealthTrendDTO> reportApHealthTrend = this.c(queryDTO);
        List<ReportV2DeviceHealthTrendDTO> reportOswHealthTrend = this.d(queryDTO);
        List<ReportV2DeviceHealthTrendDTO> reportOsgHealthTrend = this.h(queryDTO);
        List<ReportV2DeviceHealthTrendDTO> mergeApAndOsw = this.a(reportApHealthTrend, reportOswHealthTrend);
        List<ReportV2DeviceHealthTrendDTO> mergeApAndOswAndOsg = this.a(mergeApAndOsw, reportOsgHealthTrend);
        return mergeApAndOswAndOsg.stream().sorted(Comparator.comparing(ReportV2DeviceHealthTrendDTO::getTime)).collect(Collectors.toList());
    }

    public List<ReportV2DeviceHealthTrendDTO> c(ReportV2HealthQueryDTO queryDTO) {
        N granularity = N.d((long)queryDTO.getStart(), (long)queryDTO.getEnd());
        DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO = new DeviceHealthScoreQueryDTO(queryDTO.getOmadacId(), queryDTO.getSiteId(), queryDTO.getStart(), queryDTO.getEnd());
        List<ApHealthAggregationDTO> apHealthAggregationList = this.b.b(deviceHealthScoreQueryDTO, granularity);
        List<ReportV2DeviceHealthTrendDTO> collect = apHealthAggregationList.stream().map(dto -> this.a((ApHealthAggregationDTO)dto)).collect(Collectors.toList());
        return collect;
    }

    public List<ReportV2DeviceHealthTrendDTO> d(ReportV2HealthQueryDTO queryDTO) {
        N granularity = N.d((long)queryDTO.getStart(), (long)queryDTO.getEnd());
        DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO = new DeviceHealthScoreQueryDTO(queryDTO.getOmadacId(), queryDTO.getSiteId(), queryDTO.getStart(), queryDTO.getEnd());
        List<OswHealthAggregationDTO> apHealthAggregationList = this.d.b(deviceHealthScoreQueryDTO, granularity);
        List<ReportV2DeviceHealthTrendDTO> collect = apHealthAggregationList.stream().map(dto -> this.a((OswHealthAggregationDTO)dto)).collect(Collectors.toList());
        return collect;
    }

    public List<ReportV2DeviceHealthTrendDTO> h(ReportV2HealthQueryDTO queryDTO) {
        N granularity = N.d((long)queryDTO.getStart(), (long)queryDTO.getEnd());
        DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO = new DeviceHealthScoreQueryDTO(queryDTO.getOmadacId(), queryDTO.getSiteId(), queryDTO.getStart(), queryDTO.getEnd());
        List<OsgHealthScoreDTO> osgHealthList = this.e.a(deviceHealthScoreQueryDTO, granularity);
        ArrayList<ReportV2DeviceHealthTrendDTO> reportV2DeviceHealthTrendDTOS = new ArrayList<ReportV2DeviceHealthTrendDTO>();
        for (OsgHealthScoreDTO osgHealthScoreDTO : osgHealthList) {
            if (!Objects.nonNull(osgHealthScoreDTO) || !Objects.nonNull(osgHealthScoreDTO.getHealthScoreEnum())) continue;
            switch (osgHealthScoreDTO.getHealthScoreEnum()) {
                case a: {
                    reportV2DeviceHealthTrendDTOS.add(new ReportV2DeviceHealthTrendDTO(osgHealthScoreDTO.getTimestamp(), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0)));
                    break;
                }
                case b: {
                    reportV2DeviceHealthTrendDTOS.add(new ReportV2DeviceHealthTrendDTO(osgHealthScoreDTO.getTimestamp(), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0)));
                    break;
                }
                case c: {
                    reportV2DeviceHealthTrendDTOS.add(new ReportV2DeviceHealthTrendDTO(osgHealthScoreDTO.getTimestamp(), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0)));
                    break;
                }
                case d: {
                    reportV2DeviceHealthTrendDTOS.add(new ReportV2DeviceHealthTrendDTO(osgHealthScoreDTO.getTimestamp(), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1)));
                    break;
                }
            }
        }
        return reportV2DeviceHealthTrendDTOS.stream().sorted(Comparator.comparing(ReportV2DeviceHealthTrendDTO::getTime)).collect(Collectors.toList());
    }

    public ReportV2WifiHealthDTO e(ReportV2HealthQueryDTO queryDTO) {
        N granularity = N.d((long)queryDTO.getStart(), (long)queryDTO.getEnd());
        DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO = new DeviceHealthScoreQueryDTO(queryDTO.getOmadacId(), queryDTO.getSiteId(), queryDTO.getStart(), queryDTO.getEnd());
        List<WifiHealthDTO> wifiHealthDTOList = this.h.a(deviceHealthScoreQueryDTO, granularity);
        if (CollectionUtils.isEmpty(wifiHealthDTOList)) {
            return new ReportV2WifiHealthDTO(Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1));
        }
        Integer accessTimeScoreTotal = 0;
        Integer channelUtilScoreTotal = 0;
        Integer channelInterUtilScoreTotal = 0;
        Integer accessCapacityScoreTotal = 0;
        Integer rssiScoreTotal = 0;
        Integer accessTimeScoreSize = 0;
        Integer channelUtilScoreSize = 0;
        Integer channelInterUtilScoreSize = 0;
        Integer accessCapacityScoreSize = 0;
        Integer rssiScoreSize = 0;
        for (WifiHealthDTO wifiHealthDTO : wifiHealthDTOList) {
            if (wifiHealthDTO.getAccessTimeScore() != null && wifiHealthDTO.getAccessTimeScore() > 0) {
                accessTimeScoreTotal = accessTimeScoreTotal + wifiHealthDTO.getAccessTimeScore();
                accessTimeScoreSize = accessTimeScoreSize + 1;
            }
            if (wifiHealthDTO.getChannelUtilScore() != null && wifiHealthDTO.getChannelUtilScore() > 0) {
                channelUtilScoreTotal = channelUtilScoreTotal + wifiHealthDTO.getChannelUtilScore();
                channelUtilScoreSize = channelUtilScoreSize + 1;
            }
            if (wifiHealthDTO.getInterUtilScore() != null && wifiHealthDTO.getInterUtilScore() > 0) {
                channelInterUtilScoreTotal = channelInterUtilScoreTotal + wifiHealthDTO.getInterUtilScore();
                channelInterUtilScoreSize = channelInterUtilScoreSize + 1;
            }
            if (wifiHealthDTO.getAccessCapacityScore() != null && wifiHealthDTO.getAccessCapacityScore() > 0) {
                accessCapacityScoreTotal = accessCapacityScoreTotal + wifiHealthDTO.getAccessCapacityScore();
                accessCapacityScoreSize = accessCapacityScoreSize + 1;
            }
            if (wifiHealthDTO.getRssiScore() == null || wifiHealthDTO.getRssiScore() <= 0) continue;
            rssiScoreTotal = rssiScoreTotal + wifiHealthDTO.getRssiScore();
            rssiScoreSize = rssiScoreSize + 1;
        }
        Integer accessTimeScoreAvg = -1;
        if (accessTimeScoreSize != 0) {
            accessTimeScoreAvg = accessTimeScoreTotal / accessTimeScoreSize;
        }
        Integer channelUtilScoreAvg = -1;
        if (channelUtilScoreSize != 0) {
            channelUtilScoreAvg = channelUtilScoreTotal / channelUtilScoreSize;
        }
        Integer channelInterUtilScoreAvg = -1;
        if (channelInterUtilScoreSize != 0) {
            channelInterUtilScoreAvg = channelInterUtilScoreTotal / channelInterUtilScoreSize;
        }
        Integer accessCapacityScoreAvg = -1;
        if (accessCapacityScoreSize != 0) {
            accessCapacityScoreAvg = accessCapacityScoreTotal / accessCapacityScoreSize;
        }
        Integer rssiScoreAvg = -1;
        if (rssiScoreSize != 0) {
            rssiScoreAvg = rssiScoreTotal / rssiScoreSize;
        }
        return new ReportV2WifiHealthDTO(accessTimeScoreAvg, channelUtilScoreAvg, channelInterUtilScoreAvg, accessCapacityScoreAvg, rssiScoreAvg);
    }

    public List<ReportV2DeviceHealthTrendDTO> f(ReportV2HealthQueryDTO queryDTO) {
        N granularity = N.d((long)queryDTO.getStart(), (long)queryDTO.getEnd());
        DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO = new DeviceHealthScoreQueryDTO(queryDTO.getOmadacId(), queryDTO.getSiteId(), queryDTO.getStart(), queryDTO.getEnd());
        List<ClientHealthAggregationDTO> clientHealthAggregationList = this.c.b(deviceHealthScoreQueryDTO, granularity);
        List<ReportV2DeviceHealthTrendDTO> collect = clientHealthAggregationList.stream().map(dto -> this.a((ClientHealthAggregationDTO)dto)).collect(Collectors.toList());
        return collect;
    }

    public List<WanHealthLevelDTO> g(ReportV2HealthQueryDTO queryDTO) {
        a.info("WanHealthTrendCardService, getReportWanHealthTrend for omadacId {}, siteId {}, query {}", new Object[]{queryDTO.getOmadacId(), queryDTO.getSiteId(), queryDTO});
        N granularity = N.d((long)queryDTO.getStart(), (long)queryDTO.getEnd());
        DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO = new DeviceHealthScoreQueryDTO(queryDTO.getOmadacId(), queryDTO.getSiteId(), queryDTO.getStart(), queryDTO.getEnd());
        a.info("WanHealthTrendCardService, getReportWanHealthTrend for omadacId {}, siteId {}, deviceHealthScoreQueryDTO {}", new Object[]{queryDTO.getOmadacId(), queryDTO.getSiteId(), deviceHealthScoreQueryDTO});
        List<WanHealthLevelDTO> wanHealthList = this.f.a(deviceHealthScoreQueryDTO, granularity);
        a.info("WanHealthTrendCardService, getReportWanHealthTrend for omadacId {}, siteId {}, wanHealthList {}", new Object[]{queryDTO.getOmadacId(), queryDTO.getSiteId(), wanHealthList});
        return wanHealthList;
    }

    public List<SiteHealthDTO> a(SiteHealthQueryDTO queryDTO) {
        return this.i.a(queryDTO, N.b);
    }

    private Integer b(DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO) {
        List<ApHealthScoreDTO> apHealthList = this.b.a(deviceHealthScoreQueryDTO, N.b);
        if (apHealthList.isEmpty()) {
            return -1;
        }
        ApHealthScoreDTO lastOne = apHealthList.get(apHealthList.size() - 1);
        return Objects.isNull(lastOne.getScore()) ? -1 : lastOne.getScore();
    }

    private Integer c(DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO) {
        List<OswHealthScoreDTO> oswHealthList = this.d.a(deviceHealthScoreQueryDTO, N.b);
        if (oswHealthList.isEmpty()) {
            return -1;
        }
        OswHealthScoreDTO lastOne = oswHealthList.get(oswHealthList.size() - 1);
        return Objects.isNull(lastOne.getScore()) ? -1 : lastOne.getScore();
    }

    private Integer d(DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO) {
        List<OsgHealthScoreDTO> osgHealthList = this.e.a(deviceHealthScoreQueryDTO, N.b);
        if (osgHealthList.isEmpty()) {
            return -1;
        }
        OsgHealthScoreDTO lastOne = osgHealthList.get(osgHealthList.size() - 1);
        return Objects.isNull(lastOne.getScore()) ? -1 : lastOne.getScore();
    }

    private Integer e(DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO) {
        List<ClientHealthScoreDTO> healthList = this.c.a(deviceHealthScoreQueryDTO, N.b);
        if (healthList.isEmpty()) {
            return -1;
        }
        ClientHealthScoreDTO lastOne = healthList.get(healthList.size() - 1);
        return Objects.isNull(lastOne.getScore()) ? -1 : lastOne.getScore();
    }

    private ClientHealthScoreDTO f(DeviceHealthScoreQueryDTO deviceHealthScoreQueryDTO) {
        List<ClientHealthScoreDTO> healthList = this.c.a(deviceHealthScoreQueryDTO, N.b);
        a.debug("getClientScoreDTO query is {}, scoreList is {}", (Object)deviceHealthScoreQueryDTO, (Object)x.a(healthList));
        return CollectionUtils.isEmpty(healthList) ? null : healthList.get(healthList.size() - 1);
    }

    private ReportV2DeviceHealthTrendDTO a(ApHealthAggregationDTO dto) {
        ReportV2DeviceHealthTrendDTO reportV2DeviceHealthTrendDTO = new ReportV2DeviceHealthTrendDTO(dto.getTimestamp(), dto.getTotalCount(), dto.getGoodCount(), dto.getFairCount(), dto.getPoorCount(), dto.getNodataCount());
        return reportV2DeviceHealthTrendDTO;
    }

    private ReportV2DeviceHealthTrendDTO a(OswHealthAggregationDTO dto) {
        ReportV2DeviceHealthTrendDTO reportV2DeviceHealthTrendDTO = new ReportV2DeviceHealthTrendDTO(dto.getTimestamp(), dto.getTotalCount(), dto.getGoodCount(), dto.getFairCount(), dto.getPoorCount(), dto.getNodataCount());
        return reportV2DeviceHealthTrendDTO;
    }

    private ReportV2DeviceHealthTrendDTO a(ClientHealthAggregationDTO dto) {
        Integer goodCount = dto.getWiredGood() + dto.getWirelessGood();
        Integer fairCount = dto.getWiredFair() + dto.getWirelessFair();
        Integer poorCount = dto.getWiredPoor() + dto.getWirelessPoor();
        Integer noDataCount = dto.getWiredNoData() + dto.getWirelessNoData();
        Integer count = goodCount + fairCount + poorCount + noDataCount;
        ReportV2DeviceHealthTrendDTO reportV2DeviceHealthTrendDTO = new ReportV2DeviceHealthTrendDTO(dto.getTime(), count, goodCount, fairCount, poorCount, noDataCount);
        return reportV2DeviceHealthTrendDTO;
    }

    private List<ReportV2DeviceHealthTrendDTO> a(List<ReportV2DeviceHealthTrendDTO> list1, List<ReportV2DeviceHealthTrendDTO> list2) {
        ArrayList<ReportV2DeviceHealthTrendDTO> list = new ArrayList<ReportV2DeviceHealthTrendDTO>();
        list.addAll(list1);
        list.addAll(list2);
        List<ReportV2DeviceHealthTrendDTO> result = list.stream().collect(Collectors.toMap(ReportV2DeviceHealthTrendDTO::getTime, a2 -> a2, (o1, o2) -> {
            o1.setTotal(Integer.valueOf(o1.getTotal() + o2.getTotal()));
            o1.setGood(Integer.valueOf(o1.getGood() + o2.getGood()));
            o1.setAverage(Integer.valueOf(o1.getAverage() + o2.getAverage()));
            o1.setPoor(Integer.valueOf(o1.getPoor() + o2.getPoor()));
            o1.setNoData(Integer.valueOf(o1.getNoData() + o2.getNoData()));
            return o1;
        })).values().stream().collect(Collectors.toList());
        return result;
    }
}

