/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.b.a;

import com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.WanHealthLevelDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.WanMarkDTO;
import com.tplink.smb.omada.anomaly.api.e.a;
import com.tplink.smb.omada.anomaly.core.b.a.d;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.util.CollectionUtils;

public class h {
    private static final Logger a = LoggerFactory.getLogger(h.class);

    private h() {
    }

    public static WanHealthLevelDTO a(WanMarkDTO wanMarkDTO, long time, boolean ippt) {
        if (Objects.isNull(wanMarkDTO)) {
            return null;
        }
        Map portStatusMap = wanMarkDTO.getPortStatusMap();
        Map periodWanDataMap = wanMarkDTO.getPeriodWanDataMap();
        Map latencyMap = wanMarkDTO.getLatencyMap();
        HashMap healthMap = new HashMap(8);
        HashMap nameMap = new HashMap(8);
        portStatusMap.forEach((port, portStatus) -> {
            List<Integer> latencyList = latencyMap.getOrDefault(port, Collections.emptyList());
            int latencyAvg = d.a(latencyList);
            int jitterAvg = h.b(latencyList);
            if (periodWanDataMap.containsKey(port)) {
                com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a periodWanData = (com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a)periodWanDataMap.get(port);
                nameMap.put(port, periodWanData.b());
                if (Objects.equals(portStatus, 6)) {
                    h.a(port, (Integer)latencyAvg, (Integer)jitterAvg, (Map<Integer, Integer>)healthMap, periodWanData);
                } else {
                    healthMap.put(port, portStatus);
                }
            }
        });
        WanHealthLevelDTO wanHealthLevelDTO = new WanHealthLevelDTO(wanMarkDTO.getOmadacId(), wanMarkDTO.getSiteId(), wanMarkDTO.getMac(), Long.valueOf(time), nameMap, healthMap);
        wanHealthLevelDTO.setIppt(Boolean.valueOf(ippt));
        return wanHealthLevelDTO;
    }

    public static WanHealthLevelDTO a(WanMarkDTO wanMarkDTO, long time, boolean useLoadBalance, boolean ippt) {
        if (Objects.isNull(wanMarkDTO)) {
            return null;
        }
        Map portStatusMap = wanMarkDTO.getPortStatusMap();
        Map periodWanDataMap = wanMarkDTO.getPeriodWanDataMap();
        Map latencyMap = wanMarkDTO.getLatencyMap();
        Map throughputMap = wanMarkDTO.getThroughputMap();
        HashMap healthMap = new HashMap(8);
        HashMap wanHealthInfoMap = new HashMap();
        HashMap nameMap = new HashMap(8);
        portStatusMap.forEach((port, portStatus) -> {
            List<Integer> latencyList = latencyMap.getOrDefault(port, Collections.emptyList());
            int latencyAvg = d.a(latencyList);
            List<Long> throughputList = throughputMap.getOrDefault(port, Collections.emptyList());
            Integer throughputAvg = h.a(throughputList);
            if (periodWanDataMap.containsKey(port)) {
                com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a periodWanData = (com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a)periodWanDataMap.get(port);
                nameMap.put(port, periodWanData.b());
                if (Objects.equals(portStatus, 6)) {
                    h.a(wanHealthInfoMap, port, (Integer)latencyAvg, (Map<Integer, Integer>)healthMap, throughputAvg);
                } else {
                    healthMap.put(port, portStatus);
                }
            }
        });
        Pair<Integer, Integer> pair = d.a(wanMarkDTO.getPortWeight(), wanMarkDTO.getLatencyMap(), useLoadBalance);
        Integer multiWanLatency = (Integer)pair.getFirst();
        Integer multiWanScore = (Integer)pair.getSecond();
        WanHealthLevelDTO wanHealthLevelDTO = new WanHealthLevelDTO();
        wanHealthLevelDTO.setOmadacId(wanMarkDTO.getOmadacId());
        wanHealthLevelDTO.setSiteId(wanMarkDTO.getSiteId());
        wanHealthLevelDTO.setMac(wanMarkDTO.getMac());
        wanHealthLevelDTO.setTimestamp(Long.valueOf(time));
        wanHealthLevelDTO.setScore(multiWanScore);
        wanHealthLevelDTO.setLatency(multiWanLatency);
        wanHealthLevelDTO.setNameMap(nameMap);
        wanHealthLevelDTO.setHealthMap(healthMap);
        wanHealthLevelDTO.setInfoMap(wanHealthInfoMap);
        wanHealthLevelDTO.setIppt(Boolean.valueOf(ippt));
        com.tplink.smb.omada.anomaly.api.e.a.a((Logger)a, (String)"calculateWanHealthLevelV2, omadacId: {}, siteId: {}, wanHealthLevelDTO:{}", (Object[])new Object[]{wanMarkDTO.getOmadacId(), wanMarkDTO.getSiteId(), wanHealthLevelDTO});
        return wanHealthLevelDTO;
    }

    private static Integer a(List<Long> throughputList) {
        if (CollectionUtils.isEmpty(throughputList)) {
            return null;
        }
        try {
            int total = throughputList.stream().filter(Objects::nonNull).mapToInt(Math::toIntExact).sum();
            return Math.round((float)total / (float)throughputList.size());
        }
        catch (Exception e2) {
            a.warn("Failed to trans throughput value.", (Throwable)e2);
            return null;
        }
    }

    private static int b(List<Integer> latencyList) {
        if (latencyList.size() <= 1) {
            return 0;
        }
        ArrayList<Integer> jitterList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < latencyList.size() - 1; ++i2) {
            jitterList.add(Math.abs(latencyList.get(i2) - latencyList.get(i2 + 1)));
        }
        return d.a(jitterList);
    }

    private static void a(Integer port, Integer latency, Integer jitter, Map<Integer, Integer> healthMap, com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a periodWanData) {
        if (periodWanData.d() > 0L) {
            double loss = 1.0 * (double)periodWanData.c() / (double)periodWanData.d() * 100.0;
            if ((loss = Double.parseDouble(String.format(Locale.ROOT, "%.1f", loss))) > 2.0 || latency > 400 || jitter > 400) {
                healthMap.put(port, 2);
            } else if (loss > 0.5 || latency > 200 || jitter > 200) {
                healthMap.put(port, 1);
            } else {
                healthMap.put(port, 0);
            }
        } else {
            healthMap.put(port, 3);
        }
    }

    private static void a(Map<Integer, WanHealthLevelDTO.WanHealthInfoDTO> wanHealthInfoMap, Integer port, Integer latency, Map<Integer, Integer> healthMap, Integer throughputAvg) {
        WanHealthLevelDTO.WanHealthInfoDTO wanHealthInfoDTO = new WanHealthLevelDTO.WanHealthInfoDTO();
        Integer score = 0;
        if (latency > 400) {
            score = 1;
            healthMap.put(port, 2);
        } else if (latency > 200) {
            score = 4;
            healthMap.put(port, 1);
        } else {
            score = 10;
            healthMap.put(port, 0);
        }
        wanHealthInfoDTO.setLatency(latency);
        wanHealthInfoDTO.setThroughput(throughputAvg);
        wanHealthInfoDTO.setScore(score);
        wanHealthInfoMap.put(port, wanHealthInfoDTO);
    }

    public static WanHealthLevelDTO a(String omadacId, String siteId, String mac, Long timeStamp, List<WanHealthLevelDTO> dtoList) {
        HashMap<Integer, Integer> wanGoodMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> wanFairMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> wanPoorMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> wanNodataMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> wanOfflineMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> wanDisableMap = new HashMap<Integer, Integer>();
        HashSet<Integer> existDataPort = new HashSet<Integer>();
        HashMap nameMap = new HashMap();
        dtoList.forEach(wanHealthLevelDTO -> {
            wanHealthLevelDTO.getNameMap().forEach((port, name) -> {
                if (!nameMap.containsKey(port)) {
                    nameMap.put(port, name);
                }
            });
            wanHealthLevelDTO.getHealthMap().forEach((port, portStatus) -> {
                existDataPort.add((Integer)port);
                switch (portStatus) {
                    case 0: {
                        wanGoodMap.put((Integer)port, wanGoodMap.getOrDefault(port, 0) + 1);
                        break;
                    }
                    case 1: {
                        wanFairMap.put((Integer)port, wanFairMap.getOrDefault(port, 0) + 1);
                        break;
                    }
                    case 2: {
                        wanPoorMap.put((Integer)port, wanPoorMap.getOrDefault(port, 0) + 1);
                        break;
                    }
                    case 3: {
                        wanNodataMap.put((Integer)port, 1);
                        break;
                    }
                    case 4: {
                        wanOfflineMap.put((Integer)port, 1);
                        break;
                    }
                    case 5: {
                        wanDisableMap.put((Integer)port, 1);
                        break;
                    }
                }
            });
        });
        Map<Integer, Integer> healthMap = h.a(wanGoodMap, wanFairMap, wanPoorMap, wanNodataMap, wanOfflineMap, wanDisableMap, existDataPort);
        return new WanHealthLevelDTO(omadacId, siteId, mac, timeStamp, nameMap, healthMap);
    }

    public static WanHealthLevelDTO b(String omadacId, String siteId, String mac, Long timeStamp, List<WanHealthLevelDTO> dtoList) {
        WanHealthLevelDTO wanHealthLevelDTO = new WanHealthLevelDTO();
        wanHealthLevelDTO.setOmadacId(omadacId);
        wanHealthLevelDTO.setSiteId(siteId);
        wanHealthLevelDTO.setMac(mac);
        wanHealthLevelDTO.setTimestamp(timeStamp);
        HashMap<Integer, WanHealthLevelDTO.WanHealthInfoDTO> wanHealthScoreMap = new HashMap<Integer, WanHealthLevelDTO.WanHealthInfoDTO>();
        HashMap nameMap = new HashMap();
        for (WanHealthLevelDTO healthLevelDTO : dtoList) {
            healthLevelDTO.getNameMap().forEach((port, name) -> {
                if (!nameMap.containsKey(port)) {
                    nameMap.put(port, name);
                }
            });
            Map infoMap = healthLevelDTO.getInfoMap();
            for (Map.Entry entry : infoMap.entrySet()) {
                Integer portId = (Integer)entry.getKey();
                Integer score = ((WanHealthLevelDTO.WanHealthInfoDTO)entry.getValue()).getScore();
                WanHealthLevelDTO.WanHealthInfoDTO wanHealthInfoDTO = wanHealthScoreMap.getOrDefault(portId, new WanHealthLevelDTO.WanHealthInfoDTO());
                Integer oldScore = wanHealthInfoDTO.getScore();
                if (Objects.isNull(oldScore)) {
                    wanHealthInfoDTO.setScore(score);
                    wanHealthScoreMap.put(portId, wanHealthInfoDTO);
                    continue;
                }
                wanHealthInfoDTO.setScore(Integer.valueOf(d.b(score, oldScore)));
                wanHealthScoreMap.put(portId, wanHealthInfoDTO);
            }
            if (!Boolean.TRUE.equals(healthLevelDTO.getIppt())) continue;
            wanHealthLevelDTO.setIppt(Boolean.valueOf(true));
        }
        wanHealthLevelDTO.setNameMap(nameMap);
        wanHealthLevelDTO.setInfoMap(wanHealthScoreMap);
        return wanHealthLevelDTO;
    }

    private static Map<Integer, Integer> a(Map<Integer, Integer> wanGoodMap, Map<Integer, Integer> wanFairMap, Map<Integer, Integer> wanPoorMap, Map<Integer, Integer> wanNodataMap, Map<Integer, Integer> wanOfflineMap, Map<Integer, Integer> wanDisableMap, Set<Integer> existDataPort) {
        HashMap<Integer, Integer> healthMap = new HashMap<Integer, Integer>();
        for (int port : existDataPort) {
            int goodCount = wanGoodMap.getOrDefault(port, 0);
            int fairCount = wanFairMap.getOrDefault(port, 0);
            int poorCount = wanPoorMap.getOrDefault(port, 0);
            if (poorCount >= goodCount && poorCount >= fairCount && poorCount > 0) {
                healthMap.put(port, 2);
                continue;
            }
            if (fairCount >= goodCount && fairCount > poorCount) {
                healthMap.put(port, 1);
                continue;
            }
            if (goodCount > fairCount && goodCount > poorCount) {
                healthMap.put(port, 0);
                continue;
            }
            if (wanNodataMap.containsKey(port) && wanNodataMap.get(port) == 1) {
                healthMap.put(port, 3);
                continue;
            }
            if (wanOfflineMap.containsKey(port) && wanOfflineMap.get(port) == 1) {
                healthMap.put(port, 4);
                continue;
            }
            if (!wanDisableMap.containsKey(port) || wanDisableMap.get(port) != 1) continue;
            healthMap.put(port, 5);
        }
        return healthMap;
    }
}

