/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.core.a.a;

import com.tplink.smb.omada.anomaly.api.b.G;
import com.tplink.smb.omada.anomaly.api.b.r;
import com.tplink.smb.omada.anomaly.api.dto.health.ClientHealthSnapshotQueryDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.DeviceHealthDetailQueryDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.DeviceHealthScoreQueryDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.ap.ApHealthAggregationDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.ap.ApHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.ap.ApWifiHealthVO;
import com.tplink.smb.omada.anomaly.api.dto.health.ap.DeviceHealthSnapshotInfoVO;
import com.tplink.smb.omada.anomaly.api.dto.health.ap.DeviceHealthVO;
import com.tplink.smb.omada.anomaly.api.dto.health.ap.DevicesHealthCount;
import com.tplink.smb.omada.anomaly.api.dto.health.ap.DevicesHealthStatusVO;
import com.tplink.smb.omada.anomaly.api.dto.health.client.ClientHealthRateStatVO;
import com.tplink.smb.omada.anomaly.api.dto.health.client.ClientHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.client.ClientHealthStatusStatDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.client.ClientSnapShopVO;
import com.tplink.smb.omada.anomaly.api.dto.health.client.ClientSnapShotEntryDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.OsgHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.WanHealthLevelDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.WanHealthVO;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.WanHistoryHealthVO;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.WanRealTimeHealthVO;
import com.tplink.smb.omada.anomaly.api.dto.health.osw.OswHealthAggregationDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osw.OswHealthScoreDTO;
import com.tplink.smb.omada.anomaly.core.a.a.b;
import com.tplink.smb.omada.anomaly.core.domain.a.a.k;
import com.tplink.smb.omada.anomaly.core.domain.a.e;
import com.tplink.smb.omada.client.api.internal.dto.ApConnectStatQueryDTO;
import com.tplink.smb.omada.client.api.internal.dto.ApConnectStatResultDTO;
import com.tplink.smb.omada.client.api.internal.dto.ClientHealthStatDTO;
import com.tplink.smb.omada.client.api.internal.dto.ClientHealthStatInternalQueryDTO;
import com.tplink.smb.omada.client.api.internal.dto.ClientHealthStatInternalResultDTO;
import com.tplink.smb.omada.client.api.internal.dto.clienthealth.ClientHealthIndexDTO;
import com.tplink.smb.omada.client.api.internal.dto.clienthealth.ClientHealthInternalSnapshotQueryDTO;
import com.tplink.smb.omada.client.api.internal.dto.clienthealth.ClientHealthSnapshotResultDTO;
import com.tplink.smb.omada.client.api.internal.g;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.gridquery.QueryDataVO;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.DeviceObjectDTO;
import com.tplink.smb.omada.insight.api.web.health.dto.HealthQueryVO;
import com.tplink.smb.omada.insight.api.web.health.vo.ClientHealthScoreVO;
import com.tplink.smb.omada.insight.api.web.health.vo.ClientHealthSnapshotGridVO;
import com.tplink.smb.omada.insight.api.web.health.vo.ClientHealthSnapshotVO;
import com.tplink.smb.omada.monitor.api.internal.statistic.dto.ApHealthStatDTO;
import com.tplink.smb.omada.monitor.api.internal.statistic.dto.OsgHealthStatDTO;
import com.tplink.smb.omada.monitor.api.internal.statistic.dto.OswHealthStatDTO;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class c
implements b {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(c.class);
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a.a b;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a.g c;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a.c d;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.a.a.e e;
    @Autowired
    private com.tplink.smb.omada.client.api.internal.c f;
    @Autowired
    private g g;
    @Autowired
    private com.tplink.smb.omada.monitor.api.internal.statistic.a h;
    @Autowired
    private k i;
    @Autowired
    private e j;
    @Autowired
    private com.tplink.smb.omada.anomaly.core.domain.model.rule.a.a k;

    @Override
    public OperationResponse a(String omadacId, String siteId, String mac, String type, HealthQueryVO healthQueryVO, N granularity) {
        return this.c(omadacId, siteId, mac, type, healthQueryVO, granularity);
    }

    @Override
    public OperationResponse b(String omadacId, String siteId, String mac, String type, HealthQueryVO healthQueryVO, N granularity) {
        return this.c(omadacId, siteId, mac, type, healthQueryVO, granularity);
    }

    private OperationResponse c(String omadacId, String siteId, String mac, String type, HealthQueryVO healthQueryVO, N granularity) {
        List<DeviceHealthVO> list;
        DeviceTypeEnum deviceTypeEnum = DeviceTypeEnum.b((String)type);
        if (Objects.isNull(deviceTypeEnum)) {
            a.info("invalid device type {}", (Object)type);
            return OperationResponse.PARAM_ERROR;
        }
        DeviceHealthScoreQueryDTO query = new DeviceHealthScoreQueryDTO(omadacId, siteId, mac, healthQueryVO.getStart(), healthQueryVO.getEnd());
        switch (deviceTypeEnum) {
            case a: {
                list = this.b(query, granularity);
                break;
            }
            case c: {
                list = this.a(query, granularity);
                break;
            }
            case b: {
                list = this.d(query, granularity);
                break;
            }
            case d: {
                a.info("olts do not support health.");
                return OperationResponse.success(Collections.emptyList());
            }
            default: {
                a.info("unsupported device type {}", (Object)deviceTypeEnum);
                return OperationResponse.PARAM_ERROR;
            }
        }
        TreeMap<Long, DeviceHealthVO> deviceHealthVOMap = list.stream().collect(Collectors.toMap(DeviceHealthVO::getTime, v2 -> v2, (v1, v2) -> v2, TreeMap::new));
        if (CollectionUtils.isEmpty((Map)deviceHealthVOMap)) {
            deviceHealthVOMap = new TreeMap<Long, DeviceHealthVO>();
        }
        switch (granularity) {
            case b: {
                long start = (healthQueryVO.getStart() / 600L + 1L) * 600L;
                long end = (healthQueryVO.getEnd() / 600L - 1L) * 600L;
                this.a(start, deviceHealthVOMap, end, 600L);
                break;
            }
            case c: {
                long start = (healthQueryVO.getStart() / 3600L + 1L) * 3600L;
                long end = (healthQueryVO.getEnd() / 3600L - 1L) * 3600L;
                this.a(start, deviceHealthVOMap, end, 3600L);
                break;
            }
            case d: {
                long days = (healthQueryVO.getEnd() - healthQueryVO.getStart()) / 86400L;
                if (deviceHealthVOMap.isEmpty()) break;
                long queryEndTime = ((DeviceHealthVO)new ArrayList(deviceHealthVOMap.values()).get(deviceHealthVOMap.size() - 1)).getTime();
                long noDataDay = (query.getEnd() - queryEndTime) / 86400L;
                long end = noDataDay > 0L ? queryEndTime + noDataDay * 86400L : queryEndTime;
                long start = end - 86400L * days;
                this.a(start, deviceHealthVOMap, end, 86400L);
                a.debug("daily request start:{}, end:{}", (Object)start, (Object)end);
                break;
            }
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, new ArrayList(deviceHealthVOMap.values()));
    }

    private void a(long start, Map<Long, DeviceHealthVO> deviceHealthVOMap, long end, long timeRange) {
        for (long time = start; time <= end; time += timeRange) {
            long finalTime = time;
            deviceHealthVOMap.computeIfAbsent(time, key -> new DeviceHealthVO(Long.valueOf(finalTime), Integer.valueOf(-1)));
        }
    }

    @Override
    public OperationResponse a(String omadacId, String siteId, HealthQueryVO healthQueryVO, N granularity) {
        DeviceHealthScoreQueryDTO query = new DeviceHealthScoreQueryDTO(omadacId, siteId, healthQueryVO.getStart(), healthQueryVO.getEnd());
        long defaultTime = System.currentTimeMillis() / 1000L / 600L * 600L;
        if (Objects.equals(granularity, N.b)) {
            query.setStart(Long.valueOf(query.getStart() - 600L));
        }
        List<ApHealthAggregationDTO> apHealthAggDTOS = this.b.b(query, granularity);
        TreeMap<Long, DevicesHealthStatusVO> voTreeMap = new TreeMap<Long, DevicesHealthStatusVO>();
        long timeUnit = this.b(granularity);
        long start = (healthQueryVO.getStart() / timeUnit + 1L) * timeUnit;
        long end = (healthQueryVO.getEnd() / timeUnit - 1L) * timeUnit;
        this.a(omadacId, siteId, granularity, defaultTime, apHealthAggDTOS, voTreeMap);
        this.b(omadacId, siteId, granularity, query, defaultTime, voTreeMap);
        this.a(omadacId, siteId, granularity, query, defaultTime, voTreeMap);
        voTreeMap.values().forEach(DevicesHealthStatusVO::calculateHealthRate);
        if (granularity == N.d) {
            long days = (healthQueryVO.getEnd() - healthQueryVO.getStart()) / 86400L - 1L;
            if (!voTreeMap.isEmpty()) {
                long queryEndTime = new ArrayList<DevicesHealthStatusVO>(voTreeMap.values()).get(voTreeMap.size() - 1).getTime();
                long noDataDay = (query.getEnd() - queryEndTime) / 86400L;
                end = noDataDay > 0L ? queryEndTime + noDataDay * 86400L : queryEndTime;
                for (long time = start = end - 86400L * days; time <= end; time += 86400L) {
                    long finalTime = time;
                    voTreeMap.computeIfAbsent(time, key -> new DevicesHealthStatusVO(Long.valueOf(finalTime)));
                }
                a.debug("daily request start:{}, end:{}", (Object)start, (Object)end);
            }
        } else {
            for (long i2 = start; i2 <= end; i2 += timeUnit) {
                voTreeMap.putIfAbsent(i2, new DevicesHealthStatusVO(Long.valueOf(i2)));
            }
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, new ArrayList<DevicesHealthStatusVO>(voTreeMap.values()));
    }

    private void a(String omadacId, String siteId, N granularity, DeviceHealthScoreQueryDTO query, long defaultTime, TreeMap<Long, DevicesHealthStatusVO> voTreeMap) {
        List<OsgHealthScoreDTO> osgHealthScoreDTOS = this.e.a(query, granularity);
        if (CollectionUtils.isEmpty(osgHealthScoreDTOS) && Objects.equals(granularity, N.b)) {
            Integer osgDevices = this.e.b(omadacId, siteId);
            this.a(osgDevices, voTreeMap, defaultTime);
        } else {
            osgHealthScoreDTOS.forEach(osgHealthScoreDTO -> {
                DevicesHealthStatusVO vo = !voTreeMap.containsKey(osgHealthScoreDTO.getTimestamp()) ? new DevicesHealthStatusVO(osgHealthScoreDTO.getTimestamp(), Integer.valueOf(0), Integer.valueOf(0)) : (DevicesHealthStatusVO)voTreeMap.get(osgHealthScoreDTO.getTimestamp());
                if (Objects.equals(r.a((int)osgHealthScoreDTO.getScore()), r.a)) {
                    vo.addCount(Integer.valueOf(1), Integer.valueOf(1));
                } else {
                    vo.addCount(Integer.valueOf(0), Integer.valueOf(1));
                }
                vo.setGatewayHealth(osgHealthScoreDTO.getScore());
                vo.mergeAnomalyInfo(osgHealthScoreDTO.getHighestAnomalyLevel(), osgHealthScoreDTO.getAnomalyCount());
                voTreeMap.put(osgHealthScoreDTO.getTimestamp(), vo);
            });
        }
    }

    private void a(Integer osgDevices, TreeMap<Long, DevicesHealthStatusVO> voTreeMap, long defaultTime) {
        if (!Objects.equals(osgDevices, 0)) {
            DevicesHealthStatusVO vo = voTreeMap.get(defaultTime);
            if (Objects.isNull(vo)) {
                vo = new DevicesHealthStatusVO(Long.valueOf(defaultTime), Integer.valueOf(0), Integer.valueOf(0));
            }
            vo.setGatewayHealth(Integer.valueOf(-1));
            vo.addCount(Integer.valueOf(0), Integer.valueOf(1));
            voTreeMap.put(defaultTime, vo);
        }
    }

    private void b(String omadacId, String siteId, N granularity, DeviceHealthScoreQueryDTO query, long defaultTime, TreeMap<Long, DevicesHealthStatusVO> voTreeMap) {
        List<OswHealthAggregationDTO> oswHealthAggDTOS = this.c.b(query, granularity);
        if (CollectionUtils.isEmpty(oswHealthAggDTOS) && Objects.equals(granularity, N.b)) {
            Integer oswDevices = this.c.b(omadacId, siteId);
            if (!Objects.equals(oswDevices, 0)) {
                DevicesHealthStatusVO vo = voTreeMap.get(defaultTime);
                if (Objects.isNull(vo)) {
                    vo = new DevicesHealthStatusVO(Long.valueOf(defaultTime), Integer.valueOf(0), Integer.valueOf(0));
                }
                DevicesHealthCount devicesHealthCount = new DevicesHealthCount();
                devicesHealthCount.setGood(Integer.valueOf(0));
                devicesHealthCount.setFair(Integer.valueOf(0));
                devicesHealthCount.setPoor(Integer.valueOf(0));
                devicesHealthCount.setNoData(oswDevices);
                vo.setSwitchHealth(devicesHealthCount);
                vo.addCount(Integer.valueOf(0), oswDevices);
                voTreeMap.put(defaultTime, vo);
            }
        } else {
            oswHealthAggDTOS.forEach(oswHealthAggregationDTO -> {
                DevicesHealthStatusVO vo = !voTreeMap.containsKey(oswHealthAggregationDTO.getTimestamp()) ? new DevicesHealthStatusVO(oswHealthAggregationDTO.getTimestamp(), Integer.valueOf(0), Integer.valueOf(0)) : (DevicesHealthStatusVO)voTreeMap.get(oswHealthAggregationDTO.getTimestamp());
                DevicesHealthCount devicesHealthCount = new DevicesHealthCount();
                devicesHealthCount.setGood(oswHealthAggregationDTO.getGoodCount());
                devicesHealthCount.setFair(oswHealthAggregationDTO.getFairCount());
                devicesHealthCount.setPoor(oswHealthAggregationDTO.getPoorCount());
                devicesHealthCount.setNoData(oswHealthAggregationDTO.getNodataCount());
                vo.setSwitchHealth(devicesHealthCount);
                vo.addCount(oswHealthAggregationDTO.getGoodCount(), oswHealthAggregationDTO.getTotalCount());
                vo.mergeAnomalyInfo(oswHealthAggregationDTO.getHighestAnomalyLevel(), oswHealthAggregationDTO.getAnomalyCount());
                voTreeMap.put(oswHealthAggregationDTO.getTimestamp(), vo);
            });
        }
    }

    private void a(String omadacId, String siteId, N granularity, long defaultTime, List<ApHealthAggregationDTO> apHealthAggDTOS, TreeMap<Long, DevicesHealthStatusVO> voTreeMap) {
        if (CollectionUtils.isEmpty(apHealthAggDTOS) && Objects.equals(granularity, N.b)) {
            Integer apDevices = this.b.b(omadacId, siteId);
            if (!Objects.equals(apDevices, 0)) {
                DevicesHealthStatusVO vo = new DevicesHealthStatusVO(Long.valueOf(defaultTime), Integer.valueOf(0), Integer.valueOf(0));
                DevicesHealthCount devicesHealthCount = new DevicesHealthCount();
                devicesHealthCount.setGood(Integer.valueOf(0));
                devicesHealthCount.setFair(Integer.valueOf(0));
                devicesHealthCount.setPoor(Integer.valueOf(0));
                devicesHealthCount.setNoData(apDevices);
                vo.setEapHealth(devicesHealthCount);
                vo.addCount(Integer.valueOf(0), apDevices);
                voTreeMap.put(defaultTime, vo);
            }
        } else {
            apHealthAggDTOS.forEach(apHealthAggregationDTO -> {
                DevicesHealthStatusVO vo = new DevicesHealthStatusVO(apHealthAggregationDTO.getTimestamp(), Integer.valueOf(0), Integer.valueOf(0));
                DevicesHealthCount devicesHealthCount = new DevicesHealthCount();
                devicesHealthCount.setGood(apHealthAggregationDTO.getGoodCount());
                devicesHealthCount.setFair(apHealthAggregationDTO.getFairCount());
                devicesHealthCount.setPoor(apHealthAggregationDTO.getPoorCount());
                devicesHealthCount.setNoData(apHealthAggregationDTO.getNodataCount());
                vo.setEapHealth(devicesHealthCount);
                vo.addCount(apHealthAggregationDTO.getGoodCount(), apHealthAggregationDTO.getTotalCount());
                vo.mergeAnomalyInfo(apHealthAggregationDTO.getHighestAnomalyLevel(), apHealthAggregationDTO.getAnomalyCount());
                voTreeMap.put(apHealthAggregationDTO.getTimestamp(), vo);
            });
        }
    }

    @Override
    public OperationResponse b(String omadacId, String siteId, HealthQueryVO healthQueryVO, N granularity) {
        ClientHealthRateStatVO vo;
        long end;
        long queryStart = healthQueryVO.getStart();
        long queryEnd = healthQueryVO.getEnd();
        DeviceHealthScoreQueryDTO queryDTO = new DeviceHealthScoreQueryDTO(omadacId, siteId, Long.valueOf(queryStart), Long.valueOf(queryEnd));
        Map<Long, ClientHealthRateStatVO> clientHealthRateStatMap = this.d.c(queryDTO, granularity);
        long timeUnit = this.a(granularity);
        if (granularity != N.d) {
            start = (queryStart / timeUnit + 1L) * timeUnit;
            end = (queryEnd / timeUnit - 1L) * timeUnit;
        } else {
            long days = (healthQueryVO.getEnd() - healthQueryVO.getStart()) / timeUnit;
            if (CollectionUtils.isEmpty(clientHealthRateStatMap)) {
                end = healthQueryVO.getEnd() / 3600L * 3600L;
            } else {
                long latestStatTime = new ArrayList<ClientHealthRateStatVO>(clientHealthRateStatMap.values()).get(clientHealthRateStatMap.size() - 1).getTime();
                while (latestStatTime + timeUnit < queryEnd) {
                    latestStatTime += timeUnit;
                }
                end = latestStatTime;
            }
            start = end - days * timeUnit;
        }
        ArrayList<ClientHealthRateStatVO> clientHealthRateStatList = new ArrayList<ClientHealthRateStatVO>();
        for (long i2 = start; i2 <= end; i2 += timeUnit) {
            vo = clientHealthRateStatMap.computeIfAbsent(i2, ClientHealthRateStatVO::new);
            clientHealthRateStatList.add(vo);
        }
        long lastStatTime = end + timeUnit;
        vo = clientHealthRateStatMap.get(lastStatTime);
        if (Objects.nonNull(vo)) {
            clientHealthRateStatList.add(vo);
        }
        return OperationResponse.success(clientHealthRateStatList);
    }

    @Override
    public OperationResponse a(String omadacId, String siteId, Long time, N granularity) {
        DeviceHealthScoreQueryDTO query = new DeviceHealthScoreQueryDTO(omadacId, siteId, time, time);
        List<Object> healthScoreDTOList = new ArrayList<Object>();
        healthScoreDTOList.addAll(this.e.a(query, granularity));
        healthScoreDTOList.addAll(this.b.a(query, granularity));
        healthScoreDTOList.addAll(this.c.a(query, granularity));
        HashMap snapshotInfoVOMap = new HashMap();
        healthScoreDTOList = healthScoreDTOList.stream().filter(healthScoreDTO -> !Objects.equals(r.a((int)healthScoreDTO.getScore()), r.a)).collect(Collectors.toList());
        healthScoreDTOList.forEach(healthScoreDTO -> {
            DeviceHealthSnapshotInfoVO deviceHealthSnapshotInfoVO = new DeviceHealthSnapshotInfoVO();
            deviceHealthSnapshotInfoVO.setHealthScore(healthScoreDTO.getScore());
            deviceHealthSnapshotInfoVO.setIp(healthScoreDTO.getIp());
            deviceHealthSnapshotInfoVO.setMac(healthScoreDTO.getMac());
            deviceHealthSnapshotInfoVO.setModel(healthScoreDTO.getModel());
            deviceHealthSnapshotInfoVO.setModelVersion(healthScoreDTO.getModelVersion());
            deviceHealthSnapshotInfoVO.setName(healthScoreDTO.getName());
            deviceHealthSnapshotInfoVO.setType(healthScoreDTO.getType());
            deviceHealthSnapshotInfoVO.setShowModel(healthScoreDTO.getShowModel());
            a.debug("deviceHealthSnapshotInfoVO :{}", (Object)deviceHealthSnapshotInfoVO);
            snapshotInfoVOMap.putIfAbsent(healthScoreDTO.getMac(), deviceHealthSnapshotInfoVO);
        });
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, snapshotInfoVOMap.values());
    }

    @Override
    public OperationResponse a(String omadacId, String siteId, Long time, Integer timeGranularity, Boolean wireless, QueryDataVO queryDataVO) {
        int pageSize;
        int currentPage = queryDataVO.getCurrentPage() <= 0 ? 1 : queryDataVO.getCurrentPage();
        int n2 = pageSize = queryDataVO.getCurrentPageSize() <= 0 ? 10 : queryDataVO.getCurrentPageSize();
        if (Objects.isNull(timeGranularity)) {
            return OperationResponse.PARAM_ERROR;
        }
        long statTime = time;
        ClientHealthSnapshotQueryDTO queryDTO = this.a(omadacId, siteId, (Long)statTime, wireless, queryDataVO);
        int minScore = queryDTO.getMinScore();
        int maxScore = queryDTO.getMaxScore();
        queryDTO.setMinScore(Integer.valueOf(-1));
        queryDTO.setMaxScore(Integer.valueOf(7));
        List<ClientSnapShotEntryDTO> dataList = this.d.a(queryDTO, timeGranularity);
        if (Objects.isNull(dataList) || CollectionUtils.isEmpty(dataList)) {
            return OperationResponse.success((Object)new ClientSnapShopVO(currentPage, pageSize, 0));
        }
        ClientHealthStatusStatDTO statDTO = new ClientHealthStatusStatDTO();
        dataList.forEach(entry -> statDTO.addHealthStat(entry.getHealthScore()));
        List filterList = dataList.stream().filter(dto -> dto.getHealthScore() >= minScore && dto.getHealthScore() <= maxScore).collect(Collectors.toList());
        ClientSnapShopVO vo = new ClientSnapShopVO(currentPage, pageSize, filterList.size());
        vo.setClientStat(statDTO);
        int start = (currentPage - 1) * pageSize;
        if (filterList.size() <= start) {
            return OperationResponse.success((Object)vo);
        }
        List targetList = filterList.subList(start, Math.min(start + pageSize, filterList.size()));
        vo.setData(targetList);
        return OperationResponse.success((Object)vo);
    }

    @Override
    public OperationResponse a(String omadacId, String siteId, String deviceMac, Long start, Long end) {
        ApConnectStatQueryDTO queryDTO = new ApConnectStatQueryDTO();
        queryDTO.setOmadacId(omadacId);
        queryDTO.setSiteId(siteId);
        queryDTO.setApMac(deviceMac);
        queryDTO.setStart(start);
        queryDTO.setEnd(end);
        ApConnectStatResultDTO apConnectStatResultDTO = this.f.a(queryDTO);
        a.debug("Get Ap Connect Info from grpc {}, {}, {}, {}, {}, {}", new Object[]{omadacId, siteId, deviceMac, start, end, apConnectStatResultDTO});
        ApWifiHealthVO apWifiHealthVO = new ApWifiHealthVO();
        apWifiHealthVO.setAssociation(apConnectStatResultDTO.getAssociationNum(), apConnectStatResultDTO.getSuccessAssociationNum());
        apWifiHealthVO.setAuthentication(apConnectStatResultDTO.getAuthenticationNum(), apConnectStatResultDTO.getSuccessAuthentication());
        apWifiHealthVO.setDhcp(apConnectStatResultDTO.getDhcpNum(), apConnectStatResultDTO.getSuccessDhcpNum());
        apWifiHealthVO.setDns(apConnectStatResultDTO.getDnsNum(), apConnectStatResultDTO.getSuccessDnsNum());
        return OperationResponse.success((Object)apWifiHealthVO);
    }

    @Override
    public OperationResponse a(String omadacId, String siteId, String mac, HealthQueryVO healthQueryVO, G granularity) {
        long interval = G.a((G)granularity);
        if (interval == 0L) {
            return OperationResponse.PARAM_ERROR;
        }
        long currentTime = System.currentTimeMillis() / 1000L / 600L * 600L;
        DeviceHealthDetailQueryDTO realTimeQuery = new DeviceHealthDetailQueryDTO(omadacId, siteId, Long.valueOf(currentTime));
        List<WanHealthLevelDTO> realTimeDTO = this.i.a(realTimeQuery);
        Map<Integer, String> wanDialCauseCodeMap = this.i.a(omadacId, siteId, healthQueryVO.getEnd());
        DeviceHealthScoreQueryDTO query = new DeviceHealthScoreQueryDTO(omadacId, siteId, mac, healthQueryVO.getStart(), healthQueryVO.getEnd());
        List<WanHealthLevelDTO> historyDTO = this.i.a(query, granularity);
        TreeMap<Integer, WanHealthVO> wanHealthVOMap = new TreeMap<Integer, WanHealthVO>();
        long realTimeStamp = 0L;
        if (!CollectionUtils.isEmpty(realTimeDTO)) {
            WanHealthLevelDTO healthLevelDTO2 = realTimeDTO.get(0);
            Map healthMap = healthLevelDTO2.getHealthMap();
            realTimeStamp = healthLevelDTO2.getTimestamp();
            healthLevelDTO2.getNameMap().forEach((port, name) -> {
                WanHealthVO wanHealthVO = new WanHealthVO();
                wanHealthVO.setPort(port);
                wanHealthVO.setName(name);
                WanRealTimeHealthVO realTimeHealth = !Objects.equals(healthMap.get(port), 5) ? new WanRealTimeHealthVO(healthLevelDTO2.getTimestamp().longValue(), (Integer)healthMap.get(port)) : new WanRealTimeHealthVO(healthLevelDTO2.getTimestamp().longValue());
                wanHealthVO.setRealTimeHealth(realTimeHealth);
                wanHealthVOMap.put((Integer)port, wanHealthVO);
            });
            this.a(currentTime, wanDialCauseCodeMap, wanHealthVOMap);
        }
        HashMap<Integer, List> wanHistoryHealthMap = new HashMap<Integer, List>();
        HashSet existWanStatusTime = new HashSet();
        long finalRealTimeStamp = realTimeStamp;
        historyDTO.forEach(healthLevelDTO -> {
            Map healthMap = healthLevelDTO.getHealthMap();
            healthLevelDTO.getNameMap().forEach((port, name) -> {
                if (!wanHealthVOMap.containsKey(port)) {
                    WanHealthVO wanHealthVO = new WanHealthVO(port, name);
                    wanHealthVO.setRealTimeHealth(new WanRealTimeHealthVO(finalRealTimeStamp));
                    wanHealthVOMap.put((Integer)port, wanHealthVO);
                }
                existWanStatusTime.add(healthLevelDTO.getTimestamp());
                WanHistoryHealthVO historyHealthVO = new WanHistoryHealthVO();
                historyHealthVO.setEnd(healthLevelDTO.getTimestamp());
                historyHealthVO.setStart(Long.valueOf(healthLevelDTO.getTimestamp() - interval));
                historyHealthVO.setPortStatus((Integer)healthMap.get(port));
                List historyHealthVOList = wanHistoryHealthMap.getOrDefault(port, new ArrayList());
                historyHealthVOList.add(historyHealthVO);
                wanHistoryHealthMap.put((Integer)port, historyHealthVOList);
            });
        });
        wanHealthVOMap.keySet().forEach(port -> {
            if (!wanHistoryHealthMap.containsKey(port)) {
                wanHistoryHealthMap.put((Integer)port, new ArrayList());
            }
        });
        wanHistoryHealthMap.forEach((port, historyHealthVOList) -> {
            Map historyHealthMap = historyHealthVOList.stream().collect(Collectors.toMap(WanHistoryHealthVO::getEnd, v2 -> v2, (v1, v2) -> v2, TreeMap::new));
            this.a(historyHealthMap, healthQueryVO, existWanStatusTime, interval);
            if (wanHealthVOMap.containsKey(port)) {
                WanHealthVO wanHealthVO = (WanHealthVO)wanHealthVOMap.get(port);
                wanHealthVO.setHistoryHealth(new ArrayList(historyHealthMap.values()));
            }
        });
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, new ArrayList(wanHealthVOMap.values()));
    }

    private void a(long currentTime, Map<Integer, String> wanDialCauseCodeMap, Map<Integer, WanHealthVO> wanHealthVOMap) {
        if (!CollectionUtils.isEmpty(wanDialCauseCodeMap)) {
            for (Map.Entry<Integer, String> entry : wanDialCauseCodeMap.entrySet()) {
                WanHealthVO wanHealthVO;
                if (Objects.isNull(entry.getKey()) || !Objects.nonNull(wanHealthVO = wanHealthVOMap.get(entry.getKey()))) continue;
                WanRealTimeHealthVO realTimeHealth = wanHealthVO.getRealTimeHealth();
                realTimeHealth.setTime(Long.valueOf(currentTime));
                realTimeHealth.setPortStatus(Integer.valueOf(4));
                realTimeHealth.setCauseCode(entry.getValue());
            }
        }
    }

    private void a(Map<Long, WanHistoryHealthVO> historyHealthMap, HealthQueryVO healthQueryVO, Set<Long> existWanStatusTime, long interval) {
        if (CollectionUtils.isEmpty(historyHealthMap)) {
            return;
        }
        if (interval >= 86400L) {
            long days = (healthQueryVO.getEnd() - healthQueryVO.getStart()) / interval;
            long statEndTime = new ArrayList<WanHistoryHealthVO>(historyHealthMap.values()).get(historyHealthMap.size() - 1).getEnd();
            long noDataDay = (healthQueryVO.getEnd() - statEndTime) / interval;
            long end = noDataDay > 0L ? statEndTime + noDataDay * interval : statEndTime;
            long start = end - interval * (days - 1L);
            this.a(start, end, interval, historyHealthMap, existWanStatusTime);
        } else {
            long start = (healthQueryVO.getStart() / interval + 1L) * interval;
            long end = (healthQueryVO.getEnd() / interval - 1L) * interval;
            this.a(start, end, interval, historyHealthMap, existWanStatusTime);
        }
    }

    private void a(long start, long end, long interval, Map<Long, WanHistoryHealthVO> historyHealthMap, Set<Long> existWanStatusTime) {
        for (long time = start; time <= end; time += interval) {
            if (historyHealthMap.containsKey(time)) continue;
            if (!existWanStatusTime.contains(time)) {
                historyHealthMap.put(time, new WanHistoryHealthVO(Long.valueOf(time - interval), Long.valueOf(time), Integer.valueOf(3)));
                continue;
            }
            historyHealthMap.put(time, new WanHistoryHealthVO(Long.valueOf(time - interval), Long.valueOf(time), Integer.valueOf(5)));
        }
    }

    private List<DeviceHealthVO> a(DeviceHealthScoreQueryDTO query, N granularity) {
        List<OswHealthScoreDTO> oswHealthScoreDTOList = this.c.a(query, granularity);
        com.tplink.smb.omada.monitor.api.internal.statistic.dto.b request = this.c(query, granularity);
        Map oswHealthStatDTOMap = this.h.b(request);
        ArrayList<DeviceHealthVO> deviceHealthVOList = new ArrayList<DeviceHealthVO>();
        for (OswHealthScoreDTO oswHealthScoreDTO : oswHealthScoreDTOList) {
            long timestamp = oswHealthScoreDTO.getTimestamp();
            ArrayList<OswHealthStatDTO> list = new ArrayList<OswHealthStatDTO>();
            if (Objects.equals(oswHealthScoreDTO.getScore(), -1)) {
                deviceHealthVOList.add(new DeviceHealthVO(Long.valueOf(timestamp), Integer.valueOf(-1)));
                continue;
            }
            if (oswHealthStatDTOMap.containsKey(timestamp)) {
                list.add((OswHealthStatDTO)oswHealthStatDTOMap.get(timestamp));
            }
            if (oswHealthStatDTOMap.containsKey(timestamp - 300L)) {
                list.add((OswHealthStatDTO)oswHealthStatDTOMap.get(timestamp - 300L));
            }
            if (!CollectionUtils.isEmpty(list)) {
                deviceHealthVOList.add(com.tplink.smb.omada.anomaly.core.a.a.a.a(oswHealthScoreDTO.getTimestamp(), oswHealthScoreDTO.getScore(), oswHealthScoreDTO.getHighestAnomalyLevel(), oswHealthScoreDTO.getAnomalyCount(), oswHealthScoreDTO, list));
                continue;
            }
            deviceHealthVOList.add(new DeviceHealthVO(Long.valueOf(timestamp), oswHealthScoreDTO.getScore(), oswHealthScoreDTO.getHighestAnomalyLevel(), oswHealthScoreDTO.getAnomalyCount(), oswHealthScoreDTO));
        }
        return deviceHealthVOList;
    }

    private List<DeviceHealthVO> b(DeviceHealthScoreQueryDTO query, N granularity) {
        List<ApHealthScoreDTO> apHealthScoreDTOList = this.b.a(query, granularity);
        com.tplink.smb.omada.monitor.api.internal.statistic.dto.b request = this.c(query, granularity);
        Map apHealthStatDTOMap = this.h.c(request).a();
        ArrayList<DeviceHealthVO> deviceHealthVOList = new ArrayList<DeviceHealthVO>();
        for (ApHealthScoreDTO apHealthScoreDTO : apHealthScoreDTOList) {
            long timestamp = apHealthScoreDTO.getTimestamp();
            ArrayList<ApHealthStatDTO> list = new ArrayList<ApHealthStatDTO>();
            if (Objects.equals(apHealthScoreDTO.getScore(), -1)) {
                deviceHealthVOList.add(new DeviceHealthVO(Long.valueOf(timestamp), Integer.valueOf(-1)));
                continue;
            }
            if (apHealthStatDTOMap.containsKey(timestamp)) {
                list.add((ApHealthStatDTO)apHealthStatDTOMap.get(timestamp));
            }
            if (apHealthStatDTOMap.containsKey(timestamp - 300L)) {
                list.add((ApHealthStatDTO)apHealthStatDTOMap.get(timestamp - 300L));
            }
            if (!CollectionUtils.isEmpty(list)) {
                deviceHealthVOList.add(com.tplink.smb.omada.anomaly.core.a.a.a.a(apHealthScoreDTO.getTimestamp(), apHealthScoreDTO.getScore(), apHealthScoreDTO.getHighestAnomalyLevel(), apHealthScoreDTO.getAnomalyCount(), apHealthScoreDTO, list));
                continue;
            }
            deviceHealthVOList.add(new DeviceHealthVO(Long.valueOf(timestamp), apHealthScoreDTO.getScore(), apHealthScoreDTO.getHighestAnomalyLevel(), apHealthScoreDTO.getAnomalyCount(), apHealthScoreDTO));
        }
        return deviceHealthVOList;
    }

    private com.tplink.smb.omada.monitor.api.internal.statistic.dto.b c(DeviceHealthScoreQueryDTO query, N granularity) {
        if (Objects.equals(granularity, N.b)) {
            return new com.tplink.smb.omada.monitor.api.internal.statistic.dto.b(query.getOmadacId(), query.getSiteId(), query.getMac(), query.getStart(), query.getEnd(), N.a);
        }
        return new com.tplink.smb.omada.monitor.api.internal.statistic.dto.b(query.getOmadacId(), query.getSiteId(), query.getMac(), query.getStart(), query.getEnd(), granularity);
    }

    @Override
    public OperationResponse<List<ClientHealthScoreVO>> a(String omadacId, String siteId, String clientMac, Long start, Long end, N timeGranularityEnum, Integer timeGranularity) {
        long endTime;
        DeviceHealthScoreQueryDTO query = new DeviceHealthScoreQueryDTO(omadacId, siteId, clientMac, start, end);
        TreeMap<Long, ClientHealthScoreVO> healthScoreMap = new TreeMap<Long, ClientHealthScoreVO>();
        List<ClientHealthScoreDTO> dtoList = this.d.a(query, timeGranularityEnum);
        ClientHealthStatInternalQueryDTO statQuery = new ClientHealthStatInternalQueryDTO(omadacId, siteId, clientMac, start, end, timeGranularity);
        ClientHealthStatInternalResultDTO statResult = this.f.a(statQuery);
        List statList = Collections.emptyList();
        if (Objects.nonNull(statResult) && !CollectionUtils.isEmpty((Collection)statResult.getClientHealthStatDTOList())) {
            statList = statResult.getClientHealthStatDTOList();
        }
        dtoList.stream().filter(scoreDTO -> Objects.nonNull(scoreDTO) && Objects.nonNull(scoreDTO.getWireless())).forEach(scoreDTO -> {
            ClientHealthScoreVO vo = this.a((ClientHealthScoreDTO)scoreDTO);
            if (Objects.nonNull(vo)) {
                healthScoreMap.put(vo.getTime(), vo);
            }
        });
        statList.stream().filter(statDTO -> Objects.nonNull(statDTO) && Objects.nonNull(statDTO.getWireless())).forEach(statDTO -> {
            ClientHealthScoreVO vo = (ClientHealthScoreVO)healthScoreMap.get(statDTO.getTime());
            if (Objects.nonNull(vo) && !Objects.equals(vo.getHealthScore(), -1)) {
                this.a(vo, (ClientHealthStatDTO)statDTO);
            }
        });
        long timeUnit = this.a(timeGranularityEnum);
        if (timeGranularityEnum != N.d) {
            startTime = (start / timeUnit + 1L) * timeUnit;
            endTime = (end / timeUnit - 1L) * timeUnit;
        } else {
            long days = (end - start) / timeUnit;
            if (CollectionUtils.isEmpty(healthScoreMap)) {
                endTime = end / 3600L * 3600L;
            } else {
                long latestStatTime = ((ClientHealthScoreVO)new ArrayList(healthScoreMap.values()).get(healthScoreMap.size() - 1)).getTime();
                endTime = this.a(latestStatTime, end, timeUnit);
            }
            startTime = endTime - days * timeUnit;
        }
        for (long t2 = startTime; t2 <= endTime; t2 += timeUnit) {
            healthScoreMap.computeIfAbsent(t2, time -> {
                ClientHealthScoreVO clientHealthScoreVO = new ClientHealthScoreVO(time);
                clientHealthScoreVO.setHealthScore(Integer.valueOf(-1));
                return clientHealthScoreVO;
            });
        }
        return OperationResponse.success(new ArrayList(healthScoreMap.values()));
    }

    @Override
    public OperationResponse<ClientHealthSnapshotGridVO> a(String omadacId, String siteId, Long time, Integer granularity, QueryDataVO queryDataVO) {
        a queryInfo = this.a(time, granularity, queryDataVO);
        boolean realtime = queryInfo.g();
        granularity = queryInfo.h();
        ClientHealthSnapshotQueryDTO queryDTO = this.a(omadacId, siteId, (Long)queryInfo.e(), true, queryDataVO);
        ClientHealthInternalSnapshotQueryDTO internalQueryDTO = new ClientHealthInternalSnapshotQueryDTO(omadacId, siteId, Long.valueOf(queryInfo.f()), granularity, Long.valueOf(queryInfo.d()), Integer.valueOf(1), Boolean.valueOf(realtime));
        this.a(internalQueryDTO, queryDataVO, "rssi");
        List<ClientSnapShotEntryDTO> healthList = this.a(queryDTO, granularity, (Long)queryInfo.c());
        ClientHealthSnapshotResultDTO statResult = this.f.a(internalQueryDTO);
        List<ClientHealthIndexDTO> statList = Optional.ofNullable(statResult.getData()).orElse(Collections.emptyList());
        TreeMap<String, ClientHealthSnapshotVO> rssiSnapshotVOMap = new TreeMap<String, ClientHealthSnapshotVO>();
        statList.forEach(stat -> {
            if (Objects.nonNull(stat) && Objects.nonNull(stat.getClientMac())) {
                String mac = stat.getClientMac();
                ClientHealthSnapshotVO rssiSnapshotVO = new ClientHealthSnapshotVO();
                rssiSnapshotVO.setRssi(stat.getRssi());
                this.a(omadacId, siteId, rssiSnapshotVO, (ClientHealthIndexDTO)stat);
                rssiSnapshotVOMap.put(mac, rssiSnapshotVO);
            }
        });
        this.a(rssiSnapshotVOMap, healthList);
        List<ClientHealthSnapshotVO> rssiSnapshotVOList = rssiSnapshotVOMap.values().stream().filter(vo -> Objects.nonNull(vo) && Objects.nonNull(vo.getRssi()) && Objects.nonNull(vo.getClientName()) && Objects.nonNull(vo.getDeviceName()) && Objects.nonNull(vo.getHealthScore())).collect(Collectors.toList());
        this.a(rssiSnapshotVOList, queryDataVO.getSorts(), 1);
        return this.a(rssiSnapshotVOList, queryInfo.a(), queryInfo.b());
    }

    @Override
    public OperationResponse<ClientHealthSnapshotGridVO> b(String omadacId, String siteId, Long time, Integer granularity, QueryDataVO queryDataVO) {
        a queryInfo = this.a(time, granularity, queryDataVO);
        boolean realtime = queryInfo.g();
        granularity = queryInfo.h();
        ClientHealthSnapshotQueryDTO queryDTO = this.a(omadacId, siteId, (Long)queryInfo.e(), true, queryDataVO);
        ClientHealthInternalSnapshotQueryDTO internalQueryDTO = new ClientHealthInternalSnapshotQueryDTO(omadacId, siteId, Long.valueOf(queryInfo.f()), granularity, Long.valueOf(queryInfo.d()), Integer.valueOf(2), Boolean.valueOf(realtime));
        this.a(internalQueryDTO, queryDataVO, "snr");
        List<ClientSnapShotEntryDTO> healthList = this.a(queryDTO, granularity, (Long)queryInfo.c());
        ClientHealthSnapshotResultDTO statResult = this.f.a(internalQueryDTO);
        List<ClientHealthIndexDTO> statList = Optional.ofNullable(statResult.getData()).orElse(Collections.emptyList());
        TreeMap<String, ClientHealthSnapshotVO> snrSnapshotVOMap = new TreeMap<String, ClientHealthSnapshotVO>();
        statList.forEach(stat -> {
            if (Objects.nonNull(stat) && Objects.nonNull(stat.getClientMac())) {
                String mac = stat.getClientMac();
                ClientHealthSnapshotVO snrSnapshotVO = new ClientHealthSnapshotVO();
                snrSnapshotVO.setSnr(stat.getSnr());
                this.a(omadacId, siteId, snrSnapshotVO, (ClientHealthIndexDTO)stat);
                snrSnapshotVOMap.put(mac, snrSnapshotVO);
            }
        });
        this.a(snrSnapshotVOMap, healthList);
        List<ClientHealthSnapshotVO> snrSnapshotVOList = snrSnapshotVOMap.values().stream().filter(vo -> Objects.nonNull(vo) && Objects.nonNull(vo.getSnr()) && Objects.nonNull(vo.getClientName()) && Objects.nonNull(vo.getDeviceName()) && Objects.nonNull(vo.getHealthScore())).collect(Collectors.toList());
        this.a(snrSnapshotVOList, queryDataVO.getSorts(), 2);
        return this.a(snrSnapshotVOList, queryInfo.a(), queryInfo.b());
    }

    @Override
    public OperationResponse<ClientHealthSnapshotGridVO> c(String omadacId, String siteId, Long time, Integer granularity, QueryDataVO queryDataVO) {
        a queryInfo = this.a(time, granularity, queryDataVO);
        boolean realtime = queryInfo.g();
        granularity = queryInfo.h();
        ClientHealthSnapshotQueryDTO queryDTO = this.a(omadacId, siteId, (Long)queryInfo.e(), true, queryDataVO);
        ClientHealthInternalSnapshotQueryDTO internalQueryDTO = new ClientHealthInternalSnapshotQueryDTO(omadacId, siteId, Long.valueOf(queryInfo.f()), granularity, Long.valueOf(queryInfo.d()), Integer.valueOf(3), Boolean.valueOf(realtime));
        this.a(internalQueryDTO, queryDataVO, "roamCount");
        List<ClientSnapShotEntryDTO> healthList = this.a(queryDTO, granularity, (Long)queryInfo.c());
        ClientHealthSnapshotResultDTO statResult = this.f.a(internalQueryDTO);
        List<ClientHealthIndexDTO> statList = Optional.ofNullable(statResult.getData()).orElse(Collections.emptyList());
        TreeMap<String, ClientHealthSnapshotVO> roamSnapshotVOMap = new TreeMap<String, ClientHealthSnapshotVO>();
        statList.forEach(stat -> {
            if (Objects.nonNull(stat) && Objects.nonNull(stat.getClientMac())) {
                String mac = stat.getClientMac();
                ClientHealthSnapshotVO roamSnapshotVO = new ClientHealthSnapshotVO();
                roamSnapshotVO.setRoam(stat.getRoams());
                this.a(omadacId, siteId, roamSnapshotVO, (ClientHealthIndexDTO)stat);
                roamSnapshotVOMap.put(mac, roamSnapshotVO);
            }
        });
        this.a(roamSnapshotVOMap, healthList);
        List<ClientHealthSnapshotVO> roamSnapshotVOList = roamSnapshotVOMap.values().stream().filter(vo -> Objects.nonNull(vo) && Objects.nonNull(vo.getRoam()) && Objects.nonNull(vo.getClientName()) && Objects.nonNull(vo.getDeviceName()) && Objects.nonNull(vo.getHealthScore())).collect(Collectors.toList());
        this.a(roamSnapshotVOList, queryDataVO.getSorts(), 3);
        return this.a(roamSnapshotVOList, queryInfo.a(), queryInfo.b());
    }

    @Override
    public OperationResponse<ClientHealthSnapshotGridVO> d(String omadacId, String siteId, Long time, Integer granularity, QueryDataVO queryDataVO) {
        a queryInfo = this.a(time, granularity, queryDataVO);
        boolean realtime = queryInfo.g();
        granularity = queryInfo.h();
        ClientHealthSnapshotQueryDTO queryDTO = this.a(omadacId, siteId, (Long)queryInfo.e(), true, queryDataVO);
        ClientHealthInternalSnapshotQueryDTO internalQueryDTO = new ClientHealthInternalSnapshotQueryDTO(omadacId, siteId, Long.valueOf(queryInfo.f()), granularity, Long.valueOf(queryInfo.d()), Integer.valueOf(4), Boolean.valueOf(realtime));
        this.a(internalQueryDTO, queryDataVO, "speed", "protocol");
        List<ClientSnapShotEntryDTO> healthList = this.a(queryDTO, granularity, (Long)queryInfo.c());
        ClientHealthSnapshotResultDTO statResult = this.f.a(internalQueryDTO);
        List<ClientHealthIndexDTO> statList = Optional.ofNullable(statResult.getData()).orElse(Collections.emptyList());
        TreeMap<String, ClientHealthSnapshotVO> speedSnapshotVOMap = new TreeMap<String, ClientHealthSnapshotVO>();
        statList.forEach(stat -> {
            if (Objects.nonNull(stat) && Objects.nonNull(stat.getClientMac())) {
                String mac = stat.getClientMac();
                ClientHealthSnapshotVO speedSnapshotVO = new ClientHealthSnapshotVO();
                speedSnapshotVO.setSpeed(stat.getSpeed());
                this.a(omadacId, siteId, speedSnapshotVO, (ClientHealthIndexDTO)stat);
                speedSnapshotVOMap.put(mac, speedSnapshotVO);
            }
        });
        this.a(speedSnapshotVOMap, healthList);
        List<ClientHealthSnapshotVO> speedSnapshotVOList = speedSnapshotVOMap.values().stream().filter(vo -> Objects.nonNull(vo) && Objects.nonNull(vo.getSpeed()) && Objects.nonNull(vo.getClientName()) && Objects.nonNull(vo.getDeviceName()) && Objects.nonNull(vo.getHealthScore())).collect(Collectors.toList());
        this.a(speedSnapshotVOList, queryDataVO.getSorts(), 4);
        return this.a(speedSnapshotVOList, queryInfo.a(), queryInfo.b());
    }

    @Override
    public OperationResponse<ClientHealthSnapshotGridVO> e(String omadacId, String siteId, Long time, Integer granularity, QueryDataVO queryDataVO) {
        a queryInfo = this.a(time, granularity, queryDataVO);
        boolean realtime = queryInfo.g();
        granularity = queryInfo.h();
        ClientHealthSnapshotQueryDTO queryDTO = this.a(omadacId, siteId, (Long)queryInfo.e(), true, queryDataVO);
        ClientHealthInternalSnapshotQueryDTO internalQueryDTO = new ClientHealthInternalSnapshotQueryDTO(omadacId, siteId, Long.valueOf(queryInfo.f()), granularity, Long.valueOf(queryInfo.d()), Integer.valueOf(5), Boolean.valueOf(realtime));
        this.a(internalQueryDTO, queryDataVO, "ssid");
        List<ClientSnapShotEntryDTO> healthList = this.a(queryDTO, granularity, (Long)queryInfo.c());
        ClientHealthSnapshotResultDTO statResult = this.f.a(internalQueryDTO);
        List<ClientHealthIndexDTO> statList = Optional.ofNullable(statResult.getData()).orElse(Collections.emptyList());
        TreeMap<String, ClientHealthSnapshotVO> ssidSnapshotVOMap = new TreeMap<String, ClientHealthSnapshotVO>();
        statList.forEach(stat -> {
            if (Objects.nonNull(stat) && Objects.nonNull(stat.getClientMac())) {
                String mac = stat.getClientMac();
                ClientHealthSnapshotVO ssidSnapshotVO = new ClientHealthSnapshotVO();
                ssidSnapshotVO.setSsid(stat.getSsid());
                this.a(omadacId, siteId, ssidSnapshotVO, (ClientHealthIndexDTO)stat);
                ssidSnapshotVOMap.put(mac, ssidSnapshotVO);
            }
        });
        this.a(ssidSnapshotVOMap, healthList);
        List<ClientHealthSnapshotVO> ssidSnapshotVOList = ssidSnapshotVOMap.values().stream().filter(vo -> Objects.nonNull(vo) && Objects.nonNull(vo.getSsid()) && Objects.nonNull(vo.getClientName()) && Objects.nonNull(vo.getDeviceName()) && Objects.nonNull(vo.getHealthScore())).collect(Collectors.toList());
        this.a(ssidSnapshotVOList, queryDataVO.getSorts(), 5);
        return this.a(ssidSnapshotVOList, queryInfo.a(), queryInfo.b());
    }

    @Override
    public OperationResponse<ClientHealthSnapshotGridVO> f(String omadacId, String siteId, Long time, Integer granularity, QueryDataVO queryDataVO) {
        a queryInfo = this.a(time, granularity, queryDataVO);
        boolean realtime = queryInfo.g();
        granularity = queryInfo.h();
        ClientHealthSnapshotQueryDTO queryDTO = this.a(omadacId, siteId, (Long)queryInfo.e(), true, queryDataVO);
        ClientHealthInternalSnapshotQueryDTO internalQueryDTO = new ClientHealthInternalSnapshotQueryDTO(omadacId, siteId, Long.valueOf(queryInfo.f()), granularity, Long.valueOf(queryInfo.d()), Integer.valueOf(6), Boolean.valueOf(realtime));
        this.a(internalQueryDTO, queryDataVO, "channel");
        List<ClientSnapShotEntryDTO> healthList = this.a(queryDTO, granularity, (Long)queryInfo.c());
        ClientHealthSnapshotResultDTO statResult = this.f.a(internalQueryDTO);
        List<ClientHealthIndexDTO> statList = Optional.ofNullable(statResult.getData()).orElse(Collections.emptyList());
        TreeMap<String, ClientHealthSnapshotVO> channelSnapshotVOMap = new TreeMap<String, ClientHealthSnapshotVO>();
        statList.forEach(stat -> {
            if (Objects.nonNull(stat) && Objects.nonNull(stat.getClientMac())) {
                String mac = stat.getClientMac();
                ClientHealthSnapshotVO channelSnapshotVO = new ClientHealthSnapshotVO();
                channelSnapshotVO.setChannel(stat.getRadio());
                this.a(omadacId, siteId, channelSnapshotVO, (ClientHealthIndexDTO)stat, true);
                channelSnapshotVOMap.put(mac, channelSnapshotVO);
            }
        });
        this.a(channelSnapshotVOMap, healthList);
        List<ClientHealthSnapshotVO> channelSnapshotVOList = channelSnapshotVOMap.values().stream().filter(vo -> Objects.nonNull(vo) && Objects.nonNull(vo.getChannel()) && Objects.nonNull(vo.getClientName()) && Objects.nonNull(vo.getDeviceName()) && Objects.nonNull(vo.getHealthScore())).collect(Collectors.toList());
        this.a(channelSnapshotVOList, queryDataVO.getSorts(), 6);
        return this.a(channelSnapshotVOList, queryInfo.a(), queryInfo.b());
    }

    private List<ClientSnapShotEntryDTO> a(ClientHealthSnapshotQueryDTO queryDTO, Integer granularity, Long timeunit) {
        List<ClientSnapShotEntryDTO> healthList = this.d.a(queryDTO, granularity);
        if (CollectionUtils.isEmpty(healthList)) {
            queryDTO.setTime(Long.valueOf(queryDTO.getTime() - timeunit));
            return this.d.a(queryDTO, granularity);
        }
        return healthList;
    }

    private a a(Long time, Integer granularity, QueryDataVO queryDataVO) {
        a queryInfo = new a();
        queryInfo.a(queryDataVO.getCurrentPage() <= 0 ? 1 : queryDataVO.getCurrentPage());
        queryInfo.b(queryDataVO.getCurrentPageSize() <= 0 ? 10 : queryDataVO.getCurrentPageSize());
        Long healthTimeUnit = this.a(granularity);
        boolean realtime = false;
        if (Objects.isNull(healthTimeUnit)) {
            realtime = true;
            healthTimeUnit = 600L;
            granularity = 0;
        }
        queryInfo.a(healthTimeUnit);
        queryInfo.a(realtime);
        queryInfo.c(granularity);
        long clientStatUnit = healthTimeUnit == 600L ? 300L : healthTimeUnit;
        queryInfo.b(clientStatUnit);
        if (healthTimeUnit == 600L) {
            queryInfo.c(time / healthTimeUnit * healthTimeUnit);
            queryInfo.d(time / clientStatUnit * clientStatUnit);
        } else {
            queryInfo.c(time);
            queryInfo.d(time);
        }
        return queryInfo;
    }

    private void a(Map<String, ClientHealthSnapshotVO> snapshotVOMap, List<ClientSnapShotEntryDTO> healthList) {
        healthList.forEach(healthStat -> {
            String mac;
            ClientHealthSnapshotVO snapshotVO;
            if (Objects.nonNull(healthStat) && Objects.nonNull(healthStat.getClientMac()) && Objects.nonNull(healthStat.getHealthScore()) && Objects.nonNull(snapshotVO = (ClientHealthSnapshotVO)snapshotVOMap.get(mac = healthStat.getClientMac()))) {
                if (!Objects.equals(healthStat.getHealthScore(), -1)) {
                    snapshotVO.setClientName(healthStat.getClientName());
                    snapshotVO.setType(healthStat.getType());
                    snapshotVO.setManager(healthStat.getManager());
                    snapshotVO.setHealthScore(healthStat.getHealthScore());
                }
                snapshotVO.setDeviceName(com.tplink.smb.omada.anomaly.core.port.f.a.a(snapshotVO.getDeviceName(), healthStat.getDeviceName()));
                snapshotVO.setDeviceModel(com.tplink.smb.omada.anomaly.core.port.f.a.a(snapshotVO.getDeviceModel(), healthStat.getDeviceModel()));
                snapshotVO.setDeviceModelVersion(com.tplink.smb.omada.anomaly.core.port.f.a.a(snapshotVO.getDeviceModelVersion(), healthStat.getDeviceModelVersion()));
                snapshotVOMap.put(mac, snapshotVO);
            }
        });
    }

    private void a(String omadacId, String siteId, ClientHealthSnapshotVO clientHealthSnapshotVO, ClientHealthIndexDTO clientHealthIndexDTO) {
        this.a(omadacId, siteId, clientHealthSnapshotVO, clientHealthIndexDTO, false);
    }

    private void a(String omadacId, String siteId, ClientHealthSnapshotVO clientHealthSnapshotVO, ClientHealthIndexDTO clientHealthIndexDTO, boolean isRadioReleated) {
        clientHealthSnapshotVO.setHealthScore(Integer.valueOf(-1));
        clientHealthSnapshotVO.setClientName(Objects.nonNull(clientHealthIndexDTO.getClientName()) ? clientHealthIndexDTO.getClientName() : clientHealthIndexDTO.getClientMac());
        clientHealthSnapshotVO.setType(Objects.nonNull(clientHealthIndexDTO.getClientType()) ? clientHealthIndexDTO.getClientType() : "unknown");
        clientHealthSnapshotVO.setManager(Boolean.valueOf(Boolean.TRUE.equals(clientHealthIndexDTO.getManager())));
        String devMac = clientHealthIndexDTO.getDevMac();
        DeviceObjectDTO deviceObjectDTO = this.j.b(omadacId, siteId, devMac);
        if (Objects.nonNull(deviceObjectDTO)) {
            clientHealthSnapshotVO.setDeviceName(deviceObjectDTO.getName());
            clientHealthSnapshotVO.setDeviceModel(deviceObjectDTO.getModel());
            clientHealthSnapshotVO.setDeviceModelVersion(deviceObjectDTO.getModelVersion());
        } else {
            clientHealthSnapshotVO.setDeviceName(devMac);
        }
        if (isRadioReleated) {
            clientHealthSnapshotVO.setSupport5g2(Boolean.valueOf(this.k.c(deviceObjectDTO)));
        }
    }

    private OperationResponse<ClientHealthSnapshotGridVO> a(List<ClientHealthSnapshotVO> dataList, int currentPage, int pageSize) {
        int totalRow = dataList.size();
        int startIndex = (currentPage - 1) * pageSize;
        int endIndex = Math.min(startIndex + pageSize, totalRow);
        if (totalRow <= startIndex) {
            return OperationResponse.success((Object)new ClientHealthSnapshotGridVO(Integer.valueOf(totalRow), Integer.valueOf(currentPage), Integer.valueOf(pageSize)));
        }
        List<ClientHealthSnapshotVO> data = dataList.subList(startIndex, endIndex);
        return OperationResponse.success((Object)new ClientHealthSnapshotGridVO(Integer.valueOf(totalRow), Integer.valueOf(currentPage), Integer.valueOf(pageSize), data));
    }

    private ClientHealthScoreVO a(ClientHealthScoreDTO dto) {
        ClientHealthScoreVO vo = new ClientHealthScoreVO(dto.getTimestamp());
        vo.setHealthScore(dto.getScore());
        vo.setHealthScore(dto.getScore());
        if (Objects.equals(dto.getScore(), -1)) {
            return vo;
        }
        vo.setDeviceMac(dto.getDeviceMac());
        vo.setDeviceName(dto.getDeviceName());
        vo.setDeviceType(dto.getDeviceType());
        if (Boolean.TRUE.equals(dto.getWireless())) {
            ClientHealthScoreVO.WirelessPropertyVO wirelessProperty = new ClientHealthScoreVO.WirelessPropertyVO();
            wirelessProperty.setConnectScore(dto.getConnectScore());
            wirelessProperty.setRssiScore(dto.getRssiScore());
            wirelessProperty.setSnrScore(dto.getSnrScore());
            wirelessProperty.setDataRateScore(dto.getDataRateScore());
            wirelessProperty.setIssueScore(dto.getIssueScore());
            wirelessProperty.setHighestAnomalyLevel(dto.getHighestAnomalyLevel());
            wirelessProperty.setAnomalyCount(dto.getAnomalyCount());
            wirelessProperty.setSupport5g2(Boolean.valueOf(this.k.h(dto.getOmadacId(), dto.getSiteId(), dto.getDeviceMac())));
            vo.setWirelessProperty(wirelessProperty);
        } else if (Boolean.FALSE.equals(dto.getWireless())) {
            ClientHealthScoreVO.WiredPropertyVO wiredPropertyVO = new ClientHealthScoreVO.WiredPropertyVO();
            wiredPropertyVO.setConnectScore(dto.getConnectScore());
            wiredPropertyVO.setLinkErrorScore(dto.getLinkErrorScore());
            vo.setWiredProperty(wiredPropertyVO);
        } else {
            return null;
        }
        return vo;
    }

    private void a(ClientHealthScoreVO vo, ClientHealthStatDTO dto) {
        if (Objects.nonNull(vo.getWirelessProperty()) && Boolean.TRUE.equals(dto.getWireless())) {
            ClientHealthScoreVO.WirelessPropertyVO wirelessProperty = vo.getWirelessProperty();
            wirelessProperty.setRssi(dto.getRssi());
            wirelessProperty.setSnr(dto.getSnr());
            wirelessProperty.setRxRate(dto.getRxRate());
            wirelessProperty.setTxRate(dto.getTxRate());
            wirelessProperty.setChannel(dto.getChannel());
            wirelessProperty.setSsid(dto.getSsid());
            wirelessProperty.setRadio(dto.getRadio());
            return;
        }
        if (Objects.nonNull(vo.getWiredProperty()) && Boolean.FALSE.equals(dto.getWireless())) {
            ClientHealthScoreVO.WiredPropertyVO wiredProperty = vo.getWiredProperty();
            wiredProperty.setPort(dto.getPort());
            wiredProperty.setDuplex(dto.getDuplex());
            wiredProperty.setLinkSpeed(dto.getLinkSpeed());
            wiredProperty.setVlan(dto.getVid());
            if (Objects.nonNull(wiredProperty.getErrorPacketNum()) && Objects.nonNull(dto.getErrorPacketNum())) {
                wiredProperty.setErrorPacketNum(Long.valueOf(wiredProperty.getErrorPacketNum() + dto.getErrorPacketNum()));
            } else {
                wiredProperty.setErrorPacketNum(dto.getErrorPacketNum());
            }
        }
    }

    private ClientHealthSnapshotQueryDTO a(String omadacId, String siteId, Long time, Boolean wireless, QueryDataVO queryDataVO) {
        Map filter = queryDataVO.getFilters();
        int minScore = -1;
        int maxScore = 10;
        if (Objects.nonNull(filter)) {
            Object minObject = filter.get("minScore");
            Object maxObject = filter.get("maxScore");
            if (Objects.nonNull(minObject) && minObject instanceof String) {
                try {
                    minScore = Integer.parseInt((String)minObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (Objects.nonNull(maxObject) && maxObject instanceof String) {
                try {
                    maxScore = Integer.parseInt((String)maxObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ClientHealthSnapshotQueryDTO queryDTO = new ClientHealthSnapshotQueryDTO(omadacId, siteId, time, wireless, Integer.valueOf(minScore), Integer.valueOf(maxScore));
        LinkedHashMap sorts = queryDataVO.getSorts();
        if (Objects.isNull(sorts)) {
            return queryDTO;
        }
        for (Map.Entry sortKeyValue : sorts.entrySet()) {
            queryDTO.addSortInfo((String)sortKeyValue.getKey(), (String)sortKeyValue.getValue());
        }
        return queryDTO;
    }

    private void a(ClientHealthInternalSnapshotQueryDTO internalQueryDTO, QueryDataVO queryDataVO, String sortFieldName) {
        this.a(internalQueryDTO, queryDataVO, sortFieldName, null);
    }

    private void a(ClientHealthInternalSnapshotQueryDTO internalQueryDTO, QueryDataVO queryDataVO, String sortFieldName, String protocolFilterName) {
        Map sort;
        String direction;
        Object protocolFilter;
        Map filters = Optional.ofNullable(queryDataVO.getFilters()).orElse(new HashMap(0));
        Object valueFilter = filters.get("realtime");
        if (Objects.nonNull(valueFilter) && valueFilter instanceof String) {
            if (Objects.equals(5, internalQueryDTO.getScope())) {
                internalQueryDTO.setNameFilter((String)valueFilter);
            } else {
                this.a(internalQueryDTO, valueFilter);
            }
        }
        if (Objects.nonNull(protocolFilterName) && Objects.equals(4, internalQueryDTO.getScope()) && Objects.nonNull(protocolFilter = filters.get("protocol")) && protocolFilter instanceof String) {
            internalQueryDTO.setProtocolFilter(Integer.valueOf(Integer.parseInt((String)protocolFilter)));
        }
        if (Objects.nonNull(direction = (String)(sort = (Map)Optional.ofNullable(queryDataVO.getSorts()).orElse(new LinkedHashMap())).get(sortFieldName))) {
            if (Objects.equals("asc", direction)) {
                internalQueryDTO.setSort(Integer.valueOf(1));
            } else if (Objects.equals("desc", direction)) {
                internalQueryDTO.setSort(Integer.valueOf(2));
            }
        }
    }

    private void a(ClientHealthInternalSnapshotQueryDTO internalQueryDTO, Object valueFilter) {
        try {
            Integer intFilter = Integer.parseInt((String)valueFilter);
            internalQueryDTO.setValueFilter(intFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void a(List<ClientHealthSnapshotVO> rssiSnapshotVOList, Map<String, String> sort, int scope) {
        if (Objects.isNull(sort) || CollectionUtils.isEmpty(sort.entrySet())) {
            return;
        }
        Comparator<ClientHealthSnapshotVO> comparator = (o1, o2) -> 0;
        for (Map.Entry<String, String> sortInfo : sort.entrySet()) {
            String field = sortInfo.getKey();
            String direction = sortInfo.getValue();
            if (Objects.isNull(field)) continue;
            switch (field) {
                case "clientName": {
                    comparator = this.c(comparator, ClientHealthSnapshotVO::getClientName, direction, 0, 0);
                    break;
                }
                case "healthScore": {
                    comparator = this.a(comparator, ClientHealthSnapshotVO::getHealthScore, direction, 0, 0);
                    break;
                }
                case "deviceName": {
                    comparator = this.c(comparator, ClientHealthSnapshotVO::getDeviceName, direction, 0, 0);
                    break;
                }
                case "rssi": {
                    comparator = this.a(comparator, ClientHealthSnapshotVO::getRssi, direction, 1, scope);
                    break;
                }
                case "snr": {
                    comparator = this.a(comparator, ClientHealthSnapshotVO::getSnr, direction, 2, scope);
                    break;
                }
                case "roamCount": {
                    comparator = this.a(comparator, ClientHealthSnapshotVO::getRoam, direction, 3, scope);
                    break;
                }
                case "speed": {
                    comparator = this.b(comparator, ClientHealthSnapshotVO::getSpeed, direction, 4, scope);
                    break;
                }
                case "ssid": {
                    comparator = this.c(comparator, ClientHealthSnapshotVO::getSsid, direction, 5, scope);
                    break;
                }
                case "channel": {
                    comparator = this.a(comparator, ClientHealthSnapshotVO::getChannel, direction, 6, scope);
                    break;
                }
            }
        }
        Collections.sort(rssiSnapshotVOList, comparator);
    }

    private Comparator<ClientHealthSnapshotVO> a(Comparator<ClientHealthSnapshotVO> comparator, Function<ClientHealthSnapshotVO, Integer> keyExtractor, String direction, int field, int scope) {
        if (field == scope) {
            if (Objects.equals("asc", direction)) {
                return comparator.thenComparing(keyExtractor, Comparator.naturalOrder());
            }
            if (Objects.equals("desc", direction)) {
                return comparator.thenComparing(keyExtractor, Comparator.reverseOrder());
            }
            return comparator;
        }
        return comparator;
    }

    private Comparator<ClientHealthSnapshotVO> b(Comparator<ClientHealthSnapshotVO> comparator, Function<ClientHealthSnapshotVO, Long> keyExtractor, String direction, int field, int scope) {
        if (field == scope) {
            if (Objects.equals("asc", direction)) {
                return comparator.thenComparing(keyExtractor, Comparator.naturalOrder());
            }
            if (Objects.equals("desc", direction)) {
                return comparator.thenComparing(keyExtractor, Comparator.reverseOrder());
            }
            return comparator;
        }
        return comparator;
    }

    private Comparator<ClientHealthSnapshotVO> c(Comparator<ClientHealthSnapshotVO> comparator, Function<ClientHealthSnapshotVO, String> keyExtractor, String direction, int field, int scope) {
        if (field == scope) {
            if (Objects.equals("asc", direction)) {
                return comparator.thenComparing(keyExtractor, Comparator.naturalOrder());
            }
            if (Objects.equals("desc", direction)) {
                return comparator.thenComparing(keyExtractor, Comparator.reverseOrder());
            }
            return comparator;
        }
        return comparator;
    }

    private long a(long currentEnd, long queryEnd, long timeunit) {
        while (currentEnd + timeunit < queryEnd) {
            currentEnd += timeunit;
        }
        return currentEnd;
    }

    private Long a(Integer granularity) {
        if (Objects.isNull(granularity)) {
            return null;
        }
        switch (granularity) {
            case 0: {
                return 600L;
            }
            case 1: {
                return 3600L;
            }
            case 2: {
                return 86400L;
            }
        }
        return null;
    }

    private long a(@Nonnull N granularityEnum) {
        switch (granularityEnum) {
            case b: {
                return 600L;
            }
            case c: {
                return 3600L;
            }
        }
        return 86400L;
    }

    private long b(@Nonnull N granularityEnum) {
        if (granularityEnum == N.b) {
            return 600L;
        }
        return 3600L;
    }

    private List<DeviceHealthVO> d(DeviceHealthScoreQueryDTO query, N granularity) {
        List<OsgHealthScoreDTO> osgHealthScoreList = this.e.a(query, granularity);
        com.tplink.smb.omada.monitor.api.internal.statistic.dto.b request = this.c(query, granularity);
        Map osgHealthStatDTOMap = this.h.a(request);
        ArrayList<DeviceHealthVO> deviceHealthVOList = new ArrayList<DeviceHealthVO>();
        osgHealthScoreList.forEach(osgHealthScoreDTO -> {
            long timestamp = osgHealthScoreDTO.getTimestamp();
            ArrayList<OsgHealthStatDTO> list = new ArrayList<OsgHealthStatDTO>();
            if (Objects.equals(osgHealthScoreDTO.getScore(), -1)) {
                deviceHealthVOList.add(new DeviceHealthVO(Long.valueOf(timestamp), Integer.valueOf(-1)));
                return;
            }
            if (osgHealthStatDTOMap.containsKey(timestamp)) {
                list.add((OsgHealthStatDTO)osgHealthStatDTOMap.get(timestamp));
            }
            if (osgHealthStatDTOMap.containsKey(timestamp - 300L)) {
                list.add((OsgHealthStatDTO)osgHealthStatDTOMap.get(timestamp - 300L));
            }
            if (!CollectionUtils.isEmpty(list)) {
                deviceHealthVOList.add(com.tplink.smb.omada.anomaly.core.a.a.a.a((Long)timestamp, osgHealthScoreDTO.getScore(), osgHealthScoreDTO.getHighestAnomalyLevel(), osgHealthScoreDTO.getAnomalyCount(), osgHealthScoreDTO, list));
            } else {
                deviceHealthVOList.add(new DeviceHealthVO(Long.valueOf(timestamp), osgHealthScoreDTO.getScore(), osgHealthScoreDTO.getHighestAnomalyLevel(), osgHealthScoreDTO.getAnomalyCount(), osgHealthScoreDTO));
            }
        });
        return deviceHealthVOList;
    }

    public static class a {
        private int a;
        private int b;
        private long c;
        private long d;
        private long e;
        private long f;
        private boolean g;
        private int h;

        @Generated
        public int a() {
            return this.a;
        }

        @Generated
        public int b() {
            return this.b;
        }

        @Generated
        public long c() {
            return this.c;
        }

        @Generated
        public long d() {
            return this.d;
        }

        @Generated
        public long e() {
            return this.e;
        }

        @Generated
        public long f() {
            return this.f;
        }

        @Generated
        public boolean g() {
            return this.g;
        }

        @Generated
        public int h() {
            return this.h;
        }

        @Generated
        public void a(int currentPage) {
            this.a = currentPage;
        }

        @Generated
        public void b(int currentPageSize) {
            this.b = currentPageSize;
        }

        @Generated
        public void a(long healthTimeunit) {
            this.c = healthTimeunit;
        }

        @Generated
        public void b(long statTimeunit) {
            this.d = statTimeunit;
        }

        @Generated
        public void c(long healthTime) {
            this.e = healthTime;
        }

        @Generated
        public void d(long statTime) {
            this.f = statTime;
        }

        @Generated
        public void a(boolean realtime) {
            this.g = realtime;
        }

        @Generated
        public void c(int granularity) {
            this.h = granularity;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof a)) {
                return false;
            }
            a other = (a)o2;
            if (!other.a(this)) {
                return false;
            }
            if (this.a() != other.a()) {
                return false;
            }
            if (this.b() != other.b()) {
                return false;
            }
            if (this.c() != other.c()) {
                return false;
            }
            if (this.d() != other.d()) {
                return false;
            }
            if (this.e() != other.e()) {
                return false;
            }
            if (this.f() != other.f()) {
                return false;
            }
            if (this.g() != other.g()) {
                return false;
            }
            return this.h() == other.h();
        }

        @Generated
        protected boolean a(Object other) {
            return other instanceof a;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.a();
            result = result * 59 + this.b();
            long $healthTimeunit = this.c();
            result = result * 59 + (int)($healthTimeunit >>> 32 ^ $healthTimeunit);
            long $statTimeunit = this.d();
            result = result * 59 + (int)($statTimeunit >>> 32 ^ $statTimeunit);
            long $healthTime = this.e();
            result = result * 59 + (int)($healthTime >>> 32 ^ $healthTime);
            long $statTime = this.f();
            result = result * 59 + (int)($statTime >>> 32 ^ $statTime);
            result = result * 59 + (this.g() ? 79 : 97);
            result = result * 59 + this.h();
            return result;
        }

        @Generated
        public String toString() {
            return "HealthQueryApplicationServiceImpl.ClientSnapshotQueryInfo(currentPage=" + this.a() + ", currentPageSize=" + this.b() + ", healthTimeunit=" + this.c() + ", statTimeunit=" + this.d() + ", healthTime=" + this.e() + ", statTime=" + this.f() + ", realtime=" + this.g() + ", granularity=" + this.h() + ")";
        }

        @Generated
        public a() {
        }

        @Generated
        public a(int currentPage, int currentPageSize, long healthTimeunit, long statTimeunit, long healthTime, long statTime, boolean realtime, int granularity) {
            this.a = currentPage;
            this.b = currentPageSize;
            this.c = healthTimeunit;
            this.d = statTimeunit;
            this.e = healthTime;
            this.f = statTime;
            this.g = realtime;
            this.h = granularity;
        }
    }
}

