/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.global.configuration.port.cache.log;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tplink.smb.omada.common.obfuscate.KeepClassNameAndSetter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AuditLogCategoryCache {
    private static final Logger c = LoggerFactory.getLogger(AuditLogCategoryCache.class);
    public static final String a = "/json/GlobalAuditLogCategory.json";
    public static final String b = "auditLogCategory";
    private static Map<String, AuditLogCategory> d = new LinkedHashMap<String, AuditLogCategory>(36);
    private static AtomicInteger e = new AtomicInteger(0);
    private static AtomicInteger f = new AtomicInteger(0);
    private static AtomicInteger g = new AtomicInteger(0);

    private AuditLogCategoryCache() {
    }

    private static void e() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        d.clear();
        try (InputStream inputStream = AuditLogCategoryCache.class.getResourceAsStream(a);){
            Map map = (Map)objectMapper.readValue(inputStream, Map.class);
            List auditLogs = (List)map.get(b);
            if (CollectionUtils.isEmpty((Collection)auditLogs)) {
                c.warn("Failed to get audit category from json file.");
                return;
            }
            for (Map kv : auditLogs) {
                AuditLogCategory logType = (AuditLogCategory)objectMapper.convertValue((Object)kv, AuditLogCategory.class);
                if (Objects.isNull(logType)) continue;
                logType.setMsp(Boolean.TRUE.equals(logType.c()));
                logType.setGlobal(Boolean.TRUE.equals(logType.d()));
                logType.setSite(Boolean.TRUE.equals(logType.e()));
                logType.setShortMsg(logType.b());
                if (Boolean.TRUE.equals(logType.c())) {
                    g.incrementAndGet();
                }
                if (Boolean.TRUE.equals(logType.d())) {
                    f.incrementAndGet();
                }
                if (Boolean.TRUE.equals(logType.e())) {
                    e.incrementAndGet();
                }
                d.putIfAbsent(logType.a(), logType);
            }
        }
        catch (IOException e2) {
            d.clear();
            c.warn("Failed to read json file {}", (Object)a, (Object)e2);
        }
    }

    public static AuditLogCategory a(String key) {
        return d.get(key);
    }

    public static String b(String key) {
        if (Objects.isNull(d) || Objects.isNull(d.get(key))) {
            return "";
        }
        return d.get(key).b();
    }

    public static String c(String shortMsg) {
        if (Objects.isNull(d)) {
            return "";
        }
        Collection<AuditLogCategory> values = d.values();
        for (AuditLogCategory value : values) {
            if (!value.b().equals(shortMsg)) continue;
            return value.a();
        }
        return "";
    }

    public static int a() {
        if (Objects.isNull(e)) {
            return 0;
        }
        return e.get();
    }

    public static int b() {
        if (Objects.isNull(f)) {
            return 0;
        }
        return f.get();
    }

    public static int c() {
        if (Objects.isNull(g)) {
            return 0;
        }
        return g.get();
    }

    public static Map<String, AuditLogCategory> d() {
        return Collections.unmodifiableMap(d);
    }

    static {
        AuditLogCategoryCache.e();
    }

    @KeepClassNameAndSetter
    public static class AuditLogCategory {
        @JsonProperty(value="key")
        private String a;
        @JsonProperty(value="shortMsg")
        private String b;
        @JsonProperty(value="msp")
        private Boolean c;
        @JsonProperty(value="global")
        private Boolean d;
        @JsonProperty(value="site")
        private Boolean e;
        @JsonProperty(value="webhook")
        private Boolean f;
        @JsonProperty(value="network")
        private Boolean g;

        public String a() {
            return this.a;
        }

        public String b() {
            return this.b;
        }

        public Boolean c() {
            return this.c;
        }

        public Boolean d() {
            return this.d;
        }

        public Boolean e() {
            return this.e;
        }

        public Boolean f() {
            return this.f;
        }

        public Boolean g() {
            return this.g;
        }

        @JsonProperty(value="key")
        public void setKey(String key) {
            this.a = key;
        }

        @JsonProperty(value="shortMsg")
        public void setShortMsg(String shortMsg) {
            this.b = shortMsg;
        }

        @JsonProperty(value="msp")
        public void setMsp(Boolean msp) {
            this.c = msp;
        }

        @JsonProperty(value="global")
        public void setGlobal(Boolean global) {
            this.d = global;
        }

        @JsonProperty(value="site")
        public void setSite(Boolean site) {
            this.e = site;
        }

        @JsonProperty(value="webhook")
        public void setWebhook(Boolean webhook) {
            this.f = webhook;
        }

        @JsonProperty(value="network")
        public void setNetwork(Boolean network) {
            this.g = network;
        }

        public String toString() {
            return "AuditLogCategoryCache.AuditLogCategory(key=" + this.a() + ", shortMsg=" + this.b() + ", msp=" + this.c() + ", global=" + this.d() + ", site=" + this.e() + ", webhook=" + this.f() + ", network=" + this.g() + ")";
        }
    }
}

