/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.global.configuration.domain.model.log.a;

import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.error.ErrorCode;
import com.tplink.smb.omada.global.configuration.api.web.dto.log.NotificationSettingVO;
import com.tplink.smb.omada.global.configuration.api.web.dto.log.NotificationVO;
import com.tplink.smb.omada.global.configuration.domain.model.log.CentralLogGlobalSetting;
import com.tplink.smb.omada.global.configuration.domain.model.log.Notification;
import com.tplink.smb.omada.global.configuration.domain.model.log.c;
import com.tplink.smb.omada.global.configuration.domain.model.log.d;
import com.tplink.smb.omada.global.configuration.domain.model.webhook.WebhookConfig;
import com.tplink.smb.omada.global.configuration.port.cache.log.CentralEventTypeCache;
import com.tplink.smb.omada.global.subsystem.api.internal.dto.log.NotificationDTO;
import com.tplink.smb.omada.global.subsystem.api.internal.dto.log.WebhookConfigDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class a {
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    private c b;

    public OperationResponse<Void> a(String centralId, NotificationSettingVO notificationSettingVO) {
        if (T.a((String)centralId) || Objects.isNull(notificationSettingVO) || Objects.isNull(notificationSettingVO.getEventNotifications())) {
            return new OperationResponse((ErrorCode)com.tplink.smb.omada.global.common.a.a.c);
        }
        Optional<CentralLogGlobalSetting> centralLogSettingOptional = this.b.a(centralId);
        if (!centralLogSettingOptional.isPresent()) {
            a.warn("modify notification failed because global log setting is empty, centralId:{}", (Object)centralId);
            return new OperationResponse((ErrorCode)com.tplink.smb.omada.global.common.a.a.b);
        }
        CentralLogGlobalSetting centralLogGlobalSetting = centralLogSettingOptional.get();
        if (CollectionUtils.isEmpty(centralLogGlobalSetting.getEventNotifications())) {
            a.warn("modify notification failed because global notifications is empty, centralId:{}", (Object)centralId);
            return new OperationResponse((ErrorCode)com.tplink.smb.omada.global.common.a.a.b);
        }
        List<Notification> eventNotifications = centralLogGlobalSetting.getEventNotifications();
        List eventNotificationVO = notificationSettingVO.getEventNotifications();
        for (NotificationVO notificationVO : eventNotificationVO) {
            if (this.a(notificationVO, eventNotifications)) continue;
            a.warn("fail to find log notification by key :{}", (Object)notificationVO.getKey());
            return new OperationResponse((ErrorCode)com.tplink.smb.omada.global.common.a.a.b);
        }
        ArrayList<Notification> saveEventNotifications = new ArrayList<Notification>(eventNotifications.size());
        for (Notification notification : eventNotifications) {
            Notification transResult = Notification.transferVO(notification, eventNotificationVO);
            if (!Objects.nonNull(transResult)) continue;
            saveEventNotifications.add(transResult);
        }
        this.b.a(centralId).ifPresent(logGlobalSetting -> this.b.a(logGlobalSetting.modifyCentralLogGlobalSetting(saveEventNotifications, notificationSettingVO.getWebhookSetting())));
        return OperationResponse.success(null);
    }

    public OperationResponse<Void> a(String centralId, List<NotificationDTO> eventNotifications, WebhookConfigDTO webhookSetting) {
        CentralLogGlobalSetting globalLogSetting;
        Optional<CentralLogGlobalSetting> globalSettingOptional = this.b.a(centralId);
        if (globalSettingOptional.isEmpty()) {
            a.info("network modify notification failed because global log setting is empty, centralId:{}", (Object)centralId);
            globalLogSetting = CentralLogGlobalSetting.builder().a(this.b.a()).b(centralId).a(CollectionUtils.isEmpty(eventNotifications) ? new ArrayList<Notification>() : eventNotifications.stream().map(Notification::fromDTO).toList()).a(WebhookConfig.fromDTO(webhookSetting)).a();
        } else {
            globalLogSetting = globalSettingOptional.get();
        }
        List<Notification> centralEventNotifications = globalLogSetting.getEventNotifications();
        if (!CollectionUtils.isEmpty(eventNotifications) && !CollectionUtils.isEmpty(centralEventNotifications)) {
            Map<String, NotificationDTO> logkeyNotificationMap = eventNotifications.stream().collect(Collectors.toMap(NotificationDTO::getKey, notificationDTO -> notificationDTO));
            for (Notification notification : centralEventNotifications) {
                NotificationDTO notificationDTO2 = logkeyNotificationMap.get(notification.getCentralLogEnumKey());
                if (Objects.isNull(notificationDTO2)) continue;
                d notificationConfiguration = notification.getNotificationConfiguration();
                if (Objects.isNull(notificationConfiguration)) {
                    a.warn("network Failed to find notification config, centralId: {}, log key: {}", (Object)centralId, (Object)notification.getCentralLogEnumKey());
                    continue;
                }
                notificationConfiguration.a(notificationDTO2.getEnable());
                if (Boolean.TRUE.equals(notificationConfiguration.c())) {
                    notificationConfiguration.a(notificationDTO2.getLevel());
                }
                notificationConfiguration.d(notificationDTO2.getEmail());
                notificationConfiguration.e(notificationDTO2.getWebhook());
            }
        }
        if (!Objects.isNull(webhookSetting)) {
            WebhookConfig centralWebhookConfig = Optional.ofNullable(globalLogSetting.getWebhookSetting()).orElse((WebhookConfig)WebhookConfig.builder().b());
            centralWebhookConfig.setWebhookEnable(Objects.isNull(webhookSetting.getWebhookEnable()) ? Boolean.FALSE : webhookSetting.getWebhookEnable());
            centralWebhookConfig.setWebhookId(webhookSetting.getWebhookId());
            globalLogSetting.setWebhookSetting(centralWebhookConfig);
        }
        a.debug("orgId:{}, modifyLogGlobalSettingsForNetwork to save data: {}", (Object)centralId, (Object)globalLogSetting);
        this.b.a(globalLogSetting);
        return OperationResponse.success(null);
    }

    public OperationResponse<Boolean> a(String centralId) {
        if (Objects.isNull(centralId)) {
            return new OperationResponse((ErrorCode)com.tplink.smb.omada.global.common.a.a.c);
        }
        Map<String, CentralEventTypeCache.LogType> logTypeMap = CentralEventTypeCache.a();
        List notificationList = this.b.a(centralId).map(CentralLogGlobalSetting::getEventNotifications).orElse(Collections.emptyList());
        ArrayList<Notification> saveNotificationList = new ArrayList<Notification>(notificationList.size());
        boolean notificationModify = false;
        for (Notification notification : notificationList) {
            CentralEventTypeCache.LogType logType = logTypeMap.get(notification.getCentralLogEnumKey());
            if (Objects.isNull(logType)) {
                a.warn("Fail to find global logType by key :{}", (Object)notification.getCentralLogEnumKey());
                continue;
            }
            if (this.a(notification.getNotificationConfiguration(), logType)) {
                notificationModify = true;
            }
            d notificationConfiguration = new d();
            notificationConfiguration.a(logType.g());
            notificationConfiguration.d(logType.i());
            notificationConfiguration.c(logType.h());
            notificationConfiguration.e(logType.j());
            notificationConfiguration.f(logType.p());
            notification.setNotificationConfiguration(notificationConfiguration);
            saveNotificationList.add(notification);
        }
        if (!notificationModify) {
            return OperationResponse.success((Object)Boolean.FALSE);
        }
        this.b.a(centralId).ifPresent(logGlobalSetting -> this.b.a(logGlobalSetting.modifyNotification(saveNotificationList)));
        return OperationResponse.success((Object)Boolean.TRUE);
    }

    private boolean a(NotificationVO notificationVO, List<Notification> notifications) {
        Notification notification = notifications.stream().filter(item -> T.a((String)notificationVO.getKey(), (String)item.getCentralLogEnumKey())).findFirst().orElse(null);
        return Objects.nonNull(notification);
    }

    private boolean a(d configuration, CentralEventTypeCache.LogType logType) {
        return !Objects.equals(logType.g(), configuration.b()) || !Objects.equals(logType.i(), configuration.f()) || Objects.nonNull(logType.j()) && !Objects.equals(logType.j(), configuration.g());
    }
}

