/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.global.configuration.domain.model.log;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.global.configuration.api.web.dto.log.NotificationVO;
import com.tplink.smb.omada.global.configuration.domain.model.log.d;
import com.tplink.smb.omada.global.configuration.domain.model.log.e;
import com.tplink.smb.omada.global.configuration.port.cache.log.CentralEventTypeCache;
import com.tplink.smb.omada.global.subsystem.api.internal.dto.log.NotificationDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@KeepClass
public class Notification {
    private static final Logger log = LoggerFactory.getLogger(Notification.class);
    protected String centralLogEnumKey;
    protected e notificationTypeEnum;
    protected com.tplink.smb.omada.global.configuration.domain.model.log.a module;
    protected d notificationConfiguration;

    public static List<Notification> buildDefaultGlobalEventNotifications(@Nonnull String centralId) {
        Map<String, CentralEventTypeCache.LogType> logTypeMap = CentralEventTypeCache.a();
        if (CollectionUtils.isEmpty(logTypeMap)) {
            log.error("centralId={} log type cache is empty.", (Object)centralId);
            return Collections.emptyList();
        }
        ArrayList<Notification> notifications = new ArrayList<Notification>(4);
        logTypeMap.forEach((key, logType) -> {
            if (!Boolean.TRUE.equals(logType.k())) {
                return;
            }
            d notificationConfiguration = d.a().a(logType.g()).d(logType.i()).e(logType.j()).f(logType.p()).a();
            log.debug("centralId={} initial central log global setting notification success.", (Object)centralId);
            notifications.add(Notification.builder().a((String)key).a(e.b).a(notificationConfiguration).a(com.tplink.smb.omada.global.configuration.domain.model.log.a.a(logType.d())).a());
        });
        return notifications;
    }

    public static List<NotificationDTO> buildDefaultGlobalEventNotificationForNetwork() {
        ArrayList<NotificationDTO> notificationDTOS = new ArrayList<NotificationDTO>();
        NotificationDTO notificationDTO = NotificationDTO.builder().enable(Boolean.valueOf(false)).key("DEV_DISCOVERY").module(com.tplink.smb.omada.global.configuration.domain.model.log.a.d.a()).event(Boolean.valueOf(true)).email(Boolean.valueOf(false)).webhook(Boolean.valueOf(false)).build();
        notificationDTOS.add(notificationDTO);
        return notificationDTOS;
    }

    public static NotificationDTO toDTO(Notification notification) {
        NotificationDTO dto = new NotificationDTO();
        dto.setKey(notification.getCentralLogEnumKey());
        dto.setModule(notification.getModule().a());
        dto.setEnable(notification.getNotificationConfiguration().b());
        dto.setEmail(notification.getNotificationConfiguration().f());
        dto.setAlert(notification.getNotificationConfiguration().c());
        dto.setEvent(notification.getNotificationConfiguration().d());
        dto.setLevel(notification.getNotificationConfiguration().e());
        dto.setWebhook(notification.getNotificationConfiguration().g());
        return dto;
    }

    public static Notification fromDTO(NotificationDTO dto) {
        Notification notification = new Notification();
        notification.setCentralLogEnumKey(dto.getKey());
        notification.setModule(com.tplink.smb.omada.global.configuration.domain.model.log.a.a(dto.getModule()));
        notification.setNotificationConfiguration(d.a().a(dto.getEnable()).d(dto.getEmail()).e(dto.getWebhook()).a());
        return notification;
    }

    public static NotificationVO toVO(Notification notification) {
        NotificationVO vo = new NotificationVO();
        vo.setKey(notification.getCentralLogEnumKey());
        vo.setModule(notification.getModule().a());
        CentralEventTypeCache.LogType logType = CentralEventTypeCache.a(notification.getCentralLogEnumKey());
        if (logType != null) {
            vo.setShortMsg(logType.b());
            if (Objects.isNull((Object)notification.getModule())) {
                vo.setModule(logType.d());
            }
        }
        vo.setEnable(notification.getNotificationConfiguration().b());
        vo.setEmail(notification.getNotificationConfiguration().f());
        vo.setWebhook(notification.getNotificationConfiguration().g());
        return vo;
    }

    public static Notification transferVO(Notification notification, List<NotificationVO> notificationVOList) {
        NotificationVO notificationVO = notificationVOList.stream().filter(item -> T.a((String)notification.getCentralLogEnumKey(), (String)item.getKey())).findFirst().orElse(null);
        if (Objects.nonNull(notificationVO)) {
            d notificationConfiguration = d.a().a(notificationVO.getEnable()).d(notificationVO.getEmail()).e(Optional.ofNullable(notificationVO.getWebhook()).orElse(notification.getNotificationConfiguration().g())).a();
            notification.setNotificationConfiguration(notificationConfiguration);
        }
        return notification;
    }

    public static a builder() {
        return new a();
    }

    public String getCentralLogEnumKey() {
        return this.centralLogEnumKey;
    }

    public e getNotificationTypeEnum() {
        return this.notificationTypeEnum;
    }

    public com.tplink.smb.omada.global.configuration.domain.model.log.a getModule() {
        return this.module;
    }

    public d getNotificationConfiguration() {
        return this.notificationConfiguration;
    }

    public void setCentralLogEnumKey(String centralLogEnumKey) {
        this.centralLogEnumKey = centralLogEnumKey;
    }

    public void setNotificationTypeEnum(e notificationTypeEnum) {
        this.notificationTypeEnum = notificationTypeEnum;
    }

    public void setModule(com.tplink.smb.omada.global.configuration.domain.model.log.a module) {
        this.module = module;
    }

    public void setNotificationConfiguration(d notificationConfiguration) {
        this.notificationConfiguration = notificationConfiguration;
    }

    public Notification() {
    }

    public Notification(String centralLogEnumKey, e notificationTypeEnum, com.tplink.smb.omada.global.configuration.domain.model.log.a module, d notificationConfiguration) {
        this.centralLogEnumKey = centralLogEnumKey;
        this.notificationTypeEnum = notificationTypeEnum;
        this.module = module;
        this.notificationConfiguration = notificationConfiguration;
    }

    public static class a {
        private String a;
        private e b;
        private com.tplink.smb.omada.global.configuration.domain.model.log.a c;
        private d d;

        a() {
        }

        public a a(String centralLogEnumKey) {
            this.a = centralLogEnumKey;
            return this;
        }

        public a a(e notificationTypeEnum) {
            this.b = notificationTypeEnum;
            return this;
        }

        public a a(com.tplink.smb.omada.global.configuration.domain.model.log.a module) {
            this.c = module;
            return this;
        }

        public a a(d notificationConfiguration) {
            this.d = notificationConfiguration;
            return this;
        }

        public Notification a() {
            return new Notification(this.a, this.b, this.c, this.d);
        }

        public String toString() {
            return "Notification.NotificationBuilder(centralLogEnumKey=" + this.a + ", notificationTypeEnum=" + this.b + ", module=" + this.c + ", notificationConfiguration=" + this.d + ")";
        }
    }
}

