/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.global.configuration.domain.model.auditlog.service;

import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.error.ErrorCode;
import com.tplink.smb.omada.global.common.dto.AuditLogNotificationDTO;
import com.tplink.smb.omada.global.common.dto.WebhookSettingDTO;
import com.tplink.smb.omada.global.configuration.api.web.dto.auditlog.AuditLogNotificationSettingVO;
import com.tplink.smb.omada.global.configuration.api.web.dto.log.WebhookConfigVO;
import com.tplink.smb.omada.global.configuration.domain.model.auditlog.CentralAuditLogGlobalSetting;
import com.tplink.smb.omada.global.configuration.domain.model.auditlog.CentralAuditLogNotification;
import com.tplink.smb.omada.global.configuration.domain.model.auditlog.a;
import com.tplink.smb.omada.global.configuration.domain.model.webhook.WebhookConfig;
import com.tplink.smb.omada.global.configuration.domain.model.webhook.a.f;
import com.tplink.smb.omada.global.subsystem.api.internal.dto.log.WebhookConfigDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class b {
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    private a b;
    @Autowired
    private f c;

    public OperationResponse<Void> a(String centralId, AuditLogNotificationSettingVO vo) {
        if (T.a((String)centralId) || Objects.isNull(vo) || Objects.isNull(vo.getLogNotifications())) {
            return new OperationResponse((ErrorCode)com.tplink.smb.omada.global.common.a.a.c);
        }
        if (!this.a(centralId, vo.getWebhookSetting())) {
            a.info("modify notification failed because webhookSetting is invalid, centralId:{}", (Object)centralId);
            return new OperationResponse((ErrorCode)com.tplink.smb.omada.global.common.a.a.B);
        }
        Optional<CentralAuditLogGlobalSetting> auditLogGlobalSettingOptional = this.b.a(centralId);
        if (!auditLogGlobalSettingOptional.isPresent()) {
            a.warn("modify notification failed because global audit log setting is empty, centralId:{}", (Object)centralId);
            return new OperationResponse((ErrorCode)com.tplink.smb.omada.global.common.a.a.b);
        }
        CentralAuditLogGlobalSetting auditLogGlobalSetting = auditLogGlobalSettingOptional.get();
        if (CollectionUtils.isEmpty(auditLogGlobalSetting.getNotifications())) {
            a.warn("modify audit log notification failed because global notifications is empty, centralId:{}", (Object)centralId);
            return new OperationResponse((ErrorCode)com.tplink.smb.omada.global.common.a.a.b);
        }
        List<CentralAuditLogNotification> notifications = auditLogGlobalSetting.getNotifications();
        List notificationVOList = vo.getLogNotifications();
        for (AuditLogNotificationDTO notificationVO : notificationVOList) {
            if (this.a(notificationVO, notifications)) continue;
            a.warn("fail to find audit log notification by key :{}", (Object)notificationVO.getKey());
            return new OperationResponse((ErrorCode)com.tplink.smb.omada.global.common.a.a.b);
        }
        ArrayList<CentralAuditLogNotification> saveEventNotifications = new ArrayList<CentralAuditLogNotification>(notificationVOList.size());
        for (CentralAuditLogNotification notification : notifications) {
            CentralAuditLogNotification transResult = CentralAuditLogNotification.fromVO(notification, notificationVOList);
            if (!Objects.nonNull(transResult)) continue;
            saveEventNotifications.add(transResult);
        }
        auditLogGlobalSetting.setNotifications(saveEventNotifications);
        auditLogGlobalSetting.setWebhookSetting(WebhookConfig.fromVO(vo.getWebhookSetting()));
        this.b.a(auditLogGlobalSetting);
        return OperationResponse.success(null);
    }

    public OperationResponse<Void> a(String centralId, List<AuditLogNotificationDTO> notifications, WebhookConfigDTO webhookSetting) {
        CentralAuditLogGlobalSetting auditLogGlobalSetting;
        Optional<CentralAuditLogGlobalSetting> auditLogGlobalSettingOptional = this.b.a(centralId);
        if (auditLogGlobalSettingOptional.isEmpty()) {
            a.info("network modify notification failed because global audit log setting is empty, centralId:{}", (Object)centralId);
            auditLogGlobalSetting = CentralAuditLogGlobalSetting.builder().a(this.b.a()).b(centralId).a(CollectionUtils.isEmpty(notifications) ? new ArrayList<CentralAuditLogNotification>() : notifications.stream().map(CentralAuditLogNotification::fromDTO).toList()).a(WebhookConfig.fromDTO(webhookSetting)).a();
        } else {
            auditLogGlobalSetting = auditLogGlobalSettingOptional.get();
        }
        List<CentralAuditLogNotification> centralAuditLogNotifications = auditLogGlobalSetting.getNotifications();
        if (!CollectionUtils.isEmpty(notifications) && !CollectionUtils.isEmpty(centralAuditLogNotifications)) {
            Map<String, AuditLogNotificationDTO> auditLogNotificationMap = notifications.stream().collect(Collectors.toMap(AuditLogNotificationDTO::getKey, auditLogNotificationDTO -> auditLogNotificationDTO));
            for (CentralAuditLogNotification centralAuditLogNotification : centralAuditLogNotifications) {
                AuditLogNotificationDTO auditLogNotificationDTO2 = auditLogNotificationMap.get(centralAuditLogNotification.getAuditCategoryKey());
                if (Objects.isNull(auditLogNotificationDTO2)) continue;
                centralAuditLogNotification.setWebhook(auditLogNotificationDTO2.getWebhook());
            }
        }
        if (Objects.nonNull(webhookSetting)) {
            WebhookConfig centralWebhookConfig = Optional.ofNullable(auditLogGlobalSetting.getWebhookSetting()).orElse((WebhookConfig)WebhookConfig.builder().b());
            centralWebhookConfig.setWebhookEnable(Objects.isNull(webhookSetting.getWebhookEnable()) ? Boolean.FALSE : webhookSetting.getWebhookEnable());
            centralWebhookConfig.setWebhookId(webhookSetting.getWebhookId());
            auditLogGlobalSetting.setWebhookSetting(centralWebhookConfig);
        }
        a.debug("orgId:{}, Network modify auditLogGlobalSettings to save data: {}", (Object)centralId, (Object)auditLogGlobalSetting);
        this.b.a(auditLogGlobalSetting);
        return OperationResponse.success(null);
    }

    private boolean a(AuditLogNotificationDTO notificationVO, List<CentralAuditLogNotification> notifications) {
        CentralAuditLogNotification notification = notifications.stream().filter(item -> T.a((String)notificationVO.getKey(), (String)item.getAuditCategoryKey())).findFirst().orElse(null);
        return Objects.nonNull(notification);
    }

    private boolean a(String centralId, WebhookConfigVO vo) {
        if (Boolean.TRUE.equals(vo.getWebhookEnable())) {
            Optional<WebhookSettingDTO> webhookSetting = this.c.a(centralId, vo.getWebhookId());
            return webhookSetting.isPresent();
        }
        return true;
    }
}

