/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.global.configuration.domain.model.auditlog;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.global.common.dto.AuditLogNotificationDTO;
import com.tplink.smb.omada.global.common.util.j;
import com.tplink.smb.omada.global.configuration.domain.model.log.e;
import com.tplink.smb.omada.global.configuration.port.cache.log.AuditLogCategoryCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@KeepClass
public class CentralAuditLogNotification {
    private static final Logger log = LoggerFactory.getLogger(CentralAuditLogNotification.class);
    private e notificationTypeEnum;
    private String auditCategoryKey;
    private Boolean webhook;
    private Boolean network;

    public static CentralAuditLogNotification fromVO(CentralAuditLogNotification notification, List<AuditLogNotificationDTO> notificationVOList) {
        AuditLogNotificationDTO notificationVO = notificationVOList.stream().filter(item -> j.a((String)notification.getAuditCategoryKey(), (String)item.getKey())).findFirst().orElse(null);
        if (Objects.nonNull(notificationVO)) {
            notification.setWebhook(notificationVO.getWebhook());
        }
        return notification;
    }

    public static List<CentralAuditLogNotification> buildDefaultGlobalNotifications(@Nonnull String centralId) {
        Map<String, AuditLogCategoryCache.AuditLogCategory> categoryCache = AuditLogCategoryCache.d();
        if (CollectionUtils.isEmpty(categoryCache)) {
            log.warn("centralId:{} Failed to get audit log type cache is empty.", (Object)centralId);
            return Collections.emptyList();
        }
        ArrayList notifications = new ArrayList(categoryCache.size());
        categoryCache.forEach((key, logCategory) -> {
            if (Boolean.TRUE.equals(logCategory.d())) {
                notifications.add(CentralAuditLogNotification.builder().a((String)key).a(e.b).a(logCategory.f()).b(logCategory.g()).a());
            }
        });
        log.info("centralId:{}.Initial audit log global setting notification success.", (Object)centralId);
        return notifications.stream().sorted(Comparator.comparing(CentralAuditLogNotification::getAuditCategoryKey)).collect(Collectors.toList());
    }

    public static List<AuditLogNotificationDTO> buildDefaultGlobalNotificationsForNetwork() {
        ArrayList<AuditLogNotificationDTO> notifications = new ArrayList<AuditLogNotificationDTO>();
        AuditLogNotificationDTO logNotification = AuditLogNotificationDTO.builder().key("LOG").shortMsg("Log").webhook(Boolean.valueOf(false)).build();
        notifications.add(logNotification);
        AuditLogNotificationDTO dataExportNotification = AuditLogNotificationDTO.builder().key("DATA_EXPORT").shortMsg("Data Export").webhook(Boolean.valueOf(false)).build();
        notifications.add(dataExportNotification);
        AuditLogNotificationDTO firmwareNotification = AuditLogNotificationDTO.builder().key("FIRMWARE").shortMsg("Firmware").webhook(Boolean.valueOf(false)).build();
        notifications.add(firmwareNotification);
        AuditLogNotificationDTO siteTemplateNotification = AuditLogNotificationDTO.builder().key("SITE_TEMPLATE").shortMsg("Site Template").webhook(Boolean.valueOf(false)).build();
        notifications.add(siteTemplateNotification);
        return notifications;
    }

    public static AuditLogNotificationDTO toDTO(CentralAuditLogNotification notification) {
        return AuditLogNotificationDTO.builder().key(notification.getAuditCategoryKey()).shortMsg(AuditLogCategoryCache.b(notification.getAuditCategoryKey())).webhook(notification.getWebhook()).build();
    }

    public static CentralAuditLogNotification fromDTO(AuditLogNotificationDTO dto) {
        return CentralAuditLogNotification.builder().a(e.a(dto.getKey())).a(AuditLogCategoryCache.c(dto.getShortMsg())).a(dto.getWebhook()).a();
    }

    public static a builder() {
        return new a();
    }

    public e getNotificationTypeEnum() {
        return this.notificationTypeEnum;
    }

    public String getAuditCategoryKey() {
        return this.auditCategoryKey;
    }

    public Boolean getWebhook() {
        return this.webhook;
    }

    public Boolean getNetwork() {
        return this.network;
    }

    public void setNotificationTypeEnum(e notificationTypeEnum) {
        this.notificationTypeEnum = notificationTypeEnum;
    }

    public void setAuditCategoryKey(String auditCategoryKey) {
        this.auditCategoryKey = auditCategoryKey;
    }

    public void setWebhook(Boolean webhook) {
        this.webhook = webhook;
    }

    public void setNetwork(Boolean network) {
        this.network = network;
    }

    public CentralAuditLogNotification(e notificationTypeEnum, String auditCategoryKey, Boolean webhook, Boolean network) {
        this.notificationTypeEnum = notificationTypeEnum;
        this.auditCategoryKey = auditCategoryKey;
        this.webhook = webhook;
        this.network = network;
    }

    public CentralAuditLogNotification() {
    }

    public static class a {
        private e a;
        private String b;
        private Boolean c;
        private Boolean d;

        a() {
        }

        public a a(e notificationTypeEnum) {
            this.a = notificationTypeEnum;
            return this;
        }

        public a a(String auditCategoryKey) {
            this.b = auditCategoryKey;
            return this;
        }

        public a a(Boolean webhook) {
            this.c = webhook;
            return this;
        }

        public a b(Boolean network) {
            this.d = network;
            return this;
        }

        public CentralAuditLogNotification a() {
            return new CentralAuditLogNotification(this.a, this.b, this.c, this.d);
        }

        public String toString() {
            return "CentralAuditLogNotification.CentralAuditLogNotificationBuilder(notificationTypeEnum=" + this.a + ", auditCategoryKey=" + this.b + ", webhook=" + this.c + ", network=" + this.d + ")";
        }
    }
}

