/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.resolver.impl.MacFormatEnum;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.b;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class OmadacMacFormatCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OmadacMacFormatCache.class);
    @Autowired
    @Lazy
    private b omadacInternalApiService;
    private static final Integer TWO_HOURS_IN_SECONDS = 7200;
    private static final Cache<String, Integer> MAC_FORMAT_CACHE = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).maximumSize(20000L).expireAfterAccess((long)TWO_HOURS_IN_SECONDS.intValue(), TimeUnit.SECONDS).build();

    public Integer getMacFormatByOmadacId(String omadacId) {
        if (Objects.isNull(omadacId)) {
            return MacFormatEnum.getDefaultMacFormatCode();
        }
        try {
            Integer macFormatCache = (Integer)MAC_FORMAT_CACHE.getIfPresent((Object)omadacId);
            if (Objects.nonNull(macFormatCache)) {
                return macFormatCache;
            }
            OperationResponse macFormatSetting = this.omadacInternalApiService.b(omadacId);
            if (macFormatSetting.success() && Objects.nonNull(macFormatSetting.getResult())) {
                MAC_FORMAT_CACHE.put((Object)omadacId, (Object)((Integer)macFormatSetting.getResult()));
                return (Integer)macFormatSetting.getResult();
            }
        }
        catch (Exception e) {
            log.info("Failed to get mac format of omadac {}, use default format, cause {}", new Object[]{omadacId, e.getMessage(), e});
        }
        return MacFormatEnum.getDefaultMacFormatCode();
    }

    public void setMacFormat(String omadacId, Integer macFormat) {
        MAC_FORMAT_CACHE.put((Object)omadacId, (Object)macFormat);
    }
}

