/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.core.repository;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.device.firmware.upgrade.common.constants.FirmwareUpgradeStatusEnum;
import com.tplink.smb.device.firmware.upgrade.common.constants.device.DeviceFirmwareUpgradeError;
import com.tplink.smb.device.firmware.upgrade.common.constants.device.DeviceFirmwareUpgradeStageEnum;
import com.tplink.smb.device.firmware.upgrade.common.dto.UpgradeRequestDTO;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.DeviceHolder;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.notify.DeviceUpgradeNotifyContent;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.notify.DeviceUpgradeNotifyDTO;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.upgrade.DeviceUpgradeResponseDTO;
import com.tplink.smb.device.firmware.upgrade.common.property.FirmwareUpgradeProperties;
import com.tplink.smb.device.firmware.upgrade.core.po.DeviceUpgradePO;
import com.tplink.smb.device.firmware.upgrade.core.po.MonitorTimeoutSettingPO;
import com.tplink.smb.device.firmware.upgrade.core.repository.FirmwareUpgradeRepository;
import com.tplink.smb.ecsp.common.util.JacksonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FirmwareUpgradeRepositoryImpl
implements FirmwareUpgradeRepository {
    private static final Logger log = LoggerFactory.getLogger(FirmwareUpgradeRepositoryImpl.class);
    @Autowired
    private CacheService cacheService;
    @Autowired
    private FirmwareUpgradeProperties properties;
    private static final int OK_ERROR_CODE = 0;
    private static final int SWITCH_DOWNLOAD_OK_ERROR_CODE = 1;
    private static final int MONITOR_DEVICE_COUNT = 10;
    private long cleanTimeout;

    @PostConstruct
    public void repositoryPostConstruct() {
        this.cleanTimeout = this.properties.getCleanUpTimeout();
    }

    @Override
    public void removeDeviceInCache(String deviceMac, String sysId) {
        DeviceHolder deviceHolder = DeviceHolder.create((String)deviceMac, (String)sysId);
        this.cacheService.deleteHashValue("firmware.upgrade", "status", deviceHolder.toJson());
        this.cacheService.deleteHashValue("firmware.upgrade", "timeout", deviceHolder.toJson());
    }

    private void updateUpgradePO(String deviceMac, String sysId, DeviceUpgradePO upgradePO) {
        Optional<DeviceUpgradePO> optOldUpgradePO = this.getUpgradePO(deviceMac, sysId);
        if (optOldUpgradePO.isPresent() && FirmwareUpgradeStatusEnum.UPGRADE_FINISHED.equals((Object)optOldUpgradePO.get().getStatus())) {
            return;
        }
        DeviceHolder deviceHolder = DeviceHolder.create((String)deviceMac, (String)sysId);
        upgradePO.setLastActive(System.currentTimeMillis());
        this.cacheService.putHashValue("firmware.upgrade", "status", deviceHolder.toJson(), (Object)upgradePO);
        if (FirmwareUpgradeStatusEnum.UPGRADE_FINISHED.equals((Object)upgradePO.getStatus())) {
            this.updateCleanUpQueue(deviceHolder);
        }
    }

    @Override
    public void updateCleanUpQueue(DeviceHolder deviceHolder) {
        long cleanUptime = System.currentTimeMillis() + this.cleanTimeout;
        this.cacheService.addSortedSetValue("firmware.upgrade", "clean", (Object)deviceHolder.toJson(), (double)cleanUptime);
    }

    private void saveTimeoutSetting(String deviceMac, String sysId, MonitorTimeoutSettingPO timeoutSettingPO) {
        DeviceHolder deviceHolder = DeviceHolder.create((String)deviceMac, (String)sysId);
        this.cacheService.putHashValue("firmware.upgrade", "timeout", deviceHolder.toJson(), (Object)timeoutSettingPO);
    }

    @Override
    public int getLengthOfMonitorQueue() {
        return this.cacheService.getSortedSetSize("firmware.upgrade", "monitor");
    }

    @Override
    public Optional<DeviceUpgradePO> getUpgradePO(String deviceMac, String sysId) {
        DeviceHolder deviceHolder = DeviceHolder.create((String)deviceMac, (String)sysId);
        return Optional.ofNullable(this.cacheService.getHashValue("firmware.upgrade", "status", deviceHolder.toJson(), DeviceUpgradePO.class));
    }

    @Override
    public Optional<MonitorTimeoutSettingPO> getTimeoutSettingPO(String deviceMac, String sysId) {
        DeviceHolder deviceHolder = DeviceHolder.create((String)deviceMac, (String)sysId);
        return Optional.ofNullable(this.cacheService.getHashValue("firmware.upgrade", "timeout", deviceHolder.toJson(), MonitorTimeoutSettingPO.class));
    }

    @Override
    public List<String> pollTimeoutDevicesFromQueue() {
        double filterMin = 0.0;
        double filterMax = System.currentTimeMillis();
        Collection timeoutDevicesCollection = this.cacheService.pollFirst("firmware.upgrade", "monitor", 10, filterMin, filterMax, String.class);
        if (Objects.isNull(timeoutDevicesCollection)) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<String>(timeoutDevicesCollection);
    }

    private void doUpdateDeviceInMonitorQueue(String deviceMac, String sysId, long expiredTime) {
        DeviceHolder deviceHolder = DeviceHolder.create((String)deviceMac, (String)sysId);
        this.cacheService.addSortedSetValue("firmware.upgrade", "monitor", (Object)deviceHolder.toJson(), (double)expiredTime);
    }

    @Override
    public boolean initFromUpgradeRequest(UpgradeRequestDTO upgradeRequest, FirmwareUpgradeStatusEnum status) {
        String sysId;
        String deviceMac = upgradeRequest.getDeviceMac();
        Optional<DeviceUpgradePO> optUpgradePO = this.getUpgradePO(deviceMac, sysId = upgradeRequest.getSysId());
        if (!optUpgradePO.isPresent() || FirmwareUpgradeStatusEnum.UPGRADE_FINISHED.equals((Object)optUpgradePO.get().getStatus())) {
            this.removeDeviceInCache(deviceMac, sysId);
            DeviceUpgradePO upgradePO = DeviceUpgradePO.fromRequest(upgradeRequest, status);
            MonitorTimeoutSettingPO timeoutSettingPO = MonitorTimeoutSettingPO.fromRequest(upgradeRequest);
            this.saveTimeoutSetting(deviceMac, sysId, timeoutSettingPO);
            this.updateUpgradePO(deviceMac, sysId, upgradePO);
            return true;
        }
        return false;
    }

    @Override
    public void updateStatusOnDeviceUpgradeRequestSent(String deviceMac, String sysId) {
        this.getUpgradePO(deviceMac, sysId).ifPresent(deviceUpgradePO -> {
            deviceUpgradePO.setDeviceErrorIdx(null);
            deviceUpgradePO.setStatus(FirmwareUpgradeStatusEnum.REQUEST_SENT);
            this.updateUpgradePO(deviceMac, sysId, (DeviceUpgradePO)deviceUpgradePO);
        });
    }

    @Override
    public void updateDeviceInMonitorQueue(String deviceMac, String sysId, DeviceFirmwareUpgradeStageEnum stage) {
        this.getTimeoutSettingPO(deviceMac, sysId).ifPresent(timeoutSettingPO -> {
            long timeoutForStage;
            switch (stage) {
                case DOWNVAL: {
                    timeoutForStage = timeoutSettingPO.getDownValStageTimeout();
                    break;
                }
                case UPGRADE: {
                    timeoutForStage = timeoutSettingPO.getUpgradeStageTimeout();
                    break;
                }
                case REBOOT: {
                    timeoutForStage = timeoutSettingPO.getRebootStageTimeout();
                    break;
                }
                case FINISHED: {
                    this.removeDeviceInMonitorQueue(deviceMac, sysId);
                    return;
                }
                default: {
                    return;
                }
            }
            long expiredTime = System.currentTimeMillis() + timeoutForStage;
            this.doUpdateDeviceInMonitorQueue(deviceMac, sysId, expiredTime);
        });
    }

    @Override
    public void updateStatusFromDeviceUpgradeResponse(String deviceMac, String sysId, DeviceUpgradeResponseDTO deviceUpgradeResponse) {
        this.getUpgradePO(deviceMac, sysId).ifPresent(deviceUpgradePO -> {
            FirmwareUpgradeStatusEnum oldStatus = deviceUpgradePO.getStatus();
            if (FirmwareUpgradeStatusEnum.UPGRADE_FINISHED.equals((Object)oldStatus)) {
                log.debug("sysId:{}, device updateStatusFromDeviceUpgradeResponse is UPGRADE_FINISHED.", (Object)sysId);
                return;
            }
            int deviceErrorCode = deviceUpgradeResponse.getErrcode();
            if (deviceErrorCode != DeviceFirmwareUpgradeError.REQUEST_ACCEPTED.getCode()) {
                deviceUpgradePO.setDeviceErrorIdx(DeviceFirmwareUpgradeError.REQUEST_REJECTED.getIndex());
                log.error("sysId:{}, device updateStatusFromDeviceUpgradeResponse is REQUEST_REJECTED.", (Object)sysId);
                deviceUpgradePO.setStatus(FirmwareUpgradeStatusEnum.UPGRADE_FINISHED);
                deviceUpgradePO.setFinishUpgradeTimestamp(System.currentTimeMillis());
            } else {
                deviceUpgradePO.setDeviceErrorIdx(DeviceFirmwareUpgradeError.REQUEST_ACCEPTED.getIndex());
                deviceUpgradePO.setStatus(FirmwareUpgradeStatusEnum.FILE_DOWNLOAD_START);
                deviceUpgradePO.setEstimateUpgradeTime(deviceUpgradeResponse.getEstimateUpgradeTime());
                deviceUpgradePO.setEstimateRebootTime(deviceUpgradeResponse.getEstimateRebootTime());
                deviceUpgradePO.setStartUpgradeTimestamp(System.currentTimeMillis());
                log.debug("sysId:{}, device updateStatusFromDeviceUpgradeResponse is FILE_DOWNLOAD_START.", (Object)sysId);
            }
            this.updateUpgradePO(deviceMac, sysId, (DeviceUpgradePO)deviceUpgradePO);
            this.updateDeviceInMonitorQueue(deviceMac, sysId, DeviceFirmwareUpgradeStageEnum.DOWNVAL);
        });
    }

    @Override
    public void updateStatusFromUpgradeNotify(DeviceUpgradeNotifyDTO upgradeNotify) {
        String deviceMac = upgradeNotify.getDeviceMac();
        String sysId = upgradeNotify.getSysId();
        this.getUpgradePO(deviceMac, sysId).ifPresent(deviceUpgradePO -> {
            FirmwareUpgradeStatusEnum oldStatus = deviceUpgradePO.getStatus();
            if (FirmwareUpgradeStatusEnum.UPGRADE_FINISHED.equals((Object)oldStatus)) {
                log.debug("sysId:{}, device updateStatusFromUpgradeNotify UPGRADE_FINISHED.", (Object)sysId);
                return;
            }
            DeviceUpgradeNotifyContent upgradeNotifyContent = upgradeNotify.getContent();
            int errorCode = upgradeNotifyContent.getErrcode();
            DeviceFirmwareUpgradeStageEnum stage = upgradeNotifyContent.getStage();
            DeviceFirmwareUpgradeError upgradeError = DeviceFirmwareUpgradeError.fromUpgradeNotify((int)errorCode, (DeviceFirmwareUpgradeStageEnum)stage);
            FirmwareUpgradeStatusEnum newStatus = FirmwareUpgradeStatusEnum.UPGRADE_FINISHED;
            switch (stage) {
                case DOWNVAL: {
                    if (errorCode != 0 && errorCode != 1) break;
                    newStatus = FirmwareUpgradeStatusEnum.UPGRADING;
                    stage = DeviceFirmwareUpgradeStageEnum.UPGRADE;
                    log.debug("sysId:{}, device updateStatusFromUpgradeNotify UPGRADE.", (Object)sysId);
                    break;
                }
                case UPGRADE: {
                    if (errorCode != 0) break;
                    boolean reboot = upgradeNotifyContent.getReboot();
                    stage = DeviceFirmwareUpgradeStageEnum.FINISHED;
                    if (reboot) {
                        newStatus = FirmwareUpgradeStatusEnum.WAITING_RECOVERY;
                        stage = DeviceFirmwareUpgradeStageEnum.REBOOT;
                    }
                    log.debug("sysId:{}, device updateStatusFromUpgradeNotify stage:{}.", (Object)sysId, (Object)stage);
                    break;
                }
            }
            deviceUpgradePO.setStatus(newStatus);
            if (FirmwareUpgradeStatusEnum.UPGRADE_FINISHED.equals((Object)newStatus)) {
                deviceUpgradePO.setFinishUpgradeTimestamp(System.currentTimeMillis());
            }
            deviceUpgradePO.setDeviceErrorIdx(upgradeError.getIndex());
            this.updateUpgradePO(deviceMac, sysId, (DeviceUpgradePO)deviceUpgradePO);
            this.updateDeviceInMonitorQueue(deviceMac, sysId, stage);
        });
    }

    @Override
    public void updateStatusOnRequestSentError(String deviceMac, String sysId) {
        this.getUpgradePO(deviceMac, sysId).ifPresent(upgradePO -> {
            upgradePO.setStatus(FirmwareUpgradeStatusEnum.UPGRADE_FINISHED);
            upgradePO.setFinishUpgradeTimestamp(System.currentTimeMillis());
            upgradePO.setDeviceErrorIdx(DeviceFirmwareUpgradeError.STAGE_REQUEST_TIMEOUT.getIndex());
            log.error("sysId:{}, device updateStatusOnRequestSentError is STAGE_REQUEST_TIMEOUT.", (Object)sysId);
            this.updateUpgradePO(deviceMac, sysId, (DeviceUpgradePO)upgradePO);
        });
    }

    @Override
    public void updateStatusFromTimeoutMonitor(String deviceMac, String sysId, DeviceFirmwareUpgradeError timeoutError) {
        this.getUpgradePO(deviceMac, sysId).ifPresent(deviceUpgradePO -> {
            deviceUpgradePO.setStatus(FirmwareUpgradeStatusEnum.UPGRADE_FINISHED);
            deviceUpgradePO.setFinishUpgradeTimestamp(System.currentTimeMillis());
            deviceUpgradePO.setDeviceErrorIdx(timeoutError.getIndex());
            this.updateUpgradePO(deviceMac, sysId, (DeviceUpgradePO)deviceUpgradePO);
        });
    }

    @Override
    public void updateStatusFromReport(String deviceMac, String sysId) {
        this.getUpgradePO(deviceMac, sysId).ifPresent(deviceUpgradePO -> {
            deviceUpgradePO.setStatus(FirmwareUpgradeStatusEnum.UPGRADE_FINISHED);
            deviceUpgradePO.setFinishUpgradeTimestamp(System.currentTimeMillis());
            deviceUpgradePO.setDeviceErrorIdx(DeviceFirmwareUpgradeError.FIRMWARE_RECONNECTED_OK.getIndex());
            log.debug("sysId:{}, updateStatusFromReport device , FIRMWARE_RECONNECTED_OK", (Object)sysId);
            this.updateUpgradePO(deviceMac, sysId, (DeviceUpgradePO)deviceUpgradePO);
            this.updateDeviceInMonitorQueue(deviceMac, sysId, DeviceFirmwareUpgradeStageEnum.FINISHED);
        });
    }

    @Override
    public void updateStatusWhenWaitingDeviceReady(String deviceMac, String sysId) {
        this.getUpgradePO(deviceMac, sysId).ifPresent(deviceUpgradePO -> {
            deviceUpgradePO.setStatus(FirmwareUpgradeStatusEnum.UPGRADE_READY);
            this.updateUpgradePO(deviceMac, sysId, (DeviceUpgradePO)deviceUpgradePO);
        });
    }

    @Override
    public void removeDeviceInWaitingQueue(String deviceMac, String sysId) {
        DeviceHolder deviceHolder = DeviceHolder.create((String)deviceMac, (String)sysId);
        this.cacheService.removeSortedSetValue("firmware.upgrade", "waiting", (Object)deviceHolder.toJson());
    }

    @Override
    public void removeDeviceInMonitorQueue(String deviceMac, String sysId) {
        DeviceHolder deviceHolder = DeviceHolder.create((String)deviceMac, (String)sysId);
        this.cacheService.removeSortedSetValue("firmware.upgrade", "monitor", (Object)deviceHolder.toJson());
    }

    @Override
    public void addDeviceToWaitingList(String deviceMac, String sysId, long timeout) {
        DeviceHolder deviceHolder = DeviceHolder.create((String)deviceMac, (String)sysId);
        long expiredTime = System.currentTimeMillis() + timeout;
        this.cacheService.addSortedSetValue("firmware.upgrade", "waiting", (Object)deviceHolder.toJson(), (double)expiredTime);
    }

    @Override
    public DeviceHolder getOneWaitingDevice() {
        Collection deviceListCollection = this.cacheService.pollFirst("firmware.upgrade", "waiting", 1, String.class);
        if (Objects.isNull(deviceListCollection)) {
            return null;
        }
        ArrayList deviceList = new ArrayList(deviceListCollection);
        if (!deviceList.isEmpty()) {
            String deviceHolderStr = (String)deviceList.get(0);
            return (DeviceHolder)JacksonUtils.json2Pojo((String)deviceHolderStr, DeviceHolder.class);
        }
        return null;
    }

    @Override
    public List<String> pollTimeoutDevicesFromWaitingQueue() {
        double filterMin = 0.0;
        double filterMax = System.currentTimeMillis();
        Collection waitingDevicesCollection = this.cacheService.pollFirst("firmware.upgrade", "waiting", 10, filterMin, filterMax, String.class);
        if (Objects.isNull(waitingDevicesCollection)) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<String>(waitingDevicesCollection);
    }

    @Override
    public List<String> pollDevicesFromCleanUpQueue() {
        double filterMin = 0.0;
        double filterMax = System.currentTimeMillis();
        Collection cleanUpDevicesCollection = this.cacheService.pollFirst("firmware.upgrade", "clean", 10, filterMin, filterMax, String.class);
        if (Objects.isNull(cleanUpDevicesCollection)) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<String>(cleanUpDevicesCollection);
    }

    @Override
    public void cleanUp() {
        this.cacheService.deleteKey("firmware.upgrade", "status");
        this.cacheService.deleteKey("firmware.upgrade", "monitor");
        this.cacheService.deleteKey("firmware.upgrade", "waiting");
        this.cacheService.deleteKey("firmware.upgrade", "timeout");
        this.cacheService.deleteKey("firmware.upgrade", "clean");
    }
}

