/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.core.repository;

import com.tplink.smb.device.firmware.upgrade.common.constants.FirmwareUpgradeStatusEnum;
import com.tplink.smb.device.firmware.upgrade.common.constants.device.DeviceFirmwareUpgradeError;
import com.tplink.smb.device.firmware.upgrade.common.constants.device.DeviceFirmwareUpgradeStageEnum;
import com.tplink.smb.device.firmware.upgrade.common.dto.UpgradeRequestDTO;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.DeviceHolder;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.notify.DeviceUpgradeNotifyDTO;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.upgrade.DeviceUpgradeResponseDTO;
import com.tplink.smb.device.firmware.upgrade.core.po.DeviceUpgradePO;
import com.tplink.smb.device.firmware.upgrade.core.po.MonitorTimeoutSettingPO;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public interface FirmwareUpgradeRepository {
    public int getLengthOfMonitorQueue();

    public Optional<DeviceUpgradePO> getUpgradePO(String var1, String var2);

    public Optional<MonitorTimeoutSettingPO> getTimeoutSettingPO(String var1, String var2);

    public List<String> pollTimeoutDevicesFromQueue();

    public void updateDeviceInMonitorQueue(String var1, String var2, DeviceFirmwareUpgradeStageEnum var3);

    public boolean initFromUpgradeRequest(UpgradeRequestDTO var1, FirmwareUpgradeStatusEnum var2);

    public void updateStatusOnDeviceUpgradeRequestSent(String var1, String var2);

    public void updateStatusFromDeviceUpgradeResponse(String var1, String var2, DeviceUpgradeResponseDTO var3);

    public void updateStatusFromUpgradeNotify(DeviceUpgradeNotifyDTO var1);

    public void updateStatusOnRequestSentError(String var1, String var2);

    public void updateStatusFromTimeoutMonitor(String var1, String var2, DeviceFirmwareUpgradeError var3);

    public void updateStatusFromReport(String var1, String var2);

    public void updateStatusWhenWaitingDeviceReady(String var1, String var2);

    public void removeDeviceInWaitingQueue(String var1, String var2);

    public void removeDeviceInMonitorQueue(String var1, String var2);

    public void addDeviceToWaitingList(String var1, String var2, long var3);

    public DeviceHolder getOneWaitingDevice();

    public List<String> pollTimeoutDevicesFromWaitingQueue();

    public List<String> pollDevicesFromCleanUpQueue();

    public void cleanUp();

    public void removeDeviceInCache(String var1, String var2);

    public void updateCleanUpQueue(DeviceHolder var1);
}

