/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.core.po;

import com.tplink.smb.device.firmware.upgrade.common.dto.UpgradeRequestDTO;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.MonitorStageTimeoutSetting;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.MonitorTimeoutSetting;
import com.tplink.smb.device.firmware.upgrade.common.util.FirmwareUpgradeUtils;
import java.util.Objects;

public class MonitorTimeoutSettingPO {
    private String deviceMac;
    private String sysId;
    private Long deviceContextTimeout;
    private Long requestStageTimeout;
    private Long downValStageTimeout;
    private Long upgradeStageTimeout;
    private Long rebootStageTimeout;

    public static MonitorTimeoutSettingPO fromRequest(UpgradeRequestDTO requestDTO) {
        MonitorTimeoutSetting monitorTimeoutSetting = requestDTO.getTimeoutSetting();
        if (Objects.isNull(monitorTimeoutSetting)) {
            monitorTimeoutSetting = MonitorTimeoutSetting.createDefault();
        }
        return ((MonitorTimeoutSettingPOBuilder)((MonitorTimeoutSettingPOBuilder)((MonitorTimeoutSettingPOBuilder)((MonitorTimeoutSettingPOBuilder)((MonitorTimeoutSettingPOBuilder)((MonitorTimeoutSettingPOBuilder)((MonitorTimeoutSettingPOBuilder)MonitorTimeoutSettingPO.builder().deviceMac(requestDTO.getDeviceMac())).sysId(requestDTO.getSysId())).deviceContextTimeout(FirmwareUpgradeUtils.getTimeoutMills((MonitorStageTimeoutSetting)monitorTimeoutSetting.getContext()))).requestStageTimeout(FirmwareUpgradeUtils.getTimeoutMills((MonitorStageTimeoutSetting)monitorTimeoutSetting.getRequestStage()))).downValStageTimeout(FirmwareUpgradeUtils.getTimeoutMills((MonitorStageTimeoutSetting)monitorTimeoutSetting.getDownValStage()))).upgradeStageTimeout(FirmwareUpgradeUtils.getTimeoutMills((MonitorStageTimeoutSetting)monitorTimeoutSetting.getUpgradeStage()))).rebootStageTimeout(FirmwareUpgradeUtils.getTimeoutMills((MonitorStageTimeoutSetting)monitorTimeoutSetting.getRebootStage()))).build();
    }

    protected MonitorTimeoutSettingPO(MonitorTimeoutSettingPOBuilder<?, ?> b) {
        this.deviceMac = ((MonitorTimeoutSettingPOBuilder)b).deviceMac;
        this.sysId = ((MonitorTimeoutSettingPOBuilder)b).sysId;
        this.deviceContextTimeout = ((MonitorTimeoutSettingPOBuilder)b).deviceContextTimeout;
        this.requestStageTimeout = ((MonitorTimeoutSettingPOBuilder)b).requestStageTimeout;
        this.downValStageTimeout = ((MonitorTimeoutSettingPOBuilder)b).downValStageTimeout;
        this.upgradeStageTimeout = ((MonitorTimeoutSettingPOBuilder)b).upgradeStageTimeout;
        this.rebootStageTimeout = ((MonitorTimeoutSettingPOBuilder)b).rebootStageTimeout;
    }

    public static MonitorTimeoutSettingPOBuilder<?, ?> builder() {
        return new MonitorTimeoutSettingPOBuilderImpl();
    }

    public MonitorTimeoutSettingPO() {
    }

    public MonitorTimeoutSettingPO(String deviceMac, String sysId, Long deviceContextTimeout, Long requestStageTimeout, Long downValStageTimeout, Long upgradeStageTimeout, Long rebootStageTimeout) {
        this.deviceMac = deviceMac;
        this.sysId = sysId;
        this.deviceContextTimeout = deviceContextTimeout;
        this.requestStageTimeout = requestStageTimeout;
        this.downValStageTimeout = downValStageTimeout;
        this.upgradeStageTimeout = upgradeStageTimeout;
        this.rebootStageTimeout = rebootStageTimeout;
    }

    public String getDeviceMac() {
        return this.deviceMac;
    }

    public String getSysId() {
        return this.sysId;
    }

    public Long getDeviceContextTimeout() {
        return this.deviceContextTimeout;
    }

    public Long getRequestStageTimeout() {
        return this.requestStageTimeout;
    }

    public Long getDownValStageTimeout() {
        return this.downValStageTimeout;
    }

    public Long getUpgradeStageTimeout() {
        return this.upgradeStageTimeout;
    }

    public Long getRebootStageTimeout() {
        return this.rebootStageTimeout;
    }

    public void setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public void setDeviceContextTimeout(Long deviceContextTimeout) {
        this.deviceContextTimeout = deviceContextTimeout;
    }

    public void setRequestStageTimeout(Long requestStageTimeout) {
        this.requestStageTimeout = requestStageTimeout;
    }

    public void setDownValStageTimeout(Long downValStageTimeout) {
        this.downValStageTimeout = downValStageTimeout;
    }

    public void setUpgradeStageTimeout(Long upgradeStageTimeout) {
        this.upgradeStageTimeout = upgradeStageTimeout;
    }

    public void setRebootStageTimeout(Long rebootStageTimeout) {
        this.rebootStageTimeout = rebootStageTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitorTimeoutSettingPO)) {
            return false;
        }
        MonitorTimeoutSettingPO other = (MonitorTimeoutSettingPO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$deviceContextTimeout = this.getDeviceContextTimeout();
        Long other$deviceContextTimeout = other.getDeviceContextTimeout();
        if (this$deviceContextTimeout == null ? other$deviceContextTimeout != null : !((Object)this$deviceContextTimeout).equals(other$deviceContextTimeout)) {
            return false;
        }
        Long this$requestStageTimeout = this.getRequestStageTimeout();
        Long other$requestStageTimeout = other.getRequestStageTimeout();
        if (this$requestStageTimeout == null ? other$requestStageTimeout != null : !((Object)this$requestStageTimeout).equals(other$requestStageTimeout)) {
            return false;
        }
        Long this$downValStageTimeout = this.getDownValStageTimeout();
        Long other$downValStageTimeout = other.getDownValStageTimeout();
        if (this$downValStageTimeout == null ? other$downValStageTimeout != null : !((Object)this$downValStageTimeout).equals(other$downValStageTimeout)) {
            return false;
        }
        Long this$upgradeStageTimeout = this.getUpgradeStageTimeout();
        Long other$upgradeStageTimeout = other.getUpgradeStageTimeout();
        if (this$upgradeStageTimeout == null ? other$upgradeStageTimeout != null : !((Object)this$upgradeStageTimeout).equals(other$upgradeStageTimeout)) {
            return false;
        }
        Long this$rebootStageTimeout = this.getRebootStageTimeout();
        Long other$rebootStageTimeout = other.getRebootStageTimeout();
        if (this$rebootStageTimeout == null ? other$rebootStageTimeout != null : !((Object)this$rebootStageTimeout).equals(other$rebootStageTimeout)) {
            return false;
        }
        String this$deviceMac = this.getDeviceMac();
        String other$deviceMac = other.getDeviceMac();
        if (this$deviceMac == null ? other$deviceMac != null : !this$deviceMac.equals(other$deviceMac)) {
            return false;
        }
        String this$sysId = this.getSysId();
        String other$sysId = other.getSysId();
        return !(this$sysId == null ? other$sysId != null : !this$sysId.equals(other$sysId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MonitorTimeoutSettingPO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $deviceContextTimeout = this.getDeviceContextTimeout();
        result = result * 59 + ($deviceContextTimeout == null ? 43 : ((Object)$deviceContextTimeout).hashCode());
        Long $requestStageTimeout = this.getRequestStageTimeout();
        result = result * 59 + ($requestStageTimeout == null ? 43 : ((Object)$requestStageTimeout).hashCode());
        Long $downValStageTimeout = this.getDownValStageTimeout();
        result = result * 59 + ($downValStageTimeout == null ? 43 : ((Object)$downValStageTimeout).hashCode());
        Long $upgradeStageTimeout = this.getUpgradeStageTimeout();
        result = result * 59 + ($upgradeStageTimeout == null ? 43 : ((Object)$upgradeStageTimeout).hashCode());
        Long $rebootStageTimeout = this.getRebootStageTimeout();
        result = result * 59 + ($rebootStageTimeout == null ? 43 : ((Object)$rebootStageTimeout).hashCode());
        String $deviceMac = this.getDeviceMac();
        result = result * 59 + ($deviceMac == null ? 43 : $deviceMac.hashCode());
        String $sysId = this.getSysId();
        result = result * 59 + ($sysId == null ? 43 : $sysId.hashCode());
        return result;
    }

    public String toString() {
        return "MonitorTimeoutSettingPO(deviceMac=" + this.getDeviceMac() + ", sysId=" + this.getSysId() + ", deviceContextTimeout=" + this.getDeviceContextTimeout() + ", requestStageTimeout=" + this.getRequestStageTimeout() + ", downValStageTimeout=" + this.getDownValStageTimeout() + ", upgradeStageTimeout=" + this.getUpgradeStageTimeout() + ", rebootStageTimeout=" + this.getRebootStageTimeout() + ")";
    }

    private static final class MonitorTimeoutSettingPOBuilderImpl
    extends MonitorTimeoutSettingPOBuilder<MonitorTimeoutSettingPO, MonitorTimeoutSettingPOBuilderImpl> {
        private MonitorTimeoutSettingPOBuilderImpl() {
        }

        @Override
        protected MonitorTimeoutSettingPOBuilderImpl self() {
            return this;
        }

        @Override
        public MonitorTimeoutSettingPO build() {
            return new MonitorTimeoutSettingPO(this);
        }
    }

    public static abstract class MonitorTimeoutSettingPOBuilder<C extends MonitorTimeoutSettingPO, B extends MonitorTimeoutSettingPOBuilder<C, B>> {
        private String deviceMac;
        private String sysId;
        private Long deviceContextTimeout;
        private Long requestStageTimeout;
        private Long downValStageTimeout;
        private Long upgradeStageTimeout;
        private Long rebootStageTimeout;

        protected abstract B self();

        public abstract C build();

        public B deviceMac(String deviceMac) {
            this.deviceMac = deviceMac;
            return this.self();
        }

        public B sysId(String sysId) {
            this.sysId = sysId;
            return this.self();
        }

        public B deviceContextTimeout(Long deviceContextTimeout) {
            this.deviceContextTimeout = deviceContextTimeout;
            return this.self();
        }

        public B requestStageTimeout(Long requestStageTimeout) {
            this.requestStageTimeout = requestStageTimeout;
            return this.self();
        }

        public B downValStageTimeout(Long downValStageTimeout) {
            this.downValStageTimeout = downValStageTimeout;
            return this.self();
        }

        public B upgradeStageTimeout(Long upgradeStageTimeout) {
            this.upgradeStageTimeout = upgradeStageTimeout;
            return this.self();
        }

        public B rebootStageTimeout(Long rebootStageTimeout) {
            this.rebootStageTimeout = rebootStageTimeout;
            return this.self();
        }

        public String toString() {
            return "MonitorTimeoutSettingPO.MonitorTimeoutSettingPOBuilder(deviceMac=" + this.deviceMac + ", sysId=" + this.sysId + ", deviceContextTimeout=" + this.deviceContextTimeout + ", requestStageTimeout=" + this.requestStageTimeout + ", downValStageTimeout=" + this.downValStageTimeout + ", upgradeStageTimeout=" + this.upgradeStageTimeout + ", rebootStageTimeout=" + this.rebootStageTimeout + ")";
        }
    }
}

