/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.core.po;

import com.tplink.smb.device.firmware.upgrade.common.constants.FirmwareUpgradeStatusEnum;
import com.tplink.smb.device.firmware.upgrade.common.constants.device.DeviceFirmwareUpgradeError;
import com.tplink.smb.device.firmware.upgrade.common.dto.UpgradeRequestDTO;
import com.tplink.smb.device.firmware.upgrade.common.dto.UpgradeStatusDTO;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.util.CollectionUtils;

public class DeviceUpgradePO {
    private String deviceMac;
    private String sysId;
    private String downloadLink;
    private FirmwareUpgradeStatusEnum status;
    private Long lastActive;
    private Long startUpgradeTimestamp;
    private Long finishUpgradeTimestamp;
    private Integer maxDownloadTime;
    private Integer estimateUpgradeTime;
    private Integer estimateRebootTime;
    private Boolean rebootAfterUpgrade;
    private Map<String, String> additionalInfo;
    private Integer deviceErrorIdx;

    public static UpgradeStatusDTO toStatusDTO(DeviceUpgradePO upgradePO) {
        UpgradeStatusDTO upgradeStatusDTO = UpgradeStatusDTO.builder().deviceMac(upgradePO.getDeviceMac()).sysId(upgradePO.getSysId()).status(upgradePO.getStatus()).maxDownloadTime(upgradePO.getMaxDownloadTime()).estimateUpgradeTime(upgradePO.getEstimateUpgradeTime()).estimateRebootTime(upgradePO.getEstimateRebootTime()).additionalInfo(upgradePO.getAdditionalInfo()).build();
        if (Objects.nonNull(upgradePO.getStartUpgradeTimestamp())) {
            long currentTime = System.currentTimeMillis();
            long upgradeTimeMillis = Objects.isNull(upgradePO.getFinishUpgradeTimestamp()) ? currentTime - upgradePO.getStartUpgradeTimestamp() : upgradePO.getFinishUpgradeTimestamp() - upgradePO.getStartUpgradeTimestamp();
            int upgradeTime = (int)TimeUnit.SECONDS.convert(upgradeTimeMillis, TimeUnit.MILLISECONDS);
            upgradeStatusDTO.setUpgradeTime(Integer.valueOf(upgradeTime));
        }
        if (Objects.nonNull(upgradePO.getDeviceErrorIdx())) {
            upgradeStatusDTO.setDeviceError(DeviceFirmwareUpgradeError.resolve((int)upgradePO.getDeviceErrorIdx()));
        }
        return upgradeStatusDTO;
    }

    public static UpgradeRequestDTO toRequestDTO(DeviceUpgradePO upgradePO) {
        UpgradeRequestDTO upgradeRequestDTO = UpgradeRequestDTO.builder().deviceMac(upgradePO.getDeviceMac()).sysId(upgradePO.getSysId()).rebootAfterUpgrade(upgradePO.getRebootAfterUpgrade()).maxDownloadTime(upgradePO.getMaxDownloadTime()).downloadLink(upgradePO.getDownloadLink()).build();
        if (!CollectionUtils.isEmpty(upgradePO.getAdditionalInfo())) {
            upgradeRequestDTO.setAdditionalInfo(upgradePO.getAdditionalInfo());
        }
        return upgradeRequestDTO;
    }

    public static DeviceUpgradePO fromRequest(UpgradeRequestDTO requestDTO, FirmwareUpgradeStatusEnum initStatus) {
        return ((DeviceUpgradePOBuilder)((DeviceUpgradePOBuilder)((DeviceUpgradePOBuilder)((DeviceUpgradePOBuilder)((DeviceUpgradePOBuilder)((DeviceUpgradePOBuilder)((DeviceUpgradePOBuilder)DeviceUpgradePO.builder().deviceMac(requestDTO.getDeviceMac())).downloadLink(requestDTO.getDownloadLink())).sysId(requestDTO.getSysId())).rebootAfterUpgrade(requestDTO.getRebootAfterUpgrade())).status(initStatus)).additionalInfo(requestDTO.getAdditionalInfo())).maxDownloadTime(requestDTO.getMaxDownloadTime())).build();
    }

    protected DeviceUpgradePO(DeviceUpgradePOBuilder<?, ?> b) {
        this.deviceMac = ((DeviceUpgradePOBuilder)b).deviceMac;
        this.sysId = ((DeviceUpgradePOBuilder)b).sysId;
        this.downloadLink = ((DeviceUpgradePOBuilder)b).downloadLink;
        this.status = ((DeviceUpgradePOBuilder)b).status;
        this.lastActive = ((DeviceUpgradePOBuilder)b).lastActive;
        this.startUpgradeTimestamp = ((DeviceUpgradePOBuilder)b).startUpgradeTimestamp;
        this.finishUpgradeTimestamp = ((DeviceUpgradePOBuilder)b).finishUpgradeTimestamp;
        this.maxDownloadTime = ((DeviceUpgradePOBuilder)b).maxDownloadTime;
        this.estimateUpgradeTime = ((DeviceUpgradePOBuilder)b).estimateUpgradeTime;
        this.estimateRebootTime = ((DeviceUpgradePOBuilder)b).estimateRebootTime;
        this.rebootAfterUpgrade = ((DeviceUpgradePOBuilder)b).rebootAfterUpgrade;
        this.additionalInfo = ((DeviceUpgradePOBuilder)b).additionalInfo;
        this.deviceErrorIdx = ((DeviceUpgradePOBuilder)b).deviceErrorIdx;
    }

    public static DeviceUpgradePOBuilder<?, ?> builder() {
        return new DeviceUpgradePOBuilderImpl();
    }

    public String getDeviceMac() {
        return this.deviceMac;
    }

    public String getSysId() {
        return this.sysId;
    }

    public String getDownloadLink() {
        return this.downloadLink;
    }

    public FirmwareUpgradeStatusEnum getStatus() {
        return this.status;
    }

    public Long getLastActive() {
        return this.lastActive;
    }

    public Long getStartUpgradeTimestamp() {
        return this.startUpgradeTimestamp;
    }

    public Long getFinishUpgradeTimestamp() {
        return this.finishUpgradeTimestamp;
    }

    public Integer getMaxDownloadTime() {
        return this.maxDownloadTime;
    }

    public Integer getEstimateUpgradeTime() {
        return this.estimateUpgradeTime;
    }

    public Integer getEstimateRebootTime() {
        return this.estimateRebootTime;
    }

    public Boolean getRebootAfterUpgrade() {
        return this.rebootAfterUpgrade;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public Integer getDeviceErrorIdx() {
        return this.deviceErrorIdx;
    }

    public void setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public void setDownloadLink(String downloadLink) {
        this.downloadLink = downloadLink;
    }

    public void setStatus(FirmwareUpgradeStatusEnum status) {
        this.status = status;
    }

    public void setLastActive(Long lastActive) {
        this.lastActive = lastActive;
    }

    public void setStartUpgradeTimestamp(Long startUpgradeTimestamp) {
        this.startUpgradeTimestamp = startUpgradeTimestamp;
    }

    public void setFinishUpgradeTimestamp(Long finishUpgradeTimestamp) {
        this.finishUpgradeTimestamp = finishUpgradeTimestamp;
    }

    public void setMaxDownloadTime(Integer maxDownloadTime) {
        this.maxDownloadTime = maxDownloadTime;
    }

    public void setEstimateUpgradeTime(Integer estimateUpgradeTime) {
        this.estimateUpgradeTime = estimateUpgradeTime;
    }

    public void setEstimateRebootTime(Integer estimateRebootTime) {
        this.estimateRebootTime = estimateRebootTime;
    }

    public void setRebootAfterUpgrade(Boolean rebootAfterUpgrade) {
        this.rebootAfterUpgrade = rebootAfterUpgrade;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public void setDeviceErrorIdx(Integer deviceErrorIdx) {
        this.deviceErrorIdx = deviceErrorIdx;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceUpgradePO)) {
            return false;
        }
        DeviceUpgradePO other = (DeviceUpgradePO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$lastActive = this.getLastActive();
        Long other$lastActive = other.getLastActive();
        if (this$lastActive == null ? other$lastActive != null : !((Object)this$lastActive).equals(other$lastActive)) {
            return false;
        }
        Long this$startUpgradeTimestamp = this.getStartUpgradeTimestamp();
        Long other$startUpgradeTimestamp = other.getStartUpgradeTimestamp();
        if (this$startUpgradeTimestamp == null ? other$startUpgradeTimestamp != null : !((Object)this$startUpgradeTimestamp).equals(other$startUpgradeTimestamp)) {
            return false;
        }
        Long this$finishUpgradeTimestamp = this.getFinishUpgradeTimestamp();
        Long other$finishUpgradeTimestamp = other.getFinishUpgradeTimestamp();
        if (this$finishUpgradeTimestamp == null ? other$finishUpgradeTimestamp != null : !((Object)this$finishUpgradeTimestamp).equals(other$finishUpgradeTimestamp)) {
            return false;
        }
        Integer this$maxDownloadTime = this.getMaxDownloadTime();
        Integer other$maxDownloadTime = other.getMaxDownloadTime();
        if (this$maxDownloadTime == null ? other$maxDownloadTime != null : !((Object)this$maxDownloadTime).equals(other$maxDownloadTime)) {
            return false;
        }
        Integer this$estimateUpgradeTime = this.getEstimateUpgradeTime();
        Integer other$estimateUpgradeTime = other.getEstimateUpgradeTime();
        if (this$estimateUpgradeTime == null ? other$estimateUpgradeTime != null : !((Object)this$estimateUpgradeTime).equals(other$estimateUpgradeTime)) {
            return false;
        }
        Integer this$estimateRebootTime = this.getEstimateRebootTime();
        Integer other$estimateRebootTime = other.getEstimateRebootTime();
        if (this$estimateRebootTime == null ? other$estimateRebootTime != null : !((Object)this$estimateRebootTime).equals(other$estimateRebootTime)) {
            return false;
        }
        Boolean this$rebootAfterUpgrade = this.getRebootAfterUpgrade();
        Boolean other$rebootAfterUpgrade = other.getRebootAfterUpgrade();
        if (this$rebootAfterUpgrade == null ? other$rebootAfterUpgrade != null : !((Object)this$rebootAfterUpgrade).equals(other$rebootAfterUpgrade)) {
            return false;
        }
        Integer this$deviceErrorIdx = this.getDeviceErrorIdx();
        Integer other$deviceErrorIdx = other.getDeviceErrorIdx();
        if (this$deviceErrorIdx == null ? other$deviceErrorIdx != null : !((Object)this$deviceErrorIdx).equals(other$deviceErrorIdx)) {
            return false;
        }
        String this$deviceMac = this.getDeviceMac();
        String other$deviceMac = other.getDeviceMac();
        if (this$deviceMac == null ? other$deviceMac != null : !this$deviceMac.equals(other$deviceMac)) {
            return false;
        }
        String this$sysId = this.getSysId();
        String other$sysId = other.getSysId();
        if (this$sysId == null ? other$sysId != null : !this$sysId.equals(other$sysId)) {
            return false;
        }
        String this$downloadLink = this.getDownloadLink();
        String other$downloadLink = other.getDownloadLink();
        if (this$downloadLink == null ? other$downloadLink != null : !this$downloadLink.equals(other$downloadLink)) {
            return false;
        }
        FirmwareUpgradeStatusEnum this$status = this.getStatus();
        FirmwareUpgradeStatusEnum other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Map<String, String> this$additionalInfo = this.getAdditionalInfo();
        Map<String, String> other$additionalInfo = other.getAdditionalInfo();
        return !(this$additionalInfo == null ? other$additionalInfo != null : !((Object)this$additionalInfo).equals(other$additionalInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceUpgradePO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $lastActive = this.getLastActive();
        result = result * 59 + ($lastActive == null ? 43 : ((Object)$lastActive).hashCode());
        Long $startUpgradeTimestamp = this.getStartUpgradeTimestamp();
        result = result * 59 + ($startUpgradeTimestamp == null ? 43 : ((Object)$startUpgradeTimestamp).hashCode());
        Long $finishUpgradeTimestamp = this.getFinishUpgradeTimestamp();
        result = result * 59 + ($finishUpgradeTimestamp == null ? 43 : ((Object)$finishUpgradeTimestamp).hashCode());
        Integer $maxDownloadTime = this.getMaxDownloadTime();
        result = result * 59 + ($maxDownloadTime == null ? 43 : ((Object)$maxDownloadTime).hashCode());
        Integer $estimateUpgradeTime = this.getEstimateUpgradeTime();
        result = result * 59 + ($estimateUpgradeTime == null ? 43 : ((Object)$estimateUpgradeTime).hashCode());
        Integer $estimateRebootTime = this.getEstimateRebootTime();
        result = result * 59 + ($estimateRebootTime == null ? 43 : ((Object)$estimateRebootTime).hashCode());
        Boolean $rebootAfterUpgrade = this.getRebootAfterUpgrade();
        result = result * 59 + ($rebootAfterUpgrade == null ? 43 : ((Object)$rebootAfterUpgrade).hashCode());
        Integer $deviceErrorIdx = this.getDeviceErrorIdx();
        result = result * 59 + ($deviceErrorIdx == null ? 43 : ((Object)$deviceErrorIdx).hashCode());
        String $deviceMac = this.getDeviceMac();
        result = result * 59 + ($deviceMac == null ? 43 : $deviceMac.hashCode());
        String $sysId = this.getSysId();
        result = result * 59 + ($sysId == null ? 43 : $sysId.hashCode());
        String $downloadLink = this.getDownloadLink();
        result = result * 59 + ($downloadLink == null ? 43 : $downloadLink.hashCode());
        FirmwareUpgradeStatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Map<String, String> $additionalInfo = this.getAdditionalInfo();
        result = result * 59 + ($additionalInfo == null ? 43 : ((Object)$additionalInfo).hashCode());
        return result;
    }

    public String toString() {
        return "DeviceUpgradePO(deviceMac=" + this.getDeviceMac() + ", sysId=" + this.getSysId() + ", downloadLink=" + this.getDownloadLink() + ", status=" + this.getStatus() + ", lastActive=" + this.getLastActive() + ", startUpgradeTimestamp=" + this.getStartUpgradeTimestamp() + ", finishUpgradeTimestamp=" + this.getFinishUpgradeTimestamp() + ", maxDownloadTime=" + this.getMaxDownloadTime() + ", estimateUpgradeTime=" + this.getEstimateUpgradeTime() + ", estimateRebootTime=" + this.getEstimateRebootTime() + ", rebootAfterUpgrade=" + this.getRebootAfterUpgrade() + ", additionalInfo=" + this.getAdditionalInfo() + ", deviceErrorIdx=" + this.getDeviceErrorIdx() + ")";
    }

    public DeviceUpgradePO(String deviceMac, String sysId, String downloadLink, FirmwareUpgradeStatusEnum status, Long lastActive, Long startUpgradeTimestamp, Long finishUpgradeTimestamp, Integer maxDownloadTime, Integer estimateUpgradeTime, Integer estimateRebootTime, Boolean rebootAfterUpgrade, Map<String, String> additionalInfo, Integer deviceErrorIdx) {
        this.deviceMac = deviceMac;
        this.sysId = sysId;
        this.downloadLink = downloadLink;
        this.status = status;
        this.lastActive = lastActive;
        this.startUpgradeTimestamp = startUpgradeTimestamp;
        this.finishUpgradeTimestamp = finishUpgradeTimestamp;
        this.maxDownloadTime = maxDownloadTime;
        this.estimateUpgradeTime = estimateUpgradeTime;
        this.estimateRebootTime = estimateRebootTime;
        this.rebootAfterUpgrade = rebootAfterUpgrade;
        this.additionalInfo = additionalInfo;
        this.deviceErrorIdx = deviceErrorIdx;
    }

    public DeviceUpgradePO() {
    }

    private static final class DeviceUpgradePOBuilderImpl
    extends DeviceUpgradePOBuilder<DeviceUpgradePO, DeviceUpgradePOBuilderImpl> {
        private DeviceUpgradePOBuilderImpl() {
        }

        @Override
        protected DeviceUpgradePOBuilderImpl self() {
            return this;
        }

        @Override
        public DeviceUpgradePO build() {
            return new DeviceUpgradePO(this);
        }
    }

    public static abstract class DeviceUpgradePOBuilder<C extends DeviceUpgradePO, B extends DeviceUpgradePOBuilder<C, B>> {
        private String deviceMac;
        private String sysId;
        private String downloadLink;
        private FirmwareUpgradeStatusEnum status;
        private Long lastActive;
        private Long startUpgradeTimestamp;
        private Long finishUpgradeTimestamp;
        private Integer maxDownloadTime;
        private Integer estimateUpgradeTime;
        private Integer estimateRebootTime;
        private Boolean rebootAfterUpgrade;
        private Map<String, String> additionalInfo;
        private Integer deviceErrorIdx;

        protected abstract B self();

        public abstract C build();

        public B deviceMac(String deviceMac) {
            this.deviceMac = deviceMac;
            return this.self();
        }

        public B sysId(String sysId) {
            this.sysId = sysId;
            return this.self();
        }

        public B downloadLink(String downloadLink) {
            this.downloadLink = downloadLink;
            return this.self();
        }

        public B status(FirmwareUpgradeStatusEnum status) {
            this.status = status;
            return this.self();
        }

        public B lastActive(Long lastActive) {
            this.lastActive = lastActive;
            return this.self();
        }

        public B startUpgradeTimestamp(Long startUpgradeTimestamp) {
            this.startUpgradeTimestamp = startUpgradeTimestamp;
            return this.self();
        }

        public B finishUpgradeTimestamp(Long finishUpgradeTimestamp) {
            this.finishUpgradeTimestamp = finishUpgradeTimestamp;
            return this.self();
        }

        public B maxDownloadTime(Integer maxDownloadTime) {
            this.maxDownloadTime = maxDownloadTime;
            return this.self();
        }

        public B estimateUpgradeTime(Integer estimateUpgradeTime) {
            this.estimateUpgradeTime = estimateUpgradeTime;
            return this.self();
        }

        public B estimateRebootTime(Integer estimateRebootTime) {
            this.estimateRebootTime = estimateRebootTime;
            return this.self();
        }

        public B rebootAfterUpgrade(Boolean rebootAfterUpgrade) {
            this.rebootAfterUpgrade = rebootAfterUpgrade;
            return this.self();
        }

        public B additionalInfo(Map<String, String> additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this.self();
        }

        public B deviceErrorIdx(Integer deviceErrorIdx) {
            this.deviceErrorIdx = deviceErrorIdx;
            return this.self();
        }

        public String toString() {
            return "DeviceUpgradePO.DeviceUpgradePOBuilder(deviceMac=" + this.deviceMac + ", sysId=" + this.sysId + ", downloadLink=" + this.downloadLink + ", status=" + this.status + ", lastActive=" + this.lastActive + ", startUpgradeTimestamp=" + this.startUpgradeTimestamp + ", finishUpgradeTimestamp=" + this.finishUpgradeTimestamp + ", maxDownloadTime=" + this.maxDownloadTime + ", estimateUpgradeTime=" + this.estimateUpgradeTime + ", estimateRebootTime=" + this.estimateRebootTime + ", rebootAfterUpgrade=" + this.rebootAfterUpgrade + ", additionalInfo=" + this.additionalInfo + ", deviceErrorIdx=" + this.deviceErrorIdx + ")";
        }
    }
}

