/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.core.monitor;

import com.tplink.smb.device.firmware.upgrade.common.constants.FirmwareUpgradeStatusEnum;
import com.tplink.smb.device.firmware.upgrade.common.constants.device.DeviceFirmwareUpgradeError;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.DeviceHolder;
import com.tplink.smb.device.firmware.upgrade.core.repository.FirmwareUpgradeRepository;
import java.util.List;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;

public abstract class BaseFirmwareUpgradeMonitor {
    private static final Logger log = LoggerFactory.getLogger(BaseFirmwareUpgradeMonitor.class);
    @Autowired
    protected FirmwareUpgradeRepository upgradeRepository;

    @Scheduled(fixedDelayString="${firmware-upgrade.delay}", initialDelayString="${random.int(${firmware-upgrade.delay})}")
    public void startMonitorTask() {
        this.doMonitorTask();
        this.doScheduleCleanUp();
    }

    @PreDestroy
    public void cleanUp() {
        this.upgradeRepository.cleanUp();
    }

    protected abstract void doMonitorTask();

    protected abstract void notifyWaitingQueue();

    protected void removeTimeoutDevices() {
        List<String> timeoutDeviceList = this.upgradeRepository.pollTimeoutDevicesFromQueue();
        if (timeoutDeviceList.isEmpty()) {
            return;
        }
        log.debug("removeTimeoutDevices to get timeoutDeviceList: {}", timeoutDeviceList);
        for (String deviceHolderStr : timeoutDeviceList) {
            DeviceHolder deviceHolder = DeviceHolder.toBean((String)deviceHolderStr);
            String deviceMac = deviceHolder.getDeviceMac();
            String sysId = deviceHolder.getSysId();
            this.upgradeRepository.getUpgradePO(deviceHolder.getDeviceMac(), deviceHolder.getSysId()).ifPresent(upgradePO -> {
                FirmwareUpgradeStatusEnum status = upgradePO.getStatus();
                if (FirmwareUpgradeStatusEnum.UPGRADE_FINISHED.equals((Object)status)) {
                    return;
                }
                this.updateStatusFromTimeoutMonitor(deviceMac, sysId, status);
            });
        }
    }

    protected void doScheduleCleanUp() {
        List<String> cleanList = this.upgradeRepository.pollDevicesFromCleanUpQueue();
        if (cleanList.isEmpty()) {
            return;
        }
        for (String deviceHolderStr : cleanList) {
            DeviceHolder deviceHolder = DeviceHolder.toBean((String)deviceHolderStr);
            String deviceMac = deviceHolder.getDeviceMac();
            String sysId = deviceHolder.getSysId();
            this.upgradeRepository.removeDeviceInCache(deviceMac, sysId);
        }
    }

    private void updateStatusFromTimeoutMonitor(String deviceMac, String sysId, FirmwareUpgradeStatusEnum status) {
        DeviceFirmwareUpgradeError upgradeError = DeviceFirmwareUpgradeError.GENERAL_ERROR;
        switch (status) {
            case FILE_DOWNLOAD_START: {
                upgradeError = DeviceFirmwareUpgradeError.STAGE_DOWNVAL_TIMEOUT;
                break;
            }
            case UPGRADING: {
                upgradeError = DeviceFirmwareUpgradeError.STAGE_UPGRADE_TIMEOUT;
                break;
            }
            case WAITING_RECOVERY: {
                upgradeError = DeviceFirmwareUpgradeError.STAGE_REBOOT_TIMEOUT;
                break;
            }
        }
        log.error("sysId:{}, device updateStatusFromTimeoutMonitor get status{}", (Object)sysId, (Object)upgradeError);
        this.upgradeRepository.updateStatusFromTimeoutMonitor(deviceMac, sysId, upgradeError);
        if (DeviceFirmwareUpgradeError.STAGE_DOWNVAL_TIMEOUT.equals((Object)upgradeError)) {
            this.notifyWaitingQueue();
        }
    }
}

