/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.core;

import com.tplink.smb.device.firmware.upgrade.common.dto.device.notify.DeviceUpgradeNotifyDTO;
import com.tplink.smb.device.firmware.upgrade.common.rxjava.RetryWithDelay;
import com.tplink.smb.ecsp.common.TransResult;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.proxy.EcspV2DeviceServerProxy;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpgradeNotifyWatcher {
    private static final Logger log = LoggerFactory.getLogger(UpgradeNotifyWatcher.class);
    @Autowired
    private EcspV2DeviceServerProxy v2Proxy;
    private Scheduler upgradeMessageScheduler;
    @Resource(name="upgradeWorkGroup")
    private ExecutorService upgradeWorkGroup;
    private final Subject<DeviceUpgradeNotifyDTO> upgradeNotifySubject = PublishSubject.create().toSerialized();

    public Observable<DeviceUpgradeNotifyDTO> observeUpgradeNotify() {
        return this.upgradeNotifySubject;
    }

    @PostConstruct
    public void constructWatcher() {
        this.upgradeMessageScheduler = Schedulers.from((Executor)this.upgradeWorkGroup);
        this.v2Proxy.observeUpgradeNotifyRequest().retryWhen((Function)new RetryWithDelay()).subscribeOn(this.upgradeMessageScheduler).subscribe(this::handleTransResult);
    }

    private void handleTransResult(@Nonnull TransResult<EcspMessage> result) {
        try {
            if (!result.isOK()) {
                log.warn("Received transfer result is not ok: {}", result);
                return;
            }
            Optional.ofNullable(result.getResult()).map(this::transFromEcspMessage).ifPresent(this::notifyManager);
        }
        catch (Exception ex) {
            log.error("upgrade device handle trans result error: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private void notifyManager(DeviceUpgradeNotifyDTO upgradeNotifyRequestDTO) {
        this.upgradeNotifySubject.onNext((Object)upgradeNotifyRequestDTO);
    }

    private DeviceUpgradeNotifyDTO transFromEcspMessage(EcspMessage message) {
        return DeviceUpgradeNotifyDTO.transFromEcspMessage((EcspMessage)message);
    }
}

