/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.core;

import com.tplink.smb.device.firmware.upgrade.common.constants.FirmwareUpgradeStatusEnum;
import com.tplink.smb.device.firmware.upgrade.common.constants.device.DeviceFirmwareUpgradeDefaultTimeoutEnum;
import com.tplink.smb.device.firmware.upgrade.common.constants.device.DeviceFirmwareUpgradeStageEnum;
import com.tplink.smb.device.firmware.upgrade.common.dto.UpgradeRequestDTO;
import com.tplink.smb.device.firmware.upgrade.common.dto.UpgradeStatusDTO;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.DeviceHolder;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.notify.DeviceUpgradeNotifyDTO;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.upgrade.DeviceUpgradeNotifyResponseDTO;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.upgrade.DeviceUpgradeRequestDTO;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.upgrade.DeviceUpgradeResponseDTO;
import com.tplink.smb.device.firmware.upgrade.common.executor.UpgradeExecutorServiceFactory;
import com.tplink.smb.device.firmware.upgrade.common.handler.AbstractUpgradeStatusHandler;
import com.tplink.smb.device.firmware.upgrade.common.property.FirmwareUpgradeProperties;
import com.tplink.smb.device.firmware.upgrade.common.util.FirmwareUpgradeUtils;
import com.tplink.smb.device.firmware.upgrade.core.UpgradeNotifyWatcher;
import com.tplink.smb.device.firmware.upgrade.core.po.DeviceUpgradePO;
import com.tplink.smb.device.firmware.upgrade.core.po.MonitorTimeoutSettingPO;
import com.tplink.smb.device.firmware.upgrade.core.repository.FirmwareUpgradeRepository;
import com.tplink.smb.ecsp.common.TransResult;
import com.tplink.smb.ecsp.common.util.JacksonUtils;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.body.MessageBody;
import com.tplink.smb.ecsp.proxy.EcspV2DeviceServerProxy;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.eventcenter.api.EventHandler;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseDeviceFirmwareUpgradeManager {
    private static final Logger log = LoggerFactory.getLogger(BaseDeviceFirmwareUpgradeManager.class);
    @Autowired
    protected FirmwareUpgradeRepository upgradeRepository;
    @Autowired
    private EcspV2DeviceServerProxy v2Proxy;
    @Autowired
    private UpgradeNotifyWatcher upgradeNotifyWatcher;
    @Autowired
    protected EventCenter eventCenter;
    @Autowired
    private FirmwareUpgradeProperties properties;
    private Scheduler upgradeMessageScheduler;
    @Resource(name="upgradeWorkGroup")
    private ExecutorService upgradeWorkGroup;
    private String eventCenterTopic;
    private String eventCenterGroupId;
    private static final ExecutorService EVENT_POOL = UpgradeExecutorServiceFactory.getEventThreadPool();
    private static final ExecutorService REQUEST_SENDING_POOL = UpgradeExecutorServiceFactory.getSendRequestThreadPool();

    @PostConstruct
    public void observeUpgradeNotify() {
        this.upgradeMessageScheduler = Schedulers.from((Executor)this.upgradeWorkGroup);
        this.eventCenterTopic = this.properties.getUpgradeStatusTopic();
        this.eventCenterGroupId = "firmware-upgrade" + this.eventCenterTopic;
        log.debug("upgrade device event center topic: {}", (Object)this.eventCenterTopic);
        this.upgradeNotifyWatcher.observeUpgradeNotify().subscribe(this::handleUpgradeNotifyRequest);
    }

    @PreDestroy
    public void shutdownThreadPools() {
        this.upgradeMessageScheduler.shutdown();
        this.upgradeWorkGroup.shutdown();
        EVENT_POOL.shutdown();
        REQUEST_SENDING_POOL.shutdown();
    }

    public abstract void publishMessage(String var1, String var2);

    public abstract void sendUpgradeRequest(List<UpgradeRequestDTO> var1);

    public abstract void notifyWaitingQueue();

    public void sendRequestToDevice(String deviceMac, String sysId) {
        this.upgradeRepository.getUpgradePO(deviceMac, sysId).ifPresent(deviceUpgradePO -> {
            if (FirmwareUpgradeStatusEnum.UPGRADE_READY.equals((Object)deviceUpgradePO.getStatus())) {
                UpgradeRequestDTO upgradeRequest = DeviceUpgradePO.toRequestDTO(deviceUpgradePO);
                DeviceUpgradeRequestDTO upgradeRequestBody = DeviceUpgradeRequestDTO.construct((UpgradeRequestDTO)upgradeRequest);
                this.sendV2UpgradeRequest(deviceMac, sysId, (MessageBody)upgradeRequestBody);
            } else {
                log.debug("sysId:{}, WRONG SENDING REQUEST: {}", (Object)sysId, deviceUpgradePO);
            }
        });
    }

    private void sendV2UpgradeRequest(String deviceMac, String sysId, MessageBody upgradeRequestBody) {
        REQUEST_SENDING_POOL.execute(() -> {
            try {
                long deviceContextTimeoutMills;
                long requestStageTimeoutMills;
                Optional<MonitorTimeoutSettingPO> timeoutSettingOptional = this.upgradeRepository.getTimeoutSettingPO(deviceMac, sysId);
                if (timeoutSettingOptional.isPresent()) {
                    MonitorTimeoutSettingPO timeoutSettingPO = timeoutSettingOptional.get();
                    requestStageTimeoutMills = timeoutSettingPO.getRequestStageTimeout();
                    deviceContextTimeoutMills = timeoutSettingPO.getDeviceContextTimeout();
                } else {
                    long defaultRequestTimeout = DeviceFirmwareUpgradeDefaultTimeoutEnum.STAGE_REQUEST.getTimeout();
                    TimeUnit defaultRequestTimeUnit = DeviceFirmwareUpgradeDefaultTimeoutEnum.STAGE_REQUEST.getTimeUnit();
                    requestStageTimeoutMills = TimeUnit.MILLISECONDS.convert(defaultRequestTimeout, defaultRequestTimeUnit);
                    long defaultContextTimeout = DeviceFirmwareUpgradeDefaultTimeoutEnum.CONTEXT.getTimeout();
                    TimeUnit defaultContextTimeUnit = DeviceFirmwareUpgradeDefaultTimeoutEnum.CONTEXT.getTimeUnit();
                    deviceContextTimeoutMills = TimeUnit.MILLISECONDS.convert(defaultContextTimeout, defaultContextTimeUnit);
                }
                this.v2Proxy.sendV2UpgradeRequest(deviceMac, "2.0.0", upgradeRequestBody, Integer.valueOf(FirmwareUpgradeUtils.randomInt((int)0, (int)0x7FFFFFFE)), requestStageTimeoutMills, deviceContextTimeoutMills).subscribeOn(this.upgradeMessageScheduler).subscribe((ecspMessageTransResult, throwable) -> this.handleUpgradeResponse((TransResult<EcspMessage>)ecspMessageTransResult, (Throwable)throwable, deviceMac, sysId));
            }
            catch (Exception e) {
                log.error("sysId:{}, sendV2UpgradeRequest error", (Object)sysId, (Object)e);
            }
        });
    }

    private void updateStatusOnRequestSentError(String deviceMac, String sysId) {
        this.upgradeRepository.updateStatusOnRequestSentError(deviceMac, sysId);
        this.publishMessage(deviceMac, sysId);
    }

    public void handleUpgradeResponse(TransResult<EcspMessage> transResult, Throwable throwable, String deviceMac, String sysId) {
        if (Objects.nonNull(throwable)) {
            log.error("sysId:{}, handleUpgradeResponse failed by throwable", (Object)sysId, (Object)throwable);
            this.updateStatusOnRequestSentError(deviceMac, sysId);
            return;
        }
        if (!transResult.isOK()) {
            log.error("sysId:{},handleUpgradeResponse failed by transResult is not ok.", (Object)sysId, (Object)throwable);
            this.updateStatusOnRequestSentError(deviceMac, sysId);
            return;
        }
        if (((EcspMessage)transResult.getResult()).getHeader().getError() != 0) {
            log.error("sysId:{},handleUpgradeResponse failed by transResult is getError not 0.", (Object)sysId, (Object)throwable);
            this.updateStatusOnRequestSentError(deviceMac, sysId);
            return;
        }
        EcspMessage message = (EcspMessage)transResult.getResult();
        if (Objects.isNull(message)) {
            log.error("sysId:{},handleUpgradeResponse failed by transResult getResult is null.", (Object)sysId, (Object)throwable);
            this.updateStatusOnRequestSentError(deviceMac, sysId);
            return;
        }
        if (Objects.isNull(message.getHeader()) || message.getError() != 0) {
            log.error("sysId:{},handleUpgradeResponse failed by transResult getHeader is null or error.", (Object)sysId, (Object)throwable);
            this.updateStatusOnRequestSentError(deviceMac, sysId);
            return;
        }
        String messageBodyStr = JacksonUtils.pojo2Json((Object)message.getBody());
        DeviceUpgradeResponseDTO upgradeResponse = (DeviceUpgradeResponseDTO)JacksonUtils.json2Pojo((String)messageBodyStr, DeviceUpgradeResponseDTO.class);
        this.upgradeRepository.updateStatusFromDeviceUpgradeResponse(deviceMac, sysId, upgradeResponse);
        this.publishMessage(deviceMac, sysId);
    }

    private void handleUpgradeNotifyRequest(DeviceUpgradeNotifyDTO upgradeNotifyDTO) {
        String sysId = upgradeNotifyDTO.getSysId();
        boolean needReply = upgradeNotifyDTO.getNeedReply();
        if (needReply) {
            String deviceMac = upgradeNotifyDTO.getDeviceMac();
            DeviceUpgradeNotifyResponseDTO upgradeNotifyResponseBody = new DeviceUpgradeNotifyResponseDTO();
            this.v2Proxy.sendUpgradeNotifyResponse(deviceMac, "2.0.0", (MessageBody)upgradeNotifyResponseBody, Integer.valueOf(FirmwareUpgradeUtils.randomInt((int)0, (int)0x7FFFFFFE)), 10000L).subscribeOn(this.upgradeMessageScheduler).subscribe((result, throwable) -> {
                if (Objects.isNull(throwable)) {
                    this.handleUpgradeNotifyResponseSent((TransResult<Integer>)result);
                } else {
                    log.warn("sysId:{}, handleUpgradeNotifyRequest throwable: {}", new Object[]{sysId, throwable.getMessage(), throwable});
                }
            });
        }
        this.upgradeRepository.updateStatusFromUpgradeNotify(upgradeNotifyDTO);
        this.publishMessage(upgradeNotifyDTO.getDeviceMac(), sysId);
        if (Objects.nonNull(upgradeNotifyDTO.getContent()) && DeviceFirmwareUpgradeStageEnum.DOWNVAL.equals((Object)upgradeNotifyDTO.getContent().getStage())) {
            this.notifyWaitingQueue();
        }
    }

    private void handleUpgradeNotifyResponseSent(TransResult<Integer> result) {
        if (!result.isOK()) {
            log.error("send upgrade notify response failed: {}", result);
        }
    }

    public List<UpgradeStatusDTO> getDeviceUpgradeStatus(List<DeviceHolder> deviceHolders) {
        ArrayList<UpgradeStatusDTO> resultLst = new ArrayList<UpgradeStatusDTO>();
        for (DeviceHolder deviceHolder : deviceHolders) {
            Optional<DeviceUpgradePO> optionalUpgradePO = this.upgradeRepository.getUpgradePO(deviceHolder.getDeviceMac(), deviceHolder.getSysId());
            if (!optionalUpgradePO.isPresent()) continue;
            UpgradeStatusDTO upgradeStatusDTO = DeviceUpgradePO.toStatusDTO(optionalUpgradePO.get());
            resultLst.add(upgradeStatusDTO);
            if (!FirmwareUpgradeStatusEnum.UPGRADE_FINISHED.equals((Object)upgradeStatusDTO.getStatus())) continue;
            this.upgradeRepository.updateCleanUpQueue(deviceHolder);
        }
        return resultLst;
    }

    public UpgradeStatusDTO getDeviceUpgradeStatus(String deviceMac, String sysId) {
        DeviceHolder deviceHolder = DeviceHolder.create((String)deviceMac, (String)sysId);
        List<DeviceHolder> deviceHolders = Collections.singletonList(deviceHolder);
        List<UpgradeStatusDTO> statusList = this.getDeviceUpgradeStatus(deviceHolders);
        if (statusList.isEmpty()) {
            return null;
        }
        return statusList.get(0);
    }

    public UpgradeStatusDTO reportReconnected(String deviceMac, String sysId) {
        log.debug("sysId:{}, reportReconnected device.", (Object)sysId);
        this.upgradeRepository.updateStatusFromReport(deviceMac, sysId);
        this.publishMessage(deviceMac, sysId);
        return this.getDeviceUpgradeStatus(deviceMac, sysId);
    }

    public void registerUpgradeStatus(AbstractUpgradeStatusHandler statusHandler) {
        this.eventCenter.registerUnicast(this.eventCenterTopic, this.eventCenterGroupId, (EventHandler)statusHandler, EVENT_POOL);
    }

    public void unregisterUpgradeStatus(AbstractUpgradeStatusHandler statusHandler) {
        this.eventCenter.unregister(this.eventCenterTopic, (EventHandler)statusHandler);
    }
}

