/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.iam.api.internal.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IamAddUserRequestDTO {
    private String userId;
    @NotBlank
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$", message="Invalid username.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @NotBlank @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$", message="Invalid username.") String username;
    @NotBlank
    @Pattern(regexp="^(?![A-Za-z]+$)(?![0-9]+$)(?![^A-Za-z0-9]+$)([!-~]{8,128})$", message="Invalid password")
    @PII(strategy=PIIMaskStrategy.MASK)
    private @NotBlank @Pattern(regexp="^(?![A-Za-z]+$)(?![0-9]+$)(?![^A-Za-z0-9]+$)([!-~]{8,128})$", message="Invalid password") String password;
    @NotNull
    @Min(value=5L)
    private @NotNull @Min(value=5L) Long loginTtl;
    @NotNull
    private Integer loginTtlUnit;
    private Integer language;

    public static IamAddUserRequestDTOBuilder builder() {
        return new IamAddUserRequestDTOBuilder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Long getLoginTtl() {
        return this.loginTtl;
    }

    public Integer getLoginTtlUnit() {
        return this.loginTtlUnit;
    }

    public Integer getLanguage() {
        return this.language;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLoginTtl(Long loginTtl) {
        this.loginTtl = loginTtl;
    }

    public void setLoginTtlUnit(Integer loginTtlUnit) {
        this.loginTtlUnit = loginTtlUnit;
    }

    public void setLanguage(Integer language) {
        this.language = language;
    }

    public IamAddUserRequestDTO(String userId, String username, String password, Long loginTtl, Integer loginTtlUnit, Integer language) {
        this.userId = userId;
        this.username = username;
        this.password = password;
        this.loginTtl = loginTtl;
        this.loginTtlUnit = loginTtlUnit;
        this.language = language;
    }

    public IamAddUserRequestDTO() {
    }

    public static class IamAddUserRequestDTOBuilder {
        private String userId;
        private String username;
        private String password;
        private Long loginTtl;
        private Integer loginTtlUnit;
        private Integer language;

        IamAddUserRequestDTOBuilder() {
        }

        public IamAddUserRequestDTOBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public IamAddUserRequestDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public IamAddUserRequestDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public IamAddUserRequestDTOBuilder loginTtl(Long loginTtl) {
            this.loginTtl = loginTtl;
            return this;
        }

        public IamAddUserRequestDTOBuilder loginTtlUnit(Integer loginTtlUnit) {
            this.loginTtlUnit = loginTtlUnit;
            return this;
        }

        public IamAddUserRequestDTOBuilder language(Integer language) {
            this.language = language;
            return this;
        }

        public IamAddUserRequestDTO build() {
            return new IamAddUserRequestDTO(this.userId, this.username, this.password, this.loginTtl, this.loginTtlUnit, this.language);
        }

        public String toString() {
            return "IamAddUserRequestDTO.IamAddUserRequestDTOBuilder(userId=" + this.userId + ", username=" + this.username + ", password=" + this.password + ", loginTtl=" + this.loginTtl + ", loginTtlUnit=" + this.loginTtlUnit + ", language=" + this.language + ")";
        }
    }
}

