/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.insight.upload;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.xiaoymin.knife4j.core.util.Knife4jUtils;
import com.github.xiaoymin.knife4j.core.util.StrUtil;
import com.github.xiaoymin.knife4j.insight.Knife4jInsightDiscoveryInfo;
import com.github.xiaoymin.knife4j.insight.Knife4jInsightRoute;
import com.github.xiaoymin.knife4j.insight.config.Knife4jInsightCommonInfo;
import com.github.xiaoymin.knife4j.insight.openapi3.Knife4jInsightOpenAPI3Config;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Knife4jInsightUploader {
    private static final Logger log = LoggerFactory.getLogger(Knife4jInsightUploader.class);

    public static void upload(Knife4jInsightCommonInfo commonInfo) throws UnknownHostException, JsonProcessingException {
        Knife4jInsightOpenAPI3Config openAPI3Config;
        Knife4jInsightDiscoveryInfo knife4jCloudDiscoveryInfo = new Knife4jInsightDiscoveryInfo();
        ObjectMapper objectMapper = new ObjectMapper();
        knife4jCloudDiscoveryInfo.setSpec(commonInfo.getSpec());
        knife4jCloudDiscoveryInfo.setHost(InetAddress.getLocalHost().getHostAddress());
        knife4jCloudDiscoveryInfo.setPort(commonInfo.getPort());
        knife4jCloudDiscoveryInfo.setServiceName(commonInfo.getServiceName());
        knife4jCloudDiscoveryInfo.setAccessKey(commonInfo.getSecret());
        knife4jCloudDiscoveryInfo.setNamespace(commonInfo.getNamespace());
        String localGroup = "http://localhost:" + commonInfo.getPort() + commonInfo.getContextPath() + "/v3/api-docs/swagger-config";
        log.debug("localHost:{}", (Object)localGroup);
        String response = Knife4jUtils.getRetry(localGroup, 3);
        if (StrUtil.isNotBlank(response) && (openAPI3Config = (Knife4jInsightOpenAPI3Config)objectMapper.readValue(response, Knife4jInsightOpenAPI3Config.class)).getUrls() != null && !openAPI3Config.getUrls().isEmpty()) {
            openAPI3Config.getUrls().forEach(route -> {
                Knife4jInsightRoute knife4jCloudRoute = new Knife4jInsightRoute();
                knife4jCloudRoute.setPath(route.getUrl());
                knife4jCloudRoute.setGroupName(route.getName());
                String apiUrl = "http://localhost:" + commonInfo.getPort() + route.getUrl();
                log.debug("apiUrl:{}", (Object)apiUrl);
                knife4jCloudRoute.setContent(Knife4jUtils.getRetry(apiUrl, 3));
                knife4jCloudDiscoveryInfo.addRoute(knife4jCloudRoute);
            });
        }
        String cloudApi = commonInfo.getServer() + "/api/cloud/upload";
        log.debug("Start Register To Knife4jInsight ,CloudApi:{}", (Object)cloudApi);
        String body = objectMapper.writeValueAsString((Object)knife4jCloudDiscoveryInfo);
        String result = Knife4jUtils.postRetry(cloudApi, body, 3);
        if (result != null) {
            log.debug("Register To Knife4jInsight Finished");
        }
    }
}

