/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.port.i.a;

import com.tplink.smb.omada.anomaly.api.internal.health.ClientHealthInternalDTO;
import com.tplink.smb.omada.client.api.openapi.vo.healthv2.ClientHealthDetailVO;
import com.tplink.smb.omada.client.api.openapi.vo.healthv2.sub.CommonSubHealthInfoDetailVO;
import com.tplink.smb.omada.client.api.openapi.vo.healthv2.time.TimeScoreItemVO;
import com.tplink.smb.omada.client.api.openapi.vo.healthv2.time.TimeScoreListVO;
import com.tplink.smb.omada.client.api.openapi.vo.healthv2.time.TimeValueItemVO;
import com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.ClientHealthStat;
import com.tplink.smb.omada.client.port.i.b.b;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class a {
    private a() {
    }

    public static ClientHealthDetailVO a(List<ClientHealthInternalDTO> scoreDTOList, List<ClientHealthStat> clientStatList, List<Long> timeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(timeList)) {
            return ClientHealthDetailVO.createNoDataVO(timeList);
        }
        Map<Long, ClientHealthInternalDTO> clientHealthScoreMap = Optional.ofNullable(scoreDTOList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(ClientHealthInternalDTO::getTime, vo -> vo, (existing, replacement) -> replacement));
        Map<Long, ClientHealthStat> clientStatMap = Optional.ofNullable(clientStatList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(ClientHealthStat::getTime, vo -> vo, (existing, replacement) -> replacement));
        int size = org.apache.commons.collections.CollectionUtils.size(clientStatList);
        ArrayList<TimeValueItemVO<Integer>> rssiList = new ArrayList<TimeValueItemVO<Integer>>(size);
        ArrayList<TimeValueItemVO<Integer>> associationTimeList = new ArrayList<TimeValueItemVO<Integer>>(size);
        ArrayList<TimeValueItemVO<Long>> dataRateList = new ArrayList<TimeValueItemVO<Long>>(size);
        for (Long time : timeList) {
            ClientHealthStat clientHealthStat = clientStatMap.get(time);
            if (Objects.isNull(clientHealthStat)) {
                rssiList.add(TimeValueItemVO.createNullValueVO((Long)time));
                associationTimeList.add(TimeValueItemVO.createNullValueVO((Long)time));
                dataRateList.add(TimeValueItemVO.createNullValueVO((Long)time));
                continue;
            }
            rssiList.add(TimeValueItemVO.createMillSecondVO((Number)clientHealthStat.getRssi(), (Long)time));
            associationTimeList.add(TimeValueItemVO.createMillSecondVO((Number)clientHealthStat.getAssociationTime(), (Long)time));
            Long dataRate = (Optional.ofNullable(clientHealthStat.getRxRate()).orElse(0L) + Optional.ofNullable(clientHealthStat.getTxRate()).orElse(0L)) / 2L;
            dataRateList.add((TimeValueItemVO<Long>)TimeValueItemVO.createMillSecondVO((Number)dataRate, (Long)time));
        }
        ClientHealthDetailVO clientHealthDetailVO = new ClientHealthDetailVO();
        Long lastTime = timeList.get(timeList.size() - 1);
        ClientHealthInternalDTO lastOne = clientHealthScoreMap.get(lastTime);
        clientHealthDetailVO.setScore(a.a(lastOne, () -> lastOne.getScore()));
        clientHealthDetailVO.setRssi(a.a(rssiList, a.a(lastOne, () -> lastOne.getRssiScore())));
        clientHealthDetailVO.setAssociationTime(a.a(associationTimeList, a.a(lastOne, () -> lastOne.getAssociationTimeScore())));
        clientHealthDetailVO.setRate(a.b(dataRateList, a.a(lastOne, () -> lastOne.getDataRateScore())));
        return clientHealthDetailVO;
    }

    public static TimeScoreListVO a(List<ClientHealthInternalDTO> scoreDTOList, List<Long> timeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(timeList)) {
            return null;
        }
        Map<Long, ClientHealthInternalDTO> healthScoreDTOMap = Optional.ofNullable(scoreDTOList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(ClientHealthInternalDTO::getTime, vo -> vo, (existing, replacement) -> replacement));
        List<TimeScoreItemVO> timeScoreList = timeList.stream().map(time -> {
            ClientHealthInternalDTO healthScoreDTO = (ClientHealthInternalDTO)healthScoreDTOMap.get(time);
            TimeScoreItemVO timeScoreItemVO = TimeScoreItemVO.createMillSecondVO((Integer)-1, (Long)time);
            if (Objects.nonNull(healthScoreDTO)) {
                timeScoreItemVO = TimeScoreItemVO.createMillSecondVO((Integer)healthScoreDTO.getScore(), (Long)healthScoreDTO.getTime());
            }
            return timeScoreItemVO;
        }).toList();
        return new TimeScoreListVO(timeScoreList);
    }

    public static List<TimeScoreItemVO> a(List<ClientHealthInternalDTO> scoreDTOList, Long end) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(scoreDTOList)) {
            return a.a(end);
        }
        Map<Long, ClientHealthInternalDTO> healthScoreDTOMap = Optional.ofNullable(scoreDTOList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(ClientHealthInternalDTO::getTime, vo -> vo, (existing, replacement) -> replacement));
        long lastValidFormatTime = end / 600L * 600L;
        ClientHealthInternalDTO lastOne = healthScoreDTOMap.get(lastValidFormatTime);
        ClientHealthInternalDTO lastSecondOne = healthScoreDTOMap.get(lastValidFormatTime - 600L);
        ClientHealthInternalDTO lastThirdOne = healthScoreDTOMap.get(lastValidFormatTime - 1200L);
        lastValidFormatTime = Objects.nonNull(lastOne) ? lastOne.getTime() : (Objects.nonNull(lastSecondOne) ? lastSecondOne.getTime() : (Objects.nonNull(lastThirdOne) ? lastThirdOne.getTime() : (lastValidFormatTime -= 1200L)));
        ArrayList<Long> timePoints = new ArrayList<Long>();
        for (long current = lastValidFormatTime - 86400L + 600L; current <= lastValidFormatTime; current += 600L) {
            timePoints.add(current);
        }
        List<TimeScoreItemVO> timeScoreItemVOList = timePoints.stream().map(time -> {
            ClientHealthInternalDTO healthScoreDTO = (ClientHealthInternalDTO)healthScoreDTOMap.get(time);
            return Objects.nonNull(healthScoreDTO) ? TimeScoreItemVO.createMillSecondVO((Integer)healthScoreDTO.getScore(), (Long)healthScoreDTO.getTime()) : TimeScoreItemVO.createMillSecondVO((Integer)-1, (Long)time);
        }).collect(Collectors.toList());
        return timeScoreItemVOList;
    }

    private static CommonSubHealthInfoDetailVO a(List<TimeValueItemVO<Integer>> timeValueList, Integer score) {
        Integer averageNum = a.a(timeValueList);
        CommonSubHealthInfoDetailVO subHealthInfoDetailVO = new CommonSubHealthInfoDetailVO(score, averageNum, timeValueList);
        return subHealthInfoDetailVO;
    }

    private static CommonSubHealthInfoDetailVO b(List<TimeValueItemVO<Long>> timeValueList, Integer score) {
        Integer averageNum = a.a(timeValueList);
        CommonSubHealthInfoDetailVO subHealthInfoDetailVO = new CommonSubHealthInfoDetailVO(score, averageNum, timeValueList);
        return subHealthInfoDetailVO;
    }

    private static List<TimeScoreItemVO> a(Long end) {
        Long start = end - 86400L;
        List<Long> timeList = b.b(start, end, 600);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(timeList)) {
            return Collections.emptyList();
        }
        List<TimeScoreItemVO> timeScoreItemVOList = timeList.stream().map(time -> TimeScoreItemVO.createMillSecondVO((Integer)-1, (Long)time)).collect(Collectors.toList());
        return timeScoreItemVOList;
    }

    private static <T extends Number> Integer a(List<TimeValueItemVO<T>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        List<TimeValueItemVO> validList = list.stream().filter(timeValue -> Objects.nonNull(timeValue) && Objects.nonNull(timeValue.getPastNum())).toList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(validList)) {
            return null;
        }
        int sum = validList.stream().mapToInt(timeValue -> timeValue.getPastNum().intValue()).sum();
        int count = validList.size();
        return Math.round((float)sum / (float)count);
    }

    public static <T> Integer a(T dto, Supplier<Integer> scoreSupplier) {
        return dto != null && scoreSupplier != null ? Optional.ofNullable(scoreSupplier.get()).orElse(-1) : -1;
    }
}

