/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.eventcenter.api.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoSerializeUtils {
    private static final Logger log = LoggerFactory.getLogger(KryoSerializeUtils.class);
    private static final int KRYO_BUFFER_SIZE = 5120;
    private static final ThreadLocal<Kryo> KRYOS = ThreadLocal.withInitial(() -> {
        Kryo kryo = new Kryo();
        kryo.setRegistrationRequired(false);
        return kryo;
    });

    private KryoSerializeUtils() {
    }

    public static byte[] bean2ByteArray(Object object) {
        byte[] byArray;
        Output output = new Output(5120, -1);
        try {
            Kryo kryo = KRYOS.get();
            kryo.writeObject(output, object);
            byArray = output.toBytes();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.warn("kryo serial object failed, exception :{}", (Throwable)e);
                return new byte[0];
            }
        }
        output.close();
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T byteArray2Bean(byte[] source, Class<T> destinationClass) {
        Kryo kryo = KRYOS.get();
        try (Input input = new Input(source);){
            Object object = kryo.readObject(input, destinationClass);
            return (T)object;
        }
        catch (Exception e) {
            log.warn("kryo deserialize object failed, exception :{}", (Throwable)e);
            return null;
        }
    }

    public static void clearKryo() {
        KRYOS.remove();
    }
}

