/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.eventcenter.api.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(JsonUtils.class);

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static void setMapper(ObjectMapper mapper) {
        JsonUtils.mapper = mapper;
    }

    public static <T> T readFile(File file, Class<T> tClass) {
        try {
            return (T)mapper.readValue(file, tClass);
        }
        catch (IOException e) {
            logger.warn("Parse json message exception .", (Throwable)e);
            return null;
        }
    }

    public static <T> T readInputStream(InputStream inputStream, Class<T> tClass) {
        try {
            return (T)mapper.readValue(inputStream, tClass);
        }
        catch (IOException e) {
            logger.warn("Parse json message exception .", (Throwable)e);
            return null;
        }
    }

    public static String bean2Json(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            logger.warn("fail to transfer bean to Json", (Throwable)e);
            return null;
        }
    }

    public static byte[] bean2Bytes(Object object) {
        try {
            return mapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            logger.warn("fail to transfer bean to bytes", (Throwable)e);
            return null;
        }
    }

    public static <T> T json2bean(String json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            logger.debug("Parse json message exception. jsonString:{}, class:{}", new Object[]{json, clazz, e});
            return null;
        }
    }

    public static <T> T map2Bean(Map map, Class<T> tClass) {
        return (T)mapper.convertValue((Object)map, tClass);
    }

    public static <T> List<? super T> json2list(String json, Class<T> tClass) {
        JavaType type = JsonUtils.getCollectionType(List.class, tClass);
        try {
            return (List)mapper.readValue(json, type);
        }
        catch (IOException e) {
            logger.warn("fail to transfer json to list .", (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> json2Map(String json) {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        try {
            return (Map)mapper.readValue(json, (TypeReference)typeRef);
        }
        catch (IOException e) {
            logger.warn("fail to transfer json to map .", (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> json2MapWithoutLog(String json) {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        try {
            return (Map)mapper.readValue(json, (TypeReference)typeRef);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, new Class[]{elementClasses});
    }
}

