/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.eventcenter.api.event;

import com.tplink.smb.eventcenter.api.event.DomainEvent;
import com.tplink.smb.eventcenter.api.util.StringUtils;
import java.util.Date;

public abstract class AbstractDomainEvent
implements DomainEvent {
    protected String id = StringUtils.generateUUID();
    protected Date createTime = new Date();
    protected String type;

    public AbstractDomainEvent() {
    }

    public AbstractDomainEvent(String type) {
        this.type = type;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Date occurredOn() {
        return this.createTime;
    }

    @Override
    public String type() {
        return this.type;
    }

    protected String getClassName() {
        return this.getClass().getName();
    }

    protected AbstractDomainEvent(AbstractDomainEventBuilder<?, ?> b) {
        this.id = b.id;
        this.createTime = b.createTime;
        this.type = b.type;
    }

    public String toString() {
        return "AbstractDomainEvent(id=" + this.id + ", createTime=" + this.createTime + ", type=" + this.type + ")";
    }

    public static abstract class AbstractDomainEventBuilder<C extends AbstractDomainEvent, B extends AbstractDomainEventBuilder<C, B>> {
        private String id;
        private Date createTime;
        private String type;

        public B id(String id) {
            this.id = id;
            return this.self();
        }

        public B createTime(Date createTime) {
            this.createTime = createTime;
            return this.self();
        }

        public B type(String type) {
            this.type = type;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "AbstractDomainEvent.AbstractDomainEventBuilder(id=" + this.id + ", createTime=" + this.createTime + ", type=" + this.type + ")";
        }
    }
}

