/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.eventcenter.api.constant;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum SerializeEnum {
    KRYO(0, "Kryo"),
    JSON(1, "Json");

    private final Integer type;
    private final String name;
    private static final Map<Integer, SerializeEnum> TYPE_MAP;

    public static SerializeEnum resolve(Integer type) {
        SerializeEnum serializeEnum = TYPE_MAP.get(type);
        if (Objects.isNull((Object)serializeEnum)) {
            return JSON;
        }
        return serializeEnum;
    }

    private SerializeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    public Integer getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    static {
        TYPE_MAP = new HashMap<Integer, SerializeEnum>(2);
        for (SerializeEnum type : SerializeEnum.values()) {
            TYPE_MAP.put(type.getType(), type);
        }
    }
}

