/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.eventcenter.api;

import com.tplink.smb.eventcenter.api.BaseEvent;
import com.tplink.smb.eventcenter.api.util.KryoSerializeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventV2<T>
extends BaseEvent<T> {
    private static final Logger log = LoggerFactory.getLogger(EventV2.class);

    public EventV2(String filterKey, T message) {
        this.filterKey = filterKey;
        this.message = message;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public static EventV2 toBean(byte[] bytes) {
        return KryoSerializeUtils.byteArray2Bean(bytes, EventV2.class);
    }

    public byte[] kryoSerialize() {
        return KryoSerializeUtils.bean2ByteArray(this);
    }

    protected EventV2(EventV2Builder<T, ?, ?> b) {
        super(b);
    }

    public static <T> EventV2Builder<T, ?, ?> builder() {
        return new EventV2BuilderImpl();
    }

    public EventV2() {
    }

    public String toString() {
        return "EventV2()";
    }

    private static final class EventV2BuilderImpl<T>
    extends EventV2Builder<T, EventV2<T>, EventV2BuilderImpl<T>> {
        private EventV2BuilderImpl() {
        }

        @Override
        protected EventV2BuilderImpl<T> self() {
            return this;
        }

        @Override
        public EventV2<T> build() {
            return new EventV2(this);
        }
    }

    public static abstract class EventV2Builder<T, C extends EventV2<T>, B extends EventV2Builder<T, C, B>>
    extends BaseEvent.BaseEventBuilder<T, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "EventV2.EventV2Builder(super=" + super.toString() + ")";
        }
    }
}

