/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.eventcenter.api;

public abstract class BaseEvent<T> {
    protected String filterKey;
    protected long timeStamp;
    protected T message;

    protected BaseEvent(BaseEventBuilder<T, ?, ?> b) {
        this.filterKey = b.filterKey;
        this.timeStamp = b.timeStamp;
        this.message = b.message;
    }

    public String getFilterKey() {
        return this.filterKey;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public T getMessage() {
        return this.message;
    }

    public BaseEvent() {
    }

    public BaseEvent(String filterKey, long timeStamp, T message) {
        this.filterKey = filterKey;
        this.timeStamp = timeStamp;
        this.message = message;
    }

    public static abstract class BaseEventBuilder<T, C extends BaseEvent<T>, B extends BaseEventBuilder<T, C, B>> {
        private String filterKey;
        private long timeStamp;
        private T message;

        public B filterKey(String filterKey) {
            this.filterKey = filterKey;
            return this.self();
        }

        public B timeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
            return this.self();
        }

        public B message(T message) {
            this.message = message;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "BaseEvent.BaseEventBuilder(filterKey=" + this.filterKey + ", timeStamp=" + this.timeStamp + ", message=" + this.message + ")";
        }
    }
}

