/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.stack.api.internal.service;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.device.StandardOswPortIndex;
import com.tplink.smb.omada.common.gridquery.QueryDataVO;
import com.tplink.smb.omada.device.manage.message.body.osw.StackMemberInfoGetResp;
import com.tplink.smb.omada.device.manage.message.body.osw.v2.OswAdoptRespV2Body;
import com.tplink.smb.omada.device.manage.message.body.osw.v2.OswStackConfig;
import com.tplink.smb.omada.device.manage.message.body.osw.v2.OswStackMemberDeviceInfo;
import com.tplink.smb.omada.device.manage.message.body.osw.v2.OswStackMemberStackInfo;
import com.tplink.smb.omada.device.manage.message.body.osw.v2.ReportedPortAndLagConfig;
import com.tplink.smb.omada.device.manage.message.config.BaseCliConfig;
import com.tplink.smb.omada.device.manage.message.config.CliConfig;
import com.tplink.smb.omada.device.manage.message.config.SetKey;
import com.tplink.smb.omada.device.manage.message.config.osw.OswPortConfigList;
import com.tplink.smb.omada.device.manage.message.config.osw.OswRetainConfigKeyEnum;
import com.tplink.smb.omada.device.manage.message.config.osw.OswSetKeyEnum;
import com.tplink.smb.omada.device.manage.message.config.osw.OswSfpPortConfig;
import com.tplink.smb.omada.device.manage.message.discovery.BaseDeviceMisc;
import com.tplink.smb.omada.manager.c.x;
import com.tplink.smb.omada.manager.configuration.api.internal.dto.UserDescriptionDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.OswSfpPortSettingDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.OswStackPortGroupDTO;
import com.tplink.smb.omada.manager.configuration.api.web.network.lan.vlan.SelectStackForVlanVO;
import com.tplink.smb.omada.manager.configuration.api.web.network.lan.vlan.SelectStacksWithVlanVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.SelectStacksVO;
import com.tplink.smb.omada.manager.configuration.domain.model.site.a.c;
import com.tplink.smb.omada.manager.configuration.domain.model.site.component.a.h;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.BaseLanNetwork;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.F;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.Z;
import com.tplink.smb.omada.manager.configuration.domain.shared.z;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.DeviceLocationDetailDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.osw.OswCapabilityDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.osw.OswQosConfigDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.osw.OswSettingDTO;
import com.tplink.smb.omada.manager.device.api.web.device.dto.ModifyDeviceLocationVO;
import com.tplink.smb.omada.manager.device.api.web.move.MoveSiteProcessVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswConfigVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswLagVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswStaticRoutingVO;
import com.tplink.smb.omada.manager.device.domain.model.device.E;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.domain.model.device.Q;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.OswCapability;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.aA;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.aB;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.aE;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.aG;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.aS;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.aT;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.aW;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.aa;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.ar;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.ay;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.b.w;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.d.P;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.h.j;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.h.k;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.h.m;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.p;
import com.tplink.smb.omada.manager.j.a.a.g;
import com.tplink.smb.omada.manager.stack.a.b;
import com.tplink.smb.omada.manager.stack.api.internal.dto.InitOswStackRespDTO;
import com.tplink.smb.omada.manager.stack.api.internal.dto.LogUserDTO;
import com.tplink.smb.omada.manager.stack.api.internal.dto.OswStackInfoDTO;
import com.tplink.smb.omada.manager.stack.api.internal.dto.OswStackMemberDTO;
import com.tplink.smb.omada.manager.stack.api.internal.dto.OswStackMsgDTO;
import com.tplink.smb.omada.manager.stack.api.internal.dto.SimpleStackInfoDTO;
import com.tplink.smb.omada.manager.stack.api.internal.dto.SimpleStackInfoDetailDTO;
import com.tplink.smb.omada.manager.stack.api.internal.dto.SimpleStackMemberInfoDTO;
import com.tplink.smb.omada.manager.stack.api.internal.dto.StackMasterInfoDTO;
import com.tplink.smb.omada.manager.stack.api.internal.dto.a;
import com.tplink.smb.omada.manager.stack.api.internal.service.c;
import com.tplink.smb.omada.manager.stack.api.web.dto.OswStackVO;
import com.tplink.smb.omada.manager.stack.domain.B;
import com.tplink.smb.omada.manager.stack.domain.D;
import com.tplink.smb.omada.manager.stack.domain.e;
import com.tplink.smb.omada.manager.stack.domain.f;
import com.tplink.smb.omada.manager.stack.domain.l;
import com.tplink.smb.omada.manager.stack.domain.o;
import com.tplink.smb.omada.manager.stack.domain.u;
import com.tplink.smb.omada.manager.stack.domain.v;
import com.tplink.smb.omada.manager.stack.domain.y;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class d
implements c {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(d.class);
    private com.tplink.smb.omada.manager.stack.port.mongo.stack.d b;
    private B c;
    private u d;
    private aT e;
    private Z f;
    private y g;
    private e h;
    private com.tplink.smb.omada.manager.stack.domain.p i;
    private f j;
    private P k;
    private com.tplink.smb.omada.manager.device.domain.model.device.osw.b.y l;
    private com.tplink.smb.omada.manager.device.domain.model.message.set.e m;
    private com.tplink.smb.omada.manager.device.domain.model.message.set.d n;
    private o o;
    private com.tplink.smb.omada.manager.common.d.e p;
    private b q;
    private ay r;
    private v s;
    private com.tplink.smb.omada.manager.common.d.b t;
    private com.tplink.smb.omada.manager.device.domain.model.device.osw.g.m u;
    private aE v;
    private h w;
    private k x;
    @Autowired
    private z y;
    @Autowired
    @Lazy
    private com.tplink.smb.omada.manager.common.d.e z;
    @Autowired
    @Lazy
    private b A;
    @Autowired
    private l B;
    @Autowired
    @Lazy
    @Qualifier(value="commThreadPool")
    private ExecutorService C;

    @Nonnull
    public OperationResponse<InitOswStackRespDTO> a(@Nonnull OswStackInfoDTO oswStackInfoDTO, String connectDeviceMac, OswAdoptRespV2Body oswAdoptRespV2Body) {
        List memberDTOS = oswStackInfoDTO.getMembers();
        if (CollectionUtils.isEmpty((Collection)memberDTOS)) {
            a.warn("Failed to init oswStack on local device negotiation.");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        OswStackMemberDTO masterMemberDTO = memberDTOS.stream().filter(memberDTO -> Objects.equals(memberDTO.getMac(), connectDeviceMac)).findFirst().orElse(null);
        if (masterMemberDTO == null) {
            a.warn("Member is null on local device negotiation.");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        oswStackInfoDTO.setMembers(Collections.singletonList(masterMemberDTO));
        com.tplink.smb.omada.manager.stack.port.mongo.a.d stack = com.tplink.smb.omada.manager.stack.port.mongo.a.d.a(oswStackInfoDTO, this.b.a());
        g stackId = stack.k();
        OperationResponse<OswSettingDTO> response = this.B.a(new com.tplink.smb.omada.manager.j.a.a.c(oswStackInfoDTO.getOmadacId()), new com.tplink.smb.omada.manager.j.a.a.d(oswStackInfoDTO.getSiteId()), stack, masterMemberDTO, oswAdoptRespV2Body);
        if (!response.success()) {
            return new OperationResponse(response.getErrorCode(), response.getMsg(), null);
        }
        OswSettingDTO stackSettingDTO = (OswSettingDTO)response.getResult();
        List stackPorts = CollectionUtils.isEmpty((Collection)masterMemberDTO.getStackPortList()) ? Collections.emptyList() : masterMemberDTO.getStackPortList().stream().map(OswStackPortGroupDTO::getStandardOswPortIndices).flatMap(Collection::stream).collect(Collectors.toList());
        List madPorts = CollectionUtils.isEmpty((Collection)masterMemberDTO.getMadPortList()) ? Collections.emptyList() : masterMemberDTO.getMadPortList().stream().map(StandardOswPortIndex::resolvePortStr).flatMap(Collection::stream).collect(Collectors.toList());
        InitOswStackRespDTO initOswStackRespDTO = new InitOswStackRespDTO();
        initOswStackRespDTO.setStackId(stackId.a());
        initOswStackRespDTO.setOswSettingDTO(stackSettingDTO);
        initOswStackRespDTO.setStackPorts(stackPorts);
        initOswStackRespDTO.setMadPorts(madPorts);
        initOswStackRespDTO.setSfpPortConfigs((List)Optional.ofNullable(oswAdoptRespV2Body).map(OswAdoptRespV2Body::getSfpPortConfigList).orElse(new ArrayList()));
        initOswStackRespDTO.setPortConfigs((ReportedPortAndLagConfig)Optional.ofNullable(oswAdoptRespV2Body).map(OswAdoptRespV2Body::getPortConfigs).orElse(null));
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)initOswStackRespDTO);
    }

    @Nonnull
    public OperationResponse a(String omadacId, String stackId, List<OswStackMemberDTO> successMemberDTOs, List<OswStackMemberDTO> failedMemberDTOs) {
        if (!CollectionUtils.isEmpty(failedMemberDTOs)) {
            this.c.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new g(stackId), this.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), failedMemberDTOs));
        }
        if (CollectionUtils.isEmpty(successMemberDTOs)) {
            return OperationResponse.SUCCESS;
        }
        Optional<com.tplink.smb.omada.manager.stack.port.mongo.a.d> stackOpt = this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new g(stackId));
        if (stackOpt.isEmpty()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.HC);
        }
        com.tplink.smb.omada.manager.stack.port.mongo.a.d stack = stackOpt.get();
        if (CollectionUtils.isEmpty(stack.l())) {
            stack.a(new ArrayList<com.tplink.smb.omada.manager.stack.port.mongo.a.e>());
        }
        Set memberMacs = stack.l().stream().map(com.tplink.smb.omada.manager.stack.port.mongo.a.e::e).collect(Collectors.toSet());
        for (OswStackMemberDTO memberDTO : successMemberDTOs) {
            if (memberMacs.contains(memberDTO.getMac())) continue;
            stack.l().add(com.tplink.smb.omada.manager.stack.port.mongo.a.e.a(memberDTO));
            memberMacs.add(memberDTO.getMac());
        }
        this.b.b(stack);
        return OperationResponse.SUCCESS;
    }

    @Nonnull
    public OperationResponse<StackMasterInfoDTO> a(@Nonnull String omadacId, @Nonnull String stackId, String onLineMac) {
        Optional<com.tplink.smb.omada.manager.stack.port.mongo.a.d> stackOptional = this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new g(stackId));
        if (!stackOptional.isPresent()) {
            a.debug("The stack device {} report with id {} on omada {} not exist when handle stack discovery.", new Object[]{onLineMac, stackId, omadacId});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, (Object)StackMasterInfoDTO.buildNoExist());
        }
        com.tplink.smb.omada.manager.stack.port.mongo.a.d stack = stackOptional.get();
        List<com.tplink.smb.omada.manager.stack.port.mongo.a.e> members = stack.l();
        if (CollectionUtils.isEmpty(members)) {
            a.debug("The stack device {} report with id {} on omada {} has no member when handle stack discovery.", new Object[]{onLineMac, stackId, omadacId});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, (Object)StackMasterInfoDTO.buildInvalidDefault());
        }
        String masterMac = null;
        com.tplink.smb.omada.manager.stack.port.mongo.a.e onlineDeviceMember = null;
        for (com.tplink.smb.omada.manager.stack.port.mongo.a.e stackMember : members) {
            if (Objects.equals(stackMember.f(), com.tplink.smb.omada.manager.stack.api.internal.dto.a.a.a())) {
                masterMac = stackMember.e();
            }
            if (!Objects.equals(stackMember.e(), onLineMac)) continue;
            onlineDeviceMember = stackMember;
        }
        if (onlineDeviceMember == null) {
            a.debug("The stack device {} report with id {} on omada {} don't has oneself member when handle stack discovery.", new Object[]{onLineMac, stackId, omadacId});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, (Object)StackMasterInfoDTO.buildInvalidDefault());
        }
        if (masterMac != null) {
            a.debug("The stack device {} report with id {} on omada {} already has master when handle stack discovery.", new Object[]{onLineMac, stackId, omadacId});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)StackMasterInfoDTO.builder().masterMac(masterMac).exist(Boolean.valueOf(true)).build());
        }
        a.debug("The stack device {} report with id {} on omada {} without master member, replace with reporter when handle stack discovery.", new Object[]{onLineMac, stackId, omadacId});
        onlineDeviceMember.c(com.tplink.smb.omada.manager.stack.api.internal.dto.a.a.a());
        this.b.b(stack);
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)StackMasterInfoDTO.builder().masterMac(onLineMac).exist(Boolean.valueOf(true)).replaceMaster(Boolean.valueOf(true)).build());
    }

    public void b(String omadacId, String stackId, String deviceMac) {
        this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new g(stackId)).ifPresent(stack -> {
            List<com.tplink.smb.omada.manager.stack.port.mongo.a.e> members = stack.l();
            if (!CollectionUtils.isEmpty(members)) {
                for (com.tplink.smb.omada.manager.stack.port.mongo.a.e member : members) {
                    if (Objects.equals(member.f(), com.tplink.smb.omada.manager.stack.api.internal.dto.a.a.a()) && !Objects.equals(member.e(), deviceMac)) {
                        member.c(com.tplink.smb.omada.manager.stack.api.internal.dto.a.b.a());
                    }
                    if (!Objects.equals(deviceMac, member.e())) continue;
                    member.c(com.tplink.smb.omada.manager.stack.api.internal.dto.a.a.a());
                }
                this.b.b((com.tplink.smb.omada.manager.stack.port.mongo.a.d)stack);
            }
        });
    }

    public List<String> a(@Nonnull String omadacId, @Nonnull String siteId, @Nonnull SelectStacksVO vo) {
        return this.g.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), vo);
    }

    public Optional<OswStackInfoDTO> c(@Nonnull String omadacId, @Nonnull String siteId, @Nonnull String stackId) {
        return this.b.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), new g(stackId));
    }

    public List<OswStackInfoDTO> a(@Nonnull String omadacId, @Nonnull String siteId) {
        return this.b.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId));
    }

    public List<OswStackInfoDTO> a(@Nonnull String omadacId, @Nonnull String siteId, @Nonnull Collection<String> stackIds) {
        return this.b.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), stackIds);
    }

    public long b(@Nonnull String omadacId, @Nonnull String siteId, @Nonnull Collection<String> stackIds) {
        return this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), stackIds);
    }

    public void a(@Nonnull String omadacId, @Nonnull String siteId, @Nonnull String masterMac, @Nonnull String stackId, @Nonnull Map<SetKey, Object> configMap) {
        this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), new g(stackId)).ifPresent(stack -> {
            List stackSlaverPorts;
            OswStackConfig oswStackConfig = com.tplink.smb.omada.manager.stack.domain.u.a(stack, null);
            if (oswStackConfig == null) {
                return;
            }
            com.tplink.smb.omada.manager.stack.domain.u.a(oswStackConfig, configMap);
            Set exceptMasterMacs = stack.l().stream().filter(member -> !Objects.equals(member.e(), masterMac)).map(com.tplink.smb.omada.manager.stack.port.mongo.a.e::e).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(exceptMasterMacs) && !CollectionUtils.isEmpty((Collection)(stackSlaverPorts = this.k.a(omadacId, siteId, exceptMasterMacs)))) {
                aa masterOsw = (aa)this.e.c(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new G(masterMac));
                OswPortConfigList stackSlaverPortsConfigs = this.d.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), masterOsw, stackSlaverPorts);
                Object configEntry = configMap.get(OswSetKeyEnum.PORT);
                if (configEntry instanceof OswPortConfigList) {
                    OswPortConfigList oswPortConfigLists = (OswPortConfigList)configEntry;
                    oswPortConfigLists.getPorts().addAll(stackSlaverPortsConfigs.getPorts());
                }
            }
        });
    }

    public void b(@Nonnull String omadacIdStr, @Nonnull String siteIdStr, @Nonnull String masterMac, @Nonnull String stackId, @Nonnull Map<SetKey, Object> configMap) {
        com.tplink.smb.omada.manager.j.a.a.c omadacId = new com.tplink.smb.omada.manager.j.a.a.c(omadacIdStr);
        com.tplink.smb.omada.manager.j.a.a.d siteId = new com.tplink.smb.omada.manager.j.a.a.d(siteIdStr);
        this.b.b(omadacId, new g(stackId)).ifPresent(stack -> {
            Optional oswOpt = this.e.a(omadacId, new G(masterMac));
            if (!oswOpt.isPresent()) {
                a.warn("Can not find osw :{} in createOswStackSelfConfig, OmadacId: {}, SiteId: {}", new Object[]{masterMac, omadacId, siteId});
                return;
            }
            OswStackInfoDTO stackInfoDTO = this.b.a(omadacId, siteId, new g(stackId)).orElse(null);
            List memberOswList = this.e.b(omadacId, siteId, stack.l().stream().map(stackMember -> new G(stackMember.e())).collect(Collectors.toList()));
            HashMap<String, aa> macOswMap = new HashMap<String, aa>(memberOswList.size());
            memberOswList.forEach(memberOsw -> macOswMap.put(memberOsw.d_(), (aa)memberOsw));
            HashMap<Integer, aa> unitOswMap = new HashMap<Integer, aa>(memberOswList.size());
            stack.l().forEach(member -> unitOswMap.put(member.c(), (aa)macOswMap.get(member.e())));
            HashMap<OswRetainConfigKeyEnum, Object> retainConfigMap = new HashMap<OswRetainConfigKeyEnum, Object>();
            HashMap<Integer, String> retainUnitMacMap = new HashMap<Integer, String>();
            this.a(omadacId, siteId, masterMac, (com.tplink.smb.omada.manager.stack.port.mongo.a.d)stack, (Map<OswRetainConfigKeyEnum, Object>)retainConfigMap, (Map<Integer, String>)retainUnitMacMap);
            this.d.a(omadacId, (com.tplink.smb.omada.manager.stack.port.mongo.a.d)stack, stackInfoDTO, (aa)oswOpt.get(), (Map<Integer, aa>)unitOswMap, (Map<String, aa>)macOswMap, configMap, (Map<OswRetainConfigKeyEnum, Object>)retainConfigMap, (Map<Integer, String>)retainUnitMacMap).forEach(entry -> configMap.put(entry.getSetKey(), entry.getConfig()));
        });
    }

    private void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, String masterMac, com.tplink.smb.omada.manager.stack.port.mongo.a.d stack, Map<OswRetainConfigKeyEnum, Object> retainConfigMap, Map<Integer, String> retainUnitMacMap) {
        D stackMemberFullInfo = this.c.a(omadacId, stack.k());
        if (stackMemberFullInfo == null || CollectionUtils.isEmpty(stackMemberFullInfo.a())) {
            return;
        }
        ArrayList madPorts = new ArrayList();
        ArrayList stackPorts = new ArrayList();
        ArrayList sfpPortConfigs = new ArrayList();
        ArrayList<ReportedPortAndLagConfig> portConfigs = new ArrayList<ReportedPortAndLagConfig>();
        for (D.a stackMemberDetailMsgInfo : stackMemberFullInfo.a()) {
            if (stackMemberDetailMsgInfo == null || stackMemberDetailMsgInfo.b() == null) continue;
            StackMemberInfoGetResp stackMemberInfoGetResp = stackMemberDetailMsgInfo.b();
            if (stackMemberInfoGetResp.getOswStackMemberStackInfo() != null && stackMemberInfoGetResp.getOswMemberDeviceInfo() != null) {
                retainUnitMacMap.put(stackMemberInfoGetResp.getOswStackMemberStackInfo().getUnit(), stackMemberInfoGetResp.getOswMemberDeviceInfo().getMac());
            }
            if (stackMemberInfoGetResp.getOswStackMemberStackInfo() != null && !CollectionUtils.isEmpty((Collection)stackMemberDetailMsgInfo.b().getOswStackMemberStackInfo().getStackGroups())) {
                stackMemberDetailMsgInfo.b().getOswStackMemberStackInfo().getStackGroups().forEach(group -> stackPorts.addAll(group.getPorts()));
            }
            if (stackMemberInfoGetResp.getOswStackMemberStackInfo() != null && !CollectionUtils.isEmpty((Collection)stackMemberDetailMsgInfo.b().getOswStackMemberStackInfo().getMadPortList())) {
                madPorts.addAll(stackMemberDetailMsgInfo.b().getOswStackMemberStackInfo().getMadPortList());
            }
            if (!CollectionUtils.isEmpty((Collection)stackMemberInfoGetResp.getSfpPortConfig())) {
                sfpPortConfigs.addAll(stackMemberDetailMsgInfo.b().getSfpPortConfig());
            }
            if (stackMemberInfoGetResp.getPortConfigs() == null) continue;
            portConfigs.add(stackMemberDetailMsgInfo.b().getPortConfigs());
        }
        if (!CollectionUtils.isEmpty(madPorts)) {
            retainConfigMap.put(OswRetainConfigKeyEnum.MAD, madPorts);
        }
        if (!CollectionUtils.isEmpty(stackPorts)) {
            retainConfigMap.put(OswRetainConfigKeyEnum.STACK_PORT, stackPorts);
        }
        if (!CollectionUtils.isEmpty(sfpPortConfigs)) {
            retainConfigMap.put(OswRetainConfigKeyEnum.SFP_PORT, sfpPortConfigs);
        }
        if (!CollectionUtils.isEmpty(portConfigs)) {
            ReportedPortAndLagConfig firstConfig = (ReportedPortAndLagConfig)portConfigs.get(0);
            firstConfig.mergeConfig(portConfigs);
            retainConfigMap.put(OswRetainConfigKeyEnum.PORT_CONFIGS, firstConfig);
        }
    }

    private D a(@Nonnull com.tplink.smb.omada.manager.j.a.a.c omadacId, @Nonnull List<OswStackMemberDTO> memberDTOS) {
        List<D.a> stackMemberDetailMsgInfos = memberDTOS.stream().map(memberDTO -> {
            Boolean supportCluster = Optional.ofNullable(memberDTO.getOswDeviceMisc()).map(BaseDeviceMisc::supportCluster).orElse(null);
            com.tplink.smb.omada.common.constant.f compatibleTypeEnum = com.tplink.smb.omada.manager.device.port.common.util.compatible.a.a((Integer)memberDTO.getVerCap(), (String)memberDTO.getModel(), (String)memberDTO.getModelVersion(), (String)memberDTO.getEcspVersion(), (Map)memberDTO.getComponentsV2(), (com.tplink.smb.omada.manager.j.a.a.c)omadacId, (G)new G(memberDTO.getMac()), (Boolean)supportCluster);
            if (!com.tplink.smb.omada.common.constant.f.a.equals((Object)compatibleTypeEnum)) {
                return D.a.a().a(compatibleTypeEnum.a()).a(new StackMemberInfoGetResp().setOswMemberDeviceInfo(new OswStackMemberDeviceInfo().setMac(memberDTO.getMac()).setModel(memberDTO.getModel()).setModelVer(memberDTO.getModelVersion()).setSupportCluster(supportCluster)).setOswStackMemberStackInfo(new OswStackMemberStackInfo().setUnit(memberDTO.getUnit()).setPriority(memberDTO.getPriority()))).a();
            }
            return D.a.a().a(compatibleTypeEnum.a()).a(new StackMemberInfoGetResp().setOswMemberDeviceInfo(new OswStackMemberDeviceInfo().setMac(memberDTO.getMac()).setModel(memberDTO.getModel()).setModelVer(memberDTO.getModelVersion()).setEcspVersion(memberDTO.getEcspVersion()).setFwVer(memberDTO.getFirmwareVersion()).setHwVer(memberDTO.getHardwareVersion()).setSn(memberDTO.getSn()).setSm(memberDTO.getSpecialModel()).setUpTime(memberDTO.getUpTime()).setVerCap(memberDTO.getVerCap()).setSupportCluster(supportCluster).setChipCap(memberDTO.getChipCap())).setOswStackMemberStackInfo(new OswStackMemberStackInfo().setUnit(memberDTO.getUnit()).setPriority(memberDTO.getPriority()).setStackGroups(memberDTO.getStackPortList().stream().map(oswStackPortGroupDTO -> {
                OswStackConfig.StackPortConfig stackPortConfig = new OswStackConfig.StackPortConfig();
                stackPortConfig.setId(oswStackPortGroupDTO.getId());
                stackPortConfig.setName(oswStackPortGroupDTO.getName());
                stackPortConfig.setPorts(oswStackPortGroupDTO.getStandardOswPortIndices().stream().map(index -> index.getUnit() + "/" + index.getSlot() + "/" + index.getPort()).collect(Collectors.toList()));
                return stackPortConfig;
            }).collect(Collectors.toList())).setInitial(Boolean.valueOf(false)).setMadPortList(this.a(memberDTO.getUnit(), (List<String>)memberDTO.getMadPortList()))).setOswDeviceMisc(memberDTO.getOswDeviceMisc()).setComponentsV2(memberDTO.getComponentsV2()).setOswDevCap(memberDTO.getOswDevCap()).setOswLagCap(memberDTO.getOswLagCap()).setOswPortCap(memberDTO.getOswPortCap()).setPoeCap(memberDTO.getOswPoeCap()).setSfpPortConfig(memberDTO.getSfpPortConfig()).setPortConfigs(memberDTO.getPortConfigs())).a();
        }).collect(Collectors.toList());
        D stackMemberFullInfo = new D();
        stackMemberFullInfo.a(stackMemberDetailMsgInfos);
        return stackMemberFullInfo;
    }

    private List<String> a(Integer unit, List<String> madPortList) {
        if (unit == null || CollectionUtils.isEmpty(madPortList)) {
            return null;
        }
        List standardOswPortIndices = StandardOswPortIndex.resolvePortStrs(madPortList);
        if (CollectionUtils.isEmpty((Collection)standardOswPortIndices)) {
            return null;
        }
        standardOswPortIndices.removeIf(index -> !Objects.equals(unit, index.getUnit()));
        return CollectionUtils.isEmpty((Collection)standardOswPortIndices) ? null : standardOswPortIndices.stream().map(StandardOswPortIndex::toStandardStr).collect(Collectors.toList());
    }

    private List<OswSfpPortConfig> b(Integer unit, List<OswSfpPortSettingDTO> sfpPortSettingList) {
        if (unit == null || CollectionUtils.isEmpty(sfpPortSettingList)) {
            return null;
        }
        sfpPortSettingList.forEach(sfpPortSetting -> sfpPortSetting.getStandardOswPortIndexList().removeIf(index -> !Objects.equals(unit, index.getUnit())));
        return sfpPortSettingList.stream().filter(sfpPortSetting -> !CollectionUtils.isEmpty((Collection)sfpPortSetting.getStandardOswPortIndexList())).map(sfpPortSetting -> {
            OswSfpPortConfig sfpPortConfig = new OswSfpPortConfig();
            sfpPortConfig.setPortList(sfpPortSetting.getPortList());
            sfpPortConfig.setStandardPortList(sfpPortSetting.getStandardOswPortIndexList().stream().map(StandardOswPortIndex::toStandardStr).collect(Collectors.toList()));
            sfpPortConfig.setSpeed(sfpPortSetting.getSpeed());
            sfpPortConfig.setDuplex(sfpPortSetting.getDuplex());
            sfpPortConfig.setFecMode(sfpPortSetting.getFecMode());
            return sfpPortConfig;
        }).toList();
    }

    private ReportedPortAndLagConfig a(Integer unit, ReportedPortAndLagConfig portConfigs) {
        if (Objects.isNull(unit) || Objects.isNull(portConfigs)) {
            return null;
        }
        ReportedPortAndLagConfig memberPortConfigs = new ReportedPortAndLagConfig();
        List ports = portConfigs.getPorts().stream().filter(portConfig -> {
            List standardOswPortIndexList = StandardOswPortIndex.resolvePortStr((String)portConfig.getPort());
            if (CollectionUtils.isEmpty((Collection)standardOswPortIndexList)) {
                return false;
            }
            StandardOswPortIndex standardOswPortIndex = (StandardOswPortIndex)standardOswPortIndexList.get(0);
            return Objects.equals(standardOswPortIndex.getUnit(), unit);
        }).collect(Collectors.toList());
        memberPortConfigs.setPorts(ports);
        memberPortConfigs.setLags(portConfigs.getLags());
        return memberPortConfigs;
    }

    @Nonnull
    public OperationResponse<Map<String, OswStackMsgDTO>> b(String omadacId, String siteId) {
        HashMap<String, OswStackMsgDTO> resMap = new HashMap<String, OswStackMsgDTO>();
        List<com.tplink.smb.omada.manager.stack.port.mongo.a.d> stackList = this.b.a(omadacId, siteId);
        this.a(resMap, stackList);
        return OperationResponse.success(resMap);
    }

    @Nonnull
    public Map<String, OswStackVO> c(String omadacId, String siteId) {
        return this.g.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId));
    }

    public Optional<OswStackVO> d(@NotNull String omadacId, @NotNull String siteId, @NotNull String stackId) {
        return this.g.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), new g(stackId));
    }

    @Nonnull
    public OperationResponse<Map<String, OswStackMsgDTO>> a(String omadacId, Set<String> siteIds) {
        HashMap<String, OswStackMsgDTO> resMap = new HashMap<String, OswStackMsgDTO>();
        List<com.tplink.smb.omada.manager.stack.port.mongo.a.d> stackList = this.b.a(omadacId, siteIds);
        this.a(resMap, stackList);
        return OperationResponse.success(resMap);
    }

    @Nonnull
    public List<OswStackInfoDTO> d(String omadacId, String siteId) {
        List<com.tplink.smb.omada.manager.stack.port.mongo.a.d> stackList = this.b.a(omadacId, siteId);
        if (CollectionUtils.isEmpty(stackList)) {
            return new ArrayList<OswStackInfoDTO>();
        }
        return stackList.stream().map(stack -> {
            OswStackInfoDTO stackInfoDTO = stack.a();
            stackInfoDTO.setOswSettingDTO(ar.a((aW)stack.q()));
            stackInfoDTO.setMasterMac(stack.g().a());
            stackInfoDTO.setMembers(stack.l().stream().map(com.tplink.smb.omada.manager.stack.port.mongo.a.d::a).collect(Collectors.toList()));
            return stackInfoDTO;
        }).collect(Collectors.toList());
    }

    @Nonnull
    public OperationResponse<SimpleStackInfoDTO> e(String omadacId, String siteId) {
        List<com.tplink.smb.omada.manager.stack.port.mongo.a.d> stacks = this.b.a(omadacId, siteId);
        if (CollectionUtils.isEmpty(stacks)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, null);
        }
        List simpleStackInfoDetailDTOS = stacks.stream().map(stack -> {
            SimpleStackInfoDetailDTO simpleStackInfoDetailDTO = new SimpleStackInfoDetailDTO();
            List simpleStackMemberInfoDTOS = stack.l().stream().map(stackMember -> {
                SimpleStackMemberInfoDTO simpleStackMemberInfoDTO = new SimpleStackMemberInfoDTO();
                simpleStackMemberInfoDTO.setMac(stackMember.e());
                simpleStackMemberInfoDTO.setStackPorts(null);
                if (Objects.equals(com.tplink.smb.omada.manager.stack.api.internal.dto.a.a.a(), stackMember.f())) {
                    simpleStackInfoDetailDTO.setMaster(stackMember.e());
                }
                return simpleStackMemberInfoDTO;
            }).collect(Collectors.toList());
            simpleStackInfoDetailDTO.setMembers(simpleStackMemberInfoDTOS);
            simpleStackInfoDetailDTO.setStackId(stack.k().a());
            return simpleStackInfoDetailDTO;
        }).collect(Collectors.toList());
        SimpleStackInfoDTO simpleStackInfoDTO = new SimpleStackInfoDTO();
        simpleStackInfoDTO.setStackInfos(simpleStackInfoDetailDTOS);
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)simpleStackInfoDTO);
    }

    @Nonnull
    public OperationResponse<OswStackInfoDTO> f(@NotNull String omadacId, @NotNull String stackId) {
        Optional<com.tplink.smb.omada.manager.stack.port.mongo.a.d> stackOpt = this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new g(stackId));
        if (!stackOpt.isPresent()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.HC);
        }
        com.tplink.smb.omada.manager.stack.port.mongo.a.d stack = stackOpt.get();
        OswStackInfoDTO oswStackInfoDTO = stack.a();
        oswStackInfoDTO.setOswSettingDTO(ar.a((aW)stack.q()));
        oswStackInfoDTO.setMasterMac(stack.g().a());
        oswStackInfoDTO.setStackName(stack.m());
        oswStackInfoDTO.setMembers(stack.l().stream().map(com.tplink.smb.omada.manager.stack.port.mongo.a.d::a).collect(Collectors.toList()));
        return OperationResponse.success((Object)oswStackInfoDTO);
    }

    @Nonnull
    public OperationResponse a(@NotNull String omadacId, @NotNull String stackId, @NotNull String lanNetworkId, @Nullable Integer mVlanBridgeVlan) {
        Optional<com.tplink.smb.omada.manager.stack.port.mongo.a.d> stackOpt = this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new g(stackId));
        if (!stackOpt.isPresent()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.HC);
        }
        com.tplink.smb.omada.manager.stack.port.mongo.a.d stack = stackOpt.get();
        stack.a(lanNetworkId, mVlanBridgeVlan);
        this.b.b(stack);
        return OperationResponse.SUCCESS;
    }

    public OperationResponse a(@NotNull String omadacIdStr, @NotNull Map<String, Set<String>> stackMacsMap) {
        if (CollectionUtils.isEmpty(stackMacsMap)) {
            return OperationResponse.SUCCESS;
        }
        a.info("OmadacId: {}, start to remove stack member :{}.", (Object)omadacIdStr, (Object)stackMacsMap.keySet().toString());
        com.tplink.smb.omada.manager.j.a.a.c omadacId = new com.tplink.smb.omada.manager.j.a.a.c(omadacIdStr);
        stackMacsMap.forEach((stackId, memberMacSet) -> {
            Optional<com.tplink.smb.omada.manager.stack.port.mongo.a.d> stackOpt = this.b.b(omadacId, new g(stackId));
            if (!stackOpt.isPresent()) {
                a.info("OmadacId: {}, Stack: {} is not existed.", (Object)omadacId, stackId);
                return;
            }
            com.tplink.smb.omada.manager.stack.port.mongo.a.d stack = stackOpt.get();
            HashSet<Integer> removeUnitSet = new HashSet<Integer>();
            stack.l().stream().filter(member -> memberMacSet.contains(member.e())).forEach(member -> removeUnitSet.add(member.c()));
            if (removeUnitSet.size() == stack.l().size()) {
                a.info("OmadacId: {}, remove all stack member, delete the stack:{}", (Object)omadacId, (Object)stack.p());
                this.b.a(omadacId, new g(stackId));
                this.j.a(stack.o(), new com.tplink.smb.omada.manager.j.a.a.d(stack.p()), stack.k(), stack.g().a());
            } else {
                this.i.a(stack, Collections.emptyMap(), removeUnitSet);
            }
        });
        return OperationResponse.SUCCESS;
    }

    public OperationResponse a(@Nonnull String omadacId, @Nonnull String siteId, @Nonnull String stackId, @Nonnull Set<String> removeMemberMacs) {
        this.C.execute(() -> {
            try {
                this.p.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new g(stackId), () -> {
                    this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), new g(stackId)).ifPresent(stack -> {
                        Set stackMembers = stack.c().stream().map(G::a).collect(Collectors.toSet());
                        if (stackMembers.size() == removeMemberMacs.size() && stackMembers.containsAll(removeMemberMacs)) {
                            OperationResponse response = this.o.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), (com.tplink.smb.omada.manager.stack.port.mongo.a.d)stack, (UserDescriptionDTO)null);
                            a.info("Success {} forget stack for member all factory in discovery omadac {} site {} stackId {}, trigger members {}.", new Object[]{response.success(), omadacId, siteId, stackId, removeMemberMacs});
                            return;
                        }
                        Iterator<com.tplink.smb.omada.manager.stack.port.mongo.a.e> iterator = stack.l().iterator();
                        HashMap<Integer, com.tplink.smb.omada.manager.stack.port.mongo.a.e> finallyRemoveMembers = new HashMap<Integer, com.tplink.smb.omada.manager.stack.port.mongo.a.e>(4);
                        boolean masterRemoveFlag = false;
                        while (iterator.hasNext()) {
                            com.tplink.smb.omada.manager.stack.port.mongo.a.e next = iterator.next();
                            if (!removeMemberMacs.contains(next.e())) continue;
                            iterator.remove();
                            finallyRemoveMembers.put(next.c(), next);
                            if (!com.tplink.smb.omada.manager.stack.api.internal.dto.a.a.a().equals(next.f())) continue;
                            masterRemoveFlag = true;
                        }
                        this.i.a((com.tplink.smb.omada.manager.stack.port.mongo.a.d)stack, Collections.emptyMap(), (Set<Integer>)new HashSet<Integer>(finallyRemoveMembers.keySet()));
                        if (masterRemoveFlag) {
                            stack.l().stream().max((member1, member2) -> Integer.compare(member1.d(), member2.d())).ifPresent(stackMember -> stackMember.c(com.tplink.smb.omada.manager.stack.api.internal.dto.a.a.a()));
                        }
                        this.b.b((com.tplink.smb.omada.manager.stack.port.mongo.a.d)stack);
                        this.a(omadacId, (com.tplink.smb.omada.manager.stack.port.mongo.a.d)stack, finallyRemoveMembers.values());
                    });
                    return true;
                }, () -> {
                    a.error("Failed remove re discovery stack {} member on omadac {} beacuse of lock failed", new Object[]{stackId, removeMemberMacs, omadacId});
                    return false;
                });
            }
            catch (Exception e2) {
                a.error("Failed remove re discovery stack {} member on omadac {} beacuse of {} {}", new Object[]{stackId, removeMemberMacs, omadacId, e2.getMessage(), e2});
            }
        });
        return OperationResponse.SUCCESS;
    }

    public OperationResponse a(@Nonnull String omadacId, @Nonnull String siteId, @Nonnull String stackId, @Nonnull String removeMember) {
        try {
            return (OperationResponse)this.p.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new g(stackId), () -> {
                this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), new g(stackId)).ifPresent(stack -> {
                    Set stackMembers = stack.c().stream().map(G::a).collect(Collectors.toSet());
                    if (stackMembers.size() == 1 && stackMembers.contains(removeMember)) {
                        this.o.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), (com.tplink.smb.omada.manager.stack.port.mongo.a.d)stack, removeMember);
                        return;
                    }
                    Iterator<com.tplink.smb.omada.manager.stack.port.mongo.a.e> iterator = stack.l().iterator();
                    HashMap<Integer, com.tplink.smb.omada.manager.stack.port.mongo.a.e> finallyRemoveMembers = new HashMap<Integer, com.tplink.smb.omada.manager.stack.port.mongo.a.e>(4);
                    boolean masterRemoveFlag = false;
                    while (iterator.hasNext()) {
                        com.tplink.smb.omada.manager.stack.port.mongo.a.e next = iterator.next();
                        if (!Objects.equals(next.e(), removeMember)) continue;
                        iterator.remove();
                        finallyRemoveMembers.put(next.c(), next);
                        if (!com.tplink.smb.omada.manager.stack.api.internal.dto.a.a.a().equals(next.f())) continue;
                        masterRemoveFlag = true;
                    }
                    this.i.a((com.tplink.smb.omada.manager.stack.port.mongo.a.d)stack, Collections.emptyMap(), (Set<Integer>)new HashSet<Integer>(finallyRemoveMembers.keySet()));
                    if (masterRemoveFlag) {
                        stack.l().stream().max((member1, member2) -> Integer.compare(member1.d(), member2.d())).ifPresent(stackMember -> stackMember.c(com.tplink.smb.omada.manager.stack.api.internal.dto.a.a.a()));
                    }
                    this.b.b((com.tplink.smb.omada.manager.stack.port.mongo.a.d)stack);
                    this.a(omadacId, (com.tplink.smb.omada.manager.stack.port.mongo.a.d)stack, finallyRemoveMembers.values());
                });
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a);
            }, () -> {
                a.error("Failed get device lock [OmadacId{} Device {}] for forget stack in initialSetting.", (Object)omadacId, (Object)removeMember);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.p);
            });
        }
        catch (Exception e2) {
            a.error("Failed remove re discovery stack {} member on omadac {} beacuse of {} {}", new Object[]{stackId, removeMember, omadacId, e2.getMessage(), e2});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.p);
        }
    }

    public void b(String omadacId, String siteId, String stackId, String macStr) {
        this.b.a(omadacId, siteId, stackId, macStr);
    }

    public String e(String omadacId, String siteId, String stackId) {
        Optional<OswStackInfoDTO> stackInfoDTOOptional = this.b.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), new g(stackId));
        return stackInfoDTOOptional.map(OswStackInfoDTO::getMasterMac).orElse(null);
    }

    public Map<String, Set<StandardOswPortIndex>> g(String omadacId, String siteId) {
        Map<String, Set<String>> stackMemberMacs = this.b.d(omadacId, siteId);
        return this.k.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), stackMemberMacs);
    }

    public void a(@Nonnull String omadacId, @Nonnull String siteId, @Nonnull List<String> stackOswNetworkIds, @Nonnull Map<String, Map<SetKey, Object>> macOswSettingMap) {
        this.q.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), stackOswNetworkIds, macOswSettingMap);
    }

    public void a(@Nonnull String omadacId, @Nonnull String siteId, @Nonnull String stackId, @Nonnull String removeLanNetworkId, @Nonnull Integer targetVlan, @Nonnull Map<SetKey, Object> macOswSettingMap) {
        Optional<com.tplink.smb.omada.manager.stack.port.mongo.a.d> stackOptional = this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), new g(stackId));
        stackOptional.ifPresent(stack -> {
            aW setting = stack.q();
            if (setting == null) {
                return;
            }
            aA mvlanSetting = setting.m();
            if (mvlanSetting == null) {
                return;
            }
            F mvlanIdNow = mvlanSetting.b();
            if (Objects.equals(mvlanIdNow, new F(removeLanNetworkId))) {
                com.tplink.smb.omada.manager.device.port.common.c.a.a.a.c.y.a((Map)macOswSettingMap, (Integer)targetVlan);
            }
        });
    }

    public Map<String, String> h(String omadacId, String siteId) {
        return this.b.e(omadacId, siteId);
    }

    public Map<String, String> a(String omadacId, String siteId, List<String> stackIds) {
        return this.b.a(omadacId, siteId, stackIds);
    }

    @Nonnull
    public Map<String, String> a(String omadacId, String siteId, Set<String> stackIds) {
        return this.b.a(omadacId, siteId, stackIds);
    }

    public OperationResponse a(List<String> stackIds, String omadacIdStr, String srcSiteId, String dstSiteId, LogUserDTO userDTO) {
        if (CollectionUtils.isEmpty(stackIds)) {
            return OperationResponse.SUCCESS;
        }
        com.tplink.smb.omada.manager.j.a.a.c omadacId = new com.tplink.smb.omada.manager.j.a.a.c(omadacIdStr);
        MoveSiteProcessVO moveSiteProcessVO = null;
        for (String stackIdStr : stackIds) {
            g stackId = new g(stackIdStr);
            Optional<com.tplink.smb.omada.manager.stack.port.mongo.a.d> stackOpt = this.b.b(omadacId, stackId);
            if (!stackOpt.isPresent()) {
                a.warn("Failed to move stack: {}, it is not in omadac: {}.", (Object)stackId, (Object)omadacId);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.HC);
            }
            com.tplink.smb.omada.manager.stack.port.mongo.a.d stack = stackOpt.get();
            List<com.tplink.smb.omada.manager.stack.port.mongo.a.e> members = stack.l();
            if (CollectionUtils.isEmpty(members)) continue;
            ArrayList deviceMacList = new ArrayList(members.size());
            members.forEach(stackMember -> deviceMacList.add(new G(stackMember.e())));
            a.info("OmadacId: {}, start to move stack: {} from site:{} to site:{}.", new Object[]{omadacId, stackId, srcSiteId, dstSiteId});
            OperationResponse response = this.r.b(deviceMacList, omadacId, new com.tplink.smb.omada.manager.j.a.a.d(srcSiteId), new com.tplink.smb.omada.manager.j.a.a.d(dstSiteId), com.tplink.smb.omada.manager.device.application.device.m.a((LogUserDTO)userDTO));
            if (!response.success()) {
                a.warn("OmadacId: {} SiteId: {} failed to move stack: {}, move switch failed.", new Object[]{omadacId, srcSiteId, stackId});
                return response;
            }
            OperationResponse moveResp = this.s.a(stack, omadacId, new com.tplink.smb.omada.manager.j.a.a.d(srcSiteId), new com.tplink.smb.omada.manager.j.a.a.d(dstSiteId));
            if (!moveResp.success()) {
                return moveResp;
            }
            if (!(response.getResult() instanceof MoveSiteProcessVO)) continue;
            moveSiteProcessVO = (MoveSiteProcessVO)response.getResult();
        }
        return OperationResponse.success(moveSiteProcessVO);
    }

    public void f(String omadacId, String stackId, String deletedCliId) {
        this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new g(stackId)).ifPresent(stack -> {
            List cliList = Optional.ofNullable(stack.q().f()).map(p::a).orElse(Collections.emptyList());
            if (!CollectionUtils.isEmpty(cliList)) {
                IntStream.range(0, cliList.size()).filter(i2 -> Objects.equals(((com.tplink.smb.omada.manager.configuration.domain.model.site.a.d)((com.tplink.smb.omada.manager.configuration.domain.model.site.a.c)cliList.get(i2)).getId()).b(), deletedCliId)).boxed().findFirst().ifPresent(i2 -> cliList.remove((int)i2));
            }
            stack.q().a(new p(cliList));
            this.b.b((com.tplink.smb.omada.manager.stack.port.mongo.a.d)stack);
        });
    }

    public OperationResponse a(String omadacId, String stackId, Boolean scheduleIssued) {
        return (OperationResponse)this.z.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new g(stackId), () -> {
            this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new g(stackId)).ifPresent(stack -> {
                stack.a(scheduleIssued);
                this.b.b((com.tplink.smb.omada.manager.stack.port.mongo.a.d)stack);
            });
            return OperationResponse.ok();
        }, () -> {
            a.warn("Failed to get stack lock {} {}, can't get write lock", (Object)omadacId, (Object)stackId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Aw);
        });
    }

    public void a(String omadacId, String stackId, ModifyDeviceLocationVO vo) {
        this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new g(stackId)).ifPresent(stack -> {
            E location = E.b().a(vo.getLongitude()).b(vo.getLatitude()).a(vo.getAddress()).a(Boolean.valueOf(vo.getLatitude() == null && vo.getLongitude() == null && vo.getAddress() == null)).a();
            if (stack.q() != null) {
                stack.q().a(location);
            }
            this.b.b((com.tplink.smb.omada.manager.stack.port.mongo.a.d)stack);
        });
    }

    public void a(String omadacId, String stackId, CliConfig cliConfig) {
        this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new g(stackId)).ifPresent(stack -> {
            List cliList = cliConfig.getCliConfigs().stream().map(this::a).collect(Collectors.toList());
            if (Objects.isNull(stack.q().f())) {
                stack.q().a(new p(cliList));
            } else {
                stack.q().f().a().addAll(cliList);
            }
            this.b.b((com.tplink.smb.omada.manager.stack.port.mongo.a.d)stack);
        });
    }

    public void a(String omadacId, String siteId, OswQosConfigDTO oswQosConfigDTO, String stackId) {
        this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new g(stackId)).ifPresent(stack -> {
            aW oswSetting = Objects.isNull(stack.q()) ? new aW() : stack.q();
            aS oswQosSetting = aS.a().a(oswQosConfigDTO.getDscpDot1pMappingId()).b(oswQosConfigDTO.getDot1pQueueMappingId()).c(oswQosConfigDTO.getQueueSchedulerId()).a();
            oswSetting.a(oswQosSetting);
            stack.a(oswSetting);
            this.b.b((com.tplink.smb.omada.manager.stack.port.mongo.a.d)stack);
        });
    }

    public List<String> c(String omadacId, String siteId, Collection<String> stackIds) {
        List<OswStackInfoDTO> stackInfoDTOList = this.b.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), stackIds);
        if (CollectionUtils.isEmpty(stackInfoDTOList)) {
            return Collections.emptyList();
        }
        return stackInfoDTOList.stream().map(OswStackInfoDTO::getMasterMac).collect(Collectors.toList());
    }

    private com.tplink.smb.omada.manager.configuration.domain.model.site.a.c a(@Nonnull BaseCliConfig cliConfig) {
        return ((c.a)((c.a)com.tplink.smb.omada.manager.configuration.domain.model.site.a.c.j().a((com.tplink.smb.omada.manager.configuration.domain.model.site.component.g)new com.tplink.smb.omada.manager.configuration.domain.model.site.a.d(cliConfig.getId()))).c(cliConfig.getCliStr())).f();
    }

    private void a(Map<String, OswStackMsgDTO> resMap, List<com.tplink.smb.omada.manager.stack.port.mongo.a.d> stackList) {
        for (com.tplink.smb.omada.manager.stack.port.mongo.a.d stack : stackList) {
            String masterMac = stack.g().a();
            List memberDTOList = Optional.ofNullable(stack.l()).map(stackMembers -> stackMembers.stream().map(stackMember -> {
                OswStackMemberDTO oswStackMemberDTO = com.tplink.smb.omada.manager.stack.port.mongo.a.d.a(stackMember);
                oswStackMemberDTO.setStackPortList(stackMember.g().stream().map(stackPortGroup -> new OswStackPortGroupDTO(stackPortGroup.a(), stackPortGroup.b(), stackPortGroup.c())).collect(Collectors.toList()));
                return oswStackMemberDTO;
            }).collect(Collectors.toList())).orElse(null);
            if (CollectionUtils.isEmpty(stack.l())) continue;
            DeviceLocationDetailDTO locationDetail = new DeviceLocationDetailDTO();
            Optional.ofNullable(stack.q()).map(Q::e).ifPresent(location -> {
                locationDetail.setLongitude(location.c());
                locationDetail.setLatitude(location.d());
                locationDetail.setAddress(location.e());
                locationDetail.setUnplaced(location.f());
            });
            OswQosConfigDTO oswQosSetting = new OswQosConfigDTO();
            Optional.ofNullable(stack.q()).map(aW::s).ifPresent(qosSetting -> {
                oswQosSetting.setDscpDot1pMappingId(qosSetting.b());
                oswQosSetting.setDot1pQueueMappingId(qosSetting.c());
                oswQosSetting.setQueueSchedulerId(qosSetting.d());
            });
            OswSettingDTO oswSetting = ((OswSettingDTO.OswSettingDTOBuilder)OswSettingDTO.builder().locationDetail(locationDetail)).oswQosConfig(oswQosSetting).build();
            for (com.tplink.smb.omada.manager.stack.port.mongo.a.e stackMember : stack.l()) {
                OswStackMsgDTO stackMsgDTO = ((OswStackMsgDTO.OswStackMsgDTOBuilder)((OswStackMsgDTO.OswStackMsgDTOBuilder)((OswStackMsgDTO.OswStackMsgDTOBuilder)((OswStackMsgDTO.OswStackMsgDTOBuilder)((OswStackMsgDTO.OswStackMsgDTOBuilder)OswStackMsgDTO.builder().mac(stackMember.e()).omadacId(stack.o().a())).siteId(stack.p())).unit(stackMember.c()).stackName(stack.m()).stackId(stack.k().a())).masterMac(masterMac).members(memberDTOList)).oswSettingDTO(oswSetting)).build();
                resMap.put(stackMember.e(), stackMsgDTO);
            }
        }
    }

    private void a(String omadacId, com.tplink.smb.omada.manager.stack.port.mongo.a.d stack, Collection<com.tplink.smb.omada.manager.stack.port.mongo.a.e> removeMembers) {
        OswStackConfig oswStackConfig = com.tplink.smb.omada.manager.stack.domain.u.a(stack, removeMembers);
        this.m.b(com.tplink.smb.omada.manager.stack.domain.u.a(oswStackConfig), stack.g(), new com.tplink.smb.omada.manager.j.a.a.c(omadacId), DeviceTypeEnum.c);
    }

    private OperationResponse a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, com.tplink.smb.omada.manager.stack.port.mongo.a.d stack, OswStackMemberDTO masterMemberDTO) {
        List masterOswLags;
        List oswNetworkList;
        List oswStaticRoutingVoList;
        a.info("Auto create stack: {} when adopting master device: {}.", (Object)stack.k(), (Object)masterMemberDTO.getMac());
        G mac = new G(masterMemberDTO.getMac());
        aa osw = (aa)this.e.c(omadacId, mac);
        if (osw == null) {
            a.warn("Failed to create stack , mac: {}", (Object)mac);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        Optional defaultLanNetworkOpt = this.f.c(omadacId, siteId, com.tplink.smb.omada.manager.c.x.a);
        if (!defaultLanNetworkOpt.isPresent()) {
            a.error("Don't find defaultLanNetwork. OmadacId: {}, SiteId: {}", (Object)omadacId, (Object)siteId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.b);
        }
        aA mVlanSetting = aA.a().a(new F(((BaseLanNetwork)defaultLanNetworkOpt.get()).getId().b())).a();
        stack.a(aW.a((OswCapability)osw.bG(), (aA)mVlanSetting, (aW)osw.bJ()));
        Optional.ofNullable(osw.bJ()).map(aW::n).ifPresent(setting -> stack.q().a(setting));
        if (Boolean.TRUE.equals(osw.bG().getQosSupport())) {
            this.h.a(omadacId, siteId, stack.q());
        }
        this.b.b(stack);
        List baseOswVrfs = this.x.a(omadacId, siteId, new G(osw.d_()), true, com.tplink.smb.omada.manager.c.x.a);
        ArrayList stackVrf = new ArrayList();
        HashMap osw2StackVrfMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)baseOswVrfs)) {
            baseOswVrfs.forEach(baseOswVrf -> {
                m oswVrfId = new m(this.v.a(com.tplink.smb.omada.manager.c.x.a));
                j oswVrf = com.tplink.smb.omada.manager.device.domain.model.device.osw.h.j.a((j)((j)baseOswVrf), (String)oswVrfId.b());
                oswVrf.c(stack.k().a());
                stackVrf.add(oswVrf);
                osw2StackVrfMap.put(baseOswVrf.getId().b(), oswVrf);
            });
            this.x.a(stackVrf, com.tplink.smb.omada.manager.c.x.a);
        }
        if (!CollectionUtils.isEmpty((Collection)(oswStaticRoutingVoList = this.u.c(omadacId, siteId, osw.d_())))) {
            ArrayList staticRoutingList = new ArrayList();
            oswStaticRoutingVoList.forEach(vo -> {
                vo.setId(((com.tplink.smb.omada.manager.device.domain.model.device.osw.g.l)this.u.e()).b());
                com.tplink.smb.omada.manager.device.domain.model.device.osw.g.h staticRouting = com.tplink.smb.omada.manager.device.domain.model.device.osw.g.h.a((com.tplink.smb.omada.manager.j.a.a.c)omadacId, (com.tplink.smb.omada.manager.j.a.a.d)siteId, (String)mac.a(), (OswStaticRoutingVO)vo);
                staticRouting.a(this.y.a(omadacId, siteId, this.u.h_()));
                staticRouting.e(null);
                staticRouting.d(stack.k().a());
                staticRouting.a((String)Optional.ofNullable(osw2StackVrfMap.getOrDefault(staticRouting.d(), null)).map(com.tplink.smb.omada.manager.configuration.domain.model.site.component.f::getId).map(com.tplink.smb.omada.manager.configuration.domain.model.site.component.g::b).orElse(null));
                staticRouting.c((String)Optional.ofNullable(osw2StackVrfMap.getOrDefault(staticRouting.g(), null)).map(com.tplink.smb.omada.manager.configuration.domain.model.site.component.f::getId).map(com.tplink.smb.omada.manager.configuration.domain.model.site.component.g::b).orElse(null));
                staticRoutingList.add(staticRouting);
            });
            this.u.a(staticRoutingList);
        }
        if (!CollectionUtils.isEmpty((Collection)(oswNetworkList = this.v.a(omadacId, new G(osw.d_()), com.tplink.smb.omada.manager.c.x.a)))) {
            oswNetworkList.forEach(oswNetwork -> {
                aB oswNetworkActually = (aB)oswNetwork;
                oswNetworkActually.a(new aG(this.v.a(com.tplink.smb.omada.manager.c.x.a)));
                oswNetworkActually.a(null);
                oswNetworkActually.a(stack.k());
                j oswVrf = osw2StackVrfMap.getOrDefault(oswNetworkActually.m(), null);
                oswNetworkActually.c((String)Optional.ofNullable(oswVrf).map(com.tplink.smb.omada.manager.device.domain.model.device.osw.h.a::d).orElse(null));
                oswNetworkActually.b((String)Optional.ofNullable(oswVrf).map(com.tplink.smb.omada.manager.configuration.domain.model.site.component.f::getId).map(com.tplink.smb.omada.manager.configuration.domain.model.site.component.g::b).orElse(null));
            });
            this.v.a((Collection)oswNetworkList, com.tplink.smb.omada.manager.c.x.a);
        }
        if (!CollectionUtils.isEmpty((Collection)(masterOswLags = this.l.a(omadacId, siteId, new G(osw.d_()))))) {
            masterOswLags.forEach(oswLag -> {
                w oswLagId = oswLag.X();
                oswLag.a((w)this.l.a(oswLagId.a()));
                oswLag.b(null);
                oswLag.a(stack.k());
            });
            this.l.a(masterOswLags);
        } else {
            this.h.a(omadacId, siteId, stack, Collections.singletonList(osw), (BaseLanNetwork)defaultLanNetworkOpt.get());
        }
        this.h.a(omadacId, siteId, stack.k(), osw);
        return OperationResponse.SUCCESS;
    }

    public OperationResponse g(String omadacId, String siteId, String stackId) {
        return (OperationResponse)this.z.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new g(stackId), () -> this.A.c(omadacId, siteId, stackId), () -> {
            a.warn("Failed to get stack lock {} {}, can't get write lock", (Object)omadacId, (Object)stackId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Aw);
        });
    }

    public void a(String omadacId, String siteId, String stackId, String masterMac, OswCapabilityDTO toOswCapabilityDTO) {
        this.c(omadacId, siteId, stackId, masterMac);
    }

    private void c(String omadacId, String siteId, String stackId, String masterMac) {
        if (this.x.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), stackId, "default")) {
            return;
        }
        List baseOswVrfs = this.x.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), new G(masterMac), true, com.tplink.smb.omada.manager.c.x.a);
        ArrayList stackVrf = new ArrayList();
        HashMap osw2StackVrfMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)baseOswVrfs)) {
            baseOswVrfs.forEach(baseOswVrf -> {
                m oswVrfId = new m(this.v.a(com.tplink.smb.omada.manager.c.x.a));
                j oswVrf = com.tplink.smb.omada.manager.device.domain.model.device.osw.h.j.a((j)((j)baseOswVrf), (String)oswVrfId.b());
                oswVrf.c(stackId);
                stackVrf.add(oswVrf);
                osw2StackVrfMap.put(baseOswVrf.getId().b(), oswVrf);
            });
            this.x.a(stackVrf, com.tplink.smb.omada.manager.c.x.a);
        }
    }

    public List<OswStackInfoDTO> h(String omadacId, String siteId, String dscpDot1pId) {
        return this.b.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), dscpDot1pId);
    }

    public List<OswStackInfoDTO> i(String omadacId, String siteId, String dot1pQueueId) {
        return this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), dot1pQueueId);
    }

    public List<OswStackInfoDTO> j(String omadacId, String siteId, String queueSchedulerId) {
        return this.b.c(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), queueSchedulerId);
    }

    public Map<String, OswStackMsgDTO> a(Set<String> omadacIds, List<String> stackIds) {
        HashMap<String, OswStackMsgDTO> resMap = new HashMap<String, OswStackMsgDTO>();
        List<com.tplink.smb.omada.manager.stack.port.mongo.a.d> stacks = this.b.a(omadacIds, stackIds);
        if (CollectionUtils.isEmpty(stackIds)) {
            return resMap;
        }
        this.a(resMap, stacks);
        return resMap;
    }

    public Set<String> i(String omadacId, String siteId) {
        return this.g.c(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId));
    }

    public OperationResponse<Integer> k(String omadacId, String siteId, String stackId) {
        Optional<com.tplink.smb.omada.manager.stack.port.mongo.a.d> stackOpt = this.b.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), new g(stackId));
        if (!stackOpt.isPresent()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.HC, null);
        }
        aW oswSetting = stackOpt.get().q();
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)oswSetting.h());
    }

    public OperationResponse b(String omadacId, String siteId, String stackId, Integer rememberMe) {
        if (rememberMe == null) {
            return OperationResponse.SUCCESS;
        }
        OswConfigVO oswConfigVO = new OswConfigVO();
        oswConfigVO.setRememberDevice(rememberMe);
        return this.i.a(omadacId, siteId, stackId, oswConfigVO);
    }

    public OperationResponse<List<SelectStackForVlanVO>> a(String omadacId, String siteId, String networkId, SelectStacksWithVlanVO selectStacksWithVlanVO) {
        return this.A.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), networkId, selectStacksWithVlanVO);
    }

    public OperationResponse a(String omadacId, String siteId, String stackId, String networkId, Integer vlan, x type) {
        return this.A.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), new g(stackId), networkId, vlan, type);
    }

    public OperationResponse l(String omadacId, String siteId, String stackId) {
        return this.A.a(omadacId, siteId, stackId);
    }

    public OperationResponse m(String omadacId, String siteId, String stackId) {
        return this.A.d(omadacId, siteId, stackId, new QueryDataVO());
    }

    public OperationResponse<OswLagVO> a(String omadacId, String siteId, String stackId, int lagId) {
        return this.A.a(omadacId, siteId, stackId, lagId);
    }

    @Autowired
    @Lazy
    public void a(com.tplink.smb.omada.manager.stack.port.mongo.stack.d stackRepository) {
        this.b = stackRepository;
    }

    @Autowired
    @Lazy
    public void a(B stackCacheService) {
        this.c = stackCacheService;
    }

    @Autowired
    @Lazy
    public void a(u oswStackEncoder) {
        this.d = oswStackEncoder;
    }

    @Autowired
    @Lazy
    public void a(aT oswRepository) {
        this.e = oswRepository;
    }

    @Autowired
    @Lazy
    public void a(Z queryLanNetworkService) {
        this.f = queryLanNetworkService;
    }

    @Autowired
    @Lazy
    public void a(y queryOswStackService) {
        this.g = queryOswStackService;
    }

    @Autowired
    @Lazy
    public void a(e createOswStackService) {
        this.h = createOswStackService;
    }

    @Autowired
    @Lazy
    public void a(com.tplink.smb.omada.manager.stack.domain.p modifyOswStackService) {
        this.i = modifyOswStackService;
    }

    @Autowired
    @Lazy
    public void a(f deleteOswStackService) {
        this.j = deleteOswStackService;
    }

    @Autowired
    @Lazy
    public void a(P oswPortRepository) {
        this.k = oswPortRepository;
    }

    @Autowired
    public void a(com.tplink.smb.omada.manager.device.domain.model.device.osw.b.y oswLagRepository) {
        this.l = oswLagRepository;
    }

    @Autowired
    @Lazy
    public void a(com.tplink.smb.omada.manager.device.domain.model.message.set.e deviceSetMsgService) {
        this.m = deviceSetMsgService;
    }

    @Autowired
    @Lazy
    public void a(com.tplink.smb.omada.manager.device.domain.model.message.set.d configVersionRepository) {
        this.n = configVersionRepository;
    }

    @Autowired
    @Lazy
    public void a(o manageStackService) {
        this.o = manageStackService;
    }

    @Autowired
    @Lazy
    public void a(com.tplink.smb.omada.manager.common.d.e stackLockFactory) {
        this.p = stackLockFactory;
    }

    @Autowired
    @Lazy
    public void a(b oswStackApplicationService) {
        this.q = oswStackApplicationService;
    }

    @Autowired
    @Lazy
    public void a(ay oswMoveSiteService) {
        this.r = oswMoveSiteService;
    }

    @Autowired
    @Lazy
    public void a(v oswStackMoveSiteService) {
        this.s = oswStackMoveSiteService;
    }

    @Autowired
    @Lazy
    public void a(com.tplink.smb.omada.manager.common.d.b managerDeviceLockFactory) {
        this.t = managerDeviceLockFactory;
    }

    @Autowired
    @Lazy
    public void a(k oswVrfDataService) {
        this.x = oswVrfDataService;
    }

    @Autowired
    public void a(com.tplink.smb.omada.manager.device.domain.model.device.osw.g.m oswStaticRoutingRepository) {
        this.u = oswStaticRoutingRepository;
    }

    @Autowired
    public void a(aE oswNetworkDataService) {
        this.v = oswNetworkDataService;
    }

    @Autowired
    public void a(h queryCommonSiteSettingService) {
        this.w = queryCommonSiteSettingService;
    }
}

