/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.api.openapi.vo.security;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.monitor.api.openapi.vo.ips.SignatureSuppressionOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.security.SiteTimeIdOpenApiVO;
import com.tplink.smb.omada.monitor.api.web.security.dto.OperateGlobalThreatVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class OperateGlobalThreatOpenApiVO {
    @Schema(name="threatId", description="The global view needs to pass in a siteId.")
    private List<SiteTimeIdOpenApiVO> threatId;
    @Schema(name="type", description="type,0 - block, 1 - isolate device, 2 - allow from all ips, 3 - allow this ip.")
    @NumberSet(value={0, 1, 2, 3}, message="Parameter [type] should be [0, 1, 2, 3].")
    @NotNull
    private Integer type;
    @Schema(name="signatureSuppression", description="Signature Suppression.")
    private SignatureSuppressionOpenApiVO signatureSuppression;
    @Schema(name="blockName", description="Block Name.")
    private String blockName;

    @Nullable
    public static OperateGlobalThreatVO toWebVO(OperateGlobalThreatOpenApiVO openApiVO) {
        if (Objects.isNull(openApiVO)) {
            return null;
        }
        List threatIdList = Optional.ofNullable(openApiVO.getThreatId()).map(threatId -> threatId.stream().map(SiteTimeIdOpenApiVO::toWebVO).collect(Collectors.toList())).orElse(null);
        OperateGlobalThreatVO vo = new OperateGlobalThreatVO();
        vo.setThreatId(threatIdList);
        vo.setType(openApiVO.getType());
        vo.setSignatureSuppression(SignatureSuppressionOpenApiVO.toWebVO(openApiVO.getSignatureSuppression()));
        vo.setBlockName(openApiVO.getBlockName());
        return vo;
    }

    @Generated
    public List<SiteTimeIdOpenApiVO> getThreatId() {
        return this.threatId;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public SignatureSuppressionOpenApiVO getSignatureSuppression() {
        return this.signatureSuppression;
    }

    @Generated
    public String getBlockName() {
        return this.blockName;
    }

    @Generated
    public void setThreatId(List<SiteTimeIdOpenApiVO> threatId) {
        this.threatId = threatId;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setSignatureSuppression(SignatureSuppressionOpenApiVO signatureSuppression) {
        this.signatureSuppression = signatureSuppression;
    }

    @Generated
    public void setBlockName(String blockName) {
        this.blockName = blockName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperateGlobalThreatOpenApiVO)) {
            return false;
        }
        OperateGlobalThreatOpenApiVO other = (OperateGlobalThreatOpenApiVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        List<SiteTimeIdOpenApiVO> this$threatId = this.getThreatId();
        List<SiteTimeIdOpenApiVO> other$threatId = other.getThreatId();
        if (this$threatId == null ? other$threatId != null : !((Object)this$threatId).equals(other$threatId)) {
            return false;
        }
        SignatureSuppressionOpenApiVO this$signatureSuppression = this.getSignatureSuppression();
        SignatureSuppressionOpenApiVO other$signatureSuppression = other.getSignatureSuppression();
        if (this$signatureSuppression == null ? other$signatureSuppression != null : !this$signatureSuppression.equals(other$signatureSuppression)) {
            return false;
        }
        String this$blockName = this.getBlockName();
        String other$blockName = other.getBlockName();
        return !(this$blockName == null ? other$blockName != null : !this$blockName.equals(other$blockName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OperateGlobalThreatOpenApiVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        List<SiteTimeIdOpenApiVO> $threatId = this.getThreatId();
        result = result * 59 + ($threatId == null ? 43 : ((Object)$threatId).hashCode());
        SignatureSuppressionOpenApiVO $signatureSuppression = this.getSignatureSuppression();
        result = result * 59 + ($signatureSuppression == null ? 43 : $signatureSuppression.hashCode());
        String $blockName = this.getBlockName();
        result = result * 59 + ($blockName == null ? 43 : $blockName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OperateGlobalThreatOpenApiVO(threatId=" + this.getThreatId() + ", type=" + this.getType() + ", signatureSuppression=" + this.getSignatureSuppression() + ", blockName=" + this.getBlockName() + ")";
    }

    @Generated
    public OperateGlobalThreatOpenApiVO() {
    }

    @Generated
    public OperateGlobalThreatOpenApiVO(List<SiteTimeIdOpenApiVO> threatId, Integer type, SignatureSuppressionOpenApiVO signatureSuppression, String blockName) {
        this.threatId = threatId;
        this.type = type;
        this.signatureSuppression = signatureSuppression;
        this.blockName = blockName;
    }
}

