/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.api.openapi.vo.report;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.f.a;
import com.tplink.smb.omada.monitor.api.web.report.vo.NetworkReportScheduleVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class NetworkReportScheduleOpenApiVO {
    @Schema(name="enable", description="Whether to enable periodic report generation and sending.")
    @NotNull(message="enable should not be null.")
    @Valid
    private @NotNull(message="enable should not be null.") @Valid Boolean enable;
    @Schema(name="tab", description="Report tab, 0-summary, 1-wireless summary, 2-wired summary, 3-wireless devices,4-wired devices, 5-ssid, 6-client.")
    @NotNull(message="tab should not be null")
    @Range(min=0L, max=6L, message="The value of tab must be between 0 and 6.")
    private @NotNull(message="tab should not be null") @Range(min=0L, max=6L, message="The value of tab must be between 0 and 6.") Integer tab;
    @Schema(name="reportName", description="Parameter [reportName] should be a string of 1 to 64 characters without any space at the beginning or end.")
    @NotNull(message="reportName should not be null")
    private @NotNull(message="reportName should not be null") String reportName;
    @Schema(name="reportType", description="Type of the file to be exported [0:PDF,1:CSV].")
    @Range(min=0L, max=1L, message="The value of reportType must be between 0 and 1.")
    @NotNull(message="reportType should not be null")
    private @Range(min=0L, max=1L, message="The value of reportType must be between 0 and 1.") @NotNull(message="reportType should not be null") Integer reportType;
    @Schema(name="emailList", description="Email List. Example:[\"11@qq.com\",\"11@qq.com\"]")
    @PII(strategy=PIIMaskStrategy.HASH)
    @NotNull(message="emailList should not be null")
    private @NotNull(message="emailList should not be null") List<String> emailList;
    @Schema(name="cards", description="According to the Tab, fill in the cards parameter with the corresponding string. The string is a json array whose elements represent a single card. The type and granularity parameters for the cards cannot be removed. Only the granularity value can be changed, which can be 0/1/2 [0:5min, 1:hourly, 2:daily].Summary:\"[{\\\"type\\\":\\\"apSummary\\\"},{\\\"type\\\":\\\"ssidSummary\\\"},{\\\"type\\\":\\\"bandSummary\\\"},{\\\"type\\\":\\\"switchSummary\\\"},{\\\"type\\\":\\\"deviceSummary\\\"},{\\\"type\\\":\\\"clientsSummary\\\"},{\\\"type\\\":\\\"trafficSummary\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"trafficDistribution\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"alertSummary\\\"},{\\\"type\\\":\\\"eventSummary\\\"},{\\\"type\\\":\\\"appFlowSummary\\\"}]\";Wireless Summary:\"[{\\\"type\\\":\\\"onlineOfflineAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"apSummary\\\"},{\\\"type\\\":\\\"ssidSummary\\\"},{\\\"type\\\":\\\"bandSummary\\\"},{\\\"type\\\":\\\"topTrafficAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topClientNumAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"apAlert\\\"},{\\\"type\\\":\\\"apRebootTimes\\\"},{\\\"type\\\":\\\"wirelessOverview\\\"},{\\\"type\\\":\\\"wirelessTxRxTraffic\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"wirelessBandTraffic\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"wirelessClientsActivities\\\",\\\"granularity\\\":0}]\";Wired Summary:\"[{\\\"type\\\":\\\"wiredOverview\\\"},{\\\"type\\\":\\\"ispLoad\\\"},{\\\"type\\\":\\\"onlineOfflineSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"wiredClientsActivities\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"switchSummary\\\"},{\\\"type\\\":\\\"topTrafficSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topPoeUtilSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topPoePowerSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topClientNumSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"switchAlert\\\"},{\\\"type\\\":\\\"switchRebootTimes\\\"}]\";Wireless Devices:\"[{\\\"type\\\":\\\"onlineOfflineAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"apSummary\\\"},{\\\"type\\\":\\\"topTrafficAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topCpuUtilAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topMemUtilAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topClientNumAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"apAlert\\\"},{\\\"type\\\":\\\"apRebootTimes\\\"}]\";Wired Devices:\"[{\\\"type\\\":\\\"onlineOfflineSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"switchSummary\\\"},{\\\"type\\\":\\\"gatewayCpuMemUtil\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topTrafficSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topCpuUtilSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topMemUtilSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topClientNumSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"switchAlert\\\"},{\\\"type\\\":\\\"switchRebootTimes\\\"}]\";SSID:\"[{\\\"type\\\":\\\"ssidSummary\\\"},{\\\"type\\\":\\\"topTrafficSsid\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topClientNumSsid\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"ssidNumActivities\\\",\\\"granularity\\\":0}]\";Clients:\"[{\\\"type\\\":\\\"clientDistribution\\\"},{\\\"type\\\":\\\"clientNumActivities\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"wirelessClientsActivities\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"guestNumActivities\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topClientNumAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topClientNumSwitch\\\",\\\"granularity\\\":0}]\";")
    @NotNull(message="cards should not be null")
    private @NotNull(message="cards should not be null") String cards;
    @Schema(name="timingType", description="Frequency of executing schedule task Daily(1), Weekly(2), Monthly(3).")
    @Range(min=1L, max=3L, message="The value of timingType must be between 1 and 3.")
    @NotNull(message="timingType should not be null")
    private @Range(min=1L, max=3L, message="The value of timingType must be between 1 and 3.") @NotNull(message="timingType should not be null") Integer timingType;
    @Schema(name="hour", description="The value ranges from 0 to 23.")
    @Range(min=0L, max=23L, message="The value of hour must be between 0 and 23.")
    @NotNull(message="hour should not be null")
    private @Range(min=0L, max=23L, message="The value of hour must be between 0 and 23.") @NotNull(message="hour should not be null") Integer hour;
    @Schema(name="minute", description="The value ranges from 0 to 59.")
    @Range(min=0L, max=59L, message="The value of minute must be between 0 and 59.")
    @NotNull(message="minute should not be null")
    private @Range(min=0L, max=59L, message="The value of minute must be between 0 and 59.") @NotNull(message="minute should not be null") Integer minute;
    @Schema(name="dayOfWeek", description="If timing type is weekly, enter and only enter [dayOfWeek].The value ranges from 0 to 6.('0' indicate Sunday)")
    @Range(min=0L, max=6L, message="The value of dayOfWeek must be between 0 and 6.")
    private @Range(min=0L, max=6L, message="The value of dayOfWeek must be between 0 and 6.") Integer dayOfWeek;
    @Schema(name="dayOfMonth", description="If timing type is monthly, enter and only enter [dayOfMonth].The value ranges from 1 to 31. Schedule will fail on the day of the monthif you select 29th,30th,31th but the month doesn't have these days.")
    @Range(min=1L, max=31L, message="The value of dayOfMonth must be between 1 and 31.")
    private @Range(min=1L, max=31L, message="The value of dayOfMonth must be between 1 and 31.") Integer dayOfMonth;

    public OperationResponse areEmailAddressesValid() {
        if (this.enable.booleanValue()) {
            if (CollectionUtils.isEmpty(this.emailList)) {
                return OperationResponse.PARAM_ERROR;
            }
            for (String email : this.emailList) {
                if (a.a((String)email)) continue;
                return new OperationResponse(b.bW);
            }
            return OperationResponse.SUCCESS;
        }
        if (!CollectionUtils.isEmpty(this.emailList)) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    @Nullable
    public static NetworkReportScheduleVO toWebVO(NetworkReportScheduleOpenApiVO openApiVO) {
        if (Objects.isNull(openApiVO)) {
            return null;
        }
        NetworkReportScheduleVO webVO = new NetworkReportScheduleVO();
        webVO.setEnable(openApiVO.getEnable());
        webVO.setTab(openApiVO.getTab());
        webVO.setCards(openApiVO.getCards());
        webVO.setReportName(openApiVO.getReportName());
        webVO.setReportType(openApiVO.getReportType());
        webVO.setEmailList(openApiVO.getEmailList());
        webVO.setMinute(openApiVO.getMinute());
        webVO.setHour(openApiVO.getHour());
        webVO.setDayOfWeek(openApiVO.getDayOfWeek());
        webVO.setDayOfMonth(openApiVO.getDayOfMonth());
        webVO.setTimingType(openApiVO.getTimingType());
        return webVO;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Integer getTab() {
        return this.tab;
    }

    @Generated
    public String getReportName() {
        return this.reportName;
    }

    @Generated
    public Integer getReportType() {
        return this.reportType;
    }

    @Generated
    public List<String> getEmailList() {
        return this.emailList;
    }

    @Generated
    public String getCards() {
        return this.cards;
    }

    @Generated
    public Integer getTimingType() {
        return this.timingType;
    }

    @Generated
    public Integer getHour() {
        return this.hour;
    }

    @Generated
    public Integer getMinute() {
        return this.minute;
    }

    @Generated
    public Integer getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Generated
    public Integer getDayOfMonth() {
        return this.dayOfMonth;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setTab(Integer tab) {
        this.tab = tab;
    }

    @Generated
    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    @Generated
    public void setReportType(Integer reportType) {
        this.reportType = reportType;
    }

    @Generated
    public void setEmailList(List<String> emailList) {
        this.emailList = emailList;
    }

    @Generated
    public void setCards(String cards) {
        this.cards = cards;
    }

    @Generated
    public void setTimingType(Integer timingType) {
        this.timingType = timingType;
    }

    @Generated
    public void setHour(Integer hour) {
        this.hour = hour;
    }

    @Generated
    public void setMinute(Integer minute) {
        this.minute = minute;
    }

    @Generated
    public void setDayOfWeek(Integer dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    @Generated
    public void setDayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    @Generated
    public String toString() {
        return "NetworkReportScheduleOpenApiVO(enable=" + this.getEnable() + ", tab=" + this.getTab() + ", reportName=" + this.getReportName() + ", reportType=" + this.getReportType() + ", emailList=" + this.getEmailList() + ", cards=" + this.getCards() + ", timingType=" + this.getTimingType() + ", hour=" + this.getHour() + ", minute=" + this.getMinute() + ", dayOfWeek=" + this.getDayOfWeek() + ", dayOfMonth=" + this.getDayOfMonth() + ")";
    }

    @Generated
    public NetworkReportScheduleOpenApiVO() {
    }

    @Generated
    public NetworkReportScheduleOpenApiVO(Boolean enable, Integer tab, String reportName, Integer reportType, List<String> emailList, String cards, Integer timingType, Integer hour, Integer minute, Integer dayOfWeek, Integer dayOfMonth) {
        this.enable = enable;
        this.tab = tab;
        this.reportName = reportName;
        this.reportType = reportType;
        this.emailList = emailList;
        this.cards = cards;
        this.timingType = timingType;
        this.hour = hour;
        this.minute = minute;
        this.dayOfWeek = dayOfWeek;
        this.dayOfMonth = dayOfMonth;
    }
}

