/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.api.openapi.vo.report;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.f.a;
import com.tplink.smb.omada.monitor.api.web.report.vo.NetworkReportScheduleLaterVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class NetworkReportScheduleLaterOpenApiVO {
    @Schema(name="enable", description="Whether to enable periodic report generation and sending.")
    @NotNull(message="enable should not be null.")
    private @NotNull(message="enable should not be null.") Boolean enable;
    @Schema(name="tab", description="Report tab, 0-summary, 1-wireless summary, 2-wired summary, 3-wireless devices,4-wired devices, 5-ssid, 6-client.")
    @Range(min=0L, max=6L, message="The value of tab must be between 0 and 6.")
    @NotNull(message="tab should not be null")
    private @Range(min=0L, max=6L, message="The value of tab must be between 0 and 6.") @NotNull(message="tab should not be null") Integer tab;
    @Schema(name="cards", description="According to the Tab, fill in the cards parameter with the corresponding json string. The string is a json array whose elements represent a single card. The type and granularity parameters for the cards cannot be removed. Only the granularity value can be changed, which can be 0/1/2 [0:5min, 1:hourly, 2:daily].Summary:\"[{\\\"type\\\":\\\"apSummary\\\"},{\\\"type\\\":\\\"ssidSummary\\\"},{\\\"type\\\":\\\"bandSummary\\\"},{\\\"type\\\":\\\"switchSummary\\\"},{\\\"type\\\":\\\"deviceSummary\\\"},{\\\"type\\\":\\\"clientsSummary\\\"},{\\\"type\\\":\\\"trafficSummary\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"trafficDistribution\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"alertSummary\\\"},{\\\"type\\\":\\\"eventSummary\\\"},{\\\"type\\\":\\\"appFlowSummary\\\"}]\";Wireless Summary:\"[{\\\"type\\\":\\\"onlineOfflineAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"apSummary\\\"},{\\\"type\\\":\\\"ssidSummary\\\"},{\\\"type\\\":\\\"bandSummary\\\"},{\\\"type\\\":\\\"topTrafficAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topClientNumAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"apAlert\\\"},{\\\"type\\\":\\\"apRebootTimes\\\"},{\\\"type\\\":\\\"wirelessOverview\\\"},{\\\"type\\\":\\\"wirelessTxRxTraffic\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"wirelessBandTraffic\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"wirelessClientsActivities\\\",\\\"granularity\\\":0}]\";Wired Summary:\"[{\\\"type\\\":\\\"wiredOverview\\\"},{\\\"type\\\":\\\"ispLoad\\\"},{\\\"type\\\":\\\"onlineOfflineSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"wiredClientsActivities\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"switchSummary\\\"},{\\\"type\\\":\\\"topTrafficSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topPoeUtilSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topPoePowerSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topClientNumSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"switchAlert\\\"},{\\\"type\\\":\\\"switchRebootTimes\\\"}]\";Wireless Devices:\"[{\\\"type\\\":\\\"onlineOfflineAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"apSummary\\\"},{\\\"type\\\":\\\"topTrafficAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topCpuUtilAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topMemUtilAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topClientNumAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"apAlert\\\"},{\\\"type\\\":\\\"apRebootTimes\\\"}]\";Wired Devices:\"[{\\\"type\\\":\\\"onlineOfflineSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"switchSummary\\\"},{\\\"type\\\":\\\"gatewayCpuMemUtil\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topTrafficSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topCpuUtilSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topMemUtilSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topClientNumSwitch\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"switchAlert\\\"},{\\\"type\\\":\\\"switchRebootTimes\\\"}]\";SSID:\"[{\\\"type\\\":\\\"ssidSummary\\\"},{\\\"type\\\":\\\"topTrafficSsid\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topClientNumSsid\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"ssidNumActivities\\\",\\\"granularity\\\":0}]\";Clients:\"[{\\\"type\\\":\\\"clientDistribution\\\"},{\\\"type\\\":\\\"clientNumActivities\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"wirelessClientsActivities\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"guestNumActivities\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topClientNumAp\\\",\\\"granularity\\\":0},{\\\"type\\\":\\\"topClientNumSwitch\\\",\\\"granularity\\\":0}]\";")
    @NotNull(message="cards should not be null")
    private @NotNull(message="cards should not be null") String cards;
    @Schema(name="reportName", description="Report Name.")
    @Pattern(regexp="^[a-zA-Z0-9_&\\- ]{1,64}$", message="Parameter [reportName] should be a string of 1 to 64 characters without any space at the beginning or end.")
    @NotNull(message="reportName should not be null")
    private @Pattern(regexp="^[a-zA-Z0-9_&\\- ]{1,64}$", message="Parameter [reportName] should be a string of 1 to 64 characters without any space at the beginning or end.") @NotNull(message="reportName should not be null") String reportName;
    @Schema(name="reportType", description="Type of the file to be exported [0:PDF,1:CSV].")
    @Range(min=0L, max=1L, message="The value of reportType must be between 0 and 1.")
    @NotNull(message="reportType should not be null")
    private @Range(min=0L, max=1L, message="The value of reportType must be between 0 and 1.") @NotNull(message="reportType should not be null") Integer reportType;
    @Schema(name="emailList", description="Email List. Example:[\"11@qq.com\",\"11@qq.com\"]")
    @PII(strategy=PIIMaskStrategy.HASH)
    @NotNull(message="emailList should not be null")
    private @NotNull(message="emailList should not be null") List<String> emailList;
    @Schema(name="minute", description="The value ranges from 0 to 59.")
    @Range(min=0L, max=59L, message="The value of minute must be between 0 and 59.")
    @NotNull(message="minute should not be null")
    private @Range(min=0L, max=59L, message="The value of minute must be between 0 and 59.") @NotNull(message="minute should not be null") Integer minute;
    @Schema(name="hour", description="The value ranges from 0 to 23.")
    @Range(min=0L, max=23L, message="The value of hour must be between 0 and 23.")
    @NotNull(message="hour should not be null")
    private @Range(min=0L, max=23L, message="The value of hour must be between 0 and 23.") @NotNull(message="hour should not be null") Integer hour;
    @Schema(name="time", description="The timestamp of the year, month, and day is generated.")
    @NotNull(message="time should not be null")
    private @NotNull(message="time should not be null") Long time;
    @Schema(name="start", description="The start timestamp of the query for the data needed to generate the report.")
    @NotNull(message="start should not be null")
    private @NotNull(message="start should not be null") Long start;
    @Schema(name="end", description="The end timestamp of the query for the data needed to generate the report.")
    @NotNull(message="end should not be null")
    private @NotNull(message="end should not be null") Long end;

    public OperationResponse areEmailAddressesValid() {
        if (this.enable.booleanValue()) {
            if (CollectionUtils.isEmpty(this.emailList)) {
                return OperationResponse.PARAM_ERROR;
            }
            for (String email : this.emailList) {
                if (a.a((String)email)) continue;
                return new OperationResponse(b.bW);
            }
            return OperationResponse.SUCCESS;
        }
        if (!CollectionUtils.isEmpty(this.emailList)) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    @Nullable
    public static NetworkReportScheduleLaterVO toWebVO(NetworkReportScheduleLaterOpenApiVO openApiVO) {
        if (Objects.isNull(openApiVO)) {
            return null;
        }
        NetworkReportScheduleLaterVO webVO = new NetworkReportScheduleLaterVO();
        webVO.setEnable(openApiVO.getEnable());
        webVO.setTab(openApiVO.getTab());
        webVO.setCards(openApiVO.getCards());
        webVO.setReportName(openApiVO.getReportName());
        webVO.setReportType(openApiVO.getReportType());
        webVO.setEmailList(openApiVO.getEmailList());
        webVO.setMinute(openApiVO.getMinute());
        webVO.setHour(openApiVO.getHour());
        webVO.setTime(openApiVO.getTime());
        webVO.setStart(openApiVO.getStart());
        webVO.setEnd(openApiVO.getEnd());
        return webVO;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Integer getTab() {
        return this.tab;
    }

    @Generated
    public String getCards() {
        return this.cards;
    }

    @Generated
    public String getReportName() {
        return this.reportName;
    }

    @Generated
    public Integer getReportType() {
        return this.reportType;
    }

    @Generated
    public List<String> getEmailList() {
        return this.emailList;
    }

    @Generated
    public Integer getMinute() {
        return this.minute;
    }

    @Generated
    public Integer getHour() {
        return this.hour;
    }

    @Generated
    public Long getTime() {
        return this.time;
    }

    @Generated
    public Long getStart() {
        return this.start;
    }

    @Generated
    public Long getEnd() {
        return this.end;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setTab(Integer tab) {
        this.tab = tab;
    }

    @Generated
    public void setCards(String cards) {
        this.cards = cards;
    }

    @Generated
    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    @Generated
    public void setReportType(Integer reportType) {
        this.reportType = reportType;
    }

    @Generated
    public void setEmailList(List<String> emailList) {
        this.emailList = emailList;
    }

    @Generated
    public void setMinute(Integer minute) {
        this.minute = minute;
    }

    @Generated
    public void setHour(Integer hour) {
        this.hour = hour;
    }

    @Generated
    public void setTime(Long time) {
        this.time = time;
    }

    @Generated
    public void setStart(Long start) {
        this.start = start;
    }

    @Generated
    public void setEnd(Long end) {
        this.end = end;
    }

    @Generated
    public String toString() {
        return "NetworkReportScheduleLaterOpenApiVO(enable=" + this.getEnable() + ", tab=" + this.getTab() + ", cards=" + this.getCards() + ", reportName=" + this.getReportName() + ", reportType=" + this.getReportType() + ", emailList=" + this.getEmailList() + ", minute=" + this.getMinute() + ", hour=" + this.getHour() + ", time=" + this.getTime() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ")";
    }

    @Generated
    public NetworkReportScheduleLaterOpenApiVO() {
    }
}

