/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.api.openapi.vo.ips;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.monitor.api.web.insight.dto.SignatureSuppressionVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="SignatureSuppression", description="Signature suppression configuration")
public class SignatureSuppressionOpenApiVO {
    @Schema(name="type", description="Type should be a value as follow: 0: all traffic; 1: packet tracking.", example="1", requiredMode=Schema.RequiredMode.REQUIRED)
    @Range(min=0L, max=1L, message="IPS signature type should be 0 or 1.")
    private @Range(min=0L, max=1L, message="IPS signature type should be 0 or 1.") Integer type;
    @Schema(name="direction", description="Direction should be a value as follow: 0: both direction; 1: source direction; 2: destination direction", example="1")
    @Range(min=0L, max=2L, message="Direction should be within the range of 0-2.")
    private @Range(min=0L, max=2L, message="Direction should be within the range of 0-2.") Integer direction;
    @Schema(name="trackBy", description="TrackBy should be a value as follow: 0: ip address; 1: subnet", example="0")
    @Range(min=0L, max=1L, message="IPS signature traffic type should be 0 or 1.")
    private @Range(min=0L, max=1L, message="IPS signature traffic type should be 0 or 1.") Integer trackBy;
    @Schema(name="ip", description="IPS signature traffic source. If parameter [trackBy] is 0, parameter [ip] is needed. ", example="192.168.0.1")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="parameter should be valid ipv4 address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="parameter should be valid ipv4 address.") String ip;
    @Schema(name="subnet", description="IPS signature traffic source. If parameter [trackBy] is 1, parameter [subnet] is needed.", example="192.168.0.0/24")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/([1-9]|((1|2)\\d)|(30|31|32))\\b", message="parameter should be valid subnet.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/([1-9]|((1|2)\\d)|(30|31|32))\\b", message="parameter should be valid subnet.") String subnet;

    @Nullable
    public static SignatureSuppressionVO toWebVO(SignatureSuppressionOpenApiVO openApiVO) {
        if (Objects.isNull(openApiVO)) {
            return null;
        }
        SignatureSuppressionVO webVO = new SignatureSuppressionVO();
        webVO.setType(openApiVO.getType());
        webVO.setDirection(openApiVO.getDirection());
        webVO.setTrackBy(openApiVO.getTrackBy());
        webVO.setIp(openApiVO.getIp());
        webVO.setSubnet(openApiVO.getSubnet());
        return webVO;
    }

    @Generated
    protected SignatureSuppressionOpenApiVO(SignatureSuppressionOpenApiVOBuilder<?, ?> b2) {
        this.type = b2.type;
        this.direction = b2.direction;
        this.trackBy = b2.trackBy;
        this.ip = b2.ip;
        this.subnet = b2.subnet;
    }

    @Generated
    public static SignatureSuppressionOpenApiVOBuilder<?, ?> builder() {
        return new SignatureSuppressionOpenApiVOBuilderImpl();
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getDirection() {
        return this.direction;
    }

    @Generated
    public Integer getTrackBy() {
        return this.trackBy;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getSubnet() {
        return this.subnet;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setDirection(Integer direction) {
        this.direction = direction;
    }

    @Generated
    public void setTrackBy(Integer trackBy) {
        this.trackBy = trackBy;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setSubnet(String subnet) {
        this.subnet = subnet;
    }

    @Generated
    public String toString() {
        return "SignatureSuppressionOpenApiVO(type=" + this.getType() + ", direction=" + this.getDirection() + ", trackBy=" + this.getTrackBy() + ", ip=" + this.getIp() + ", subnet=" + this.getSubnet() + ")";
    }

    @Generated
    public SignatureSuppressionOpenApiVO(Integer type, Integer direction, Integer trackBy, String ip, String subnet) {
        this.type = type;
        this.direction = direction;
        this.trackBy = trackBy;
        this.ip = ip;
        this.subnet = subnet;
    }

    @Generated
    public SignatureSuppressionOpenApiVO() {
    }

    @Generated
    public static abstract class SignatureSuppressionOpenApiVOBuilder<C extends SignatureSuppressionOpenApiVO, B extends SignatureSuppressionOpenApiVOBuilder<C, B>> {
        @Generated
        private Integer type;
        @Generated
        private Integer direction;
        @Generated
        private Integer trackBy;
        @Generated
        private String ip;
        @Generated
        private String subnet;

        @Generated
        public B type(Integer type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B direction(Integer direction) {
            this.direction = direction;
            return this.self();
        }

        @Generated
        public B trackBy(Integer trackBy) {
            this.trackBy = trackBy;
            return this.self();
        }

        @Generated
        public B ip(String ip) {
            this.ip = ip;
            return this.self();
        }

        @Generated
        public B subnet(String subnet) {
            this.subnet = subnet;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SignatureSuppressionOpenApiVO.SignatureSuppressionOpenApiVOBuilder(type=" + this.type + ", direction=" + this.direction + ", trackBy=" + this.trackBy + ", ip=" + this.ip + ", subnet=" + this.subnet + ")";
        }
    }

    @Generated
    private static final class SignatureSuppressionOpenApiVOBuilderImpl
    extends SignatureSuppressionOpenApiVOBuilder<SignatureSuppressionOpenApiVO, SignatureSuppressionOpenApiVOBuilderImpl> {
        @Generated
        private SignatureSuppressionOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected SignatureSuppressionOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SignatureSuppressionOpenApiVO build() {
            return new SignatureSuppressionOpenApiVO(this);
        }
    }
}

