/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.api.openapi.vo.fullchanneldetect;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.monitor.api.web.fullchanneldetect.dto.EnableFullChannelDetectDeviceVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;

@Schema(name="EnableFullChannelDetectApInfoOpenApiVO")
public class EnableFullChannelDetectApInfoOpenApiVO {
    @Schema(description="Mac address")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private String mac;
    @Schema(description="Default uses the MAC address as the name.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String name;
    @Schema(description="Model, such as EAP225.")
    private String model;
    @Schema(name="modelVersion", description="Model version of device,for example:3.0")
    private String modelVersion;
    @Schema(description="Device type:ap\u3001gateway\u3001switch\u3001olt")
    private String type;
    @Schema(description="Ip address,such as 192.168.0.105")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String ip;
    @Schema(name="statusCategory", description="Category of device status,statusCategory should be a value as follows: 0:Disconnected;1:Connected;2:Pending;3:Heartbeat Missed;4:Isolated")
    private Integer statusCategory;
    @Schema(name="status", description="Status of device,status should be a value as follows: 0:Disconnected;1:Disconnected(Migrating);10:Provisioning;11:Configuring;12:Upgrading;13:Rebooting;14:Connected;15:Connected(Wireless);16:Connected(Migrating);17:Connected(Wireless,Migrating);20:Pending;21:Pending(Wireless);22:Adopting;23:Adopting(Wireless);24:Adopt Failed;25:Adopt Failed(Wireless);26:Managed By Others;27:Managed By Others(Wireless);30:Heartbeat Missed;31:Heartbeat Missed(Wireless);32:Heartbeat Missed(Migrating);33:Heartbeat Missed(Wireless,Migrating);40:Isolated;41:Isolated(Migrating);50:Slice Configuring")
    private Integer status;
    @Schema(description="Software version, such as \"2.5.0,\" extracted from DeviceDO.firmwareVersion - \"2.5.0 Build 20190118 Rel. 64821.\"")
    private String version;
    @Schema(description="Whether the device is added in advanced.")
    private Boolean addedInAdvanced;
    @Schema(description="Runtime duration, in seconds (s).")
    private Long uptimeLong;
    @Schema(description="Whether the device is wireless linked.")
    private Boolean wirelessLinked;
    @Schema(name="scanStatus", description="Scan Status of device,status should be a value as follows:  0:Not Scanned, 1:Spectrum Scanning, 2:RFScanning, 3:packet capturing, 4:RFPlanning;")
    private Integer scanStatus;
    @Schema(name="powerModeList", description="Indicating the power supply modes for AP devices across frequency bands, with array indices corresponding to the frequency bands: 0: 2.4G 1: 5G/5G1 2: 5G2 3: 6G. The corresponding values for power supply modes are: 0: Normal operation 1: Power limited 2: Frequency band disabled")
    private List<Integer> powerModeList;

    public static EnableFullChannelDetectApInfoOpenApiVO fromVO(EnableFullChannelDetectDeviceVO vo) {
        if (vo == null) {
            return null;
        }
        EnableFullChannelDetectApInfoOpenApiVO openApiVO = new EnableFullChannelDetectApInfoOpenApiVO();
        openApiVO.setMac(vo.getMac());
        openApiVO.setName(vo.getName());
        openApiVO.setModel(vo.getModel());
        openApiVO.setModelVersion(vo.getModelVersion());
        openApiVO.setType(vo.getType());
        openApiVO.setIp(vo.getIp());
        openApiVO.setStatusCategory(vo.getStatusCategory());
        openApiVO.setStatus(vo.getStatus());
        openApiVO.setVersion(vo.getVersion());
        openApiVO.setAddedInAdvanced(vo.getAddedInAdvanced());
        openApiVO.setUptimeLong(vo.getUptimeLong());
        openApiVO.setWirelessLinked(vo.getWirelessLinked());
        openApiVO.setScanStatus(vo.getScanStatus());
        openApiVO.setPowerModeList(vo.getPowerModeList());
        return openApiVO;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Integer getStatusCategory() {
        return this.statusCategory;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Boolean getAddedInAdvanced() {
        return this.addedInAdvanced;
    }

    @Generated
    public Long getUptimeLong() {
        return this.uptimeLong;
    }

    @Generated
    public Boolean getWirelessLinked() {
        return this.wirelessLinked;
    }

    @Generated
    public Integer getScanStatus() {
        return this.scanStatus;
    }

    @Generated
    public List<Integer> getPowerModeList() {
        return this.powerModeList;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setStatusCategory(Integer statusCategory) {
        this.statusCategory = statusCategory;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setAddedInAdvanced(Boolean addedInAdvanced) {
        this.addedInAdvanced = addedInAdvanced;
    }

    @Generated
    public void setUptimeLong(Long uptimeLong) {
        this.uptimeLong = uptimeLong;
    }

    @Generated
    public void setWirelessLinked(Boolean wirelessLinked) {
        this.wirelessLinked = wirelessLinked;
    }

    @Generated
    public void setScanStatus(Integer scanStatus) {
        this.scanStatus = scanStatus;
    }

    @Generated
    public void setPowerModeList(List<Integer> powerModeList) {
        this.powerModeList = powerModeList;
    }

    @Generated
    public String toString() {
        return "EnableFullChannelDetectApInfoOpenApiVO(mac=" + this.getMac() + ", name=" + this.getName() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ", type=" + this.getType() + ", ip=" + this.getIp() + ", statusCategory=" + this.getStatusCategory() + ", status=" + this.getStatus() + ", version=" + this.getVersion() + ", addedInAdvanced=" + this.getAddedInAdvanced() + ", uptimeLong=" + this.getUptimeLong() + ", wirelessLinked=" + this.getWirelessLinked() + ", scanStatus=" + this.getScanStatus() + ", powerModeList=" + this.getPowerModeList() + ")";
    }
}

