/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.api.openapi.stat;

import com.tplink.smb.omada.monitor.api.web.statistic.dto.OswStatDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OswStatVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.PortStatVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class OswStatOpenApiVO {
    @Schema(description="Port total traffic map")
    private Map<Integer, PortStatVO> portMap;
    @Schema(description="Detailed traffic information of ports")
    private List<OswStatDetailOpenApiVO> statList;
    @Schema(description="Type of Switch should be a value as follows: 0:Non-Agile Series Switch, 1:Agile Series Switch")
    private Integer switchType;

    public static OswStatOpenApiVO buildFromWebVO(OswStatVO dto) {
        OswStatOpenApiVO oswStatOpenApiVO = new OswStatOpenApiVO();
        oswStatOpenApiVO.setPortMap(dto.getPortMap());
        oswStatOpenApiVO.setSwitchType(dto.getSwitchType());
        oswStatOpenApiVO.setStatList(((List)Optional.ofNullable(dto.getStatList()).orElse(new ArrayList())).stream().map(OswStatDetailOpenApiVO::buildFromWebVO).collect(Collectors.toList()));
        return oswStatOpenApiVO;
    }

    @Generated
    public Map<Integer, PortStatVO> getPortMap() {
        return this.portMap;
    }

    @Generated
    public List<OswStatDetailOpenApiVO> getStatList() {
        return this.statList;
    }

    @Generated
    public Integer getSwitchType() {
        return this.switchType;
    }

    @Generated
    public void setPortMap(Map<Integer, PortStatVO> portMap) {
        this.portMap = portMap;
    }

    @Generated
    public void setStatList(List<OswStatDetailOpenApiVO> statList) {
        this.statList = statList;
    }

    @Generated
    public void setSwitchType(Integer switchType) {
        this.switchType = switchType;
    }

    @Generated
    public OswStatOpenApiVO(Map<Integer, PortStatVO> portMap, List<OswStatDetailOpenApiVO> statList, Integer switchType) {
        this.portMap = portMap;
        this.statList = statList;
        this.switchType = switchType;
    }

    @Generated
    public OswStatOpenApiVO() {
    }

    public static class OswPortStatOpenApiVO {
        @Schema(description="Port of Switch")
        private Integer port;
        @Schema(description="Transmit traffic of the port, in bytes")
        private Long tx;
        @Schema(description="Receive traffic of the port, in bytes")
        private Long rx;
        @Schema(description="Transmit rate, byte/s")
        private Long txRate;
        @Schema(description="Receive rate, byte/s")
        private Long rxRate;
        @Schema(description="Transmit packets of the port")
        private Long txPkts;
        @Schema(description="Receive receive packets of the port")
        private Long rxPkts;
        @Schema(description="Transmit broadcast packets")
        private Long txBroadPkts;
        @Schema(description="Receive broadcast packets")
        private Long rxBroadPkts;
        @Schema(description="Transmit multicast packets")
        private Long txMultiPkts;
        @Schema(description="Receive multicast packets")
        private Long rxMultiPkts;
        @Schema(description="Drop packets")
        private Long dropPkts;
        @Schema(description="Transmit error packets")
        private Long txErrPkts;
        @Schema(description="Receive error packets")
        private Long rxErrPkts;

        public static OswPortStatOpenApiVO buildFromWebVO(OswStatDTO.OswPortStatDTO dto) {
            return OswPortStatOpenApiVO.builder().port(dto.getPort()).tx(dto.getTx()).rx(dto.getRx()).txRate(dto.getTxRate()).rxRate(dto.getRxRate()).txPkts(dto.getTxPkts()).rxPkts(dto.getRxPkts()).txBroadPkts(dto.getTxBroadPkts()).rxBroadPkts(dto.getRxBroadPkts()).txMultiPkts(dto.getTxMultiPkts()).rxMultiPkts(dto.getRxMultiPkts()).dropPkts(dto.getDropPkts()).txErrPkts(dto.getTxErrPkts()).rxErrPkts(dto.getRxErrPkts()).build();
        }

        @Generated
        public static OswPortStatOpenApiVOBuilder builder() {
            return new OswPortStatOpenApiVOBuilder();
        }

        @Generated
        public Integer getPort() {
            return this.port;
        }

        @Generated
        public Long getTx() {
            return this.tx;
        }

        @Generated
        public Long getRx() {
            return this.rx;
        }

        @Generated
        public Long getTxRate() {
            return this.txRate;
        }

        @Generated
        public Long getRxRate() {
            return this.rxRate;
        }

        @Generated
        public Long getTxPkts() {
            return this.txPkts;
        }

        @Generated
        public Long getRxPkts() {
            return this.rxPkts;
        }

        @Generated
        public Long getTxBroadPkts() {
            return this.txBroadPkts;
        }

        @Generated
        public Long getRxBroadPkts() {
            return this.rxBroadPkts;
        }

        @Generated
        public Long getTxMultiPkts() {
            return this.txMultiPkts;
        }

        @Generated
        public Long getRxMultiPkts() {
            return this.rxMultiPkts;
        }

        @Generated
        public Long getDropPkts() {
            return this.dropPkts;
        }

        @Generated
        public Long getTxErrPkts() {
            return this.txErrPkts;
        }

        @Generated
        public Long getRxErrPkts() {
            return this.rxErrPkts;
        }

        @Generated
        public void setPort(Integer port) {
            this.port = port;
        }

        @Generated
        public void setTx(Long tx) {
            this.tx = tx;
        }

        @Generated
        public void setRx(Long rx) {
            this.rx = rx;
        }

        @Generated
        public void setTxRate(Long txRate) {
            this.txRate = txRate;
        }

        @Generated
        public void setRxRate(Long rxRate) {
            this.rxRate = rxRate;
        }

        @Generated
        public void setTxPkts(Long txPkts) {
            this.txPkts = txPkts;
        }

        @Generated
        public void setRxPkts(Long rxPkts) {
            this.rxPkts = rxPkts;
        }

        @Generated
        public void setTxBroadPkts(Long txBroadPkts) {
            this.txBroadPkts = txBroadPkts;
        }

        @Generated
        public void setRxBroadPkts(Long rxBroadPkts) {
            this.rxBroadPkts = rxBroadPkts;
        }

        @Generated
        public void setTxMultiPkts(Long txMultiPkts) {
            this.txMultiPkts = txMultiPkts;
        }

        @Generated
        public void setRxMultiPkts(Long rxMultiPkts) {
            this.rxMultiPkts = rxMultiPkts;
        }

        @Generated
        public void setDropPkts(Long dropPkts) {
            this.dropPkts = dropPkts;
        }

        @Generated
        public void setTxErrPkts(Long txErrPkts) {
            this.txErrPkts = txErrPkts;
        }

        @Generated
        public void setRxErrPkts(Long rxErrPkts) {
            this.rxErrPkts = rxErrPkts;
        }

        @Generated
        public OswPortStatOpenApiVO(Integer port, Long tx, Long rx, Long txRate, Long rxRate, Long txPkts, Long rxPkts, Long txBroadPkts, Long rxBroadPkts, Long txMultiPkts, Long rxMultiPkts, Long dropPkts, Long txErrPkts, Long rxErrPkts) {
            this.port = port;
            this.tx = tx;
            this.rx = rx;
            this.txRate = txRate;
            this.rxRate = rxRate;
            this.txPkts = txPkts;
            this.rxPkts = rxPkts;
            this.txBroadPkts = txBroadPkts;
            this.rxBroadPkts = rxBroadPkts;
            this.txMultiPkts = txMultiPkts;
            this.rxMultiPkts = rxMultiPkts;
            this.dropPkts = dropPkts;
            this.txErrPkts = txErrPkts;
            this.rxErrPkts = rxErrPkts;
        }

        @Generated
        public OswPortStatOpenApiVO() {
        }

        @Generated
        public static class OswPortStatOpenApiVOBuilder {
            @Generated
            private Integer port;
            @Generated
            private Long tx;
            @Generated
            private Long rx;
            @Generated
            private Long txRate;
            @Generated
            private Long rxRate;
            @Generated
            private Long txPkts;
            @Generated
            private Long rxPkts;
            @Generated
            private Long txBroadPkts;
            @Generated
            private Long rxBroadPkts;
            @Generated
            private Long txMultiPkts;
            @Generated
            private Long rxMultiPkts;
            @Generated
            private Long dropPkts;
            @Generated
            private Long txErrPkts;
            @Generated
            private Long rxErrPkts;

            @Generated
            OswPortStatOpenApiVOBuilder() {
            }

            @Generated
            public OswPortStatOpenApiVOBuilder port(Integer port) {
                this.port = port;
                return this;
            }

            @Generated
            public OswPortStatOpenApiVOBuilder tx(Long tx) {
                this.tx = tx;
                return this;
            }

            @Generated
            public OswPortStatOpenApiVOBuilder rx(Long rx) {
                this.rx = rx;
                return this;
            }

            @Generated
            public OswPortStatOpenApiVOBuilder txRate(Long txRate) {
                this.txRate = txRate;
                return this;
            }

            @Generated
            public OswPortStatOpenApiVOBuilder rxRate(Long rxRate) {
                this.rxRate = rxRate;
                return this;
            }

            @Generated
            public OswPortStatOpenApiVOBuilder txPkts(Long txPkts) {
                this.txPkts = txPkts;
                return this;
            }

            @Generated
            public OswPortStatOpenApiVOBuilder rxPkts(Long rxPkts) {
                this.rxPkts = rxPkts;
                return this;
            }

            @Generated
            public OswPortStatOpenApiVOBuilder txBroadPkts(Long txBroadPkts) {
                this.txBroadPkts = txBroadPkts;
                return this;
            }

            @Generated
            public OswPortStatOpenApiVOBuilder rxBroadPkts(Long rxBroadPkts) {
                this.rxBroadPkts = rxBroadPkts;
                return this;
            }

            @Generated
            public OswPortStatOpenApiVOBuilder txMultiPkts(Long txMultiPkts) {
                this.txMultiPkts = txMultiPkts;
                return this;
            }

            @Generated
            public OswPortStatOpenApiVOBuilder rxMultiPkts(Long rxMultiPkts) {
                this.rxMultiPkts = rxMultiPkts;
                return this;
            }

            @Generated
            public OswPortStatOpenApiVOBuilder dropPkts(Long dropPkts) {
                this.dropPkts = dropPkts;
                return this;
            }

            @Generated
            public OswPortStatOpenApiVOBuilder txErrPkts(Long txErrPkts) {
                this.txErrPkts = txErrPkts;
                return this;
            }

            @Generated
            public OswPortStatOpenApiVOBuilder rxErrPkts(Long rxErrPkts) {
                this.rxErrPkts = rxErrPkts;
                return this;
            }

            @Generated
            public OswPortStatOpenApiVO build() {
                return new OswPortStatOpenApiVO(this.port, this.tx, this.rx, this.txRate, this.rxRate, this.txPkts, this.rxPkts, this.txBroadPkts, this.rxBroadPkts, this.txMultiPkts, this.rxMultiPkts, this.dropPkts, this.txErrPkts, this.rxErrPkts);
            }

            @Generated
            public String toString() {
                return "OswStatOpenApiVO.OswPortStatOpenApiVO.OswPortStatOpenApiVOBuilder(port=" + this.port + ", tx=" + this.tx + ", rx=" + this.rx + ", txRate=" + this.txRate + ", rxRate=" + this.rxRate + ", txPkts=" + this.txPkts + ", rxPkts=" + this.rxPkts + ", txBroadPkts=" + this.txBroadPkts + ", rxBroadPkts=" + this.rxBroadPkts + ", txMultiPkts=" + this.txMultiPkts + ", rxMultiPkts=" + this.rxMultiPkts + ", dropPkts=" + this.dropPkts + ", txErrPkts=" + this.txErrPkts + ", rxErrPkts=" + this.rxErrPkts + ")";
            }
        }
    }

    public static class OswStatDetailOpenApiVO {
        @Schema(description="sampling moment")
        private Long time;
        @Schema(description="Utilization of cpu")
        private Integer cpu;
        @Schema(description="Utilization of memory")
        private Integer mem;
        @Schema(description="Traffic information of ports")
        private List<OswPortStatOpenApiVO> ports;

        public static OswStatDetailOpenApiVO buildFromWebVO(OswStatDTO dto) {
            return OswStatDetailOpenApiVO.builder().time(dto.getTime()).cpu(dto.getCpu()).mem(dto.getMem()).ports(((List)Optional.ofNullable(dto.getPorts()).orElse(new ArrayList())).stream().map(OswPortStatOpenApiVO::buildFromWebVO).collect(Collectors.toList())).build();
        }

        @Generated
        public static OswStatDetailOpenApiVOBuilder builder() {
            return new OswStatDetailOpenApiVOBuilder();
        }

        @Generated
        public Long getTime() {
            return this.time;
        }

        @Generated
        public Integer getCpu() {
            return this.cpu;
        }

        @Generated
        public Integer getMem() {
            return this.mem;
        }

        @Generated
        public List<OswPortStatOpenApiVO> getPorts() {
            return this.ports;
        }

        @Generated
        public void setTime(Long time) {
            this.time = time;
        }

        @Generated
        public void setCpu(Integer cpu) {
            this.cpu = cpu;
        }

        @Generated
        public void setMem(Integer mem) {
            this.mem = mem;
        }

        @Generated
        public void setPorts(List<OswPortStatOpenApiVO> ports) {
            this.ports = ports;
        }

        @Generated
        public OswStatDetailOpenApiVO(Long time, Integer cpu, Integer mem, List<OswPortStatOpenApiVO> ports) {
            this.time = time;
            this.cpu = cpu;
            this.mem = mem;
            this.ports = ports;
        }

        @Generated
        public OswStatDetailOpenApiVO() {
        }

        @Generated
        public static class OswStatDetailOpenApiVOBuilder {
            @Generated
            private Long time;
            @Generated
            private Integer cpu;
            @Generated
            private Integer mem;
            @Generated
            private List<OswPortStatOpenApiVO> ports;

            @Generated
            OswStatDetailOpenApiVOBuilder() {
            }

            @Generated
            public OswStatDetailOpenApiVOBuilder time(Long time) {
                this.time = time;
                return this;
            }

            @Generated
            public OswStatDetailOpenApiVOBuilder cpu(Integer cpu) {
                this.cpu = cpu;
                return this;
            }

            @Generated
            public OswStatDetailOpenApiVOBuilder mem(Integer mem) {
                this.mem = mem;
                return this;
            }

            @Generated
            public OswStatDetailOpenApiVOBuilder ports(List<OswPortStatOpenApiVO> ports) {
                this.ports = ports;
                return this;
            }

            @Generated
            public OswStatDetailOpenApiVO build() {
                return new OswStatDetailOpenApiVO(this.time, this.cpu, this.mem, this.ports);
            }

            @Generated
            public String toString() {
                return "OswStatOpenApiVO.OswStatDetailOpenApiVO.OswStatDetailOpenApiVOBuilder(time=" + this.time + ", cpu=" + this.cpu + ", mem=" + this.mem + ", ports=" + this.ports + ")";
            }
        }
    }
}

