/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.api.openapi.stat;

import com.tplink.smb.omada.monitor.api.web.statistic.dto.OltStatDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.OltStatVO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.PortStatVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class OltStatOpenApiVO {
    @Schema(description="Port total traffic map")
    private Map<String, PortStatVO> portMap;
    @Schema(description="Detailed traffic information of ports")
    private List<OltStatDetailOpenApiVO> statList;

    public static OltStatOpenApiVO buildFromWebVO(OltStatVO dto) {
        OltStatOpenApiVO oltStatOpenApiVO = new OltStatOpenApiVO();
        oltStatOpenApiVO.setPortMap(dto.getPortMap());
        oltStatOpenApiVO.setStatList(((List)Optional.ofNullable(dto.getStatList()).orElse(new ArrayList())).stream().map(OltStatDetailOpenApiVO::buildFromWebVO).collect(Collectors.toList()));
        return oltStatOpenApiVO;
    }

    @Generated
    public Map<String, PortStatVO> getPortMap() {
        return this.portMap;
    }

    @Generated
    public List<OltStatDetailOpenApiVO> getStatList() {
        return this.statList;
    }

    @Generated
    public void setPortMap(Map<String, PortStatVO> portMap) {
        this.portMap = portMap;
    }

    @Generated
    public void setStatList(List<OltStatDetailOpenApiVO> statList) {
        this.statList = statList;
    }

    @Generated
    public OltStatOpenApiVO(Map<String, PortStatVO> portMap, List<OltStatDetailOpenApiVO> statList) {
        this.portMap = portMap;
        this.statList = statList;
    }

    @Generated
    public OltStatOpenApiVO() {
    }

    public static class OltPortStatOpenApiVO {
        @Schema(description="Port of OLT")
        private String port;
        @Schema(description="Transmit traffic of the port, in bytes")
        private Long tx;
        @Schema(description="Receive traffic of the port, in bytes")
        private Long rx;
        @Schema(description="Transmit packets of the port")
        private Long txPackets;
        @Schema(description="Receive receive packets of the port")
        private Long rxPackets;
        @Schema(description="Transmit broadcast packets")
        private Long txBroadcastPackets;
        @Schema(description="Receive broadcast packets")
        private Long rxBroadcastPackets;
        @Schema(description="Transmit multicast packets")
        private Long txMulticastPackets;
        @Schema(description="Receive multicast packets")
        private Long rxMulticastPackets;
        @Schema(description="Transmit rate, byte/s")
        private Double txRate;
        @Schema(description="Receive rate, byte/s")
        private Double rxRate;

        public static OltPortStatOpenApiVO buildFromWebVO(OltStatDTO.OltPortStatDTO dto) {
            return OltPortStatOpenApiVO.builder().port(dto.getPort()).tx(dto.getTx()).rx(dto.getRx()).txPackets(dto.getTxPackets()).rxPackets(dto.getRxPackets()).txBroadcastPackets(dto.getTxBroadcastPackets()).rxBroadcastPackets(dto.getRxBroadcastPackets()).txMulticastPackets(dto.getTxMulticastPackets()).rxMulticastPackets(dto.getRxMulticastPackets()).txRate(dto.getTxRate()).rxRate(dto.getRxRate()).build();
        }

        @Generated
        public static OltPortStatOpenApiVOBuilder builder() {
            return new OltPortStatOpenApiVOBuilder();
        }

        @Generated
        public String getPort() {
            return this.port;
        }

        @Generated
        public Long getTx() {
            return this.tx;
        }

        @Generated
        public Long getRx() {
            return this.rx;
        }

        @Generated
        public Long getTxPackets() {
            return this.txPackets;
        }

        @Generated
        public Long getRxPackets() {
            return this.rxPackets;
        }

        @Generated
        public Long getTxBroadcastPackets() {
            return this.txBroadcastPackets;
        }

        @Generated
        public Long getRxBroadcastPackets() {
            return this.rxBroadcastPackets;
        }

        @Generated
        public Long getTxMulticastPackets() {
            return this.txMulticastPackets;
        }

        @Generated
        public Long getRxMulticastPackets() {
            return this.rxMulticastPackets;
        }

        @Generated
        public Double getTxRate() {
            return this.txRate;
        }

        @Generated
        public Double getRxRate() {
            return this.rxRate;
        }

        @Generated
        public void setPort(String port) {
            this.port = port;
        }

        @Generated
        public void setTx(Long tx) {
            this.tx = tx;
        }

        @Generated
        public void setRx(Long rx) {
            this.rx = rx;
        }

        @Generated
        public void setTxPackets(Long txPackets) {
            this.txPackets = txPackets;
        }

        @Generated
        public void setRxPackets(Long rxPackets) {
            this.rxPackets = rxPackets;
        }

        @Generated
        public void setTxBroadcastPackets(Long txBroadcastPackets) {
            this.txBroadcastPackets = txBroadcastPackets;
        }

        @Generated
        public void setRxBroadcastPackets(Long rxBroadcastPackets) {
            this.rxBroadcastPackets = rxBroadcastPackets;
        }

        @Generated
        public void setTxMulticastPackets(Long txMulticastPackets) {
            this.txMulticastPackets = txMulticastPackets;
        }

        @Generated
        public void setRxMulticastPackets(Long rxMulticastPackets) {
            this.rxMulticastPackets = rxMulticastPackets;
        }

        @Generated
        public void setTxRate(Double txRate) {
            this.txRate = txRate;
        }

        @Generated
        public void setRxRate(Double rxRate) {
            this.rxRate = rxRate;
        }

        @Generated
        public OltPortStatOpenApiVO(String port, Long tx, Long rx, Long txPackets, Long rxPackets, Long txBroadcastPackets, Long rxBroadcastPackets, Long txMulticastPackets, Long rxMulticastPackets, Double txRate, Double rxRate) {
            this.port = port;
            this.tx = tx;
            this.rx = rx;
            this.txPackets = txPackets;
            this.rxPackets = rxPackets;
            this.txBroadcastPackets = txBroadcastPackets;
            this.rxBroadcastPackets = rxBroadcastPackets;
            this.txMulticastPackets = txMulticastPackets;
            this.rxMulticastPackets = rxMulticastPackets;
            this.txRate = txRate;
            this.rxRate = rxRate;
        }

        @Generated
        public OltPortStatOpenApiVO() {
        }

        @Generated
        public static class OltPortStatOpenApiVOBuilder {
            @Generated
            private String port;
            @Generated
            private Long tx;
            @Generated
            private Long rx;
            @Generated
            private Long txPackets;
            @Generated
            private Long rxPackets;
            @Generated
            private Long txBroadcastPackets;
            @Generated
            private Long rxBroadcastPackets;
            @Generated
            private Long txMulticastPackets;
            @Generated
            private Long rxMulticastPackets;
            @Generated
            private Double txRate;
            @Generated
            private Double rxRate;

            @Generated
            OltPortStatOpenApiVOBuilder() {
            }

            @Generated
            public OltPortStatOpenApiVOBuilder port(String port) {
                this.port = port;
                return this;
            }

            @Generated
            public OltPortStatOpenApiVOBuilder tx(Long tx) {
                this.tx = tx;
                return this;
            }

            @Generated
            public OltPortStatOpenApiVOBuilder rx(Long rx) {
                this.rx = rx;
                return this;
            }

            @Generated
            public OltPortStatOpenApiVOBuilder txPackets(Long txPackets) {
                this.txPackets = txPackets;
                return this;
            }

            @Generated
            public OltPortStatOpenApiVOBuilder rxPackets(Long rxPackets) {
                this.rxPackets = rxPackets;
                return this;
            }

            @Generated
            public OltPortStatOpenApiVOBuilder txBroadcastPackets(Long txBroadcastPackets) {
                this.txBroadcastPackets = txBroadcastPackets;
                return this;
            }

            @Generated
            public OltPortStatOpenApiVOBuilder rxBroadcastPackets(Long rxBroadcastPackets) {
                this.rxBroadcastPackets = rxBroadcastPackets;
                return this;
            }

            @Generated
            public OltPortStatOpenApiVOBuilder txMulticastPackets(Long txMulticastPackets) {
                this.txMulticastPackets = txMulticastPackets;
                return this;
            }

            @Generated
            public OltPortStatOpenApiVOBuilder rxMulticastPackets(Long rxMulticastPackets) {
                this.rxMulticastPackets = rxMulticastPackets;
                return this;
            }

            @Generated
            public OltPortStatOpenApiVOBuilder txRate(Double txRate) {
                this.txRate = txRate;
                return this;
            }

            @Generated
            public OltPortStatOpenApiVOBuilder rxRate(Double rxRate) {
                this.rxRate = rxRate;
                return this;
            }

            @Generated
            public OltPortStatOpenApiVO build() {
                return new OltPortStatOpenApiVO(this.port, this.tx, this.rx, this.txPackets, this.rxPackets, this.txBroadcastPackets, this.rxBroadcastPackets, this.txMulticastPackets, this.rxMulticastPackets, this.txRate, this.rxRate);
            }

            @Generated
            public String toString() {
                return "OltStatOpenApiVO.OltPortStatOpenApiVO.OltPortStatOpenApiVOBuilder(port=" + this.port + ", tx=" + this.tx + ", rx=" + this.rx + ", txPackets=" + this.txPackets + ", rxPackets=" + this.rxPackets + ", txBroadcastPackets=" + this.txBroadcastPackets + ", rxBroadcastPackets=" + this.rxBroadcastPackets + ", txMulticastPackets=" + this.txMulticastPackets + ", rxMulticastPackets=" + this.rxMulticastPackets + ", txRate=" + this.txRate + ", rxRate=" + this.rxRate + ")";
            }
        }
    }

    public static class OltStatDetailOpenApiVO {
        @Schema(description="Number of ONU")
        private Integer onuCount;
        @Schema(description="Uplink traffic")
        private Long up;
        @Schema(description="Downlink traffic")
        private Long down;
        @Schema(description="sampling moment")
        private Long time;
        @Schema(description="Utilization of cpu")
        private Integer cpu;
        @Schema(description="Utilization of memory")
        private Integer mem;
        @Schema(description="Traffic information of ports")
        private List<OltPortStatOpenApiVO> ports;

        public static OltStatDetailOpenApiVO buildFromWebVO(OltStatDTO dto) {
            return OltStatDetailOpenApiVO.builder().onuCount(dto.getOnuCount()).up(dto.getUp()).down(dto.getDown()).time(dto.getTime()).cpu(dto.getCpu()).mem(dto.getMem()).ports(((List)Optional.ofNullable(dto.getPorts()).orElse(new ArrayList())).stream().map(OltPortStatOpenApiVO::buildFromWebVO).collect(Collectors.toList())).build();
        }

        @Generated
        public static OltStatDetailOpenApiVOBuilder builder() {
            return new OltStatDetailOpenApiVOBuilder();
        }

        @Generated
        public Integer getOnuCount() {
            return this.onuCount;
        }

        @Generated
        public Long getUp() {
            return this.up;
        }

        @Generated
        public Long getDown() {
            return this.down;
        }

        @Generated
        public Long getTime() {
            return this.time;
        }

        @Generated
        public Integer getCpu() {
            return this.cpu;
        }

        @Generated
        public Integer getMem() {
            return this.mem;
        }

        @Generated
        public List<OltPortStatOpenApiVO> getPorts() {
            return this.ports;
        }

        @Generated
        public void setOnuCount(Integer onuCount) {
            this.onuCount = onuCount;
        }

        @Generated
        public void setUp(Long up) {
            this.up = up;
        }

        @Generated
        public void setDown(Long down) {
            this.down = down;
        }

        @Generated
        public void setTime(Long time) {
            this.time = time;
        }

        @Generated
        public void setCpu(Integer cpu) {
            this.cpu = cpu;
        }

        @Generated
        public void setMem(Integer mem) {
            this.mem = mem;
        }

        @Generated
        public void setPorts(List<OltPortStatOpenApiVO> ports) {
            this.ports = ports;
        }

        @Generated
        public OltStatDetailOpenApiVO(Integer onuCount, Long up, Long down, Long time, Integer cpu, Integer mem, List<OltPortStatOpenApiVO> ports) {
            this.onuCount = onuCount;
            this.up = up;
            this.down = down;
            this.time = time;
            this.cpu = cpu;
            this.mem = mem;
            this.ports = ports;
        }

        @Generated
        public OltStatDetailOpenApiVO() {
        }

        @Generated
        public static class OltStatDetailOpenApiVOBuilder {
            @Generated
            private Integer onuCount;
            @Generated
            private Long up;
            @Generated
            private Long down;
            @Generated
            private Long time;
            @Generated
            private Integer cpu;
            @Generated
            private Integer mem;
            @Generated
            private List<OltPortStatOpenApiVO> ports;

            @Generated
            OltStatDetailOpenApiVOBuilder() {
            }

            @Generated
            public OltStatDetailOpenApiVOBuilder onuCount(Integer onuCount) {
                this.onuCount = onuCount;
                return this;
            }

            @Generated
            public OltStatDetailOpenApiVOBuilder up(Long up) {
                this.up = up;
                return this;
            }

            @Generated
            public OltStatDetailOpenApiVOBuilder down(Long down) {
                this.down = down;
                return this;
            }

            @Generated
            public OltStatDetailOpenApiVOBuilder time(Long time) {
                this.time = time;
                return this;
            }

            @Generated
            public OltStatDetailOpenApiVOBuilder cpu(Integer cpu) {
                this.cpu = cpu;
                return this;
            }

            @Generated
            public OltStatDetailOpenApiVOBuilder mem(Integer mem) {
                this.mem = mem;
                return this;
            }

            @Generated
            public OltStatDetailOpenApiVOBuilder ports(List<OltPortStatOpenApiVO> ports) {
                this.ports = ports;
                return this;
            }

            @Generated
            public OltStatDetailOpenApiVO build() {
                return new OltStatDetailOpenApiVO(this.onuCount, this.up, this.down, this.time, this.cpu, this.mem, this.ports);
            }

            @Generated
            public String toString() {
                return "OltStatOpenApiVO.OltStatDetailOpenApiVO.OltStatDetailOpenApiVOBuilder(onuCount=" + this.onuCount + ", up=" + this.up + ", down=" + this.down + ", time=" + this.time + ", cpu=" + this.cpu + ", mem=" + this.mem + ", ports=" + this.ports + ")";
            }
        }
    }
}

