/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.rrm.domain.service.schedule;

import com.google.common.collect.Sets;
import com.tplink.smb.algorithm.common.ScanAlgAp;
import com.tplink.smb.algorithm.common.ScanInfo;
import com.tplink.smb.algorithm.common.utils.CommonDeployUtils;
import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.ScheduleTask;
import com.tplink.smb.component.schedule.api.ScheduledEvent;
import com.tplink.smb.component.schedule.api.handler.ScheduledEventHandler;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.common.concurrent.thread.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.c.x;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.ap.ApDTO;
import com.tplink.smb.omada.manager.device.rfplanning.dto.RFPlanningScanChannelRequestDTO;
import com.tplink.smb.omada.monitor.api.internal.enventcenter.rfplanning.ScanResultDTO;
import com.tplink.smb.omada.monitor.rfplanning.domain.model.a.g;
import com.tplink.smb.omada.monitor.rfplanning.domain.service.i.p;
import com.tplink.smb.omada.monitor.rrm.domain.service.schedule.RrmScheduleProperties;
import com.tplink.smb.omada.monitor.rrm.port.cache.dto.RFPlanningRrmSiteSettingDTO;
import com.tplink.smb.omada.monitor.rrm.port.cache.dto.RrmHandleApDTO;
import com.tplink.smb.omada.monitor.rrm.port.cache.dto.RrmHandleSiteDTO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class a
implements ScheduledEventHandler {
    @Generated
    private static final Logger b = LoggerFactory.getLogger(a.class);
    @Autowired
    private ScheduleCenter c;
    @Autowired
    private RrmScheduleProperties d;
    @Autowired
    private com.tplink.smb.omada.monitor.rrm.port.cache.a e;
    @Autowired
    private com.tplink.smb.omada.manager.device.rfplanning.a.a f;
    @Autowired
    private p g;
    @Autowired
    private com.tplink.smb.omada.monitor.rrm.domain.service.b.b h;
    @Autowired
    private com.tplink.smb.omada.monitor.rrm.domain.service.b.a i;
    @Resource
    @Qualifier(value="commThreadPool")
    private ExecutorService j;
    @Autowired
    @Qualifier(value="rrmInterApWorkGroup")
    private ExecutorService k;
    @Autowired
    @Qualifier(value="rrmNewApWorkGroup")
    private ExecutorService l;
    @Autowired
    @Lazy
    private com.tplink.smb.omada.monitor.rrm.port.a.b m;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.a n;
    private static final String o = "monitor_rrm";
    private static final String p = "site_new_ap";
    private static final String q = "site_inter_ap";
    private static final int r = 600000;
    public static final int a = 900000;
    private static final int s = 90000;
    private static final int t = 4;

    @PostConstruct
    public void a() {
        ScheduleTask rrmSiteNewApScheduleTask = ScheduleTask.builder().withIdentity(o, p).withFixedRateTrigger(Integer.valueOf(600000), Integer.valueOf(180000)).withEnableSharding(Integer.valueOf(this.d.getShardingSizeOf(o))).build();
        this.c.saveTask(rrmSiteNewApScheduleTask);
        ScheduleTask rrmSiteInterApScheduleTask = ScheduleTask.builder().withIdentity(o, q).withFixedRateTrigger(Integer.valueOf(this.d.getInterFixRate() * 1000), Integer.valueOf(this.d.getInterDelay() * 1000)).withEnableSharding(Integer.valueOf(this.d.getShardingSizeOf(o))).build();
        this.c.saveTask(rrmSiteInterApScheduleTask);
        this.c.registerEventHandler(o, (ScheduledEventHandler)this, this.j);
    }

    @PreDestroy
    public void b() {
    }

    public void handle(@Nonnull ScheduledEvent scheduledEvent) {
        String taskParam = scheduledEvent.getTaskParam();
        Integer shardingIndex = scheduledEvent.getShardingParam().getShardingIndex();
        if (T.a((String)taskParam)) {
            b.warn("null taskParam, scheduledEvent={}", (Object)scheduledEvent);
            return;
        }
        switch (taskParam) {
            case "site_new_ap": {
                this.b(shardingIndex);
                break;
            }
            case "site_inter_ap": {
                this.a(shardingIndex);
                break;
            }
            default: {
                b.warn("RrmScheduleTaskHandler invalid taskParam:{}", (Object)taskParam);
            }
        }
    }

    private void b(Integer shardingIndex) {
        long endTime = System.currentTimeMillis();
        long startTime = endTime - 900000L;
        List<RrmHandleSiteDTO> handleSiteList = this.e.a(shardingIndex, startTime, endTime);
        if (CollectionUtils.isEmpty(handleSiteList)) {
            return;
        }
        Map<String, String> siteOmadacMap = handleSiteList.stream().collect(Collectors.toMap(RrmHandleSiteDTO::getSiteId, RrmHandleSiteDTO::getOmadacId, (v1, v2) -> v1));
        siteOmadacMap.forEach((siteId, omadacId) -> this.l.execute(() -> this.a((String)omadacId, (String)siteId, startTime, endTime)));
    }

    private void a(String omadacId, String siteId, long startTime, long endTime) {
        List<RrmHandleApDTO> handleApList = this.e.a(omadacId, siteId, startTime, endTime);
        if (b.isDebugEnabled()) {
            b.debug("RRM: start to scan newAp handleApList:{}, omadacId:{}, siteId:{}", new Object[]{handleApList, omadacId, siteId});
        }
        if (CollectionUtils.isEmpty(handleApList)) {
            return;
        }
        Set<String> handleApMacs = handleApList.stream().map(RrmHandleApDTO::getMac).collect(Collectors.toSet());
        Set<String> macWithScanResult = this.g.a(omadacId, siteId);
        handleApMacs = handleApMacs.stream().filter(mac -> !macWithScanResult.contains(mac)).collect(Collectors.toSet());
        if (b.isDebugEnabled()) {
            b.debug("RRM: start to scan newAp handleApMacs:{}, macWithScanResult={}, omadacId:{}, siteId:{}", new Object[]{handleApMacs, macWithScanResult, omadacId, siteId});
        }
        if (CollectionUtils.isEmpty(handleApMacs)) {
            return;
        }
        HashSet<String> supportRrmScanApMacs = new HashSet<String>();
        HashSet<String> supportScanChannelNewTypeApMacs = new HashSet<String>();
        HashSet<String> supportScanChannelOldTypeApMacs = new HashSet<String>();
        ArrayList<ScanAlgAp> scanAlgApList = this.h.a(omadacId, siteId, handleApMacs, supportRrmScanApMacs, supportScanChannelNewTypeApMacs, supportScanChannelOldTypeApMacs);
        long scanTimeout = 0L;
        ArrayList newApScanInfo = CommonDeployUtils.getNewApScanInfo(scanAlgApList);
        if (!CollectionUtils.isEmpty(supportScanChannelNewTypeApMacs)) {
            scanTimeout = 240000L;
            RFPlanningScanChannelRequestDTO rfPlanningScanChannelRequestDTO = RFPlanningScanChannelRequestDTO.builder().omadacId(omadacId).siteId(siteId).type(Integer.valueOf(1)).apMacList(supportScanChannelNewTypeApMacs).build();
            this.f.a(rfPlanningScanChannelRequestDTO);
        }
        if (!CollectionUtils.isEmpty((Collection)newApScanInfo)) {
            scanTimeout = Math.max(this.i.a(newApScanInfo), scanTimeout);
            Map scanInfoMap = newApScanInfo.stream().filter(ScanInfo::isScan).collect(Collectors.toMap(ScanInfo::getMac, Function.identity()));
            RFPlanningScanChannelRequestDTO rfPlanningScanChannelRequestDTO = RFPlanningScanChannelRequestDTO.builder().omadacId(omadacId).siteId(siteId).type(Integer.valueOf(3)).apMacList(supportRrmScanApMacs).scanInfoMap(scanInfoMap).rrmReason(com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.ay).interTimeStamp(Long.valueOf(0L)).build();
            this.f.a(rfPlanningScanChannelRequestDTO);
        }
        HashSet<String> needHandleApMacs = new HashSet<String>();
        needHandleApMacs.addAll(supportScanChannelNewTypeApMacs);
        needHandleApMacs.addAll(supportRrmScanApMacs);
        if (b.isDebugEnabled()) {
            b.debug("RRM: start to handle newAp scanResult after {} ms, omadacId={}, siteId={}, needHandleAp={}", new Object[]{scanTimeout, omadacId, siteId, needHandleApMacs});
        }
        com.tplink.smb.omada.common.concurrent.thread.b.a(() -> {
            try {
                this.a(omadacId, siteId, needHandleApMacs);
            }
            catch (Exception e2) {
                b.error("RRM: handle newAp scanResult error, message={}, omadacId={}, siteId={}", new Object[]{e2, omadacId, siteId});
            }
        }, (long)scanTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void a(String omadacId, String siteId, Set<String> handleApMacs) {
        List ssids = this.n.a(omadacId, siteId, x.a.b());
        RFPlanningRrmSiteSettingDTO rrmSiteSetting = this.h.b(omadacId, siteId);
        if (!rrmSiteSetting.isRrmEnable()) {
            return;
        }
        if (b.isDebugEnabled()) {
            b.debug("RRM: start deploy newAp handleApMacs:{}, omadacId:{}, siteId:{}", new Object[]{handleApMacs, omadacId, siteId});
        }
        com.tplink.smb.omada.monitor.rrm.domain.service.a.b rrmSolveRequestData = new com.tplink.smb.omada.monitor.rrm.domain.service.a.b(omadacId, siteId);
        g planningHistory = new g(omadacId, siteId);
        rrmSolveRequestData.a(planningHistory);
        rrmSolveRequestData.z(new ArrayList<String>(handleApMacs));
        rrmSolveRequestData.v(new ArrayList<String>(handleApMacs));
        rrmSolveRequestData.w(new ArrayList<String>(handleApMacs));
        rrmSolveRequestData.x(new ArrayList<String>(handleApMacs));
        rrmSolveRequestData.y(new ArrayList<String>(handleApMacs));
        this.h.a(omadacId, siteId, rrmSolveRequestData, rrmSiteSetting);
        Map<String, List<ScanResultDTO>> globalScanResultMap = this.g.a(omadacId, siteId, handleApMacs);
        this.i.a(omadacId, siteId, rrmSolveRequestData, globalScanResultMap, true);
        Sets.SetView neighborMacSet = Sets.difference(rrmSolveRequestData.X(), handleApMacs);
        Map<String, List<ScanResultDTO>> neighborGlobalScanResultMap = this.g.a(omadacId, siteId, (Set<String>)neighborMacSet);
        this.i.a(omadacId, siteId, rrmSolveRequestData, neighborGlobalScanResultMap, false);
        handleApMacs.addAll((Collection<String>)neighborMacSet);
        this.h.a(omadacId, siteId, rrmSolveRequestData, new ArrayList<String>(handleApMacs));
        Map<String, ApDTO> apDTOMap = rrmSolveRequestData.K();
        this.h.a(omadacId, siteId, rrmSolveRequestData, (Integer)0);
        this.h.a(omadacId, siteId, rrmSolveRequestData, (Integer)1);
        this.h.a(omadacId, siteId, rrmSolveRequestData, (Integer)2);
        this.h.a(omadacId, siteId, rrmSolveRequestData, (Integer)3);
        this.h.a(omadacId, siteId, rrmSolveRequestData, (Integer)0, ssids);
        this.h.a(omadacId, siteId, rrmSolveRequestData, (Integer)1, ssids);
        this.h.a(omadacId, siteId, rrmSolveRequestData, (Integer)2, ssids);
        this.h.a(omadacId, siteId, rrmSolveRequestData, (Integer)3, ssids);
        this.h.n(omadacId, siteId, rrmSolveRequestData);
        this.h.m(omadacId, siteId, rrmSolveRequestData);
        this.h.j(omadacId, siteId, rrmSolveRequestData);
        this.h.l(omadacId, siteId, rrmSolveRequestData);
        this.h.a(omadacId, siteId, rrmSolveRequestData, true);
        this.h.b(omadacId, siteId, rrmSolveRequestData, true);
        this.h.c(omadacId, siteId, rrmSolveRequestData, true);
        this.h.d(omadacId, siteId, rrmSolveRequestData, true);
        this.h.a(rrmSolveRequestData, rrmSiteSetting, apDTOMap);
        if (b.isDebugEnabled()) {
            b.debug("RRM: newAp before fill deployConfig, omadacId={}, siteId={}, rrmSolveRequestData: channelDeployEnable={}, powerAdjustEnable={}, channelWidthDeployEnable={}, bandDeployEnable={}, newApMacList={}, meshApSet={}, excludeApMac={}, deployApList2g={}, deployApList5g={}, deployApList5g2={}, deployApList6g={}, neighborApMacMap2g={}, neighborApMacMap5g={}, neighborApMacMap5g2={}, neighborApMacMap6g={}, allNeighborApMac={}, origGlobalScan2gMacList={}, origGlobalScan5gMacList={}, origGlobalScan6gMacList={}, apWithoutGlobalScanResult={}, rfAdvanceSetting={}", new Object[]{omadacId, siteId, rrmSolveRequestData.g(), rrmSolveRequestData.h(), rrmSolveRequestData.i(), rrmSolveRequestData.j(), rrmSolveRequestData.ac(), rrmSolveRequestData.ae(), rrmSolveRequestData.d(), rrmSolveRequestData.Y(), rrmSolveRequestData.Z(), rrmSolveRequestData.aa(), rrmSolveRequestData.ab(), rrmSolveRequestData.T(), rrmSolveRequestData.U(), rrmSolveRequestData.V(), rrmSolveRequestData.W(), rrmSolveRequestData.X(), rrmSolveRequestData.H(), rrmSolveRequestData.I(), rrmSolveRequestData.J(), rrmSolveRequestData.ag(), rrmSolveRequestData.k()});
        }
        this.h.b(omadacId, siteId, rrmSolveRequestData, com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.ap);
    }

    public void a(Integer shardingIndex) {
        long currentTimeMillis = System.currentTimeMillis();
        Set<RrmHandleSiteDTO> rrmHandleSiteSet = this.e.b(shardingIndex, currentTimeMillis - 90000L, currentTimeMillis);
        if (CollectionUtils.isEmpty(rrmHandleSiteSet)) {
            b.debug("RRM: InterApTask no need solve, empty rrmHandleSiteSet in cache");
            return;
        }
        int rrmInterApCount = 0;
        for (RrmHandleSiteDTO rrmHandleSiteDTO : rrmHandleSiteSet) {
            String siteId = rrmHandleSiteDTO.getSiteId();
            String omadacId = rrmHandleSiteDTO.getOmadacId();
            Set<RrmHandleApDTO> rrmInterApSet = this.e.b(omadacId, siteId, currentTimeMillis - 90000L, currentTimeMillis);
            List newApRrmHandleSet = rrmInterApSet.stream().filter(rrmHandleApDTO -> com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.am.equals(rrmHandleApDTO.getType())).map(RrmHandleApDTO::getMac).collect(Collectors.toList());
            HashSet<RrmHandleApDTO> needSolveRrmInterApSet = new HashSet<RrmHandleApDTO>();
            for (RrmHandleApDTO rrmHandleApDTO2 : rrmInterApSet) {
                if (newApRrmHandleSet.contains(rrmHandleApDTO2.getMac())) continue;
                needSolveRrmInterApSet.add(rrmHandleApDTO2);
            }
            if (CollectionUtils.isEmpty(rrmInterApSet)) {
                return;
            }
            this.k.execute(() -> this.b(omadacId, siteId, needSolveRrmInterApSet));
            rrmInterApCount += needSolveRrmInterApSet.size();
        }
        this.m.a((Integer)rrmHandleSiteSet.size());
        this.m.b(rrmInterApCount);
    }

    private void b(String omadacId, String siteId, Set<RrmHandleApDTO> rrmInterApSet) {
        long startTime = System.nanoTime();
        RFPlanningRrmSiteSettingDTO rrmSiteSetting = this.h.b(omadacId, siteId);
        if (!rrmSiteSetting.isRrmEnable()) {
            return;
        }
        if (b.isDebugEnabled()) {
            b.debug("RRM: start to deployRrmSiteInterAp, omadacId={}, siteId={}, rrmInterApSet={}", new Object[]{omadacId, siteId, rrmInterApSet});
        }
        com.tplink.smb.omada.monitor.rrm.domain.service.a.b rrmSolveRequestData = new com.tplink.smb.omada.monitor.rrm.domain.service.a.b(omadacId, siteId);
        g planningHistory = new g(omadacId, siteId);
        rrmSolveRequestData.a(planningHistory);
        ArrayList<String> deployMacList2g = new ArrayList<String>();
        ArrayList<String> deployMacList5g = new ArrayList<String>();
        ArrayList<String> deployMacList5g2 = new ArrayList<String>();
        ArrayList<String> deployMacList6g = new ArrayList<String>();
        HashSet<String> allDeployMacSet = new HashSet<String>();
        HashMap<String, Long> jamApTimeStampMap2g = new HashMap<String, Long>();
        HashMap<String, Long> jamApTimeStampMap5g = new HashMap<String, Long>();
        HashMap<String, Long> jamApTimeStampMap5g2 = new HashMap<String, Long>();
        HashMap<String, Long> jamApTimeStampMap6g = new HashMap<String, Long>();
        for (RrmHandleApDTO rrmHandleApDTO : rrmInterApSet) {
            Integer radioId = rrmHandleApDTO.getRadioId();
            switch (radioId) {
                case 0: {
                    deployMacList2g.add(rrmHandleApDTO.getMac());
                    jamApTimeStampMap2g.put(rrmHandleApDTO.getMac(), rrmHandleApDTO.getInterTimeStamp());
                    break;
                }
                case 1: {
                    deployMacList5g.add(rrmHandleApDTO.getMac());
                    jamApTimeStampMap5g.put(rrmHandleApDTO.getMac(), rrmHandleApDTO.getInterTimeStamp());
                    break;
                }
                case 2: {
                    deployMacList5g2.add(rrmHandleApDTO.getMac());
                    jamApTimeStampMap5g2.put(rrmHandleApDTO.getMac(), rrmHandleApDTO.getInterTimeStamp());
                    break;
                }
                case 3: {
                    deployMacList6g.add(rrmHandleApDTO.getMac());
                    jamApTimeStampMap6g.put(rrmHandleApDTO.getMac(), rrmHandleApDTO.getInterTimeStamp());
                }
            }
            allDeployMacSet.add(rrmHandleApDTO.getMac());
        }
        rrmSolveRequestData.v(deployMacList2g);
        rrmSolveRequestData.w(deployMacList5g);
        rrmSolveRequestData.x(deployMacList5g2);
        rrmSolveRequestData.y(deployMacList6g);
        rrmSolveRequestData.a((Map<String, Long>)jamApTimeStampMap2g);
        rrmSolveRequestData.b((Map<String, Long>)jamApTimeStampMap5g);
        rrmSolveRequestData.c((Map<String, Long>)jamApTimeStampMap5g2);
        rrmSolveRequestData.d((Map<String, Long>)jamApTimeStampMap6g);
        ArrayList<String> allDeployMacList = new ArrayList<String>(allDeployMacSet);
        this.h.a(omadacId, siteId, rrmSolveRequestData, rrmSiteSetting);
        Map<String, List<ScanResultDTO>> interApScanResultMap = this.e.a(omadacId, siteId, allDeployMacList);
        this.i.a(omadacId, siteId, rrmSolveRequestData, interApScanResultMap);
        Sets.SetView neighborMacSet = Sets.difference(rrmSolveRequestData.X(), allDeployMacSet);
        this.m.c(neighborMacSet.size());
        allDeployMacList.addAll((Collection<String>)neighborMacSet);
        Map<String, List<ScanResultDTO>> jamGlobalScanResultMap = this.g.a(omadacId, siteId, new HashSet<String>(allDeployMacList));
        this.i.a(omadacId, siteId, rrmSolveRequestData, jamGlobalScanResultMap, false);
        this.h.a(omadacId, siteId, rrmSolveRequestData, allDeployMacList);
        Map<String, ApDTO> apDTOMap = rrmSolveRequestData.K();
        rrmSolveRequestData.a(rrmSolveRequestData.Y());
        rrmSolveRequestData.b(rrmSolveRequestData.Z());
        rrmSolveRequestData.c(rrmSolveRequestData.aa());
        rrmSolveRequestData.d(rrmSolveRequestData.ab());
        this.h.a(omadacId, siteId, rrmSolveRequestData, (Integer)0);
        this.h.a(omadacId, siteId, rrmSolveRequestData, (Integer)1);
        this.h.a(omadacId, siteId, rrmSolveRequestData, (Integer)2);
        this.h.a(omadacId, siteId, rrmSolveRequestData, (Integer)3);
        this.h.n(omadacId, siteId, rrmSolveRequestData);
        this.h.m(omadacId, siteId, rrmSolveRequestData);
        this.h.j(omadacId, siteId, rrmSolveRequestData);
        this.h.k(omadacId, siteId, rrmSolveRequestData);
        this.h.l(omadacId, siteId, rrmSolveRequestData);
        this.h.i(omadacId, siteId, rrmSolveRequestData);
        this.m.a(System.nanoTime() - startTime, "prepare_alg_info");
        startTime = System.nanoTime();
        this.h.a(omadacId, siteId, rrmSolveRequestData, false);
        this.h.b(omadacId, siteId, rrmSolveRequestData, false);
        this.h.c(omadacId, siteId, rrmSolveRequestData, false);
        this.h.d(omadacId, siteId, rrmSolveRequestData, false);
        this.m.a(System.nanoTime() - startTime, "fill_alg_info");
        this.h.a(rrmSolveRequestData, rrmSiteSetting, apDTOMap);
        if (b.isDebugEnabled()) {
            Set interApSet = rrmInterApSet.stream().map(RrmHandleApDTO::getMac).collect(Collectors.toSet());
            b.debug("RRM: interAp before fill deployConfig, omadacId={}, siteId={}, rrmSolveRequestData: channelDeployEnable={}, powerAdjustEnable={}, channelWidthDeployEnable={}, bandDeployEnable={}, interApSet={}, meshApSet={}, excludeApMac={}, deployApList2g={}, deployApList5g={}, deployApList5g2={}, deployApList6g={}, neighborApMacMap2g={}, neighborApMacMap5g={}, neighborApMacMap5g2={}, neighborApMacMap6g={}, allNeighborApMac={}, origGlobalScan2gMacList={}, origGlobalScan5gMacList={},  origGlobalScan6gMacList={}, apWithoutGlobalScanResult={}, rfAdvanceSetting={}", new Object[]{omadacId, siteId, rrmSolveRequestData.g(), rrmSolveRequestData.h(), rrmSolveRequestData.i(), rrmSolveRequestData.j(), interApSet, rrmSolveRequestData.ae(), rrmSolveRequestData.d(), rrmSolveRequestData.Y(), rrmSolveRequestData.Z(), rrmSolveRequestData.aa(), rrmSolveRequestData.ab(), rrmSolveRequestData.T(), rrmSolveRequestData.U(), rrmSolveRequestData.V(), rrmSolveRequestData.W(), rrmSolveRequestData.X(), rrmSolveRequestData.H(), rrmSolveRequestData.I(), rrmSolveRequestData.J(), rrmSolveRequestData.ag(), rrmSolveRequestData.k()});
        }
        startTime = System.nanoTime();
        this.h.b(omadacId, siteId, rrmSolveRequestData, com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.ao);
        this.m.a(System.nanoTime() - startTime, "deploy_alg_result");
    }
}

