/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.rrm.domain.service.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.omada.monitor.rrm.domain.service.config.RRMProperties;
import com.tplink.smb.omada.monitor.rrm.domain.service.config.a;
import com.tplink.smb.omada.monitor.rrm.port.a.b;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import jakarta.annotation.Resource;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@EnableConfigurationProperties(value={RRMProperties.class})
public class RrmExecutorConfiguration {
    @Resource
    @Lazy
    private b a;
    @Resource
    private MeterRegistry b;
    @Autowired
    private RRMProperties c;

    @Lazy
    @Bean(name={"rrmInterApWorkGroup"})
    @ConditionalOnMissingBean(name={"rrmInterApWorkGroup"})
    public ExecutorService rrmInterApWorkGroup() {
        int coreSize = this.c.getCoreSize();
        int queueSize = this.c.getQueueSize();
        String poolName = "monitor-rrm-pool";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSize, coreSize, 15L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(queueSize), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new a(this, poolName));
        executor.allowCoreThreadTimeOut(true);
        return ExecutorServiceMetrics.monitor((MeterRegistry)this.b, (ExecutorService)executor, (String)poolName, (String)"executor_metric", (Tag[])new Tag[0]);
    }

    @Lazy
    @Bean(name={"rrmNewApWorkGroup"})
    @ConditionalOnMissingBean(name={"rrmNewApWorkGroup"})
    public ExecutorService rrmNewApWorkGroup() {
        int coreSize = this.c.getCoreSize();
        int queueSize = this.c.getQueueSize();
        String poolName = "monitor-rrm-pool";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSize, coreSize, 15L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(queueSize), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build());
        executor.allowCoreThreadTimeOut(true);
        return ExecutorServiceMetrics.monitor((MeterRegistry)this.b, (ExecutorService)executor, (String)poolName, (String)"executor_metric", (Tag[])new Tag[0]);
    }
}

