/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.rfplanning.port.eventcenter;

import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.algorithm.common.ChannelsInfo;
import com.tplink.smb.algorithm.common.RFPlanningScanResult;
import com.tplink.smb.algorithm.common.ScanBss;
import com.tplink.smb.algorithm.common.ScanResult;
import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventHandler;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.monitor.api.internal.enventcenter.rfplanning.ChannelsInfoDTO;
import com.tplink.smb.omada.monitor.api.internal.enventcenter.rfplanning.RFPlanningNotifyDTO;
import com.tplink.smb.omada.monitor.api.internal.enventcenter.rfplanning.ScanBssDTO;
import com.tplink.smb.omada.monitor.api.internal.enventcenter.rfplanning.ScanResultDTO;
import com.tplink.smb.omada.monitor.rfplanning.domain.service.i.p;
import com.tplink.smb.omada.monitor.rrm.port.cache.dto.RrmHandleApDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class a
implements EventHandler {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    private p b;
    @Autowired
    private com.tplink.smb.omada.monitor.rrm.port.cache.a c;

    public void handleEvent(Event event) {
        RFPlanningNotifyDTO rfPlanningNotifyDTO = (RFPlanningNotifyDTO)x.a((String)((String)event.getMessage()), RFPlanningNotifyDTO.class);
        if (a.isDebugEnabled()) {
            a.debug("received RFPlanning scan channel message from eventCenter:{}, omadacId={}, siteId={}, mac={}", new Object[]{event.getMessage(), rfPlanningNotifyDTO.getOmadacId(), rfPlanningNotifyDTO.getSiteId(), rfPlanningNotifyDTO.getMac()});
        }
        if (!rfPlanningNotifyDTO.validate()) {
            return;
        }
        String omadacId = rfPlanningNotifyDTO.getOmadacId();
        String siteId = rfPlanningNotifyDTO.getSiteId();
        String apMac = rfPlanningNotifyDTO.getMac();
        Boolean rrmFlag = rfPlanningNotifyDTO.getRrmFlag();
        Boolean oldScanType = rfPlanningNotifyDTO.getOldScanType();
        List scanResults = rfPlanningNotifyDTO.getChannelDeployResultBO().getScanResults();
        Long interTimeStamp = rfPlanningNotifyDTO.getChannelDeployResultBO().getInterTimeStamp();
        if (CollectionUtil.isEmpty((Collection)scanResults)) {
            return;
        }
        Map<Integer, ScanResultDTO> scanResultDTOMap = scanResults.stream().collect(Collectors.toMap(ScanResultDTO::getRadioId, v -> v, (v1, v2) -> v2));
        if (Boolean.TRUE.equals(rrmFlag)) {
            for (Map.Entry<Integer, ScanResultDTO> entry : scanResultDTOMap.entrySet()) {
                Integer radioId = entry.getKey();
                ScanResultDTO scanResultDTO = entry.getValue();
                this.c.a(omadacId, siteId, apMac, radioId, scanResultDTO);
                RrmHandleApDTO rrmHandleApDTO = RrmHandleApDTO.builder().omadacId(omadacId).siteId(siteId).mac(apMac).radioId(radioId).interTimeStamp(interTimeStamp).type(com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.an).build();
                a.debug("RRM: receive scanResult and updateRrmJamApInfo cache, omadacId={}, siteId={}, rrmHandleApDTO={}", new Object[]{omadacId, siteId, rrmHandleApDTO});
                this.c.b(omadacId, siteId, rrmHandleApDTO);
            }
            a.debug("RRM: receive scanResult and updateJamApSite cache, omadacId={}, siteId={}", (Object)omadacId, (Object)siteId);
            this.c.b(omadacId, siteId);
        } else {
            this.b.a(omadacId, siteId, apMac, scanResultDTOMap, oldScanType);
        }
    }

    private RFPlanningScanResult a(String omadacId, String siteId, String apMac, Integer radioId, ScanResultDTO scanResultDTO) {
        RFPlanningScanResult rfPlanningScanResult = new RFPlanningScanResult();
        rfPlanningScanResult.setOmadacId(omadacId);
        rfPlanningScanResult.setSiteId(siteId);
        rfPlanningScanResult.setMac(apMac);
        rfPlanningScanResult.setRadioId(radioId);
        ScanResult scanResults = new ScanResult();
        scanResults.setRadioId(scanResultDTO.getRadioId());
        scanResults.setChWidth(scanResultDTO.getChWidth());
        ArrayList<ChannelsInfo> channels = new ArrayList<ChannelsInfo>();
        List channelDTOS = scanResultDTO.getChannels();
        for (ChannelsInfoDTO channelsInfoDTO : channelDTOS) {
            ChannelsInfo channelsInfo = new ChannelsInfo();
            channelsInfo.setChannel(channelsInfoDTO.getChannel());
            channelsInfo.setNsFloor(channelsInfoDTO.getNsFloor());
            channelsInfo.setLoadUtil(channelsInfoDTO.getLoadUtil());
            List bssDTOS = channelsInfoDTO.getBss();
            ArrayList<ScanBss> bss = new ArrayList<ScanBss>();
            for (ScanBssDTO scanBssDTO : bssDTOS) {
                ScanBss scanBss = new ScanBss();
                scanBss.setRssi(scanBssDTO.getRssi());
                scanBss.setMac(scanBssDTO.getMac());
                bss.add(scanBss);
            }
            channelsInfo.setBss(bss);
            channels.add(channelsInfo);
        }
        scanResults.setChannels(channels);
        rfPlanningScanResult.setScanResults(scanResults);
        return rfPlanningScanResult;
    }
}

