/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.rfplanning.domain.service.m;

import com.tplink.smb.omada.common.constant.DeviceStatusEnum;
import com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.SsidBriefDTO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.SsidVO;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.ap.ApDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.ap.ApMeshSettingDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.DeviceQueryDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.ap.ApImageCapabilityDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.ap.ApImageDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.ap.ApImageStatusDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.ap.status.WirelessParamDTO;
import com.tplink.smb.omada.monitor.rfplanning.domain.model.b.b;
import com.tplink.smb.omada.monitor.rfplanning.domain.model.b.c;
import com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class e {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(e.class);
    private static final String b = "channelDeploy";
    private static final String c = "powerControl";
    private static final Integer d = 131072;
    private static final Integer e = 262144;
    private static final Integer f = 256;
    private static final Integer g = 0x800000;
    private static final Integer h = f | g;
    private static final Integer i = 0x1000000;
    private static final Integer j = f | i;

    public static boolean a(ApDTO ap, int radioId, List<SsidBriefDTO> ssids) {
        if (CollectionUtils.isEmpty(ssids)) {
            return true;
        }
        for (SsidBriefDTO ssid : ssids) {
            boolean ssidEnable6g;
            String wlanId;
            if (ssid == null || (wlanId = ssid.getWlanId()) == null || !wlanId.equals(ap.getSetting().getWlanSetting().getWlanId())) continue;
            boolean ssidEnable2g = radioId == 0 && SsidVO.contain2G((Integer)ssid.getBand());
            boolean ssidEnable5g = (radioId == 1 || radioId == 2) && SsidVO.contain5G((Integer)ssid.getBand());
            boolean bl = ssidEnable6g = radioId == 3 && SsidVO.contain6G((Integer)ssid.getBand());
            if (!ssidEnable2g && !ssidEnable5g && !ssidEnable6g) continue;
            return false;
        }
        return true;
    }

    public static boolean a(ApImageDTO apImage, ApDTO apDTO, Integer radioId) {
        Pair version = com.tplink.smb.omada.monitor.common.i.a.a((ApImageDTO)apImage, (String)b);
        if (version == null) {
            version = com.tplink.smb.omada.monitor.common.i.a.a((ApDTO)apDTO, (String)b);
        }
        if (version == null || version.getKey() == null) {
            return true;
        }
        if ((Integer)version.getKey() < 1) {
            return true;
        }
        return radioId != null && radioId == 3 && (version.getValue() == null || (Integer)version.getValue() < 1);
    }

    public static boolean a(ApImageDTO apImage, ApDTO apDTO) {
        Integer supportBackground = null;
        if (apImage != null && apImage.getCapability() != null) {
            supportBackground = ((ApImageCapabilityDTO)apImage.getCapability()).getSupportBackground();
        }
        if (supportBackground == null && apDTO != null && apDTO.getCapability() != null) {
            supportBackground = apDTO.getCapability().getSupportBackground();
        }
        if (supportBackground == null) {
            return false;
        }
        return supportBackground > 0;
    }

    public static boolean b(ApImageDTO apImage, ApDTO apDTO, Integer radioId) {
        Pair version = com.tplink.smb.omada.monitor.common.i.a.a((ApImageDTO)apImage, (String)c);
        if (version == null) {
            version = com.tplink.smb.omada.monitor.common.i.a.a((ApDTO)apDTO, (String)c);
        }
        if (version == null || version.getKey() == null) {
            return true;
        }
        if ((Integer)version.getKey() < 1) {
            return true;
        }
        return radioId != null && radioId == 3 && (version.getValue() == null || (Integer)version.getValue() < 1);
    }

    public static boolean a(ApDTO ap, com.tplink.smb.omada.manager.device.api.internal.device.a apInternalApiService) {
        if (Objects.equals(ap.getStatus(), DeviceStatusEnum.h.n())) {
            return true;
        }
        if (!ap.getCapability().supportMesh() || ap.getSetting() == null) {
            return false;
        }
        ApMeshSettingDTO apMeshSetting = ap.getSetting().getMeshSetting();
        if (apMeshSetting == null) {
            return false;
        }
        Set childApMacs = apMeshSetting.getChildApMacs();
        String parentApMac = apMeshSetting.getParentApMac();
        return com.tplink.smb.omada.monitor.rfplanning.domain.service.m.e.a(ap, childApMacs, parentApMac, apInternalApiService);
    }

    private static boolean a(ApDTO ap, Set<String> childApMacs, String parentApMac, com.tplink.smb.omada.manager.device.api.internal.device.a apInternalApiService) {
        if (CollectionUtils.isEmpty(childApMacs) && parentApMac == null) {
            return false;
        }
        if (!CollectionUtils.isEmpty(childApMacs)) {
            for (String childApMac : childApMacs) {
                ApImageDTO apImage = apInternalApiService.a(DeviceQueryDTO.builder().omadacId(ap.getOmadacId()).mac(childApMac).build());
                if (apImage != null && !Boolean.TRUE.equals(((ApImageStatusDTO)apImage.getDeviceStatus()).isWirelessLinked())) continue;
                return true;
            }
        }
        if (parentApMac != null) {
            ApImageDTO apImage = apInternalApiService.a(DeviceQueryDTO.builder().omadacId(ap.getOmadacId()).mac(parentApMac).build());
            return apImage == null || Boolean.TRUE.equals(((ApImageStatusDTO)apImage.getDeviceStatus()).isWirelessLinked());
        }
        return false;
    }

    public static int[] a(int radioId) {
        int[] commonChannel = null;
        switch (radioId) {
            case 0: {
                commonChannel = com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.aa;
                break;
            }
            case 1: 
            case 2: {
                commonChannel = com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.ab;
                break;
            }
            case 3: {
                commonChannel = com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.ac;
                break;
            }
        }
        return commonChannel;
    }

    public static List<Integer> a(int radioId, c advancedSetting) {
        List<Integer> allChannel = new ArrayList<Integer>();
        switch (radioId) {
            case 0: {
                allChannel = com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.ad;
                break;
            }
            case 1: 
            case 2: {
                allChannel = new ArrayList<Integer>(com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.ae);
                if (Objects.isNull(advancedSetting) || !Boolean.TRUE.equals(advancedSetting.b()) || CollectionUtils.isEmpty(advancedSetting.c())) break;
                List excludeChannels = advancedSetting.c().stream().map(b::b).collect(Collectors.toList());
                allChannel.removeAll(excludeChannels);
                break;
            }
            case 3: {
                allChannel = com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.ag;
                break;
            }
        }
        return allChannel;
    }

    public static String a(ApImageDTO apImage, int radioId) {
        switch (radioId) {
            case 0: {
                return Optional.ofNullable(((ApImageStatusDTO)apImage.getDeviceStatus()).getWp2g()).map(WirelessParamDTO::getActualChannel).orElse(null);
            }
            case 1: {
                return Optional.ofNullable(((ApImageStatusDTO)apImage.getDeviceStatus()).getWp5g()).map(WirelessParamDTO::getActualChannel).orElse(null);
            }
            case 2: {
                return Optional.ofNullable(((ApImageStatusDTO)apImage.getDeviceStatus()).getWp5g2()).map(WirelessParamDTO::getActualChannel).orElse(null);
            }
            case 3: {
                return Optional.ofNullable(((ApImageStatusDTO)apImage.getDeviceStatus()).getWp6g()).map(WirelessParamDTO::getActualChannel).orElse(null);
            }
        }
        return null;
    }

    public static Integer a(Integer channel, int radioId) {
        if (channel != null && channel != -1 && channel != 0) {
            return channel;
        }
        switch (radioId) {
            case 0: {
                return com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.ad.get(new Random().nextInt(com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.ad.size()));
            }
            case 1: {
                return com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.ae.get(new Random().nextInt(com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.ae.size()));
            }
            case 2: {
                return com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.af.get(new Random().nextInt(com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.af.size()));
            }
            case 3: {
                return com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.ag.get(new Random().nextInt(com.tplink.smb.omada.monitor.rfplanning.domain.service.e.a.ag.size()));
            }
        }
        return channel;
    }

    private e() {
    }
}

